/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.attr;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FieldExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public class StructAnnotationAttribute
extends StructGeneralAttribute {
    private List<AnnotationExprent> annotations;

    @Override
    public void initContent(DataInputFullStream data, ConstantPool pool) throws IOException {
        this.annotations = StructAnnotationAttribute.parseAnnotations(pool, data);
    }

    public static List<AnnotationExprent> parseAnnotations(ConstantPool pool, DataInputStream data) throws IOException {
        int len = data.readUnsignedShort();
        if (len > 0) {
            ArrayList<AnnotationExprent> annotations = new ArrayList<AnnotationExprent>(len);
            for (int i = 0; i < len; ++i) {
                annotations.add(StructAnnotationAttribute.parseAnnotation(data, pool));
            }
            return annotations;
        }
        return Collections.emptyList();
    }

    public static AnnotationExprent parseAnnotation(DataInputStream data, ConstantPool pool) throws IOException {
        List values;
        List<String> names;
        String className = pool.getPrimitiveConstant(data.readUnsignedShort()).getString();
        int len = data.readUnsignedShort();
        if (len > 0) {
            names = new ArrayList(len);
            values = new ArrayList(len);
            for (int i = 0; i < len; ++i) {
                names.add(pool.getPrimitiveConstant(data.readUnsignedShort()).getString());
                values.add(StructAnnotationAttribute.parseAnnotationElement(data, pool));
            }
        } else {
            names = Collections.emptyList();
            values = Collections.emptyList();
        }
        return new AnnotationExprent(new VarType((String)className).value, names, values);
    }

    public static Exprent parseAnnotationElement(DataInputStream data, ConstantPool pool) throws IOException {
        int tag = data.readUnsignedByte();
        switch (tag) {
            case 101: {
                String className = pool.getPrimitiveConstant(data.readUnsignedShort()).getString();
                String constName = pool.getPrimitiveConstant(data.readUnsignedShort()).getString();
                FieldDescriptor descr = FieldDescriptor.parseDescriptor(className);
                return new FieldExprent(constName, descr.type.value, true, null, descr, null);
            }
            case 99: {
                String value;
                String descriptor = pool.getPrimitiveConstant(data.readUnsignedShort()).getString();
                VarType type = FieldDescriptor.parseDescriptor((String)descriptor).type;
                switch (type.type) {
                    case 8: {
                        value = type.value;
                        break;
                    }
                    case 0: {
                        value = Byte.TYPE.getName();
                        break;
                    }
                    case 1: {
                        value = Character.TYPE.getName();
                        break;
                    }
                    case 2: {
                        value = Double.TYPE.getName();
                        break;
                    }
                    case 3: {
                        value = Float.TYPE.getName();
                        break;
                    }
                    case 4: {
                        value = Integer.TYPE.getName();
                        break;
                    }
                    case 5: {
                        value = Long.TYPE.getName();
                        break;
                    }
                    case 6: {
                        value = Short.TYPE.getName();
                        break;
                    }
                    case 7: {
                        value = Boolean.TYPE.getName();
                        break;
                    }
                    case 10: {
                        value = Void.TYPE.getName();
                        break;
                    }
                    default: {
                        throw new RuntimeException("invalid class type: " + type.type);
                    }
                }
                return new ConstExprent(VarType.VARTYPE_CLASS, value, null);
            }
            case 91: {
                VarType newType;
                List<Exprent> elements = Collections.emptyList();
                int len = data.readUnsignedShort();
                if (len > 0) {
                    elements = new ArrayList(len);
                    for (int i = 0; i < len; ++i) {
                        elements.add(StructAnnotationAttribute.parseAnnotationElement(data, pool));
                    }
                }
                if (elements.isEmpty()) {
                    newType = new VarType(8, 1, "java/lang/Object");
                } else {
                    VarType elementType = ((Exprent)elements.get(0)).getExprType();
                    newType = new VarType(elementType.type, 1, elementType.value);
                }
                NewExprent newExpr = new NewExprent(newType, Collections.emptyList(), null);
                newExpr.setDirectArrayInit(true);
                newExpr.setLstArrayElements(elements);
                return newExpr;
            }
            case 64: {
                return StructAnnotationAttribute.parseAnnotation(data, pool);
            }
        }
        PrimitiveConstant cn = pool.getPrimitiveConstant(data.readUnsignedShort());
        switch (tag) {
            case 66: {
                return new ConstExprent(VarType.VARTYPE_BYTE, cn.value, null);
            }
            case 67: {
                return new ConstExprent(VarType.VARTYPE_CHAR, cn.value, null);
            }
            case 68: {
                return new ConstExprent(VarType.VARTYPE_DOUBLE, cn.value, null);
            }
            case 70: {
                return new ConstExprent(VarType.VARTYPE_FLOAT, cn.value, null);
            }
            case 73: {
                return new ConstExprent(VarType.VARTYPE_INT, cn.value, null);
            }
            case 74: {
                return new ConstExprent(VarType.VARTYPE_LONG, cn.value, null);
            }
            case 83: {
                return new ConstExprent(VarType.VARTYPE_SHORT, cn.value, null);
            }
            case 90: {
                return new ConstExprent(VarType.VARTYPE_BOOLEAN, cn.value, null);
            }
            case 115: {
                return new ConstExprent(VarType.VARTYPE_STRING, cn.value, null);
            }
        }
        throw new RuntimeException("invalid element type!");
    }

    public List<AnnotationExprent> getAnnotations() {
        return this.annotations;
    }
}

