/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.maven.compiler.MavenEscapeWindowsCharacterUtils;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.maven.model.impl.ResourceRootConfiguration;
import org.jetbrains.jps.model.JpsEncodingConfigurationService;
import org.jetbrains.jps.model.JpsEncodingProjectConfiguration;
import org.jetbrains.jps.model.JpsProject;

public class MavenResourceFileProcessor {
    private static final int FILTERING_SIZE_LIMIT = 0xA00000;
    private static final String MAVEN_BUILD_TIMESTAMP_PROPERTY = "maven.build.timestamp";
    private static final String MAVEN_BUILD_TIMESTAMP_FORMAT_PROPERTY = "maven.build.timestamp.format";
    protected final Set<String> myFilteringExcludedExtensions;
    protected final JpsEncodingProjectConfiguration myEncodingConfig;
    protected final MavenProjectConfiguration myProjectConfig;
    protected final MavenModuleResourceConfiguration myModuleConfiguration;
    protected final Date myTimestamp = new Date();
    private Map<String, String> myProperties;
    private Pattern myDelimitersPattern;

    public MavenResourceFileProcessor(MavenProjectConfiguration projectConfiguration, JpsProject project, MavenModuleResourceConfiguration moduleConfiguration) {
        this.myProjectConfig = projectConfiguration;
        this.myEncodingConfig = JpsEncodingConfigurationService.getInstance().getEncodingConfiguration(project);
        this.myModuleConfiguration = moduleConfiguration;
        this.myFilteringExcludedExtensions = moduleConfiguration.getFilteringExcludedExtensions();
    }

    public void copyFile(File file, File targetFile, ResourceRootConfiguration rootConfiguration, CompileContext context, FileFilter filteringFilter) throws IOException {
        boolean shouldFilter;
        boolean bl = shouldFilter = rootConfiguration.isFiltered && !this.myFilteringExcludedExtensions.contains(FileUtilRt.getExtension((String)file.getName())) && filteringFilter.accept(file);
        if (shouldFilter && file.length() > 0xA00000L) {
            context.processMessage((BuildMessage)new CompilerMessage("MavenResources", BuildMessage.Kind.WARNING, "File is too big to be filtered. Most likely it is a binary file and should be excluded from filtering", file.getPath()));
            shouldFilter = false;
        }
        if (shouldFilter) {
            this.copyWithFiltering(file, targetFile);
        } else {
            FSOperations.copy((File)file, (File)targetFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyWithFiltering(File file, File outputFile) throws IOException {
        PrintWriter writer;
        String encoding = this.myEncodingConfig != null ? this.myEncodingConfig.getEncoding(file) : null;
        try {
            writer = encoding != null ? new PrintWriter(outputFile, encoding) : new PrintWriter(outputFile);
        }
        catch (FileNotFoundException e) {
            File parentFile = outputFile.getParentFile();
            if (parentFile == null || !parentFile.mkdirs() && !outputFile.setWritable(true)) {
                throw e;
            }
            writer = encoding != null ? new PrintWriter(outputFile, encoding) : new PrintWriter(outputFile);
        }
        try {
            byte[] bytes = FileUtil.loadFileBytes((File)file);
            String text = encoding != null ? new String(bytes, encoding) : new String(bytes, StandardCharsets.UTF_8);
            this.doFilterText(text, this.getDelimitersPattern(), this.getProperties(), null, writer);
        }
        finally {
            writer.close();
        }
    }

    private void doFilterText(String text, Pattern delimitersPattern, @NotNull Map<String, String> additionalProperties, @Nullable Map<String, String> resolvedPropertiesParam, Appendable out) throws IOException {
        if (additionalProperties == null) {
            MavenResourceFileProcessor.$$$reportNull$$$0(0);
        }
        Map<String, String> resolvedProperties = resolvedPropertiesParam;
        Matcher matcher = delimitersPattern.matcher(text);
        boolean hasEscapeString = !StringUtil.isEmpty((String)this.myModuleConfiguration.escapeString);
        int groupCount = matcher.groupCount();
        int firstPropertyGroupIndex = hasEscapeString ? 3 : 0;
        int last = 0;
        while (matcher.find()) {
            String propertyValue;
            out.append(text, last, matcher.start());
            last = matcher.end();
            if (hasEscapeString) {
                if (matcher.group(1) != null) {
                    out.append(this.myModuleConfiguration.escapeString).append(this.myModuleConfiguration.escapeString);
                    continue;
                }
                if (matcher.group(2) != null) {
                    out.append(matcher.group(3));
                    continue;
                }
            }
            String propertyName = null;
            for (int i = firstPropertyGroupIndex; i < groupCount && (propertyName = matcher.group(i + 1)) == null; ++i) {
            }
            assert (propertyName != null);
            if (resolvedProperties == null) {
                resolvedProperties = new HashMap<String, String>();
            }
            if ((propertyValue = resolvedProperties.get(propertyName)) == null) {
                if (resolvedProperties.containsKey(propertyName)) {
                    out.append(matcher.group());
                    continue;
                }
                String resolved = this.myProjectConfig.resolveProperty(propertyName, this.myModuleConfiguration, additionalProperties);
                if (resolved == null) {
                    out.append(matcher.group());
                    continue;
                }
                resolvedProperties.put(propertyName, null);
                StringBuilder sb = new StringBuilder();
                this.doFilterText(resolved, delimitersPattern, additionalProperties, resolvedProperties, sb);
                propertyValue = sb.toString();
                resolvedProperties.put(propertyName, propertyValue);
            }
            if (this.myModuleConfiguration.escapeWindowsPaths) {
                MavenEscapeWindowsCharacterUtils.escapeWindowsPath(out, propertyValue);
                continue;
            }
            out.append(propertyValue);
        }
        out.append(text, last, text.length());
    }

    private Pattern getDelimitersPattern() {
        Pattern pattern = this.myDelimitersPattern;
        if (pattern == null) {
            if (StringUtil.isEmpty((String)this.myModuleConfiguration.escapeString)) {
                pattern = Pattern.compile(this.myModuleConfiguration.delimitersPattern);
            } else {
                String quotedEscapeString = Pattern.quote(this.myModuleConfiguration.escapeString);
                pattern = Pattern.compile("(" + quotedEscapeString + quotedEscapeString + ")|(?:(" + quotedEscapeString + ")?(" + this.myModuleConfiguration.delimitersPattern + "))");
            }
            this.myDelimitersPattern = pattern;
        }
        return pattern;
    }

    private Map<String, String> getProperties() {
        Map<String, String> props = this.myProperties;
        if (props == null) {
            props = new HashMap<String, String>(this.myModuleConfiguration.properties);
            String timestampFormat = props.get(MAVEN_BUILD_TIMESTAMP_FORMAT_PROPERTY);
            if (timestampFormat == null) {
                timestampFormat = "yyyyMMdd-HHmm";
            }
            props.put(MAVEN_BUILD_TIMESTAMP_PROPERTY, new SimpleDateFormat(timestampFormat).format(this.myTimestamp));
            this.myProperties = props;
        }
        return props;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "additionalProperties", "org/jetbrains/jps/maven/compiler/MavenResourceFileProcessor", "doFilterText"));
    }
}

