/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.actions.updateFromSources;

import com.intellij.CommonBundle;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ProjectTaskManager;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.Restarter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesDialog;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateFromSourcesSettings;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateIdeFromSourcesAction;
import org.jetbrains.idea.devkit.actions.updateFromSources.UpdateIdeFromSourcesActionKt;
import org.jetbrains.idea.devkit.util.PsiUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u000e\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002JV\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00042\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001cH\u0002J#\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010!J\u001d\u0010\"\u001a\n #*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010$J\u001b\u0010%\u001a\u00020\u00072\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0\u001fH\u0002\u00a2\u0006\u0002\u0010'J0\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010*\u001a\u00020\fH\u0002J \u0010+\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010,\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/jetbrains/idea/devkit/actions/updateFromSources/UpdateIdeFromSourcesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "forceShowSettings", "", "(Z)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "backupImportantFilesIfNeeded", "workIdeHome", "", "backupDirPath", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "checkIdeHome", "createScriptJavaParameters", "Lcom/intellij/execution/configurations/JavaParameters;", "devIdeaHome", "project", "Lcom/intellij/openapi/project/Project;", "deployDir", "distRelativePath", "scriptFile", "Ljava/io/File;", "buildEnabledPluginsOnly", "bundledPluginDirsToSkip", "", "nonBundledPluginDirsToInclude", "generateUpdateCommand", "", "builtDistPath", "(Ljava/lang/String;Ljava/lang/String;)[Ljava/lang/String;", "isIdeaProject", "kotlin.jvm.PlatformType", "(Lcom/intellij/openapi/project/Project;)Ljava/lang/Boolean;", "restartWithCommand", "command", "([Ljava/lang/String;)V", "runUpdateScript", "params", "backupDir", "startCopyingFiles", "update", "intellij.devkit"})
public class UpdateIdeFromSourcesAction
extends AnAction
implements DumbAware {
    private final boolean forceShowSettings;

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        block20: {
            block19: {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                v0 = e.getProject();
                if (v0 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"e.project ?: return");
                project = v0;
                if ((this.forceShowSettings || UpdateFromSourcesSettings.Companion.getState().getShowSettings()) && !(ok = new UpdateFromSourcesDialog(project, this.forceShowSettings).showAndGet())) {
                    return;
                }
                $fun$error$1 = new Function1<String, Unit>(project){
                    final /* synthetic */ Project $project;

                    public final void invoke(@NotNull String message) {
                        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                        Messages.showErrorDialog((Project)this.$project, (String)message, (String)CommonBundle.getErrorTitle());
                    }
                    {
                        this.$project = project;
                        super(1);
                    }
                };
                state = UpdateFromSourcesSettings.Companion.getState();
                v1 = project.getBasePath();
                if (v1 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"project.basePath ?: return");
                devIdeaHome = v1;
                v2 = state.getWorkIdePath();
                if (v2 == null) {
                    v3 = PathManager.getHomePath();
                    v2 = v3;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"PathManager.getHomePath()");
                }
                workIdeHome = v2;
                v4 = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"ApplicationManager.getApplication()");
                if (!v4.isRestartCapable() && FileUtil.pathsEqual((String)workIdeHome, (String)PathManager.getHomePath())) {
                    $fun$error$1.invoke("This IDE cannot restart itself so updating from sources isn't supported");
                    return;
                }
                notIdeHomeMessage = this.checkIdeHome(workIdeHome);
                if (notIdeHomeMessage != null) {
                    $fun$error$1.invoke(workIdeHome + " is not a valid IDE home: " + notIdeHomeMessage);
                    return;
                }
                scriptFile = new File(devIdeaHome, "build/scripts/idea_ultimate.gant");
                if (!scriptFile.exists()) {
                    $fun$error$1.invoke(scriptFile + " doesn't exist");
                    return;
                }
                if (!StringsKt.contains$default((CharSequence)FilesKt.readText$default((File)scriptFile, null, (int)1, null), (CharSequence)"intellij.build.generate.bin.and.runtime.for.unpacked.dist", (boolean)false, (int)2, null)) {
                    $fun$error$1.invoke("The build scripts is out-of-date, please update to the latest 'master' sources.");
                    return;
                }
                bundledPluginDirsToSkip = null;
                nonBundledPluginDirsToInclude = null;
                v5 = buildEnabledPluginsOnly = state.getBuildDisabledPlugins() == false;
                if (!buildEnabledPluginsOnly) break block19;
                pluginDirectoriesToSkip = new LinkedHashSet<E>(state.getPluginDirectoriesForDisabledPlugins());
                v6 = pluginDirectoriesToSkip;
                v7 = PluginManagerCore.getLoadedPlugins();
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"PluginManagerCore.getLoadedPlugins()");
                CollectionsKt.removeAll((Collection)v6, (Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)v7), (Function1)actionPerformed.2.INSTANCE), (Function1)actionPerformed.3.INSTANCE), (Function1)actionPerformed.4.INSTANCE), (Function1)actionPerformed.5.INSTANCE));
                v8 = PluginManagerCore.getPlugins();
                Intrinsics.checkExpressionValueIsNotNull((Object)v8, (String)"PluginManagerCore.getPlugins()");
                $this$filter$iv /* !! */  = v8;
                $i$f$filter = false;
                var15_17 = $this$filter$iv /* !! */ ;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var18_24 = $this$filterTo$iv$iv;
                var19_27 = ((void)var18_24).length;
                for (var20_31 = 0; var20_31 < var19_27; ++var20_31) {
                    it = element$iv$iv = var18_24[var20_31];
                    $i$a$-filter-UpdateIdeFromSourcesAction$actionPerformed$6 = false;
                    v9 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v9, (String)"it");
                    if (!(v9.isBundled() != false && it.isEnabled() == false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv /* !! */ ) {
                    var20_32 = (IdeaPluginDescriptor)item$iv$iv;
                    var25_50 = destination$iv$iv;
                    $i$a$-map-UpdateIdeFromSourcesAction$actionPerformed$7 = false;
                    v10 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v10, (String)"it");
                    var26_51 = v10.getPath();
                    var25_50.add(var26_51);
                }
                $this$filter$iv /* !! */  = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$mapTo$iv$iv /* !! */  = $this$filter$iv /* !! */ ;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var18_24 = $this$filterTo$iv$iv.iterator();
                while (var18_24.hasNext()) {
                    element$iv$iv = var18_24.next();
                    it = (File)element$iv$iv;
                    $i$a$-filter-UpdateIdeFromSourcesAction$actionPerformed$8 = false;
                    v11 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v11, (String)"it");
                    if (!v11.isDirectory()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$mapTo$iv = (List)destination$iv$iv;
                $i$f$mapTo = false;
                for (E item$iv : $this$mapTo$iv) {
                    $i$f$filterTo = (File)item$iv /* !! */ ;
                    var25_50 = pluginDirectoriesToSkip;
                    $i$a$-mapTo-UpdateIdeFromSourcesAction$actionPerformed$9 = false;
                    v12 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v12, (String)"it");
                    var26_51 = v12.getName();
                    var25_50.add(var26_51);
                }
                (Collection)pluginDirectoriesToSkip;
                list = CollectionsKt.toMutableList((Collection)pluginDirectoriesToSkip);
                state.setPluginDirectoriesForDisabledPlugins(list);
                bundledPluginDirsToSkip = list;
                v13 = PluginManagerCore.getPlugins();
                Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"PluginManagerCore.getPlugins()");
                $this$filter$iv = v13;
                $i$f$filter = false;
                item$iv /* !! */  = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var19_30 = $this$filterTo$iv$iv;
                it = ((void)var19_30).length;
                for ($i$a$-filter-UpdateIdeFromSourcesAction$actionPerformed$8 = 0; $i$a$-filter-UpdateIdeFromSourcesAction$actionPerformed$8 < it; ++$i$a$-filter-UpdateIdeFromSourcesAction$actionPerformed$8) {
                    it = element$iv$iv = var19_30[$i$a$-filter-UpdateIdeFromSourcesAction$actionPerformed$8];
                    $i$a$-filter-UpdateIdeFromSourcesAction$actionPerformed$10 = false;
                    v14 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v14, (String)"it");
                    if (v14.isBundled() || !it.isEnabled() || it.getVersion() == null) ** GOTO lbl-1000
                    v15 = it.getVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)v15, (String)"it.version");
                    if (StringsKt.contains$default((CharSequence)v15, (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null)) {
                        v16 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v16 = false;
                    }
                    if (!v16) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var19_30 = $this$mapTo$iv$iv.iterator();
                while (var19_30.hasNext()) {
                    item$iv$iv = var19_30.next();
                    $i$a$-filter-UpdateIdeFromSourcesAction$actionPerformed$8 = (IdeaPluginDescriptor)item$iv$iv;
                    var25_50 = destination$iv$iv;
                    $i$a$-map-UpdateIdeFromSourcesAction$actionPerformed$11 = false;
                    v17 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v17, (String)"it");
                    var26_51 = v17.getPath();
                    var25_50.add(var26_51);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (File)element$iv$iv;
                    $i$a$-filter-UpdateIdeFromSourcesAction$actionPerformed$12 = false;
                    v18 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v18, (String)"it");
                    if (!v18.isDirectory()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$map$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var19_30 = $this$mapTo$iv$iv.iterator();
                while (var19_30.hasNext()) {
                    item$iv$iv = var19_30.next();
                    it = (File)item$iv$iv;
                    var25_50 = destination$iv$iv;
                    $i$a$-map-UpdateIdeFromSourcesAction$actionPerformed$13 = false;
                    v19 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v19, (String)"it");
                    var26_51 = v19.getName();
                    var25_50.add(var26_51);
                }
                nonBundledPluginDirsToInclude = (List)destination$iv$iv;
                break block20;
            }
            bundledPluginDirsToSkip = CollectionsKt.emptyList();
            nonBundledPluginDirsToInclude = CollectionsKt.emptyList();
        }
        deployDir = devIdeaHome + "/out/deploy";
        distRelativePath = "dist";
        backupDir = devIdeaHome + "/out/backup-before-update-from-sources";
        v20 = this.createScriptJavaParameters(devIdeaHome, project, deployDir, distRelativePath, scriptFile, buildEnabledPluginsOnly, bundledPluginDirsToSkip, nonBundledPluginDirsToInclude);
        if (v20 == null) {
            return;
        }
        params = v20;
        ProjectTaskManager.getInstance((Project)project).buildAllModules().onSuccess((Consumer)new Consumer<ProjectTaskManager.Result>(this, params, project, workIdeHome, deployDir, distRelativePath, backupDir){
            final /* synthetic */ UpdateIdeFromSourcesAction this$0;
            final /* synthetic */ JavaParameters $params;
            final /* synthetic */ Project $project;
            final /* synthetic */ String $workIdeHome;
            final /* synthetic */ String $deployDir;
            final /* synthetic */ String $distRelativePath;
            final /* synthetic */ String $backupDir;

            public final void accept(ProjectTaskManager.Result it) {
                ProjectTaskManager.Result result = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)result, (String)"it");
                if (!result.isAborted() && !it.hasErrors()) {
                    UpdateIdeFromSourcesAction.access$runUpdateScript(this.this$0, this.$params, this.$project, this.$workIdeHome, this.$deployDir + '/' + this.$distRelativePath, this.$backupDir);
                }
            }
            {
                this.this$0 = updateIdeFromSourcesAction;
                this.$params = javaParameters;
                this.$project = project;
                this.$workIdeHome = string;
                this.$deployDir = string2;
                this.$distRelativePath = string3;
                this.$backupDir = string4;
            }
        });
    }

    private final String checkIdeHome(String workIdeHome) {
        File homeDir = new File(workIdeHome);
        if (!homeDir.exists()) {
            return null;
        }
        if (homeDir.isFile()) {
            return "it is not a directory";
        }
        String buildTxt = SystemInfo.isMac ? "Resources/build.txt" : "build.txt";
        for (String name : CollectionsKt.listOf((Object[])new String[]{"bin", buildTxt})) {
            if (new File(homeDir, name).exists()) continue;
            return '\'' + name + "' doesn't exist";
        }
        return null;
    }

    private final void runUpdateScript(JavaParameters params, Project project, String workIdeHome, String builtDistPath, String backupDir) {
        new Task.Backgroundable(this, workIdeHome, backupDir, builtDistPath, params, project, project, "Updating from Sources", true){
            final /* synthetic */ UpdateIdeFromSourcesAction this$0;
            final /* synthetic */ String $workIdeHome;
            final /* synthetic */ String $backupDir;
            final /* synthetic */ String $builtDistPath;
            final /* synthetic */ JavaParameters $params;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setText("Updating IDE from sources...");
                UpdateIdeFromSourcesAction.access$backupImportantFilesIfNeeded(this.this$0, this.$workIdeHome, this.$backupDir, indicator);
                indicator.setText2("Deleting " + this.$builtDistPath);
                FileUtil.delete((File)new File(this.$builtDistPath));
                indicator.setText2("Starting gant script");
                OSProcessHandler oSProcessHandler = this.$params.createOSProcessHandler();
                Intrinsics.checkExpressionValueIsNotNull((Object)oSProcessHandler, (String)"params.createOSProcessHandler()");
                OSProcessHandler scriptHandler = oSProcessHandler;
                List<T> errorLines = Collections.synchronizedList((List)new ArrayList<E>());
                scriptHandler.addProcessListener((ProcessListener)new ProcessAdapter(this, errorLines, indicator){
                    final /* synthetic */ runUpdateScript.1 this$0;
                    final /* synthetic */ List $errorLines;
                    final /* synthetic */ ProgressIndicator $indicator;

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
                        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                        Intrinsics.checkParameterIsNotNull(outputType, (String)"outputType");
                        UpdateIdeFromSourcesActionKt.access$getLOG$p().debug("script: " + event.getText());
                        if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDERR)) {
                            this.$errorLines.add(event.getText());
                        } else if (Intrinsics.areEqual(outputType, (Object)ProcessOutputTypes.STDOUT)) {
                            this.$indicator.setText2(event.getText());
                        }
                    }

                    public void processTerminated(@NotNull ProcessEvent event) {
                        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                        if (this.$indicator.isCanceled()) {
                            return;
                        }
                        if (event.getExitCode() != 0) {
                            List list = this.$errorLines;
                            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"errorLines");
                            String errorText = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                            NotificationGroup.createNotification$default((NotificationGroup)UpdateIdeFromSourcesActionKt.access$getNotificationGroup$p(), (String)"Update from Sources Failed", (String)("Build script finished with " + event.getExitCode() + ": " + errorText), (NotificationType)NotificationType.ERROR, null, (int)8, null).notify(this.this$0.$project);
                            return;
                        }
                        if (!FileUtil.pathsEqual((String)this.this$0.$workIdeHome, (String)PathManager.getHomePath())) {
                            UpdateIdeFromSourcesAction.access$startCopyingFiles(this.this$0.this$0, this.this$0.$builtDistPath, this.this$0.$workIdeHome, this.this$0.$project);
                            return;
                        }
                        String[] command = UpdateIdeFromSourcesAction.access$generateUpdateCommand(this.this$0.this$0, this.this$0.$builtDistPath, this.this$0.$workIdeHome);
                        if (this.$indicator.isShowing()) {
                            UpdateIdeFromSourcesAction.access$restartWithCommand(this.this$0.this$0, command);
                        } else {
                            NotificationGroup.createNotification$default((NotificationGroup)UpdateIdeFromSourcesActionKt.access$getNotificationGroup$p(), (String)"Update from Sources", (String)"New installation is prepared from sources. <a href=\"#\">Restart</a>?", null, (NotificationListener)new NotificationListener(this, command){
                                final /* synthetic */ runUpdateScript.run.1 this$0;
                                final /* synthetic */ String[] $command;

                                public final void hyperlinkUpdate(@NotNull Notification $noName_0, @NotNull HyperlinkEvent $noName_1) {
                                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                    Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                                    UpdateIdeFromSourcesAction.access$restartWithCommand(this.this$0.this$0.this$0, this.$command);
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$command = stringArray;
                                }
                            }, (int)4, null).notify(this.this$0.$project);
                        }
                    }
                    {
                        this.this$0 = $outer;
                        this.$errorLines = $captured_local_variable$1;
                        this.$indicator = $captured_local_variable$2;
                    }
                });
                scriptHandler.startNotify();
                while (!scriptHandler.isProcessTerminated()) {
                    scriptHandler.waitFor(300L);
                    indicator.checkCanceled();
                }
            }
            {
                this.this$0 = $outer;
                this.$workIdeHome = $captured_local_variable$1;
                this.$backupDir = $captured_local_variable$2;
                this.$builtDistPath = $captured_local_variable$3;
                this.$params = $captured_local_variable$4;
                this.$project = $captured_local_variable$5;
                super($super_call_param$6, $super_call_param$7, $super_call_param$8);
            }
        }.queue();
    }

    private final void backupImportantFilesIfNeeded(String workIdeHome, String backupDirPath, ProgressIndicator indicator) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        File it;
        File element$iv$iv;
        int n;
        int n2;
        File[] $this$filterTo$iv$iv;
        boolean $i$f$filterTo;
        Collection destination$iv$iv;
        boolean $i$f$filter;
        File[] $this$filter$iv;
        File backupDir = new File(backupDirPath);
        if (backupDir.exists()) {
            UpdateIdeFromSourcesActionKt.access$getLOG$p().debug(backupDir + " already exists, skipping backup");
            return;
        }
        UpdateIdeFromSourcesActionKt.access$getLOG$p().debug("Backing up files from " + workIdeHome + " to " + backupDir);
        indicator.setText2("Backing up files");
        FileUtil.createDirectory((File)backupDir);
        File[] fileArray = new File(workIdeHome, "bin").listFiles();
        if (fileArray != null) {
            $this$filter$iv = fileArray;
            $i$f$filter = false;
            File[] fileArray2 = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            void var10_12 = $this$filterTo$iv$iv;
            n2 = ((void)var10_12).length;
            for (n = 0; n < n2; ++n) {
                it = element$iv$iv = var10_12[n];
                boolean bl = false;
                Set set = UpdateIdeFromSourcesActionKt.access$getSafeToDeleteFilesInBin$p();
                void v2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                if (!(!set.contains(v2.getName()) && !UpdateIdeFromSourcesActionKt.access$getSafeToDeleteExtensions$p().contains(FilesKt.getExtension((File)it)))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$forEach$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it2 = (File)element$iv;
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append("bin/");
                File file = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                FileUtil.copy((File)it2, (File)new File(backupDir, stringBuilder.append(file.getName()).toString()));
            }
        }
        File[] fileArray3 = new File(workIdeHome).listFiles();
        if (fileArray3 != null) {
            $this$filter$iv = fileArray3;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            File[] bl = $this$filterTo$iv$iv;
            n2 = bl.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv$iv = bl[n];
                boolean bl2 = false;
                Set set = UpdateIdeFromSourcesActionKt.access$getSafeToDeleteFilesInHome$p();
                File file = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                if (!(!set.contains(file.getName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$forEach$iv = (List)destination$iv$iv;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it3 = (File)element$iv;
                boolean bl3 = false;
                File file = it3;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                FileUtil.copyFileOrDir((File)it3, (File)new File(backupDir, file.getName()));
            }
        }
    }

    private final void startCopyingFiles(String builtDistPath, String workIdeHome, Project project) {
        new Task.Backgroundable(workIdeHome, builtDistPath, project, project, "Updating from Sources", true){
            final /* synthetic */ String $workIdeHome;
            final /* synthetic */ String $builtDistPath;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                indicator.setText("Copying files to IDE distribution...");
                indicator.setText2("Deleting old files");
                FileUtil.delete((File)new File(this.$workIdeHome));
                indicator.checkCanceled();
                indicator.setText2("Copying new files");
                FileUtil.copyDir((File)new File(this.$builtDistPath), (File)new File(this.$workIdeHome));
                indicator.checkCanceled();
                new Notification("Update from Sources", "Update from Sources", "New installation is prepared at " + this.$workIdeHome + '.', NotificationType.INFORMATION).notify(this.$project);
            }
            {
                this.$workIdeHome = $captured_local_variable$0;
                this.$builtDistPath = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        }.queue();
    }

    private final String[] generateUpdateCommand(String builtDistPath, String workIdeHome) {
        if (SystemInfo.isWindows) {
            File restartLogFile = new File(PathManager.getLogPath(), "update-from-sources.log");
            File file = FileUtil.createTempFile((String)"update", (String)".cmd", (boolean)false);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"FileUtil.createTempFile(\"update\", \".cmd\", false)");
            File updateScript = file;
            String workHomePath = new File(workIdeHome).getAbsolutePath();
            FileUtil.writeToFile((File)updateScript, (String)StringsKt.trimIndent((String)("\n        @echo off\n        SET count=20\n        SET time_to_wait=1\n        :DELETE_DIR\n        RMDIR /Q /S \"" + workHomePath + "\"\n        IF EXIST \"" + workHomePath + "\" (\n          IF %count% GEQ 0 (\n            ECHO \"" + workHomePath + "\" still exists, wait %time_to_wait%s and try delete again\n            SET /A time_to_wait=%time_to_wait%+1\n            PING 127.0.0.1 -n %time_to_wait% >NUL\n            SET /A count=%count%-1\n            ECHO %count% attempts remain\n            GOTO DELETE_DIR\n          )\n          ECHO Failed to delete \"" + workHomePath + "\", IDE wasn't updated. You may delete it manually and copy files from \"" + new File(builtDistPath).getAbsolutePath() + "\" by hand  \n          GOTO CLEANUP_AND_EXIT \n        )\n        \n        XCOPY \"" + new File(builtDistPath).getAbsolutePath() + "\" \"" + workHomePath + "\"\\ /Q /E /Y\n        :CLEANUP_AND_EXIT\n        START /b \"\" cmd /c DEL /Q /F \"" + updateScript.getAbsolutePath() + "\" & EXIT /b\n      ")));
            String[] stringArray = new String[5];
            stringArray[0] = "cmd";
            stringArray[1] = "/c";
            String string = updateScript.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"updateScript.absolutePath");
            stringArray[2] = string;
            stringArray[3] = '>' + restartLogFile.getAbsolutePath();
            stringArray[4] = "2>&1";
            return stringArray;
        }
        Object[] command = new String[]{"rm -rf \"" + workIdeHome + "\"/*", "cp -R \"" + builtDistPath + "\"/* \"" + workIdeHome + '\"'};
        return new String[]{"/bin/sh", "-c", ArraysKt.joinToString$default((Object[])command, (CharSequence)" && ", null, null, (int)0, null, null, (int)62, null)};
    }

    private final void restartWithCommand(String[] command) {
        Restarter.doNotLockInstallFolderOnRestart();
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
        }
        ((ApplicationImpl)application).restart(7, command);
    }

    /*
     * WARNING - void declaration
     */
    private final JavaParameters createScriptJavaParameters(String devIdeaHome, Project project, String deployDir, String distRelativePath, File scriptFile, boolean buildEnabledPluginsOnly, List<String> bundledPluginDirsToSkip, List<String> nonBundledPluginDirsToInclude) {
        JavaParameters params;
        block16: {
            block15: {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$filterTo$iv$iv;
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
                Sdk sdk = projectRootManager.getProjectSdk();
                if (sdk == null) {
                    UpdateIdeFromSourcesActionKt.access$getLOG$p().warn("Project SDK is not defined");
                    return null;
                }
                params = new JavaParameters();
                params.setUseClasspathJar(true);
                params.setDefaultCharset(project);
                params.setJdk(sdk);
                params.setMainClass("org.codehaus.groovy.tools.GroovyStarter");
                params.getProgramParametersList().add("--classpath");
                String buildScriptsModuleName = "intellij.idea.ultimate.build";
                Module buildScriptsModule = ModuleManager.getInstance((Project)project).findModuleByName(buildScriptsModuleName);
                if (buildScriptsModule == null) {
                    UpdateIdeFromSourcesActionKt.access$getLOG$p().warn("Build scripts module " + buildScriptsModuleName + " is not found in the project");
                    return null;
                }
                OrderRootsEnumerator orderRootsEnumerator = OrderEnumerator.orderEntries((Module)buildScriptsModule).recursively().withoutSdk().runtimeOnly().productionOnly().classes();
                Intrinsics.checkExpressionValueIsNotNull((Object)orderRootsEnumerator, (String)"OrderEnumerator.orderEnt\u2026roductionOnly().classes()");
                PathsList pathsList = orderRootsEnumerator.getPathsList();
                Intrinsics.checkExpressionValueIsNotNull((Object)pathsList, (String)"OrderEnumerator.orderEnt\u2026nly().classes().pathsList");
                PathsList classpath = pathsList;
                List classesFromCoreJars = CollectionsKt.listOf((Object[])new String[]{params.getMainClass(), "org.apache.tools.ant.BuildException", "org.apache.tools.ant.launch.AntMain", "org.apache.commons.cli.ParseException", "groovy.util.CliBuilder"});
                List list = classpath.getRootDirs();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"classpath.rootDirs");
                Iterable $this$filter$iv = list;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    boolean bl;
                    block14: {
                        VirtualFile root = (VirtualFile)element$iv$iv;
                        boolean bl2 = false;
                        Iterable $this$any$iv = classesFromCoreJars;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl3 = false;
                                if (!LibraryUtil.isClassAvailableInLibrary((List)CollectionsKt.listOf((Object)root), (String)it)) continue;
                                bl = true;
                                break block14;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
                boolean $i$f$mapNotNull = false;
                $this$filterTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String string;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    VirtualFile it = (VirtualFile)element$iv$iv;
                    boolean bl4 = false;
                    if (PathUtil.getLocalPath((VirtualFile)it) == null) continue;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    String it$iv$iv = string;
                    boolean bl7 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List coreClassPath = (List)destination$iv$iv;
                params.getClassPath().addAll(coreClassPath);
                Iterable $this$forEach$iv = coreClassPath;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    classpath.remove(FileUtil.toSystemDependentName((String)it));
                }
                params.getProgramParametersList().add(classpath.getPathsString());
                params.getProgramParametersList().add("--main");
                params.getProgramParametersList().add("gant.Gant");
                params.getProgramParametersList().add("--file");
                params.getProgramParametersList().add(scriptFile.getAbsolutePath());
                params.getProgramParametersList().add("update-from-sources");
                params.getVMParametersList().add("-Dintellij.build.generate.bin.and.runtime.for.unpacked.dist=true");
                params.getVMParametersList().add("-Dintellij.build.bundled.jre.prefix=jbrsdk-");
                if (buildEnabledPluginsOnly) {
                    $this$forEach$iv = bundledPluginDirsToSkip;
                    boolean bl = false;
                    if (!$this$forEach$iv.isEmpty()) {
                        params.getVMParametersList().add("-Dintellij.build.bundled.plugin.dirs.to.skip=" + CollectionsKt.joinToString$default((Iterable)bundledPluginDirsToSkip, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
                    }
                    Collection collection = nonBundledPluginDirsToInclude;
                    boolean bl8 = false;
                    String nonBundled = !collection.isEmpty() ? CollectionsKt.joinToString$default((Iterable)nonBundledPluginDirsToInclude, (CharSequence)",", null, null, (int)0, null, null, (int)62, null) : "none";
                    params.getVMParametersList().add("-Dintellij.build.non.bundled.plugin.dirs.to.include=" + nonBundled);
                }
                if (!buildEnabledPluginsOnly) break block15;
                Collection collection = nonBundledPluginDirsToInclude;
                boolean bl = false;
                if (!(!collection.isEmpty())) break block16;
            }
            params.getVMParametersList().add("-Dintellij.build.local.plugins.repository=true");
        }
        params.getVMParametersList().add("-Dintellij.build.output.root=" + deployDir);
        params.getVMParametersList().add("-DdistOutputRelativePath=" + distRelativePath);
        return params;
    }

    /*
     * Unable to fully structure code
     */
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        project = e.getProject();
        v0 = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"e.presentation");
        if (project == null) ** GOTO lbl-1000
        v1 = this.isIdeaProject(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"isIdeaProject(project)");
        if (v1.booleanValue()) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        v0.setEnabledAndVisible(v2);
    }

    private final Boolean isIdeaProject(Project project) {
        Boolean bl;
        try {
            bl = (Boolean)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled((ThrowableComputable)new ThrowableComputable<Boolean, RuntimeException>(project){
                final /* synthetic */ Project $project;

                public final boolean compute() {
                    return PsiUtil.isIdeaProject(this.$project);
                }
                {
                    this.$project = project;
                }
            });
        }
        catch (IndexNotReadyException e) {
            bl = false;
        }
        return bl;
    }

    @JvmOverloads
    public UpdateIdeFromSourcesAction(boolean forceShowSettings) {
        super(forceShowSettings ? "Update IDE from Sources Settings..." : "Update IDE from Sources...", "Builds an installation of IntelliJ IDEA from the currently opened sources and replace the current installation by it.", null);
        this.forceShowSettings = forceShowSettings;
    }

    public /* synthetic */ UpdateIdeFromSourcesAction(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @JvmOverloads
    public UpdateIdeFromSourcesAction() {
        this(false, 1, null);
    }

    public static final /* synthetic */ void access$runUpdateScript(UpdateIdeFromSourcesAction $this, JavaParameters params, Project project, String workIdeHome, String builtDistPath, String backupDir) {
        $this.runUpdateScript(params, project, workIdeHome, builtDistPath, backupDir);
    }

    public static final /* synthetic */ void access$backupImportantFilesIfNeeded(UpdateIdeFromSourcesAction $this, String workIdeHome, String backupDirPath, ProgressIndicator indicator) {
        $this.backupImportantFilesIfNeeded(workIdeHome, backupDirPath, indicator);
    }

    public static final /* synthetic */ void access$startCopyingFiles(UpdateIdeFromSourcesAction $this, String builtDistPath, String workIdeHome, Project project) {
        $this.startCopyingFiles(builtDistPath, workIdeHome, project);
    }

    public static final /* synthetic */ String[] access$generateUpdateCommand(UpdateIdeFromSourcesAction $this, String builtDistPath, String workIdeHome) {
        return $this.generateUpdateCommand(builtDistPath, workIdeHome);
    }

    public static final /* synthetic */ void access$restartWithCommand(UpdateIdeFromSourcesAction $this, String[] command) {
        $this.restartWithCommand(command);
    }
}

