/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.generator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAnnotation;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSFacet;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSModelGroupDefinition;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jetbrains.idea.devkit.dom.generator.FieldDesc;
import org.jetbrains.idea.devkit.dom.generator.ModelDesc;
import org.jetbrains.idea.devkit.dom.generator.ModelLoader;
import org.jetbrains.idea.devkit.dom.generator.NamespaceDesc;
import org.jetbrains.idea.devkit.dom.generator.TypeDesc;
import org.jetbrains.idea.devkit.dom.generator.Util;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public class XSDModelLoader
implements ModelLoader {
    private static final boolean TEXT_ELEMENTS_ARE_COMPLEX = false;
    private ModelDesc model;

    @Override
    public void loadModel(ModelDesc model, Collection<File> files, XMLEntityResolver resolver) throws Exception {
        this.model = model;
        this.processSchemas(files, resolver);
    }

    public static boolean checkComplexType(XSTypeDefinition td) {
        if (td.getTypeCategory() != 15) {
            return false;
        }
        XSComplexTypeDefinition ctd = (XSComplexTypeDefinition)td;
        if (ctd.getContentType() == 2) {
            return true;
        }
        if (td instanceof XSComplexTypeDecl && ((XSComplexTypeDecl)td).getAbstract()) {
            return true;
        }
        if (ctd.getAttributeUses() != null) {
            for (int i = 0; i < ctd.getAttributeUses().getLength(); ++i) {
                XSSimpleTypeDefinition xsstd = ((XSAttributeUse)ctd.getAttributeUses().item(i)).getAttrDeclaration().getTypeDefinition();
                if ("ID".equals(xsstd.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkEnumType(XSTypeDefinition td) {
        XSSimpleTypeDefinition st;
        if (td.getTypeCategory() == 15) {
            XSComplexTypeDefinition ctd = (XSComplexTypeDefinition)td;
            if (ctd.getContentType() != 1) {
                return false;
            }
            if (ctd.getAttributeUses() != null) {
                for (int i = 0; i < ctd.getAttributeUses().getLength(); ++i) {
                    XSSimpleTypeDefinition xsstd = ((XSAttributeUse)ctd.getAttributeUses().item(i)).getAttrDeclaration().getTypeDefinition();
                    if ("ID".equals(xsstd.getName())) continue;
                    return false;
                }
            }
            st = ctd.getSimpleType();
        } else if (td.getTypeCategory() == 16) {
            st = (XSSimpleTypeDefinition)td;
        } else {
            return false;
        }
        return st.getLexicalEnumeration() != null && st.getLexicalEnumeration().getLength() != 0;
    }

    private static boolean checkBooleanType(XSTypeDefinition td) {
        if (td.getTypeCategory() != 16) {
            return false;
        }
        XSSimpleTypeDefinition st = (XSSimpleTypeDefinition)td;
        XSObjectList facets = st.getFacets();
        for (int i = 0; i < facets.getLength(); ++i) {
            XSFacet facet = (XSFacet)facets.item(i);
            if (facet.getFacetKind() != 1 || !"0".equals(facet.getLexicalFacetValue())) continue;
            return true;
        }
        return false;
    }

    private XSModel loadSchema(File schemaFile, XMLEntityResolver resolver) throws Exception {
        String file;
        QName qname;
        XSObject obj;
        int i;
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
        DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
        XSImplementation impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
        XSLoader schemaLoader = impl.createXSLoader(null);
        DOMConfiguration config = schemaLoader.getConfig();
        DOMErrorHandler errorHandler = new DOMErrorHandler(){

            @Override
            public boolean handleError(DOMError domError) {
                Util.log("DOMError: " + domError.getMessage());
                Object relatedException = domError.getRelatedException();
                if (relatedException != null) {
                    Util.log("DOMError: " + relatedException);
                    if (relatedException instanceof Throwable) {
                        ((Throwable)relatedException).printStackTrace(System.out);
                    }
                }
                return false;
            }
        };
        config.setParameter("error-handler", errorHandler);
        config.setParameter("validate", Boolean.TRUE);
        config.setParameter("error-handler", errorHandler);
        config.setParameter("http://apache.org/xml/properties/internal/entity-resolver", resolver);
        XSModel model = schemaLoader.loadURI(schemaFile.getAbsolutePath());
        if (model == null) {
            return null;
        }
        XSNamedMap components = model.getComponents((short)2);
        for (i = 0; i < components.getLength(); ++i) {
            obj = components.item(i);
            qname = new QName(obj.getNamespace(), obj.getName());
            file = this.model.qname2FileMap.get(qname);
            this.model.qname2FileMap.put(qname, (file == null ? "" : file + ";") + schemaFile.getName());
        }
        components = model.getComponents((short)3);
        for (i = 0; i < components.getLength(); ++i) {
            obj = components.item(i);
            qname = new QName(obj.getNamespace(), obj.getName());
            file = this.model.qname2FileMap.get(qname);
            this.model.qname2FileMap.put(qname, (file == null ? "" : file) + ":" + schemaFile.getName() + ":");
        }
        return model;
    }

    public void processSchemas(Collection<File> schemas, XMLEntityResolver resolver) throws Exception {
        Map<String, NamespaceDesc> nsdMap = this.model.nsdMap;
        Map<String, TypeDesc> jtMap = this.model.jtMap;
        NamespaceDesc nsdDef = nsdMap.get("");
        ArrayList<XSModel> models = new ArrayList<XSModel>();
        HashMap<String, Object> types = new HashMap<String, Object>();
        for (File schemaFile : schemas) {
            String fileName = schemaFile.getPath();
            if (schemaFile.isDirectory() || !fileName.endsWith(".xsd")) {
                Util.log("skipping " + fileName);
                continue;
            }
            Util.log("loading " + fileName + "..");
            XSModel model = this.loadSchema(schemaFile, resolver);
            if (model == null) continue;
            StringList namespaceList = model.getNamespaces();
            for (int i = 0; i < namespaceList.getLength(); ++i) {
                String ns = namespaceList.item(i);
                if (nsdMap.containsKey(ns)) continue;
                Util.log("Adding default namespace desc for: " + ns);
                NamespaceDesc nsd = new NamespaceDesc(ns, nsdDef);
                nsdMap.put(ns, nsd);
            }
            models.add(model);
            XSNamedMap typeDefMap = model.getComponents((short)3);
            for (int i = 0; i < typeDefMap.getLength(); ++i) {
                XSTypeDefinition o = (XSTypeDefinition)typeDefMap.item(i);
                NamespaceDesc nsd = nsdMap.get(o.getNamespace());
                if (nsd != null && nsd.skip) continue;
                String key = o.getName() + "," + o.getNamespace();
                types.put(key, o);
            }
            XSNamedMap elementDeclMap = model.getComponents((short)2);
            for (int i = 0; i < elementDeclMap.getLength(); ++i) {
                XSElementDeclaration o = (XSElementDeclaration)elementDeclMap.item(i);
                if (!o.getTypeDefinition().getAnonymous() || !(o.getTypeDefinition() instanceof XSComplexTypeDefinition)) continue;
                XSComplexTypeDefinition ctd = this.makeTypeFromAnonymous((XSObject)o);
                NamespaceDesc nsd = nsdMap.get(o.getNamespace());
                if (nsd != null && nsd.skip) continue;
                String key = ctd.getName() + "," + ctd.getNamespace();
                types.put(key, ctd);
            }
        }
        Util.log(types.size() + " elements loaded, processing..");
        ArrayList toProcess = new ArrayList(types.values());
        ArrayList<XSComplexTypeDefinition> toAdd = new ArrayList<XSComplexTypeDefinition>();
        ListIterator it = toProcess.listIterator();
        while (it.hasNext()) {
            XSTypeDefinition td = (XSTypeDefinition)it.next();
            Util.log("processing " + td.getName() + "," + td.getNamespace() + "..");
            if (XSDModelLoader.checkComplexType(td)) {
                this.processType((XSComplexTypeDefinition)td, models, jtMap, nsdMap, toAdd);
            } else if (XSDModelLoader.checkEnumType(td)) {
                this.processEnumType(td, jtMap, nsdMap);
            }
            if (toAdd.size() == 0) continue;
            for (XSComplexTypeDefinition o : toAdd) {
                String key = o.getName() + "," + o.getNamespace();
                if (!types.containsKey(key)) {
                    Util.log("  adding " + o.getName() + "," + o.getNamespace());
                    types.put(key, o);
                    it.add(o);
                    it.previous();
                    continue;
                }
                Util.logwarn(key + " already exists");
            }
            toAdd.clear();
        }
    }

    private XSComplexTypeDefinition makeTypeFromAnonymous(XSObject o) {
        XSComplexTypeDecl ctd = new XSComplexTypeDecl();
        if (o instanceof XSElementDeclaration && ((XSElementDeclaration)o).getTypeDefinition() instanceof XSComplexTypeDecl) {
            XSComplexTypeDecl ctd1 = (XSComplexTypeDecl)((XSElementDeclaration)o).getTypeDefinition();
            XSObjectListImpl annotations = ctd1.getAnnotations() instanceof XSObjectListImpl ? (XSObjectListImpl)ctd1.getAnnotations() : new XSObjectListImpl();
            ctd.setValues(o.getName(), ctd1.getNamespace(), ctd1.getBaseType(), ctd1.getDerivationMethod(), ctd1.getFinal(), ctd1.getProhibitedSubstitutions(), ctd1.getContentType(), ctd1.getAbstract(), ctd1.getAttrGrp(), (XSSimpleType)ctd1.getSimpleType(), (XSParticleDecl)ctd1.getParticle(), annotations);
            ctd.setName(o.getName() + "ElemType");
        } else if (o instanceof XSAttributeDeclaration) {
            XSSimpleTypeDecl ctd1 = (XSSimpleTypeDecl)((XSAttributeDeclaration)o).getTypeDefinition();
            XSObjectListImpl annotations = ctd1.getAnnotations() instanceof XSObjectListImpl ? (XSObjectListImpl)ctd1.getAnnotations() : new XSObjectListImpl();
            ctd.setValues(o.getName(), ctd1.getNamespace(), ctd1.getBaseType(), (short)2, ctd1.getFinal(), (short)0, (short)1, false, new XSAttributeGroupDecl(), (XSSimpleType)ctd1, null, annotations);
            ctd.setName(o.getName() + "AttrType");
        }
        this.model.qname2FileMap.put(new QName(ctd.getNamespace(), ctd.getName()), this.model.qname2FileMap.get(new QName(o.getNamespace(), o.getName())));
        return ctd;
    }

    public void processEnumType(XSTypeDefinition def, Map<String, TypeDesc> jtMap, Map<String, NamespaceDesc> nsdMap) throws Exception {
        boolean complexType = def instanceof XSComplexTypeDefinition;
        if (!nsdMap.containsKey(def.getNamespace())) {
            Util.log("Namespace desc not found for: " + def);
        }
        String typeName = this.toJavaTypeName((XSObject)def, nsdMap);
        TypeDesc td = new TypeDesc(def.getName(), def.getNamespace(), typeName, TypeDesc.TypeEnum.ENUM);
        XSComplexTypeDefinition ct = complexType ? (XSComplexTypeDefinition)def : null;
        XSSimpleTypeDefinition st = (XSSimpleTypeDefinition)(complexType ? ((XSComplexTypeDefinition)def).getSimpleType() : def);
        for (int i = 0; i < st.getLexicalEnumeration().getLength(); ++i) {
            String s = st.getLexicalEnumeration().item(i);
            td.fdMap.put(s, new FieldDesc(Util.computeEnumConstantName(s, td.name), s));
        }
        XSObjectList anns = complexType ? ct.getAnnotations() : st.getAnnotations();
        td.documentation = XSDModelLoader.parseAnnotationString("Enumeration " + def.getNamespace() + ":" + def.getName() + " documentation", anns != null && anns.getLength() > 0 ? ((XSAnnotation)anns.item(0)).getAnnotationString() : null);
        jtMap.put(this.model.toJavaQualifiedTypeName((XSObject)def, nsdMap, true), td);
    }

    public void processType(XSComplexTypeDefinition def, List<XSModel> models, Map<String, TypeDesc> jtMap, Map<String, NamespaceDesc> nsdMap, ArrayList<XSComplexTypeDefinition> toAdd) throws Exception {
        if (!nsdMap.containsKey(def.getNamespace())) {
            Util.log("Namespace desc not found for: " + def);
        }
        String typeName = this.toJavaTypeName((XSObject)def, nsdMap);
        TypeDesc td = jtMap.get(this.model.toJavaQualifiedTypeName((XSObject)def, nsdMap, false));
        if (td != null) {
            if (td.fdMap.size() != 0) {
                Util.logerr("merging: type names collision: " + typeName);
            }
        } else {
            td = new TypeDesc(def.getName(), def.getNamespace(), typeName, TypeDesc.TypeEnum.CLASS);
        }
        XSObjectList anns = def.getAnnotations();
        td.documentation = XSDModelLoader.parseAnnotationString("Type " + def.getNamespace() + ":" + def.getName() + " documentation", anns != null && anns.getLength() > 0 ? ((XSAnnotation)anns.item(0)).getAnnotationString() : null);
        TypeDesc tdBase = null;
        if (XSDModelLoader.checkComplexType(def.getBaseType())) {
            XSComplexTypeDefinition base = (XSComplexTypeDefinition)def.getBaseType();
            String typeNameBase = this.toJavaTypeName((XSObject)base, nsdMap);
            tdBase = jtMap.get(this.model.toJavaQualifiedTypeName((XSObject)base, nsdMap, false));
            if (tdBase == null) {
                tdBase = new TypeDesc(base.getName(), base.getNamespace(), typeNameBase, TypeDesc.TypeEnum.CLASS);
                jtMap.put(this.model.toJavaQualifiedTypeName((XSObject)base, nsdMap, false), tdBase);
            }
        }
        if (def.getSimpleType() != null || def.getContentType() == 3) {
            FieldDesc fd = new FieldDesc(6, "value", "String", null, "null", true);
            fd.realIndex = td.fdMap.size();
            td.fdMap.put(fd.name, fd);
        }
        XSObjectList attrs = def.getAttributeUses();
        for (int i = 0; i < attrs.getLength(); ++i) {
            XSAttributeUse au = (XSAttributeUse)attrs.item(i);
            XSAttributeDeclaration ad = au.getAttrDeclaration();
            XSSimpleTypeDefinition atd = ad.getTypeDefinition();
            XSAnnotation ann = ad.getAnnotation();
            String documentation = XSDModelLoader.parseAnnotationString("Attribute " + ad.getNamespace() + ":" + ad.getName() + " documentation", ann != null ? ann.getAnnotationString() : null);
            if ("ID".equals(atd.getName()) || ad.getConstraintType() == 2) continue;
            FieldDesc fd1 = new FieldDesc(4, Util.toJavaFieldName(ad.getName()), "String", null, "null", au.getRequired());
            fd1.tagName = ad.getName();
            fd1.documentation = documentation;
            fd1.realIndex = td.fdMap.size();
            boolean bl = td.duplicates = Util.addToNameMap(td.fdMap, fd1, false) || td.duplicates;
            if (XSDModelLoader.checkEnumType((XSTypeDefinition)ad.getTypeDefinition())) {
                XSSimpleTypeDefinition etRoot = ad.getTypeDefinition();
                if (etRoot.getAnonymous()) {
                    etRoot = this.makeTypeFromAnonymous((XSObject)ad);
                    if (toAdd != null) {
                        toAdd.add((XSComplexTypeDefinition)etRoot);
                    }
                }
                fd1.type = this.toJavaTypeName((XSObject)etRoot, nsdMap);
                fd1.contentQualifiedName = this.model.toJavaQualifiedTypeName((XSObject)etRoot, nsdMap, true);
                if (jtMap.get(fd1.contentQualifiedName) != null) continue;
                TypeDesc ftd = new TypeDesc(etRoot.getName(), etRoot.getNamespace(), fd1.type, TypeDesc.TypeEnum.ENUM);
                jtMap.put(fd1.contentQualifiedName, ftd);
                continue;
            }
            fd1.simpleTypesString = XSDModelLoader.getSimpleTypesString((XSTypeDefinition)ad.getTypeDefinition());
        }
        LinkedList<PEntry> plist = new LinkedList<PEntry>();
        if (def.getParticle() != null) {
            plist.add(new PEntry(def.getParticle(), false));
        }
        this.processParticles((XSObject)def, plist, nsdMap, jtMap, td, models, toAdd, tdBase);
        jtMap.put(this.model.toJavaQualifiedTypeName((XSObject)def, nsdMap, false), td);
        if (td.fdMap.size() == 1 && def.getSimpleType() != null) {
            FieldDesc fd = td.fdMap.get("value");
            fd.simpleTypesString = XSDModelLoader.getSimpleTypesString((XSTypeDefinition)def);
        }
    }

    private static String getSimpleTypesString(XSTypeDefinition et) {
        StringBuilder typesHierarchy = new StringBuilder();
        while (et != null && !"anySimpleType".equals(et.getName()) && !"anyType".equals(et.getName()) && et.getNamespace() != null) {
            XSObjectList list;
            XSSimpleType simpleType;
            typesHierarchy.append(et.getNamespace().substring(et.getNamespace().lastIndexOf("/") + 1)).append(":").append(et.getName()).append(";");
            if (et instanceof XSSimpleType && ((simpleType = (XSSimpleType)et).getVariety() == 2 || simpleType.getVariety() == 3) && (list = simpleType.getMemberTypes()).getLength() > 0) {
                typesHierarchy.append("{");
                for (int i = 0; i < list.getLength(); ++i) {
                    typesHierarchy.append(XSDModelLoader.getSimpleTypesString((XSTypeDefinition)list.item(i)));
                }
                typesHierarchy.append("}");
            }
            et = et.getBaseType();
        }
        return typesHierarchy.toString();
    }

    private TypeDesc processGroup(XSModelGroup modelGroup, List<XSModel> models, Map<String, TypeDesc> jtMap, Map<String, NamespaceDesc> nsdMap) {
        XSModelGroupDefinition def = null;
        block0: for (XSModel xsModel : models) {
            XSNamedMap map = xsModel.getComponents((short)6);
            for (int i = 0; i < map.getLength(); ++i) {
                XSModelGroupDefinition mg = (XSModelGroupDefinition)map.item(i);
                XSModelGroup xsModelGroup = mg.getModelGroup();
                if (xsModelGroup != modelGroup && !xsModelGroup.toString().equals(modelGroup.toString())) continue;
                def = mg;
                continue block0;
            }
        }
        if (def == null) {
            return null;
        }
        if (!nsdMap.containsKey(def.getNamespace())) {
            Util.log("Namespace desc not found for: " + def);
        }
        String typeName = this.toJavaTypeName((XSObject)def, nsdMap);
        String typeQName = this.model.toJavaQualifiedTypeName((XSObject)def, nsdMap, false);
        TypeDesc td = jtMap.get(typeQName);
        if (td != null) {
            if (td.type == TypeDesc.TypeEnum.GROUP_INTERFACE) {
                return td;
            }
            Util.logerr("type-group conflict: " + typeName);
            return null;
        }
        td = new TypeDesc(def.getName(), def.getNamespace(), typeName, TypeDesc.TypeEnum.GROUP_INTERFACE);
        XSAnnotation ann = def.getAnnotation();
        td.documentation = XSDModelLoader.parseAnnotationString("Type " + def.getNamespace() + ":" + def.getName() + " documentation", ann == null ? null : ann.getAnnotationString());
        td.type = TypeDesc.TypeEnum.GROUP_INTERFACE;
        LinkedList<PEntry> plist = new LinkedList<PEntry>();
        for (int i = 0; i < def.getModelGroup().getParticles().getLength(); ++i) {
            XSParticle p = (XSParticle)def.getModelGroup().getParticles().item(i);
            plist.add(new PEntry(p, false));
        }
        this.processParticles((XSObject)def, plist, nsdMap, jtMap, td, models, null, null);
        jtMap.put(typeQName, td);
        return td;
    }

    private void processParticles(XSObject def, LinkedList<PEntry> plist, Map<String, NamespaceDesc> nsdMap, Map<String, TypeDesc> jtMap, TypeDesc td, List<XSModel> models, ArrayList<XSComplexTypeDefinition> toAdd, TypeDesc baseClass) {
        boolean globalMerge = jtMap.containsKey(this.model.toJavaQualifiedTypeName(def, nsdMap, td.type == TypeDesc.TypeEnum.ENUM));
        HashMap<XSParticle, String> globalChoice = new HashMap<XSParticle, String>();
        ArrayList<XSObjectList> choiceList = new ArrayList<XSObjectList>();
        ArrayList<TypeDesc> supers = new ArrayList<TypeDesc>();
        if (baseClass != null) {
            supers.add(baseClass);
        }
        while (!plist.isEmpty()) {
            PEntry pentry = plist.removeFirst();
            XSParticle p = pentry.p;
            if (p.getTerm() instanceof XSElementDecl) {
                XSTypeDefinition etRoot;
                XSElementDecl el = (XSElementDecl)p.getTerm();
                if (el.getConstraintType() == 2) continue;
                XSTypeDefinition et = etRoot = el.getTypeDefinition();
                XSAnnotation ann = el.getAnnotation();
                String documentation = XSDModelLoader.parseAnnotationString("Element " + el.getNamespace() + ":" + el.getName() + " documentation", ann != null ? ann.getAnnotationString() : null);
                FieldDesc fd1 = new FieldDesc(1, Util.toJavaFieldName(el.getName()), et.getName(), null, "null", !pentry.many && p.getMinOccurs() > 0);
                fd1.documentation = documentation;
                fd1.tagName = el.getName();
                while (et.getBaseType() != null && !"anySimpleType".equals(et.getBaseType().getName()) && !"anyType".equals(et.getBaseType().getName())) {
                    et = et.getBaseType();
                }
                if (XSDModelLoader.checkEnumType(etRoot)) {
                    if (etRoot.getAnonymous()) {
                        etRoot = this.makeTypeFromAnonymous((XSObject)el);
                        if (toAdd != null) {
                            toAdd.add((XSComplexTypeDefinition)etRoot);
                        }
                    }
                    fd1.type = this.toJavaTypeName((XSObject)etRoot, nsdMap);
                    fd1.clType = 3;
                    fd1.contentQualifiedName = this.model.toJavaQualifiedTypeName((XSObject)etRoot, nsdMap, true);
                    if (!jtMap.containsKey(fd1.contentQualifiedName)) {
                        TypeDesc ftd = new TypeDesc(etRoot.getName(), etRoot.getNamespace(), fd1.type, TypeDesc.TypeEnum.ENUM);
                        jtMap.put(fd1.contentQualifiedName, ftd);
                    }
                } else if (XSDModelLoader.checkComplexType(etRoot)) {
                    if (etRoot.getAnonymous()) {
                        etRoot = this.makeTypeFromAnonymous((XSObject)el);
                        if (toAdd != null) {
                            toAdd.add((XSComplexTypeDefinition)etRoot);
                        }
                    }
                    fd1.type = this.toJavaTypeName((XSObject)etRoot, nsdMap);
                    fd1.clType = 3;
                    fd1.contentQualifiedName = this.model.toJavaQualifiedTypeName((XSObject)etRoot, nsdMap, false);
                    if (jtMap.get(fd1.contentQualifiedName) == null) {
                        jtMap.put(fd1.contentQualifiedName, new TypeDesc(etRoot.getName(), etRoot.getNamespace(), fd1.type, TypeDesc.TypeEnum.CLASS));
                    }
                } else if (XSDModelLoader.checkBooleanType(etRoot)) {
                    fd1.type = "boolean";
                    fd1.clType = 2;
                } else {
                    if (etRoot instanceof XSComplexTypeDefinition) {
                        XSComplexTypeDefinition ct = (XSComplexTypeDefinition)etRoot;
                        ann = (XSAnnotation)(ct.getAnnotations() != null && ct.getAnnotations().getLength() > 0 ? ct.getAnnotations().item(ct.getAnnotations().getLength() - 1) : null);
                        documentation = XSDModelLoader.parseAnnotationString("Type " + ct.getNamespace() + ":" + ct.getName() + " documentation", ann != null ? ann.getAnnotationString() : null);
                        if (documentation != null) {
                            fd1.documentation = fd1.documentation != null ? fd1.documentation + "\n" + documentation : documentation;
                        }
                    }
                    fd1.simpleTypesString = XSDModelLoader.getSimpleTypesString(etRoot);
                    fd1.type = et.getName();
                    if (fd1.type == null) {
                        fd1.type = "String";
                        fd1.def = "null";
                        fd1.clType = 1;
                    } else if (fd1.type.equals("string") || fd1.type.equals("anyURI")) {
                        fd1.type = "String";
                    } else if (fd1.type.equals("boolean")) {
                        fd1.type = "String";
                    } else if (fd1.type.equals("emptyType")) {
                        fd1.type = "boolean";
                        fd1.def = "false";
                        fd1.clType = 2;
                    } else if (fd1.type.equals("decimal")) {
                        fd1.type = "String";
                        fd1.def = "\"0.0\"";
                    } else if (fd1.type.equals("QName")) {
                        fd1.type = "String";
                    } else if (fd1.type.equals("extensibleType")) {
                        fd1.type = "Object";
                    } else {
                        if (et.getBaseType() != null && ("anySimpleType".equals(et.getBaseType().getName()) || "anyType".equals(et.getBaseType().getName()))) {
                            fd1.type = "String";
                            fd1.def = "null";
                            fd1.clType = 1;
                        } else {
                            fd1.type = "boolean";
                            fd1.def = "false";
                            fd1.clType = 2;
                        }
                        Util.logwarn("using '" + fd1.type + "' for unknown base type: " + et.getName() + " for " + el);
                    }
                }
                if ((pentry.many || p.getMaxOccursUnbounded() || p.getMaxOccurs() > 1) && fd1.clType != 2) {
                    fd1.elementType = fd1.type;
                    fd1.elementName = fd1.name;
                    fd1.type = "List<" + fd1.elementType + ">";
                    fd1.name = Util.pluralize(fd1.name);
                    fd1.def = "new ArrayList(0)";
                    fd1.clType = -fd1.clType;
                    fd1.comment = "array of " + fd1.elementType;
                }
                fd1.realIndex = td.fdMap.size();
                boolean merge = globalMerge || globalChoice.containsKey(p) && globalChoice.containsValue(fd1.name);
                td.duplicates = Util.addToNameMap(td.fdMap, fd1, merge) || td.duplicates;
                globalChoice.put(p, fd1.name);
                continue;
            }
            if (!(p.getTerm() instanceof XSModelGroup)) continue;
            boolean addToGlobalChoice = false;
            boolean many = p.getMaxOccursUnbounded() || p.getMaxOccurs() > 1;
            XSObjectList l = ((XSModelGroup)p.getTerm()).getParticles();
            if (!many) {
                if (((XSModelGroup)p.getTerm()).getCompositor() == 2) {
                    addToGlobalChoice = true;
                    choiceList.add(l);
                } else {
                    XSModelGroup groupDef = (XSModelGroup)p.getTerm();
                    TypeDesc gtd = this.processGroup(groupDef, models, jtMap, nsdMap);
                    if (gtd != null) {
                        supers.add(gtd);
                    }
                }
            }
            if (globalChoice.containsKey(p)) {
                addToGlobalChoice = true;
            }
            for (int i = 0; i < l.getLength(); ++i) {
                PEntry o = new PEntry((XSParticle)l.item(i), many);
                plist.add(o);
                if (!addToGlobalChoice || globalChoice.containsKey(o.p)) continue;
                globalChoice.put(o.p, null);
            }
        }
        int i = 0;
        for (FieldDesc fd : td.fdMap.values()) {
            fd.idx = i++;
        }
        for (XSObjectList l : choiceList) {
            ArrayList<XSParticle> clist = new ArrayList<XSParticle>();
            LinkedList<XSParticle> elist = new LinkedList<XSParticle>();
            for (i = 0; i < l.getLength(); ++i) {
                elist.add((XSParticle)l.item(i));
            }
            while (!elist.isEmpty()) {
                XSParticle p = (XSParticle)elist.removeFirst();
                if (p.getTerm() instanceof XSModelGroup) {
                    XSObjectList l2 = ((XSModelGroup)p.getTerm()).getParticles();
                    for (int i2 = 0; i2 < l2.getLength(); ++i2) {
                        elist.addFirst((XSParticle)l2.item(i2));
                    }
                    continue;
                }
                if (!(p.getTerm() instanceof XSElementDecl)) continue;
                clist.add(p);
            }
            boolean choiceOpt = true;
            FieldDesc[] choice = new FieldDesc[clist.size()];
            for (i = 0; i < choice.length; ++i) {
                FieldDesc fd;
                XSParticle p = (XSParticle)clist.get(i);
                XSElementDecl el = (XSElementDecl)p.getTerm();
                String s = Util.toJavaFieldName(el.getName());
                if (p.getMaxOccursUnbounded() || p.getMaxOccurs() > 1) {
                    s = Util.pluralize(s);
                }
                if ((fd = td.fdMap.get(s)) == null && (fd = td.fdMap.get(Util.pluralize(s))) == null) {
                    Util.logerr("uknown choice element: " + s);
                }
                if (fd == null) continue;
                choice[i] = fd;
                choice[i].choice = choice;
                if (!fd.required) continue;
                choiceOpt = false;
            }
            for (i = 0; i < choice.length; ++i) {
                if (choice[i] == null) continue;
                choice[i].choiceOpt = choiceOpt;
            }
        }
        td.supers = supers.toArray(new TypeDesc[0]);
    }

    public static String parseAnnotationString(String title, String str) {
        if (str == null) {
            return null;
        }
        int idx = str.indexOf(":documentation");
        if (idx == -1) {
            idx = str.indexOf("<documentation");
        }
        if (idx == -1) {
            return null;
        }
        if ((idx = str.indexOf(">", idx + 1)) == -1) {
            return null;
        }
        int idx2 = str.indexOf(":documentation", idx + 1);
        if (idx2 == -1) {
            idx2 = str.indexOf("</documentation", idx + 1);
        }
        if ((idx = (str = str.substring(idx + 1, idx2 = str.lastIndexOf("<", idx2 + 1)).trim()).indexOf("<![CDATA[")) > -1) {
            idx = str.indexOf("[", idx + 3);
            idx2 = str.indexOf("]]>", idx + 1);
            str = str.substring(idx + 1, idx2);
        }
        return "<pre>\n<h3>" + title + "</h3>\n" + str + "\n</pre>";
    }

    public String toJavaTypeName(XSObject xs, Map<String, NamespaceDesc> nsdMap) {
        String name = xs.getName();
        if (name == null && xs instanceof TypeInfo && (name = ((TypeInfo)xs).getTypeName()) != null && name.startsWith("#")) {
            name = name.substring(1);
        }
        return this.model.toJavaTypeName(name, xs.getNamespace());
    }

    public static class PEntry {
        XSParticle p;
        boolean many;

        public PEntry(XSParticle p, boolean many) {
            this.p = p;
            this.many = many;
        }
    }
}

