/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.ProjectIconsAccessor;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.xml.DomUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ActionOrGroup;
import org.jetbrains.idea.devkit.dom.AddToGroup;
import org.jetbrains.idea.devkit.dom.Group;
import org.jetbrains.idea.devkit.dom.Reference;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UastContextKt;

public class ActionOrGroupPresentationProvider
extends PresentationProvider<ActionOrGroup> {
    @Nullable
    public Icon getIcon(@Nullable ActionOrGroup actionOrGroup) {
        return ActionOrGroupPresentationProvider.getIconForActionOrGroup(actionOrGroup);
    }

    @Nullable
    private static Icon getIconForActionOrGroup(@Nullable ActionOrGroup actionOrGroup) {
        String value;
        Icon icon;
        if (actionOrGroup == null || !DomUtil.hasXml(actionOrGroup.getIcon())) {
            return actionOrGroup instanceof Group ? AllIcons.Actions.GroupByPackage : null;
        }
        XmlAttributeValue iconAttrValue = actionOrGroup.getIcon().getXmlAttributeValue();
        assert (iconAttrValue != null);
        boolean referenceFound = false;
        for (PsiReference reference : iconAttrValue.getReferences()) {
            referenceFound = true;
            Icon icon2 = ActionOrGroupPresentationProvider.getIconFromReference(reference);
            if (icon2 == null) continue;
            return icon2;
        }
        if (referenceFound && (icon = IconLoader.findIcon((String)(value = iconAttrValue.getValue()), (boolean)false)) != null) {
            return icon;
        }
        return null;
    }

    @Nullable
    private static Icon getIconFromReference(@NotNull PsiReference reference) {
        PsiElement resolved;
        if (reference == null) {
            ActionOrGroupPresentationProvider.$$$reportNull$$$0(0);
        }
        if (!((resolved = reference.resolve()) instanceof PsiField)) {
            return null;
        }
        UField field = (UField)UastContextKt.toUElement((PsiElement)resolved, UField.class);
        assert (field != null);
        UExpression expression = field.getUastInitializer();
        if (expression == null) {
            return null;
        }
        ProjectIconsAccessor iconsAccessor = ProjectIconsAccessor.getInstance((Project)resolved.getProject());
        VirtualFile iconFile = iconsAccessor.resolveIconFile((UElement)expression);
        return iconFile == null ? null : iconsAccessor.getIcon(iconFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/idea/devkit/dom/impl/ActionOrGroupPresentationProvider", "getIconFromReference"));
    }

    public static class ForAddToGroup
    extends PresentationProvider<AddToGroup> {
        @Nullable
        public Icon getIcon(AddToGroup addToGroup) {
            return ActionOrGroupPresentationProvider.getIconForActionOrGroup((ActionOrGroup)addToGroup.getGroupId().getValue());
        }
    }

    public static class ForReference
    extends PresentationProvider<Reference> {
        @Nullable
        public Icon getIcon(Reference reference) {
            if (DomUtil.hasXml(reference.getId())) {
                return ActionOrGroupPresentationProvider.getIconForActionOrGroup((ActionOrGroup)reference.getId().getValue());
            }
            return ActionOrGroupPresentationProvider.getIconForActionOrGroup((ActionOrGroup)reference.getRef().getValue());
        }
    }
}

