/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.dom.index;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.dom.Action;
import org.jetbrains.idea.devkit.dom.Actions;
import org.jetbrains.idea.devkit.dom.Component;
import org.jetbrains.idea.devkit.dom.Group;
import org.jetbrains.idea.devkit.dom.IdeaPlugin;
import org.jetbrains.idea.devkit.dom.index.RegistrationEntry;

class RegistrationIndexer {
    private final IdeaPlugin myPlugin;
    private final Map<String, List<RegistrationEntry>> myValueMap = FactoryMap.create(s -> new SmartList());

    RegistrationIndexer(IdeaPlugin plugin) {
        this.myPlugin = plugin;
    }

    @NotNull
    Map<String, List<RegistrationEntry>> indexFile() {
        this.process(this.myPlugin);
        Map<String, List<RegistrationEntry>> map = this.myValueMap;
        if (map == null) {
            RegistrationIndexer.$$$reportNull$$$0(0);
        }
        return map;
    }

    private void process(IdeaPlugin ideaPlugin) {
        this.processActions(ideaPlugin);
        this.processComponents(ideaPlugin.getApplicationComponents(), components -> components.getComponents(), RegistrationEntry.RegistrationType.APPLICATION_COMPONENT);
        this.processComponents(ideaPlugin.getProjectComponents(), components -> components.getComponents(), RegistrationEntry.RegistrationType.PROJECT_COMPONENT);
        this.processComponents(ideaPlugin.getModuleComponents(), components -> components.getComponents(), RegistrationEntry.RegistrationType.MODULE_COMPONENT);
    }

    private <T extends DomElement> void processComponents(List<T> componentWrappers, Function<T, List<? extends Component>> componentGetter, RegistrationEntry.RegistrationType type) {
        for (DomElement wrapper : componentWrappers) {
            for (Component component : (List)componentGetter.fun((Object)wrapper)) {
                this.addEntry(component, component.getImplementationClass(), type);
            }
        }
    }

    private void processActions(IdeaPlugin ideaPlugin) {
        for (Actions actions : ideaPlugin.getActions()) {
            for (Action action : actions.getActions()) {
                this.processAction(action);
            }
            for (Group group : actions.getGroups()) {
                this.processGroup(group);
            }
        }
    }

    private void processGroup(Group group) {
        this.addEntry(group, (GenericDomValue<PsiClass>)group.getClazz(), RegistrationEntry.RegistrationType.ACTION);
        this.addIdEntry(group, (GenericAttributeValue<String>)group.getId(), RegistrationEntry.RegistrationType.ACTION_GROUP_ID);
        for (Action action : group.getActions()) {
            this.processAction(action);
        }
        for (Group nestedGroup : group.getGroups()) {
            this.processGroup(nestedGroup);
        }
    }

    private void processAction(Action action) {
        this.addEntry(action, (GenericDomValue<PsiClass>)action.getClazz(), RegistrationEntry.RegistrationType.ACTION);
        this.addIdEntry(action, action.getId(), RegistrationEntry.RegistrationType.ACTION_ID);
    }

    private void addIdEntry(DomElement domElement, GenericAttributeValue<String> idValue, RegistrationEntry.RegistrationType type) {
        if (!DomUtil.hasXml((DomElement)domElement)) {
            return;
        }
        String id = idValue.getStringValue();
        if (StringUtil.isEmpty((String)id)) {
            return;
        }
        this.storeEntry(id, domElement, type);
    }

    private void addEntry(DomElement domElement, GenericDomValue<PsiClass> clazzValue, RegistrationEntry.RegistrationType type) {
        if (!DomUtil.hasXml(clazzValue)) {
            return;
        }
        String clazz = clazzValue.getStringValue();
        if (clazz == null) {
            return;
        }
        String className = clazz.replace('$', '.');
        this.storeEntry(className, domElement, type);
    }

    private void storeEntry(String key, DomElement domElement, RegistrationEntry.RegistrationType type) {
        List<RegistrationEntry> entries = this.myValueMap.get(key);
        XmlElement xmlElement = domElement.getXmlElement();
        assert (xmlElement != null) : domElement;
        RegistrationEntry entry = new RegistrationEntry(type, xmlElement.getTextOffset());
        entries.add(entry);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/devkit/dom/index/RegistrationIndexer", "indexFile"));
    }
}

