/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.formConversion;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uiDesigner.binding.FormClassIndex;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.formConversion.ConvertFormToDslActionKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/idea/devkit/formConversion/ConvertFormToDslAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.devkit"})
public final class ConvertFormToDslAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.EDITOR);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"e.getRequiredData(CommonDataKeys.EDITOR)");
        Editor editor = (Editor)object;
        Object object2 = e.getRequiredData(CommonDataKeys.PSI_FILE);
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiJavaFile");
        }
        PsiJavaFile psiFile = (PsiJavaFile)object2;
        Project project = psiFile.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"psiFile.project");
        Project project2 = project;
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        PsiElement element = psiFile.findElementAt(caretModel.getOffset());
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass == null) {
            ConvertFormToDslAction convertFormToDslAction = this;
            boolean bl = false;
            boolean bl2 = false;
            ConvertFormToDslAction $this$run = convertFormToDslAction;
            boolean bl3 = false;
            HintManager.getInstance().showErrorHint(editor, "Please put a caret inside a Java class bound to a form");
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"PsiTreeUtil.getParentOfT\u2026form\")\n      return\n    }");
        PsiClass psiClass2 = psiClass;
        String string = psiClass2.getQualifiedName();
        if (string == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"psiClass.qualifiedName ?: return");
        String qName = string;
        List list = FormClassIndex.findFormsBoundToClass((Project)project2, (String)qName);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"FormClassIndex.findForms\u2026ndToClass(project, qName)");
        PsiFile psiFile2 = (PsiFile)CollectionsKt.singleOrNull((List)list);
        if (psiFile2 == null) {
            ConvertFormToDslAction convertFormToDslAction = this;
            boolean bl = false;
            boolean bl4 = false;
            ConvertFormToDslAction $this$run = convertFormToDslAction;
            boolean bl5 = false;
            HintManager.getInstance().showErrorHint(editor, "Can't find a form bound to " + qName);
            return;
        }
        PsiFile formFile = psiFile2;
        ConvertFormToDslActionKt.convertFormToUiDsl(psiClass2, formFile);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(e.getData(CommonDataKeys.PSI_FILE) instanceof PsiJavaFile && e.getData(CommonDataKeys.EDITOR) != null);
    }
}

