/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.inspections.DescriptionCheckerUtil;
import org.jetbrains.idea.devkit.inspections.DescriptionType;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.idea.devkit.inspections.quickfix.CreateHtmlDescriptionFix;
import org.jetbrains.idea.devkit.util.PsiUtil;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;

abstract class DescriptionNotFoundInspectionBase
extends DevKitUastInspectionBase {
    private final DescriptionType myDescriptionType;

    protected DescriptionNotFoundInspectionBase(DescriptionType descriptionType) {
        super(UClass.class);
        this.myDescriptionType = descriptionType;
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass uClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (uClass == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(1);
        }
        if (uClass instanceof UAnonymousClass) {
            return null;
        }
        PsiClass psiClass = uClass.getJavaPsi();
        PsiIdentifier nameIdentifier = psiClass.getNameIdentifier();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (nameIdentifier == null || module == null || !PsiUtil.isInstantiable(psiClass)) {
            return null;
        }
        PsiClass base = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(this.getClassName(), psiClass.getResolveScope());
        if (base == null || !psiClass.isInheritor(base, true)) {
            return null;
        }
        String descriptionDir = DescriptionCheckerUtil.getDescriptionDirName(psiClass);
        if (StringUtil.isEmptyOrSpaces((String)descriptionDir)) {
            return null;
        }
        for (PsiDirectory description2 : this.getDescriptionsDirs(module)) {
            PsiFile descr;
            PsiDirectory dir = description2.findSubdirectory(descriptionDir);
            if (dir == null || (descr = dir.findFile("description.html")) == null) continue;
            if (!this.skipIfNotRegistered(psiClass) && !DescriptionNotFoundInspectionBase.hasBeforeAndAfterTemplate(dir.getVirtualFile())) {
                PsiElement highlightElement = DescriptionNotFoundInspectionBase.getInspectionHighlightElement(uClass);
                if (highlightElement == null) {
                    return null;
                }
                ProblemDescriptor problemDescriptor = manager.createProblemDescriptor(highlightElement, this.getHasNotBeforeAfterError(), isOnTheFly, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, false, new LocalQuickFix[0]);
                return new ProblemDescriptor[]{problemDescriptor};
            }
            return null;
        }
        if (this.skipIfNotRegistered(psiClass)) {
            return null;
        }
        PsiElement highlightElement = DescriptionNotFoundInspectionBase.getInspectionHighlightElement(uClass);
        if (highlightElement == null) {
            return null;
        }
        ProblemDescriptor problemDescriptor = manager.createProblemDescriptor(highlightElement, this.getHasNotDescriptionError(), isOnTheFly, new LocalQuickFix[]{this.getFix(module, descriptionDir)}, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        return new ProblemDescriptor[]{problemDescriptor};
    }

    @Nullable
    private static PsiElement getInspectionHighlightElement(@NotNull UClass uClass) {
        if (uClass == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(2);
        }
        return UElementKt.getSourcePsiElement((UElement)uClass.getUastAnchor());
    }

    protected CreateHtmlDescriptionFix getFix(Module module, String descriptionDir) {
        return new CreateHtmlDescriptionFix(descriptionDir, module, this.myDescriptionType);
    }

    protected abstract boolean skipIfNotRegistered(PsiClass var1);

    private static boolean hasBeforeAndAfterTemplate(@NotNull VirtualFile dir) {
        if (dir == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(3);
        }
        boolean hasBefore = false;
        boolean hasAfter = false;
        for (VirtualFile file : dir.getChildren()) {
            String name = file.getName();
            if (!name.endsWith(".template")) continue;
            if (name.startsWith("before.")) {
                hasBefore = true;
                continue;
            }
            if (!name.startsWith("after.")) continue;
            hasAfter = true;
        }
        return hasBefore && hasAfter;
    }

    @NotNull
    protected String getClassName() {
        String string = this.myDescriptionType.getClassName();
        if (string == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected PsiDirectory @NotNull [] getDescriptionsDirs(@NotNull Module module) {
        if (module == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(5);
        }
        PsiDirectory[] psiDirectoryArray = DescriptionCheckerUtil.getDescriptionsDirs(module, this.myDescriptionType);
        if (psiDirectoryArray == null) {
            DescriptionNotFoundInspectionBase.$$$reportNull$$$0(6);
        }
        return psiDirectoryArray;
    }

    protected abstract @InspectionMessage @NotNull String getHasNotDescriptionError();

    protected abstract @InspectionMessage @NotNull String getHasNotBeforeAfterError();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspectionBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/inspections/DescriptionNotFoundInspectionBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionsDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionHighlightElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasBeforeAndAfterTemplate";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptionsDirs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

