/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.inspections.DevKitInspectionBase;

public class UnsafeReturnStatementVisitorInspection
extends DevKitInspectionBase {
    private static final String BASE_WALKING_VISITOR_NAME = JavaRecursiveElementWalkingVisitor.class.getName();
    private static final String BASE_VISITOR_NAME = JavaRecursiveElementVisitor.class.getName();
    private static final String EMPTY_LAMBDA = "public void visitLambdaExpression(PsiLambdaExpression expression) {}";
    private static final String EMPTY_CLASS = "public void visitClass(PsiClass aClass) {}";

    @Override
    @NotNull
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnsafeReturnStatementVisitorInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitClass(PsiClass aClass) {
                super.visitClass(aClass);
                if ((InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)BASE_WALKING_VISITOR_NAME) || InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)BASE_VISITOR_NAME)) && UnsafeReturnStatementVisitorInspection.findVisitMethod(aClass, "visitReturnStatement", PsiReturnStatement.class.getName())) {
                    boolean skipLambdaFound = UnsafeReturnStatementVisitorInspection.findVisitMethod(aClass, "visitLambdaExpression", PsiLambdaExpression.class.getName());
                    boolean skipClassFound = UnsafeReturnStatementVisitorInspection.findVisitMethod(aClass, "visitClass", PsiClass.class.getName());
                    if (!skipClassFound || !skipLambdaFound) {
                        String[] methods;
                        String name;
                        if (!skipLambdaFound ^ !skipClassFound) {
                            if (!skipLambdaFound) {
                                name = "Insert visitLambdaExpression method";
                                methods = new String[]{UnsafeReturnStatementVisitorInspection.EMPTY_LAMBDA};
                            } else {
                                name = "Insert visitClass method";
                                methods = new String[]{UnsafeReturnStatementVisitorInspection.EMPTY_CLASS};
                            }
                        } else {
                            name = "Insert visitLambdaExpression/visitClass methods";
                            methods = new String[]{UnsafeReturnStatementVisitorInspection.EMPTY_LAMBDA, UnsafeReturnStatementVisitorInspection.EMPTY_CLASS};
                        }
                        holder.registerProblem((PsiElement)aClass, HighlightNamesUtil.getClassDeclarationTextRange((PsiClass)aClass).shiftRight(-aClass.getTextRange().getStartOffset()), "Recursive visitors which visit return statements most probably should specifically process anonymous/local classes as well as lambda expressions", new LocalQuickFix[]{new MySkipVisitFix(name, methods)});
                    }
                }
            }
        };
    }

    private static boolean findVisitMethod(PsiClass aClass, String visitMethodName, String argumentType) {
        PsiMethod[] visitReturnStatements;
        for (PsiMethod method : visitReturnStatements = aClass.findMethodsByName(visitMethodName, false)) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1 || !parameters[0].getType().equalsToText(argumentType)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/UnsafeReturnStatementVisitorInspection", "buildInternalVisitor"));
    }

    private static class MySkipVisitFix
    implements LocalQuickFix {
        private final String myName;
        private final String[] myMethods;

        MySkipVisitFix(String name, String[] methods) {
            this.myName = name;
            this.myMethods = methods;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                MySkipVisitFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            return "Skip anonymous/local classes";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element;
            if (project == null) {
                MySkipVisitFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                MySkipVisitFix.$$$reportNull$$$0(2);
            }
            if ((element = descriptor.getPsiElement()) instanceof PsiClass) {
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiClass aClass = (PsiClass)element;
                for (String methodText : this.myMethods) {
                    PsiMethod method = factory.createMethodFromText(methodText, element);
                    PsiMethod overridden = aClass.findMethodBySignature(method, true);
                    if (overridden != null) {
                        OverrideImplementUtil.annotateOnOverrideImplement((PsiMethod)method, (PsiClass)aClass, (PsiMethod)overridden);
                    }
                    aClass.add((PsiElement)method);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/inspections/internal/UnsafeReturnStatementVisitorInspection$MySkipVisitFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/inspections/internal/UnsafeReturnStatementVisitorInspection$MySkipVisitFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

