/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.NotNull;

public class ChangeToPairCreateQuickFix
implements LocalQuickFix {
    public @IntentionFamilyName @NotNull String getFamilyName() {
        return "Replace with 'Pair.create()'";
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            ChangeToPairCreateQuickFix.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            ChangeToPairCreateQuickFix.$$$reportNull$$$0(1);
        }
        if (!((element = descriptor.getPsiElement().getParent()) instanceof PsiNewExpression)) {
            return;
        }
        PsiNewExpression newExpression = (PsiNewExpression)element;
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        String newText = "com.intellij.openapi.util.Pair.create" + argumentList.getText();
        PsiExpression expression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(newText, element.getContext());
        PsiElement newElement = element.replace((PsiElement)expression);
        JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(newElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/inspections/quickfix/ChangeToPairCreateQuickFix";
        objectArray[2] = "applyFix";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

