/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.pom.references.PomService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.util.ExtensionCandidate;
import org.jetbrains.idea.devkit.util.ExtensionLocatorKt;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;
import org.jetbrains.idea.devkit.util.ExtensionPointLocator;

abstract class ExtensionPointReferenceBase
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    protected ExtensionPointReferenceBase(@NotNull PsiElement element) {
        if (element == null) {
            ExtensionPointReferenceBase.$$$reportNull$$$0(0);
        }
        super(element);
    }

    protected abstract String getExtensionPointClassname();

    protected abstract GenericAttributeValue<?> getNameElement(Extension var1);

    @Nullable
    public PsiElement resolve() {
        final String id = this.getValue();
        CommonProcessors.FindProcessor<Extension> resolveProcessor = new CommonProcessors.FindProcessor<Extension>(){

            protected boolean accept(Extension extension) {
                GenericAttributeValue<?> nameElement = ExtensionPointReferenceBase.this.getNameElement(extension);
                return nameElement != null && id.equals(nameElement.getStringValue());
            }
        };
        this.processCandidates((Processor<? super Extension>)resolveProcessor);
        Extension value = (Extension)resolveProcessor.getFoundValue();
        if (value == null) {
            return null;
        }
        DomTarget target = DomTarget.getTarget((DomElement)value, this.getNameElement(value));
        return target != null ? PomService.convertToPsi((PsiTarget)target) : value.getXmlElement();
    }

    @Nullable
    protected static GenericAttributeValue<?> getAttribute(Extension extension, String attributeName) {
        DomAttributeChildDescription attributeDescription = extension.getGenericInfo().getAttributeChildDescription(attributeName);
        if (attributeDescription == null) {
            return null;
        }
        return attributeDescription.getDomAttributeValue((DomElement)extension);
    }

    @Nullable
    protected static String getAttributeValue(Extension extension, String attributeName) {
        GenericAttributeValue<?> attribute = ExtensionPointReferenceBase.getAttribute(extension, attributeName);
        return attribute == null ? null : attribute.getStringValue();
    }

    protected void processCandidates(Processor<? super Extension> processor) {
        Project project = this.myElement.getProject();
        PsiClass extensionPointClass = JavaPsiFacade.getInstance((Project)project).findClass(this.getExtensionPointClassname(), this.myElement.getResolveScope());
        if (extensionPointClass == null) {
            return;
        }
        ExtensionPointLocator extensionPointLocator = new ExtensionPointLocator(extensionPointClass);
        ExtensionPointCandidate extensionPointCandidate = (ExtensionPointCandidate)ContainerUtil.getFirstItem(extensionPointLocator.findDirectCandidates());
        if (extensionPointCandidate == null) {
            return;
        }
        DomManager manager = DomManager.getDomManager((Project)project);
        DomElement extensionPointDomElement = manager.getDomElement((XmlTag)extensionPointCandidate.pointer.getElement());
        if (!(extensionPointDomElement instanceof ExtensionPoint)) {
            return;
        }
        for (ExtensionCandidate candidate : ExtensionLocatorKt.locateExtensionsByExtensionPoint((ExtensionPoint)extensionPointDomElement)) {
            XmlTag element = (XmlTag)candidate.pointer.getElement();
            DomElement domElement = manager.getDomElement(element);
            if (!(domElement instanceof Extension) || processor.process((Object)((Extension)domElement))) continue;
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/idea/devkit/references/ExtensionPointReferenceBase", "<init>"));
    }
}

