/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyBean;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.uast.UastPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.psi.UastReferenceProvider;
import com.intellij.psi.UastReferenceRegistrar;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.Extension;
import org.jetbrains.idea.devkit.inspections.RegistryPropertiesAnnotator;
import org.jetbrains.idea.devkit.references.ExtensionPointReferenceBase;
import org.jetbrains.uast.UExpression;

final class RegistryKeyIdReferenceContributor
extends PsiReferenceContributor {
    RegistryKeyIdReferenceContributor() {
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            RegistryKeyIdReferenceContributor.$$$reportNull$$$0(0);
        }
        UastReferenceRegistrar.registerUastReferenceProvider((PsiReferenceRegistrar)registrar, (ElementPattern)UastPatterns.injectionHostUExpression().methodCallParameter(0, (ElementPattern)((PsiMethodPattern)PsiJavaPatterns.psiMethod().withName((ElementPattern)StandardPatterns.string().oneOf(new String[]{"get", "is", "intValue", "doubleValue", "stringValue", "getColor"}))).definedInClass(Registry.class.getName())), (UastReferenceProvider)new UastInjectionHostReferenceProvider(){

            public PsiReference @NotNull [] getReferencesForInjectionHost(@NotNull UExpression uExpression, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
                if (uExpression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (host == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(2);
                }
                PsiReference[] psiReferenceArray = new PsiReference[]{new RegistryKeyIdReference((PsiElement)host)};
                if (psiReferenceArray == null) {
                    1.$$$reportNull$$$0(3);
                }
                return psiReferenceArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "uExpression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "host";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/devkit/references/RegistryKeyIdReferenceContributor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/devkit/references/RegistryKeyIdReferenceContributor$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesForInjectionHost";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesForInjectionHost";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }, (double)0.0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/idea/devkit/references/RegistryKeyIdReferenceContributor", "registerReferenceProviders"));
    }

    private static class RegistryKeyIdReference
    extends ExtensionPointReferenceBase {
        private RegistryKeyIdReference(@NotNull PsiElement element) {
            if (element == null) {
                RegistryKeyIdReference.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @Override
        protected String getExtensionPointClassname() {
            return RegistryKeyBean.class.getName();
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = "Cannot resolve registry key '" + this.getValue() + "'";
            if (string == null) {
                RegistryKeyIdReference.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        protected GenericAttributeValue<?> getNameElement(Extension extension) {
            return RegistryKeyIdReference.getAttribute(extension, "key");
        }

        @Override
        @Nullable
        public PsiElement resolve() {
            IProperty propertyKey;
            PropertiesFile file = this.getRegistryPropertiesFile();
            if (file != null && (propertyKey = file.findPropertyByKey(this.getValue())) != null) {
                return propertyKey.getPsiElement();
            }
            return super.resolve();
        }

        public Object @NotNull [] getVariants() {
            PropertiesFile registryProperties = this.getRegistryPropertiesFile();
            if (registryProperties == null) {
                if (EMPTY_ARRAY == null) {
                    RegistryKeyIdReference.$$$reportNull$$$0(2);
                }
                return EMPTY_ARRAY;
            }
            List<LookupElement> variants = Collections.synchronizedList(new SmartList());
            this.processCandidates((Processor<? super Extension>)((Processor)extension -> {
                String key = this.getNameElement((Extension)extension).getStringValue();
                if (key == null || extension.getXmlElement() == null) {
                    return true;
                }
                boolean requireRestart = "true".equals(RegistryKeyIdReference.getAttributeValue(extension, "restartRequired"));
                String description2 = " " + StringUtil.notNullize((String)RegistryKeyIdReference.getAttributeValue(extension, "description"), (String)"No Description");
                String defaultValue = StringUtil.notNullize((String)RegistryKeyIdReference.getAttributeValue(extension, "defaultValue"), (String)"No Default");
                variants.add((LookupElement)LookupElementBuilder.create((Object)extension.getXmlElement(), (String)key).withIcon(requireRestart ? AllIcons.Nodes.PluginRestart : AllIcons.Nodes.Plugin).withTailText(description2, true).withTypeText(defaultValue));
                return true;
            }));
            for (IProperty property : registryProperties.getProperties()) {
                String key = property.getKey();
                if (key == null || RegistryPropertiesAnnotator.isImplicitUsageKey(key)) continue;
                boolean requireRestart = registryProperties.findPropertyByKey(key + ".restartRequired") != null;
                IProperty descriptionKey = registryProperties.findPropertyByKey(key + ".description");
                String description2 = descriptionKey != null ? " " + RegistryKeyIdReference.cleanupDescription(descriptionKey.getUnescapedValue()) : "";
                variants.add((LookupElement)LookupElementBuilder.create((Object)property.getPsiElement(), (String)key).withIcon(requireRestart ? AllIcons.Nodes.PluginRestart : AllIcons.Nodes.Plugin).withTailText(description2, true).withTypeText(property.getValue()));
            }
            Object[] objectArray = variants.toArray(LookupElement.EMPTY_ARRAY);
            if (objectArray == null) {
                RegistryKeyIdReference.$$$reportNull$$$0(3);
            }
            return objectArray;
        }

        private static String cleanupDescription(String description2) {
            return StringUtil.strip((String)description2, ch -> ch != '\n' && ch != '\r');
        }

        @Nullable
        private PropertiesFile getRegistryPropertiesFile() {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
            if (module == null) {
                return null;
            }
            PropertiesReferenceManager propertiesReferenceManager = PropertiesReferenceManager.getInstance((Project)this.myElement.getProject());
            return (PropertiesFile)ContainerUtil.getFirstItem((List)propertiesReferenceManager.findPropertiesFiles(module, "misc.registry"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/idea/devkit/references/RegistryKeyIdReferenceContributor$RegistryKeyIdReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/idea/devkit/references/RegistryKeyIdReferenceContributor$RegistryKeyIdReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

