/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.references.extensions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.DocumentationManagerUtil;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.references.extensions.ExtensionPointBinding;
import org.jetbrains.idea.devkit.util.DescriptorUtil;

public class ExtensionPointDocumentationProvider
implements DocumentationProvider {
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        ExtensionPoint extensionPoint = ExtensionPointDocumentationProvider.findExtensionPoint(element);
        if (extensionPoint == null) {
            return null;
        }
        XmlFile epDeclarationFile = DomUtil.getFile((DomElement)extensionPoint);
        StringBuilder epClassesText = new StringBuilder();
        if (DomUtil.hasXml(extensionPoint.getBeanClass())) {
            ExtensionPointDocumentationProvider.generateClassLink(epClassesText, (PsiClass)extensionPoint.getBeanClass().getValue());
            epClassesText.append("<br/>");
        }
        PsiClass extensionPointClass = extensionPoint.getExtensionPointClass();
        ExtensionPointDocumentationProvider.generateClassLink(epClassesText, extensionPointClass);
        Module epModule = ModuleUtilCore.findModuleForFile((VirtualFile)epDeclarationFile.getVirtualFile(), (Project)element.getProject());
        String moduleName = epModule == null ? "" : "[" + epModule.getName() + "]<br/>";
        return moduleName + "<b>" + extensionPoint.getEffectiveQualifiedName() + "</b> (" + epDeclarationFile.getName() + ")<br/>" + epClassesText;
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        ExtensionPoint extensionPoint = ExtensionPointDocumentationProvider.findExtensionPoint(element);
        if (extensionPoint == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<div class='definition'><pre>");
        sb.append("<b>").append(extensionPoint.getEffectiveQualifiedName()).append("</b>");
        sb.append("<br>").append(DomUtil.getFile((DomElement)extensionPoint).getName());
        PsiClass beanClass = (PsiClass)extensionPoint.getBeanClass().getValue();
        if (beanClass != null) {
            ExtensionPointDocumentationProvider.generateClassDoc(sb, (PsiElement)beanClass);
            final StringBuilder bindingText = new StringBuilder();
            new ExtensionPointBinding(beanClass).visit(new ExtensionPointBinding.BindingVisitor(){

                @Override
                public void visitAttribute(@NotNull PsiField field, @NotNull String attributeName, boolean required) {
                    if (field == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (attributeName == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    this.appendFieldBindingText(field, attributeName, required);
                }

                @Override
                public void visitTagOrProperty(@NotNull PsiField field, @NotNull String tagName, boolean required) {
                    if (field == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (tagName == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    this.visitAttribute(field, "&lt;" + tagName + ">", required);
                }

                @Override
                public void visitXCollection(@NotNull PsiField field, @Nullable String tagName, @NotNull PsiAnnotation collectionAnnotation, boolean required) {
                    if (field == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (collectionAnnotation == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    this.visitAttribute(field, "&lt;" + tagName + ">...", required);
                }

                private void appendFieldBindingText(@NotNull PsiField field, @NotNull String displayName, boolean required) {
                    if (field == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    if (displayName == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    StringBuilder hyperLink = new StringBuilder();
                    DocumentationManagerUtil.createHyperlink((StringBuilder)hyperLink, (PsiElement)field, (String)JavaDocUtil.getReferenceText((Project)field.getProject(), (PsiElement)field), (String)displayName, (boolean)false);
                    String typeText = field.getType().getPresentableText();
                    String initializer = field.getInitializer() != null ? " = " + field.getInitializer().getText() : "";
                    ExtensionPointDocumentationProvider.appendSection(bindingText, hyperLink.toString(), typeText + (required ? " (required)" : "") + initializer);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "field";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "attributeName";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "tagName";
                            break;
                        }
                        case 5: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "collectionAnnotation";
                            break;
                        }
                        case 7: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "displayName";
                            break;
                        }
                    }
                    objectArray2[1] = "org/jetbrains/idea/devkit/references/extensions/ExtensionPointDocumentationProvider$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitAttribute";
                            break;
                        }
                        case 2: 
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitTagOrProperty";
                            break;
                        }
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitXCollection";
                            break;
                        }
                        case 6: 
                        case 7: {
                            objectArray = objectArray2;
                            objectArray2[2] = "appendFieldBindingText";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (bindingText.length() > 0) {
                sb.append("<table class='sections'>");
                sb.append((CharSequence)bindingText);
                sb.append("<br/>");
                sb.append("</table>");
            }
        }
        sb.append("</pre></div>");
        PsiClass extensionPointClass = extensionPoint.getExtensionPointClass();
        if (extensionPointClass != null) {
            sb.append("<div class='content'>");
            sb.append("<h2>Extension Point Implementation</h2>");
            ExtensionPointDocumentationProvider.generateClassDoc(sb, (PsiElement)extensionPointClass);
            sb.append("</div>");
        }
        return sb.toString();
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return JavaDocUtil.findReferenceTarget((PsiManager)psiManager, (String)link, (PsiElement)context);
    }

    private static void generateClassLink(StringBuilder epClassText, @Nullable PsiClass epClass) {
        if (epClass == null) {
            return;
        }
        DocumentationManagerUtil.createHyperlink((StringBuilder)epClassText, (PsiElement)epClass, (String)epClass.getQualifiedName(), (String)epClass.getName(), (boolean)false);
    }

    private static void generateClassDoc(StringBuilder sb, @Nullable PsiElement element) {
        if (element == null) {
            sb.append("??? not found ???");
            return;
        }
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement((PsiElement)element);
        sb.append(documentationProvider.generateDoc(element, null));
    }

    private static void appendSection(StringBuilder sb, String sectionName, String sectionContent) {
        sb.append("<tr><td valign='top' class='section'><p>").append(sectionName).append("</td><td valign='top'>");
        sb.append(sectionContent);
        sb.append("</td>");
    }

    @Nullable
    private static ExtensionPoint findExtensionPoint(PsiElement element) {
        DomElement domElement;
        if (element instanceof PomTargetPsiElement && DescriptorUtil.isPluginXml(element.getContainingFile())) {
            DomElement domElement2;
            PomTarget pomTarget = ((PomTargetPsiElement)element).getTarget();
            if (pomTarget instanceof DomTarget && (domElement2 = ((DomTarget)pomTarget).getDomElement()) instanceof ExtensionPoint) {
                return (ExtensionPoint)domElement2;
            }
        } else if (element instanceof XmlTag && DescriptorUtil.isPluginXml(element.getContainingFile()) && (domElement = DomUtil.getDomElement((PsiElement)element)) instanceof ExtensionPoint) {
            return (ExtensionPoint)domElement;
        }
        return null;
    }
}

