/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.module.ModuleComponent;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public enum ComponentType {
    MODULE(ModuleComponent.class, "module-components", "new.menu.module.component.text"),
    PROJECT(ProjectComponent.class, "project-components", "new.menu.project.component.text"),
    APPLICATION(BaseComponent.class, "application-components", "new.menu.application.component.text");

    public final String myClassName;
    @PropertyKey(resourceBundle="messages.DevKitBundle")
    public final String myPropertyKey;
    private final String myName;

    private ComponentType(@PropertyKey(resourceBundle="messages.DevKitBundle") Class<? extends BaseComponent> clazz, String name, String propertyKey) {
        this.myPropertyKey = propertyKey;
        this.myClassName = clazz.getName();
        this.myName = name;
    }

    public void patchPluginXml(XmlFile pluginXml, PsiClass klass) throws IncorrectOperationException {
        XmlTag rootTag = pluginXml.getDocument().getRootTag();
        if (rootTag != null && "idea-plugin".equals(rootTag.getName())) {
            PsiMethod[] methods;
            XmlTag components = rootTag.findFirstSubTag(this.myName);
            if (components == null || !components.isPhysical()) {
                components = (XmlTag)rootTag.add((PsiElement)rootTag.createChildTag(this.myName, rootTag.getNamespace(), null, false));
            }
            XmlTag cmp = (XmlTag)components.add((PsiElement)components.createChildTag("component", components.getNamespace(), null, false));
            cmp.add((PsiElement)cmp.createChildTag("implementation-class", cmp.getNamespace(), klass.getQualifiedName(), false));
            for (PsiMethod method : methods = klass.findMethodsByName("getInstance", true)) {
                PsiType returnType;
                PsiParameter[] parameters = method.getParameterList().getParameters();
                if (parameters.length > 1 || !((returnType = method.getReturnType()) instanceof PsiClassType)) continue;
                String intf = returnType.getCanonicalText();
                cmp.add((PsiElement)cmp.createChildTag("interface-class", cmp.getNamespace(), intf, false));
                break;
            }
        }
    }

    public void process(XmlTag rootTag, Processor processor) {
        XmlTag[] compGroup;
        for (XmlTag tag : compGroup = rootTag.findSubTags(this.myName)) {
            XmlTag[] components;
            if (!tag.isPhysical()) continue;
            for (XmlTag component : components = tag.findSubTags("component")) {
                XmlTag intf;
                XmlTag impl = component.findFirstSubTag("implementation-class");
                if (processor.process(this, component, impl != null ? impl.getValue() : null, (intf = component.findFirstSubTag("interface-class")) != null ? intf.getValue() : null)) continue;
                return;
            }
        }
    }

    public static interface Processor {
        public boolean process(ComponentType var1, XmlTag var2, @Nullable XmlTagValue var3, @Nullable XmlTagValue var4);
    }
}

