/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    public static final String EMPTY = "";

    public static List<CharSequence> getLines(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/coverage/report/impl/StringUtil.getLines must not be null");
        }
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        int lineStart = -1;
        int lineEnd = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean addLine = false;
            switch (c) {
                default: {
                    if (lineStart < 0) {
                        lineStart = i;
                    }
                    lineEnd = i + 1;
                    break;
                }
                case '\r': {
                    addLine = true;
                    Character next = StringUtil.charAtOrNull(i + 1, text);
                    if (next == null || next.charValue() != '\n') break;
                    ++i;
                    break;
                }
                case '\n': {
                    Character nextChar = StringUtil.charAtOrNull(i + 1, text);
                    if (nextChar != null && nextChar.charValue() == '\r') break;
                    addLine = true;
                }
            }
            if (!addLine) continue;
            if (lineStart < 0 || lineStart >= lineEnd) {
                result.add(EMPTY);
            } else {
                result.add(text.subSequence(lineStart, lineEnd));
            }
            lineStart = -1;
            lineEnd = -1;
        }
        if (lineStart >= 0) {
            result.add(text.subSequence(lineStart, lineEnd));
        }
        return result;
    }

    private static Character charAtOrNull(int idx, CharSequence text) {
        if (idx < text.length()) {
            return Character.valueOf(text.charAt(idx));
        }
        return null;
    }
}

