/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.unused.UnusedPropertyUtil;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.PropertyBundleEditorStructureViewElement;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.editor.inspections.InspectedPropertyProblems;
import com.intellij.lang.properties.editor.inspections.ResourceBundleEditorProblemDescriptor;
import com.intellij.lang.properties.editor.inspections.incomplete.IncompletePropertyInspection;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Queue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleEditorHighlighter
implements BackgroundEditorHighlighter {
    private final ResourceBundleEditor myEditor;

    public ResourceBundleEditorHighlighter(ResourceBundleEditor editor) {
        this.myEditor = editor;
    }

    public HighlightingPass @NotNull [] createPassesForEditor() {
        HighlightingPass[] highlightingPassArray = new HighlightingPass[]{new ResourceBundleEditorHighlightingPass(this.myEditor)};
        if (highlightingPassArray == null) {
            ResourceBundleEditorHighlighter.$$$reportNull$$$0(0);
        }
        return highlightingPassArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/editor/ResourceBundleEditorHighlighter", "createPassesForEditor"));
    }

    private static class InspectionVisitorWrapper {
        private final Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> myProblemVisitor;
        private final HighlightSeverity mySeverity;
        private final HighlightDisplayKey myKey;

        private InspectionVisitorWrapper(@NotNull Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> visitor, @NotNull HighlightSeverity severity, @NotNull HighlightDisplayKey key) {
            if (visitor == null) {
                InspectionVisitorWrapper.$$$reportNull$$$0(0);
            }
            if (severity == null) {
                InspectionVisitorWrapper.$$$reportNull$$$0(1);
            }
            if (key == null) {
                InspectionVisitorWrapper.$$$reportNull$$$0(2);
            }
            this.myProblemVisitor = visitor;
            this.mySeverity = severity;
            this.myKey = key;
        }

        public Function<IProperty[], ResourceBundleEditorProblemDescriptor[]> getProblemVisitor() {
            return this.myProblemVisitor;
        }

        public HighlightSeverity getSeverity() {
            return this.mySeverity;
        }

        public HighlightDisplayKey getKey() {
            return this.myKey;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "visitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "severity";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "key";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/properties/editor/ResourceBundleEditorHighlighter$InspectionVisitorWrapper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ResourceBundleEditorHighlightingPass
    implements HighlightingPass {
        private final ResourceBundleEditor myEditor;

        private ResourceBundleEditorHighlightingPass(ResourceBundleEditor editor) {
            this.myEditor = editor;
        }

        public void collectInformation(@NotNull ProgressIndicator progress) {
            HighlightDisplayKey incompleteKey;
            if (progress == null) {
                ResourceBundleEditorHighlightingPass.$$$reportNull$$$0(0);
            }
            InspectionProfileImpl profileToUse = InspectionProfileManager.getInstance().getCurrentProfile();
            ResourceBundle rb = this.myEditor.getResourceBundle();
            if (!rb.isValid()) {
                return;
            }
            PsiFile containingFile = rb.getDefaultPropertiesFile().getContainingFile();
            ArrayList<InspectionVisitorWrapper> visitors = new ArrayList<InspectionVisitorWrapper>();
            HighlightDisplayKey unusedKey = HighlightDisplayKey.find((String)"UnusedProperty");
            if (profileToUse.isToolEnabled(unusedKey, (PsiElement)containingFile)) {
                visitors.add(new InspectionVisitorWrapper(UnusedPropertyUtil.buildPropertyGroupVisitor(rb), profileToUse.getErrorLevel(unusedKey, (PsiElement)containingFile).getSeverity(), unusedKey));
            }
            if (profileToUse.isToolEnabled(incompleteKey = HighlightDisplayKey.find((String)"IncompleteProperty"), (PsiElement)containingFile)) {
                InspectionProfileEntry unwrappedTool = profileToUse.getUnwrappedTool("IncompleteProperty", (PsiElement)containingFile);
                assert (unwrappedTool != null);
                visitors.add(new InspectionVisitorWrapper(((IncompletePropertyInspection)unwrappedTool).buildPropertyGroupVisitor(rb), profileToUse.getErrorLevel(incompleteKey, (PsiElement)containingFile).getSeverity(), incompleteKey));
            }
            List files = rb.getPropertiesFiles();
            Project project = rb.getProject();
            StructureViewModel model = this.myEditor.getStructureViewComponent().getTreeModel();
            Queue queue = new Queue(1);
            queue.addLast((Object)model.getRoot());
            while (!queue.isEmpty()) {
                TreeElement treeElement = (TreeElement)queue.pullFirst();
                if (treeElement instanceof PropertyBundleEditorStructureViewElement) {
                    String key;
                    IProperty property = ((PropertyBundleEditorStructureViewElement)treeElement).getProperty();
                    if (property == null || (key = property.getKey()) == null) continue;
                    TreeSet<HighlightInfoType> highlightTypes = new TreeSet<HighlightInfoType>(Comparator.comparing(t -> t.getSeverity(null)));
                    SmartList allDescriptors = new SmartList();
                    IProperty[] properties = (IProperty[])files.stream().map(f -> f.findPropertyByKey(key)).filter(Objects::nonNull).toArray(IProperty[]::new);
                    if (properties.length != 0) {
                        for (InspectionVisitorWrapper v : visitors) {
                            Object[] problemDescriptors = v.getProblemVisitor().apply(properties);
                            if (ArrayUtil.isEmpty((Object[])problemDescriptors)) continue;
                            HighlightSeverity severity = v.getSeverity();
                            for (Object descriptor : problemDescriptors) {
                                allDescriptors.add(Pair.create((Object)descriptor, (Object)v.getKey()));
                                HighlightInfoType infoType = ProblemDescriptorUtil.getHighlightInfoType((ProblemHighlightType)((ResourceBundleEditorProblemDescriptor)descriptor).getHighlightType(), (HighlightSeverity)severity, (SeverityRegistrar)SeverityRegistrar.getSeverityRegistrar((Project)project));
                                highlightTypes.add(infoType);
                            }
                        }
                        ((PropertyBundleEditorStructureViewElement)treeElement).setInspectedPropertyProblems(allDescriptors.isEmpty() ? null : new InspectedPropertyProblems(allDescriptors.toArray(new Pair[0]), highlightTypes));
                    }
                }
                for (TreeElement element : treeElement.getChildren()) {
                    queue.addLast((Object)element);
                }
            }
        }

        public void applyInformationToEditor() {
            this.myEditor.getStructureViewComponent().repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/lang/properties/editor/ResourceBundleEditorHighlighter$ResourceBundleEditorHighlightingPass", "collectInformation"));
        }
    }
}

