/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.editor.ResourceBundleEditor;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ResourceBundleEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            ResourceBundleEditorProvider.$$$reportNull$$$0(1);
        }
        if (file instanceof ResourceBundleAsVirtualFile) {
            return true;
        }
        if (!file.isValid()) {
            return false;
        }
        FileType type = file.getFileType();
        if (type != PropertiesFileType.INSTANCE && type != StdFileTypes.XML) {
            return false;
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return Boolean.FALSE;
            }
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile((PsiFile)psiFile);
            return propertiesFile != null && propertiesFile.getResourceBundle().getPropertiesFiles().size() > 1;
        });
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        ResourceBundle resourceBundle;
        if (project == null) {
            ResourceBundleEditorProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            ResourceBundleEditorProvider.$$$reportNull$$$0(3);
        }
        if (file instanceof ResourceBundleAsVirtualFile) {
            resourceBundle = ((ResourceBundleAsVirtualFile)file).getResourceBundle();
        } else {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            if (psiFile == null) {
                throw new IllegalArgumentException("psifile cannot be null");
            }
            resourceBundle = PropertiesImplUtil.getPropertiesFile((PsiFile)psiFile).getResourceBundle();
        }
        return new ResourceBundleEditor(resourceBundle);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project, @NotNull VirtualFile file) {
        if (element == null) {
            ResourceBundleEditorProvider.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ResourceBundleEditorProvider.$$$reportNull$$$0(5);
        }
        if (file == null) {
            ResourceBundleEditorProvider.$$$reportNull$$$0(6);
        }
        return new ResourceBundleEditor.ResourceBundleEditorState(null);
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            ResourceBundleEditorProvider.$$$reportNull$$$0(7);
        }
        return fileEditorPolicy;
    }

    @NotNull
    public String getEditorTypeId() {
        return "ResourceBundle";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/editor/ResourceBundleEditorProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/editor/ResourceBundleEditorProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

