/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.capitalization;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.NlsCapitalizationUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.text.ChoiceFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TitleCapitalizationInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            TitleCapitalizationInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                PsiType type = method.getReturnType();
                if (!InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.String")) {
                    return;
                }
                Collection statements = PsiTreeUtil.findChildrenOfType((PsiElement)method, PsiReturnStatement.class);
                Nls.Capitalization capitalization = null;
                for (PsiReturnStatement returnStatement : statements) {
                    PsiExpression expression = returnStatement.getReturnValue();
                    if (expression == null) continue;
                    List children = ExpressionUtils.nonStructuralChildren((PsiExpression)expression).collect(Collectors.toList());
                    for (PsiExpression e : children) {
                        if (capitalization == null && (capitalization = NlsInfo.getCapitalization((PsiModifierListOwner)method)) == Nls.Capitalization.NotSpecified) {
                            return;
                        }
                        Value titleValue = TitleCapitalizationInspection.getTitleValue(e, new HashSet());
                        if (titleValue == null) continue;
                        TitleCapitalizationInspection.checkCapitalization(e, titleValue, holder, capitalization);
                    }
                }
            }

            public void visitCallExpression(PsiCallExpression expression) {
                PsiExpressionList argumentList;
                PsiMethod psiMethod = expression.resolveMethod();
                if (psiMethod != null && (argumentList = expression.getArgumentList()) != null) {
                    PsiExpression[] args = argumentList.getExpressions();
                    PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                    for (int i = 0; i < Math.min(parameters.length, args.length); ++i) {
                        PsiParameter parameter = parameters[i];
                        Nls.Capitalization capitalization = NlsInfo.getCapitalization((PsiModifierListOwner)parameter);
                        if (capitalization == Nls.Capitalization.NotSpecified) continue;
                        ExpressionUtils.nonStructuralChildren((PsiExpression)args[i]).forEach(e -> TitleCapitalizationInspection.checkCapitalization(e, TitleCapitalizationInspection.getTitleValue(e, new HashSet()), holder, capitalization));
                    }
                }
            }
        };
    }

    private static void checkCapitalization(PsiExpression e, Value titleValue, @NotNull ProblemsHolder holder, Nls.Capitalization capitalization) {
        if (holder == null) {
            TitleCapitalizationInspection.$$$reportNull$$$0(1);
        }
        if (titleValue != null && !titleValue.isSatisfied(capitalization)) {
            holder.registerProblem((PsiElement)e, JavaI18nBundle.message("inspection.title.capitalization.description", titleValue, StringUtil.toLowerCase((String)capitalization.toString())), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{titleValue.canFix() ? new TitleCapitalizationFix(titleValue, capitalization) : null});
        }
    }

    @Nullable
    private static Value getTitleValue(@Nullable PsiExpression arg, Set<? super PsiElement> processed) {
        PsiExpression initializer;
        PsiElement result;
        if (arg instanceof PsiLiteralExpression) {
            return Value.of((PsiLiteralExpression)arg);
        }
        if (arg instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)arg;
            PsiMethod psiMethod = call.resolveMethod();
            PsiExpression returnValue = PropertyUtilBase.getGetterReturnExpression((PsiMethod)psiMethod);
            if (arg == returnValue) {
                return null;
            }
            if (returnValue != null && processed.add((PsiElement)returnValue)) {
                return TitleCapitalizationInspection.getTitleValue(returnValue, processed);
            }
            return Value.of(TitleCapitalizationInspection.getPropertyArgument(call), call.getArgumentList().getExpressionCount() > 1);
        }
        if (arg instanceof PsiReferenceExpression && (result = ((PsiReferenceExpression)arg).resolve()) instanceof PsiVariable && ((PsiVariable)result).hasModifierProperty("final") && processed.add((PsiElement)(initializer = ((PsiVariable)result).getInitializer()))) {
            return TitleCapitalizationInspection.getTitleValue(initializer, processed);
        }
        return null;
    }

    @Nullable
    private static Property getPropertyArgument(PsiMethodCallExpression arg) {
        PsiExpression[] args = arg.getArgumentList().getExpressions();
        if (args.length > 0) {
            PsiReference[] references;
            for (PsiReference reference : references = args[0].getReferences()) {
                PsiElement element;
                ResolveResult[] resolveResults;
                if (!(reference instanceof PropertyReference) || (resolveResults = ((PropertyReference)reference).multiResolve(false)).length != 1 || !resolveResults[0].isValidResult() || !((element = resolveResults[0].getElement()) instanceof Property)) continue;
                return (Property)element;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "holder";
        objectArray2[1] = "com/intellij/codeInspection/capitalization/TitleCapitalizationInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCapitalization";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class PropertyValue
    implements Value {
        private final String myPresentation;
        private final MessageFormat myFormat;

        PropertyValue(String presentation, MessageFormat format) {
            this.myPresentation = presentation;
            this.myFormat = format;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.myPresentation;
            if (string == null) {
                PropertyValue.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean isSatisfied(@NotNull Nls.Capitalization capitalization) {
            if (capitalization == null) {
                PropertyValue.$$$reportNull$$$0(1);
            }
            if (capitalization == Nls.Capitalization.NotSpecified) {
                return true;
            }
            Format[] formats = this.myFormat.getFormats();
            MessageFormat clone = (MessageFormat)this.myFormat.clone();
            clone.setFormats(new Format[formats.length]);
            if (!NlsCapitalizationUtil.isCapitalizationSatisfied((String)clone.toPattern(), (Nls.Capitalization)capitalization)) {
                return false;
            }
            for (Format format : formats) {
                if (!(format instanceof ChoiceFormat)) continue;
                for (Object subValue : ((ChoiceFormat)format).getFormats()) {
                    String str = subValue.toString();
                    if (capitalization == Nls.Capitalization.Sentence) {
                        str = "The " + str;
                    }
                    if (NlsCapitalizationUtil.isCapitalizationSatisfied((String)str, (Nls.Capitalization)capitalization)) continue;
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean canFix() {
            return ContainerUtil.findInstance((Object[])this.myFormat.getFormats(), ChoiceFormat.class) == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/capitalization/TitleCapitalizationInspection$PropertyValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "capitalization";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/capitalization/TitleCapitalizationInspection$PropertyValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSatisfied";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class TextValue
    implements Value {
        private final String myText;

        TextValue(String text) {
            this.myText = text;
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.myText;
            if (string == null) {
                TextValue.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public boolean isSatisfied(@NotNull Nls.Capitalization capitalization) {
            if (capitalization == null) {
                TextValue.$$$reportNull$$$0(1);
            }
            return NlsCapitalizationUtil.isCapitalizationSatisfied((String)this.myText, (Nls.Capitalization)capitalization);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/capitalization/TitleCapitalizationInspection$TextValue";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "capitalization";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/capitalization/TitleCapitalizationInspection$TextValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSatisfied";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static interface Value {
        @NotNull
        public String toString();

        public boolean isSatisfied(@NotNull Nls.Capitalization var1);

        @NotNull
        default public String fixCapitalization(@NotNull Nls.Capitalization capitalization) {
            if (capitalization == null) {
                Value.$$$reportNull$$$0(0);
            }
            String string = NlsCapitalizationUtil.fixValue((String)this.toString(), (Nls.Capitalization)capitalization);
            if (string == null) {
                Value.$$$reportNull$$$0(1);
            }
            return string;
        }

        default public boolean canFix() {
            return true;
        }

        @Contract(value="null, _ -> null")
        @Nullable
        public static Value of(@Nullable Property property, boolean useFormat) {
            if (property == null) {
                return null;
            }
            String value = property.getUnescapedValue();
            if (value == null) {
                return null;
            }
            if (useFormat) {
                try {
                    MessageFormat format = new MessageFormat(value);
                    return new PropertyValue(value, format);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return new TextValue(value);
        }

        @Nullable
        public static Value of(@NotNull PsiLiteralExpression literal) {
            Object value;
            if (literal == null) {
                Value.$$$reportNull$$$0(2);
            }
            return (value = literal.getValue()) instanceof String ? new TextValue((String)value) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "capitalization";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/capitalization/TitleCapitalizationInspection$Value";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "literal";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/capitalization/TitleCapitalizationInspection$Value";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fixCapitalization";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "fixCapitalization";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TitleCapitalizationFix
    implements LocalQuickFix {
        private final Value myTitleValue;
        private final Nls.Capitalization myCapitalization;

        TitleCapitalizationFix(Value titleValue, Nls.Capitalization capitalization) {
            this.myTitleValue = titleValue;
            this.myCapitalization = capitalization;
        }

        @NotNull
        public String getName() {
            String string = JavaI18nBundle.message("quickfix.text.title.capitalization", this.myTitleValue);
            if (string == null) {
                TitleCapitalizationFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public final void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement problemElement;
            if (project == null) {
                TitleCapitalizationFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                TitleCapitalizationFix.$$$reportNull$$$0(2);
            }
            if ((problemElement = descriptor.getPsiElement()) == null) {
                return;
            }
            this.doFix(project, problemElement);
        }

        protected void doFix(Project project, PsiElement element) throws IncorrectOperationException {
            if (element instanceof PsiLiteralExpression) {
                Value value = Value.of((PsiLiteralExpression)element);
                if (value == null) {
                    return;
                }
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression newExpression = factory.createExpressionFromText('\"' + StringUtil.escapeStringCharacters((String)value.fixCapitalization(this.myCapitalization)) + '\"', element);
                element.replace((PsiElement)newExpression);
            } else if (element instanceof PsiMethodCallExpression) {
                Property property;
                Value value;
                PsiMethodCallExpression call = (PsiMethodCallExpression)element;
                PsiMethod method = call.resolveMethod();
                PsiExpression returnValue = PropertyUtilBase.getGetterReturnExpression((PsiMethod)method);
                if (returnValue != null) {
                    this.doFix(project, (PsiElement)returnValue);
                }
                if ((value = Value.of(property = TitleCapitalizationInspection.getPropertyArgument(call), call.getArgumentList().getExpressionCount() > 1)) == null) {
                    return;
                }
                property.setValue(value.fixCapitalization(this.myCapitalization));
            } else if (element instanceof PsiReferenceExpression) {
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)element;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                PsiVariable variable = (PsiVariable)target;
                if (variable.hasModifierProperty("final")) {
                    this.doFix(project, (PsiElement)variable.getInitializer());
                }
            }
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaI18nBundle.message("quickfix.family.title.capitalization.fix", new Object[0]);
            if (string == null) {
                TitleCapitalizationFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/capitalization/TitleCapitalizationInspection$TitleCapitalizationFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/capitalization/TitleCapitalizationInspection$TitleCapitalizationFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

