/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.externalAnnotation.NonNlsAnnotationProvider;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.i18n.I18nizeBatchQuickFix;
import com.intellij.codeInspection.i18n.I18nizeConcatenationQuickFix;
import com.intellij.codeInspection.i18n.I18nizeQuickFix;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.NlsInfo;
import com.intellij.codeInspection.i18n.SuppressByCommentOutAction;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.introduceField.IntroduceConstantHandler;
import com.intellij.ui.AddDeleteListPanel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;
import org.jetbrains.uast.util.UastExpressionUtils;

public class I18nInspection
extends AbstractBaseUastLocalInspectionTool
implements CustomSuppressableInspectionTool {
    public boolean ignoreForAssertStatements = true;
    public boolean ignoreForExceptionConstructors = true;
    @NonNls
    public String ignoreForSpecifiedExceptionConstructors = "";
    public boolean ignoreForJUnitAsserts = true;
    public boolean ignoreForClassReferences = true;
    public boolean ignoreForPropertyKeyReferences = true;
    public boolean ignoreForNonAlpha = true;
    private boolean ignoreForAllButNls = false;
    public boolean ignoreAssignedToConstants;
    public boolean ignoreToString;
    @NonNls
    public String nonNlsCommentPattern = "NON-NLS";
    private boolean ignoreForEnumConstants;
    @Nullable
    private Pattern myCachedNonNlsPattern;
    @NonNls
    private static final String TO_STRING = "toString";
    private static final String SKIP_FOR_ENUM = "ignoreForEnumConstant";
    private static final String IGNORE_ALL_BUT_NLS = "ignoreAllButNls";

    public I18nInspection() {
        this.cacheNonNlsCommentPattern();
    }

    public SuppressIntentionAction @NotNull [] getSuppressActions(PsiElement element) {
        Object[] suppressActions = this.getBatchSuppressActions(element);
        if (this.myCachedNonNlsPattern == null) {
            SuppressIntentionAction[] suppressIntentionActionArray = (SuppressIntentionAction[])ContainerUtil.map2Array((Object[])suppressActions, SuppressIntentionAction.class, SuppressIntentionActionFromFix::convertBatchToSuppressIntentionAction);
            if (suppressIntentionActionArray == null) {
                I18nInspection.$$$reportNull$$$0(0);
            }
            return suppressIntentionActionArray;
        }
        ArrayList<SuppressByCommentOutAction> suppressors = new ArrayList<SuppressByCommentOutAction>(suppressActions.length + 1);
        suppressors.add(new SuppressByCommentOutAction(this.nonNlsCommentPattern));
        suppressors.addAll(ContainerUtil.map((Object[])suppressActions, SuppressIntentionActionFromFix::convertBatchToSuppressIntentionAction));
        SuppressIntentionAction[] suppressIntentionActionArray = suppressors.toArray(SuppressIntentionAction.EMPTY_ARRAY);
        if (suppressIntentionActionArray == null) {
            I18nInspection.$$$reportNull$$$0(1);
        }
        return suppressIntentionActionArray;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            I18nInspection.$$$reportNull$$$0(2);
        }
        super.writeSettings(node);
        if (this.ignoreForEnumConstants) {
            node.addContent(new Element("option").setAttribute("name", SKIP_FOR_ENUM).setAttribute("value", Boolean.toString(this.ignoreForEnumConstants)));
        }
        if (this.ignoreForAllButNls) {
            node.addContent(new Element("option").setAttribute("name", IGNORE_ALL_BUT_NLS).setAttribute("value", Boolean.toString(this.ignoreForAllButNls)));
        }
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            I18nInspection.$$$reportNull$$$0(3);
        }
        super.readSettings(node);
        for (Element o : node.getChildren()) {
            String nameAttr = o.getAttributeValue("name");
            String valueAttr = o.getAttributeValue("value");
            if (Comparing.strEqual((String)nameAttr, (String)SKIP_FOR_ENUM)) {
                if (valueAttr == null) continue;
                this.ignoreForEnumConstants = Boolean.parseBoolean(valueAttr);
                continue;
            }
            if (!Comparing.strEqual((String)nameAttr, (String)IGNORE_ALL_BUT_NLS) || valueAttr == null) continue;
            this.ignoreForAllButNls = Boolean.parseBoolean(valueAttr);
        }
        this.cacheNonNlsCommentPattern();
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.internationalization.issues", (Object[])new Object[0]);
        if (string == null) {
            I18nInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "HardCodedStringLiteral";
    }

    public boolean setIgnoreForEnumConstants(boolean ignoreForEnumConstants) {
        boolean old = this.ignoreForEnumConstants;
        this.ignoreForEnumConstants = ignoreForEnumConstants;
        return old;
    }

    public boolean setIgnoreForAllButNls(boolean ignoreForAllButNls) {
        boolean old = this.ignoreForAllButNls;
        this.ignoreForAllButNls = ignoreForAllButNls;
        return old;
    }

    public JComponent createOptionsPanel() {
        GridBagLayout layout = new GridBagLayout();
        JPanel panel = new JPanel(layout);
        final JCheckBox assertStatementsCheckbox = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.assert", new Object[0]), this.ignoreForAssertStatements);
        assertStatementsCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForAssertStatements = assertStatementsCheckbox.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$1", "stateChanged"));
            }
        });
        final JCheckBox exceptionConstructorCheck = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.for.exception.constructor.arguments", new Object[0]), this.ignoreForExceptionConstructors);
        exceptionConstructorCheck.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForExceptionConstructors = exceptionConstructorCheck.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$2", "stateChanged"));
            }
        });
        final JTextField specifiedExceptions = new JTextField(this.ignoreForSpecifiedExceptionConstructors);
        specifiedExceptions.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForSpecifiedExceptionConstructors = specifiedExceptions.getText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$3", "textChanged"));
            }
        });
        final JCheckBox junitAssertCheckbox = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.for.junit.assert.arguments", new Object[0]), this.ignoreForJUnitAsserts);
        junitAssertCheckbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForJUnitAsserts = junitAssertCheckbox.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$4", "stateChanged"));
            }
        });
        final JCheckBox classRef = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.qualified.class.names", new Object[0]), this.ignoreForClassReferences);
        classRef.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    5.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForClassReferences = classRef.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$5", "stateChanged"));
            }
        });
        final JCheckBox propertyRef = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.property.keys", new Object[0]), this.ignoreForPropertyKeyReferences);
        propertyRef.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    6.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForPropertyKeyReferences = propertyRef.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$6", "stateChanged"));
            }
        });
        final JCheckBox nonAlpha = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.nonalphanumerics", new Object[0]), this.ignoreForNonAlpha);
        nonAlpha.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    7.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForNonAlpha = nonAlpha.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$7", "stateChanged"));
            }
        });
        final JCheckBox assignedToConstants = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.assigned.to.constants", new Object[0]), this.ignoreAssignedToConstants);
        assignedToConstants.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreAssignedToConstants = assignedToConstants.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$8", "stateChanged"));
            }
        });
        final JCheckBox chkToString = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.tostring", new Object[0]), this.ignoreToString);
        chkToString.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreToString = chkToString.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$9", "stateChanged"));
            }
        });
        final JCheckBox ignoreEnumConstants = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.enum", new Object[0]), this.ignoreForEnumConstants);
        ignoreEnumConstants.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    10.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForEnumConstants = ignoreEnumConstants.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$10", "stateChanged"));
            }
        });
        final JCheckBox ignoreAllButNls = new JCheckBox(JavaI18nBundle.message("inspection.i18n.option.ignore.nls", new Object[0]), this.ignoreForAllButNls);
        ignoreAllButNls.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    11.$$$reportNull$$$0(0);
                }
                I18nInspection.this.ignoreForAllButNls = ignoreAllButNls.isSelected();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$11", "stateChanged"));
            }
        });
        GridBagConstraints gc = new GridBagConstraints();
        gc.fill = 2;
        gc.insets.bottom = 2;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weightx = 1.0;
        gc.weighty = 0.0;
        panel.add((Component)ignoreAllButNls, gc);
        ++gc.gridy;
        panel.add((Component)assertStatementsCheckbox, gc);
        ++gc.gridy;
        panel.add((Component)junitAssertCheckbox, gc);
        ++gc.gridy;
        panel.add((Component)exceptionConstructorCheck, gc);
        ++gc.gridy;
        final Project[] openProjects = ProjectManager.getInstance().getOpenProjects();
        panel.add((Component)new FieldPanel(specifiedExceptions, null, JavaI18nBundle.message("inspection.i18n.option.ignore.for.specified.exception.constructor.arguments", new Object[0]), openProjects.length == 0 ? null : new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                if (e == null) {
                    12.$$$reportNull$$$0(0);
                }
                I18nInspection.this.createIgnoreExceptionsConfigurationDialog(openProjects[0], specifiedExceptions).show();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInspection/i18n/I18nInspection$12", "actionPerformed"));
            }
        }, null), gc);
        ++gc.gridy;
        panel.add((Component)classRef, gc);
        ++gc.gridy;
        panel.add((Component)propertyRef, gc);
        ++gc.gridy;
        panel.add((Component)assignedToConstants, gc);
        ++gc.gridy;
        panel.add((Component)chkToString, gc);
        ++gc.gridy;
        panel.add((Component)nonAlpha, gc);
        ++gc.gridy;
        panel.add((Component)ignoreEnumConstants, gc);
        ++gc.gridy;
        gc.anchor = 18;
        gc.weighty = 1.0;
        JTextField text = new JTextField(this.nonNlsCommentPattern);
        FieldPanel nonNlsCommentPatternComponent = new FieldPanel(text, JavaI18nBundle.message("inspection.i18n.option.ignore.comment.pattern", new Object[0]), JavaI18nBundle.message("inspection.i18n.option.ignore.comment.title", new Object[0]), null, () -> {
            this.nonNlsCommentPattern = text.getText();
            this.cacheNonNlsCommentPattern();
        });
        panel.add((Component)nonNlsCommentPatternComponent, gc);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)panel);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setBorder(null);
        scrollPane.setPreferredSize(new Dimension(panel.getPreferredSize().width + scrollPane.getVerticalScrollBar().getPreferredSize().width, panel.getPreferredSize().height + scrollPane.getHorizontalScrollBar().getPreferredSize().height));
        return scrollPane;
    }

    private DialogWrapper createIgnoreExceptionsConfigurationDialog(final Project project, final JTextField specifiedExceptions) {
        return new DialogWrapper(true){
            private AddDeleteListPanel myPanel;
            {
                super(arg0);
                this.setTitle(JavaI18nBundle.message("inspection.i18n.option.ignore.for.specified.exception.constructor.arguments", new Object[0]));
                this.init();
            }

            protected JComponent createCenterPanel() {
                String[] ignored = I18nInspection.this.ignoreForSpecifiedExceptionConstructors.split(",");
                ArrayList<String> initialList = new ArrayList<String>();
                for (String e : ignored) {
                    if (e.isEmpty()) continue;
                    initialList.add(e);
                }
                this.myPanel = new AddDeleteListPanel<String>(null, initialList){

                    protected String findItemToAdd() {
                        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
                        TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)project).createInheritanceClassChooser(JavaI18nBundle.message("inspection.i18n.option.ignore.for.specified.exception.constructor.arguments", new Object[0]), scope, JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Throwable", scope), true, true, null);
                        chooser.showDialog();
                        PsiClass selectedClass = chooser.getSelected();
                        return selectedClass != null ? selectedClass.getQualifiedName() : null;
                    }
                };
                return this.myPanel;
            }

            protected void doOKAction() {
                Object[] exceptions;
                StringBuilder buf = new StringBuilder();
                for (Object exception : exceptions = this.myPanel.getListItems()) {
                    buf.append(",").append(exception);
                }
                specifiedExceptions.setText(buf.length() > 0 ? buf.substring(1) : buf.toString());
                super.doOKAction();
            }
        };
    }

    public ProblemDescriptor @Nullable [] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            I18nInspection.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(6);
        }
        if (I18nInspection.isClassNonNls((UDeclaration)method)) {
            return null;
        }
        ArrayList<ProblemDescriptor> results = new ArrayList<ProblemDescriptor>();
        this.checkMethodBody(method, manager, isOnTheFly, results);
        this.checkAnnotations((UDeclaration)method, manager, isOnTheFly, results);
        for (UParameter parameter : method.getUastParameters()) {
            this.checkAnnotations((UDeclaration)parameter, manager, isOnTheFly, results);
        }
        return results.isEmpty() ? null : results.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private void checkMethodBody(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly, @NotNull List<ProblemDescriptor> results) {
        UExpression body;
        if (method == null) {
            I18nInspection.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(8);
        }
        if (results == null) {
            I18nInspection.$$$reportNull$$$0(9);
        }
        if ((body = method.getUastBody()) != null) {
            if (body.getSourcePsi() != null) {
                I18nInspection.addAll(results, this.checkElement((UElement)body, manager, isOnTheFly));
            } else if (body instanceof UBlockExpression) {
                for (UExpression expression : ((UBlockExpression)body).getExpressions()) {
                    if (expression instanceof UReturnExpression && expression.getSourcePsi() == null) {
                        UExpression returnExpression = ((UReturnExpression)expression).getReturnExpression();
                        if (returnExpression == null) continue;
                        I18nInspection.addAll(results, this.checkElement((UElement)returnExpression, manager, isOnTheFly));
                        continue;
                    }
                    I18nInspection.addAll(results, this.checkElement((UElement)expression, manager, isOnTheFly));
                }
            }
        }
    }

    private static void addAll(List<? super ProblemDescriptor> results, ProblemDescriptor[] descriptors) {
        if (descriptors != null) {
            ContainerUtil.addAll(results, (Object[])descriptors);
        }
    }

    public ProblemDescriptor @Nullable [] checkClass(@NotNull UClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            I18nInspection.$$$reportNull$$$0(10);
        }
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(11);
        }
        if (I18nInspection.isClassNonNls((UDeclaration)aClass)) {
            return null;
        }
        UClassInitializer[] initializers = aClass.getInitializers();
        ArrayList<ProblemDescriptor> result = new ArrayList<ProblemDescriptor>();
        for (UMethod uMethod : aClass.getMethods()) {
            if (uMethod.getSourcePsi() != aClass.getSourcePsi()) continue;
            this.checkMethodBody(uMethod, manager, isOnTheFly, result);
        }
        for (UMethod uMethod : initializers) {
            I18nInspection.addAll(result, this.checkElement((UElement)uMethod.getUastBody(), manager, isOnTheFly));
        }
        this.checkAnnotations((UDeclaration)aClass, manager, isOnTheFly, result);
        return result.isEmpty() ? null : result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private void checkAnnotations(UDeclaration member, @NotNull InspectionManager manager, boolean isOnTheFly, List<? super ProblemDescriptor> result) {
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(12);
        }
        for (UAnnotation annotation : member.getUAnnotations()) {
            I18nInspection.addAll(result, this.checkElement((UElement)annotation, manager, isOnTheFly));
        }
    }

    public ProblemDescriptor @Nullable [] checkField(@NotNull UField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            I18nInspection.$$$reportNull$$$0(13);
        }
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(14);
        }
        if (I18nInspection.isClassNonNls((UDeclaration)field)) {
            return null;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)field.getJavaPsi()), (String)"org.jetbrains.annotations.NonNls", (int)2)) {
            return null;
        }
        ArrayList result = new ArrayList();
        UExpression initializer = field.getUastInitializer();
        if (initializer != null) {
            I18nInspection.addAll(result, this.checkElement((UElement)initializer, manager, isOnTheFly));
        } else if (field instanceof UEnumConstant) {
            List arguments = ((UEnumConstant)field).getValueArguments();
            for (UExpression argument : arguments) {
                I18nInspection.addAll(result, this.checkElement((UElement)argument, manager, isOnTheFly));
            }
        }
        this.checkAnnotations((UDeclaration)field, manager, isOnTheFly, result);
        return result.isEmpty() ? null : result.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    public String getAlternativeID() {
        return "nls";
    }

    private ProblemDescriptor[] checkElement(@NotNull UElement element, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement sourcePsi;
        if (element == null) {
            I18nInspection.$$$reportNull$$$0(15);
        }
        if (manager == null) {
            I18nInspection.$$$reportNull$$$0(16);
        }
        if (element instanceof ULiteralExpression) {
            element = UastLiteralUtils.wrapULiteral((UExpression)((ULiteralExpression)element));
        }
        if ((sourcePsi = element.getSourcePsi()) == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        StringI18nVisitor visitor = new StringI18nVisitor(manager, isOnTheFly);
        sourcePsi.accept((PsiElementVisitor)visitor);
        List problems = visitor.getProblems();
        return problems.isEmpty() ? null : problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    private static LocalQuickFix createIntroduceConstantFix() {
        return new LocalQuickFix(){

            @NotNull
            public String getFamilyName() {
                String string = IntroduceConstantHandler.getRefactoringNameText();
                if (string == null) {
                    14.$$$reportNull$$$0(0);
                }
                return string;
            }

            public boolean startInWriteAction() {
                return false;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                PsiElement element;
                if (project == null) {
                    14.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    14.$$$reportNull$$$0(2);
                }
                if (!((element = descriptor.getPsiElement()) instanceof PsiExpression)) {
                    return;
                }
                PsiExpression[] expressions = new PsiExpression[]{(PsiExpression)element};
                new IntroduceConstantHandler().invoke(project, expressions);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/i18n/I18nInspection$14";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/i18n/I18nInspection$14";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static String getStringValueOfKnownPart(@NotNull UInjectionHost expression) {
        UStringConcatenationsFacade concatenationsFacade;
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(17);
        }
        if ((concatenationsFacade = UStringConcatenationsFacade.createFromUExpression((UExpression)expression)) != null) {
            return concatenationsFacade.asPartiallyKnownString().getConcatenationOfKnown();
        }
        return expression.evaluateToString();
    }

    private static List<UExpression> findIndirectUsages(UExpression expression) {
        PsiElement codeBlock;
        PsiElement sourcePsi = expression.getSourcePsi();
        if (!(sourcePsi instanceof PsiLiteralExpression)) {
            return Collections.emptyList();
        }
        while (sourcePsi.getParent() instanceof PsiPolyadicExpression || sourcePsi.getParent() instanceof PsiParenthesizedExpression) {
            sourcePsi = sourcePsi.getParent();
        }
        PsiExpression passThrough = ExpressionUtils.getPassThroughExpression((PsiExpression)((PsiExpression)sourcePsi));
        PsiElement parent = passThrough.getParent();
        ArrayList<UExpression> expressions = new ArrayList<UExpression>();
        if (!passThrough.equals(sourcePsi)) {
            expressions.add((UExpression)UastContextKt.toUElement((PsiElement)passThrough, UExpression.class));
        }
        PsiLocalVariable local = null;
        if (parent instanceof PsiLocalVariable) {
            local = (PsiLocalVariable)parent;
        } else if (parent instanceof PsiAssignmentExpression && passThrough.equals(((PsiAssignmentExpression)parent).getRExpression()) && ((PsiAssignmentExpression)parent).getOperationTokenType() == JavaTokenType.EQ) {
            local = ExpressionUtils.resolveLocalVariable((PsiExpression)((PsiAssignmentExpression)parent).getLExpression());
        }
        if (local != null && (codeBlock = PsiUtil.getVariableCodeBlock((PsiVariable)local, null)) instanceof PsiCodeBlock) {
            for (PsiElement e : DefUseUtil.getRefs((PsiCodeBlock)((PsiCodeBlock)codeBlock), (PsiVariable)local, (PsiElement)passThrough)) {
                ContainerUtil.addIfNotNull(expressions, (Object)((UExpression)UastContextKt.toUElement((PsiElement)e, UExpression.class)));
            }
        }
        return expressions;
    }

    private NlsInfo getExpectedNlsInfo(@NotNull Project project, @NotNull UInjectionHost expression, @NotNull String value, @NotNull Set<? super PsiModifierListOwner> nonNlsTargets) {
        if (project == null) {
            I18nInspection.$$$reportNull$$$0(18);
        }
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(19);
        }
        if (value == null) {
            I18nInspection.$$$reportNull$$$0(20);
        }
        if (nonNlsTargets == null) {
            I18nInspection.$$$reportNull$$$0(21);
        }
        if (this.ignoreForNonAlpha && !StringUtil.containsAlphaCharacters((String)value)) {
            return NlsInfo.nonLocalized();
        }
        List<UExpression> usages = I18nInspection.findIndirectUsages((UExpression)expression);
        if (usages.isEmpty()) {
            usages = Collections.singletonList(expression);
        }
        for (UExpression usage : usages) {
            NlsInfo info = NlsInfo.forExpression(usage);
            switch (info.getNlsStatus()) {
                case YES: {
                    if (this.isSuppressedByComment(project, expression)) {
                        return NlsInfo.nonLocalized();
                    }
                    return info;
                }
                case UNSURE: {
                    if (this.ignoreForAllButNls || this.shouldIgnoreUsage(project, value, nonNlsTargets, usage)) break;
                    if (this.isSuppressedByComment(project, expression)) {
                        return NlsInfo.nonLocalized();
                    }
                    ContainerUtil.addIfNotNull(nonNlsTargets, (Object)((NlsInfo.Unspecified)info).getAnnotationCandidate());
                    return NlsInfo.localized();
                }
            }
        }
        return NlsInfo.nonLocalized();
    }

    private boolean isSuppressedByComment(@NotNull Project project, @NotNull UInjectionHost expression) {
        Pattern pattern;
        if (project == null) {
            I18nInspection.$$$reportNull$$$0(22);
        }
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(23);
        }
        if ((pattern = this.myCachedNonNlsPattern) != null) {
            PsiElement sourcePsi = expression.getSourcePsi();
            if (sourcePsi == null) {
                return false;
            }
            PsiFile file = sourcePsi.getContainingFile();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document == null) {
                return false;
            }
            int line = document.getLineNumber(sourcePsi.getTextRange().getStartOffset());
            int lineStartOffset = document.getLineStartOffset(line);
            CharSequence lineText = document.getCharsSequence().subSequence(lineStartOffset, document.getLineEndOffset(line));
            Matcher matcher = pattern.matcher(lineText);
            int start = 0;
            while (matcher.find(start)) {
                start = matcher.start();
                PsiElement element = file.findElementAt(lineStartOffset + start);
                if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null) {
                    return true;
                }
                if (start == lineText.length() - 1) break;
                ++start;
            }
        }
        return false;
    }

    private boolean shouldIgnoreUsage(@NotNull Project project, @NotNull String value, @NotNull Set<? super PsiModifierListOwner> nonNlsTargets, @NotNull UExpression usage) {
        if (project == null) {
            I18nInspection.$$$reportNull$$$0(24);
        }
        if (value == null) {
            I18nInspection.$$$reportNull$$$0(25);
        }
        if (nonNlsTargets == null) {
            I18nInspection.$$$reportNull$$$0(26);
        }
        if (usage == null) {
            I18nInspection.$$$reportNull$$$0(27);
        }
        if (I18nInspection.isInNonNlsCall(usage, nonNlsTargets)) {
            return true;
        }
        if (I18nInspection.isInNonNlsEquals(usage, nonNlsTargets)) {
            return true;
        }
        if (this.isPassedToNonNlsVariable(usage, nonNlsTargets)) {
            return true;
        }
        if (this.ignoreForAssertStatements && I18nInspection.isArgOfAssertStatement(usage)) {
            return true;
        }
        if (this.ignoreForExceptionConstructors && I18nInspection.isExceptionArgument(usage)) {
            return true;
        }
        if (this.ignoreForEnumConstants && I18nInspection.isArgOfEnumConstant(usage)) {
            return true;
        }
        if (!this.ignoreForExceptionConstructors && I18nInspection.isArgOfSpecifiedExceptionConstructor(usage, this.ignoreForSpecifiedExceptionConstructors.split(","))) {
            return true;
        }
        if (this.ignoreForJUnitAsserts && I18nInspection.isArgOfJUnitAssertion(usage)) {
            return true;
        }
        if (this.ignoreForClassReferences && I18nInspection.isClassRef(usage, value)) {
            return true;
        }
        if (this.ignoreForPropertyKeyReferences && !PropertiesImplUtil.findPropertiesByKey((Project)project, (String)value).isEmpty()) {
            return true;
        }
        return this.ignoreToString && I18nInspection.isToString(usage);
    }

    private static boolean isArgOfEnumConstant(UExpression expression) {
        return expression.getUastParent() instanceof UEnumConstant;
    }

    public void cacheNonNlsCommentPattern() {
        this.myCachedNonNlsPattern = this.nonNlsCommentPattern.trim().isEmpty() ? null : Pattern.compile(this.nonNlsCommentPattern);
    }

    private static boolean isClassRef(UExpression expression, String value) {
        Project project;
        if (StringUtil.startsWithChar((CharSequence)value, (char)'#')) {
            value = value.substring(1);
        }
        return JavaPsiFacade.getInstance((Project)(project = Objects.requireNonNull(expression.getSourcePsi()).getProject())).findClass(value, GlobalSearchScope.allScope((Project)project)) != null || ClassUtil.findPsiClassByJVMName((PsiManager)PsiManager.getInstance((Project)project), (String)value) != null;
    }

    private static boolean isClassNonNls(@NotNull UDeclaration clazz) {
        UFile uFile;
        if (clazz == null) {
            I18nInspection.$$$reportNull$$$0(28);
        }
        if ((uFile = UastUtils.getContainingUFile((UElement)clazz)) == null) {
            return false;
        }
        PsiDirectory directory = uFile.getSourcePsi().getContainingDirectory();
        return directory != null && I18nInspection.isPackageNonNls(JavaDirectoryService.getInstance().getPackage(directory));
    }

    public static boolean isPackageNonNls(PsiPackage psiPackage) {
        if (psiPackage == null || psiPackage.getName() == null) {
            return false;
        }
        PsiModifierList pkgModifierList = psiPackage.getAnnotationList();
        return pkgModifierList != null && pkgModifierList.hasAnnotation("org.jetbrains.annotations.NonNls") || I18nInspection.isPackageNonNls(psiPackage.getParentPackage());
    }

    private boolean isPassedToNonNlsVariable(@NotNull UExpression expression, Set<? super PsiModifierListOwner> nonNlsTargets) {
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(29);
        }
        UExpression toplevel = JavaI18nUtil.getTopLevelExpression(expression);
        PsiVariable var = null;
        if (UastExpressionUtils.isAssignment((UElement)toplevel)) {
            PsiElement resolved;
            UExpression lExpression = ((UBinaryExpression)toplevel).getLeftOperand();
            while (lExpression instanceof UArrayAccessExpression) {
                lExpression = ((UArrayAccessExpression)lExpression).getReceiver();
            }
            if (lExpression instanceof UResolvable && (resolved = ((UResolvable)lExpression).resolve()) instanceof PsiVariable) {
                var = (PsiVariable)resolved;
            }
        }
        if (var == null) {
            UElement caseParent;
            PsiElement resolved;
            UExpression switchExpression;
            UElement parent = toplevel.getUastParent();
            if (parent instanceof UVariable && toplevel.equals(((UVariable)parent).getUastInitializer())) {
                if (((UVariable)parent).findAnnotation("org.jetbrains.annotations.NonNls") != null) {
                    return true;
                }
                PsiElement psi = parent.getSourcePsi();
                if (psi instanceof PsiModifierListOwner) {
                    var = (PsiModifierListOwner)psi;
                }
            } else if (toplevel instanceof USwitchExpression && (switchExpression = ((USwitchExpression)toplevel).getExpression()) instanceof UResolvable && (resolved = ((UResolvable)switchExpression).resolve()) instanceof PsiVariable && (caseParent = expression.getUastParent()) instanceof USwitchClauseExpression && ((USwitchClauseExpression)caseParent).getCaseValues().contains(expression)) {
                var = (PsiVariable)resolved;
            }
        }
        if (var != null) {
            if (I18nInspection.annotatedAsNonNls(var)) {
                return true;
            }
            if (this.ignoreAssignedToConstants && var.hasModifierProperty("static") && var.hasModifierProperty("final")) {
                return true;
            }
            nonNlsTargets.add((PsiModifierListOwner)var);
        }
        return false;
    }

    private static boolean annotatedAsNonNls(PsiModifierListOwner parent) {
        return NlsInfo.forModifierListOwner(parent) instanceof NlsInfo.NonLocalized;
    }

    private static boolean isInNonNlsEquals(UExpression expression, Set<? super PsiModifierListOwner> nonNlsTargets) {
        PsiElement resolvedEntity;
        UElement parent = UastUtils.skipParenthesizedExprUp((UElement)expression.getUastParent());
        if (!(parent instanceof UQualifiedReferenceExpression)) {
            return false;
        }
        UExpression selector = ((UQualifiedReferenceExpression)parent).getSelector();
        if (!(selector instanceof UCallExpression)) {
            return false;
        }
        UCallExpression call = (UCallExpression)selector;
        if (!"equals".equals(call.getMethodName()) || !MethodUtils.isEquals((PsiMethod)call.resolve())) {
            return false;
        }
        List expressions = call.getValueArguments();
        if (expressions.size() != 1) {
            return false;
        }
        UExpression arg = UastUtils.skipParenthesizedExprDown((UExpression)((UExpression)expressions.get(0)));
        UResolvable ref = (UResolvable)ObjectUtils.tryCast((Object)arg, UResolvable.class);
        if (ref != null && (resolvedEntity = ref.resolve()) instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)resolvedEntity;
            if (I18nInspection.annotatedAsNonNls(modifierListOwner)) {
                return true;
            }
            nonNlsTargets.add((PsiModifierListOwner)modifierListOwner);
        }
        return false;
    }

    private static boolean isInNonNlsCall(@NotNull UExpression expression, Set<? super PsiModifierListOwner> nonNlsTargets) {
        UElement parentOfNew;
        UExpression parent;
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(30);
        }
        if ((parent = UastUtils.skipParenthesizedExprDown((UExpression)JavaI18nUtil.getTopLevelExpression(expression))) instanceof UQualifiedReferenceExpression) {
            return I18nInspection.isNonNlsCall((UReferenceExpression)((UQualifiedReferenceExpression)parent), nonNlsTargets);
        }
        if (parent != null && UastExpressionUtils.isAssignment((UElement)parent)) {
            UExpression operand = ((UBinaryExpression)parent).getLeftOperand();
            if (operand instanceof UReferenceExpression && I18nInspection.isNonNlsCall((UReferenceExpression)operand, nonNlsTargets)) {
                return true;
            }
        } else if (parent instanceof UCallExpression && (parentOfNew = UastUtils.skipParenthesizedExprUp((UElement)parent.getUastParent())) instanceof ULocalVariable) {
            ULocalVariable newVariable = (ULocalVariable)parentOfNew;
            if (I18nInspection.annotatedAsNonNls((PsiModifierListOwner)newVariable.getPsi())) {
                return true;
            }
            PsiElement variableJavaPsi = newVariable.getJavaPsi();
            if (variableJavaPsi instanceof PsiModifierListOwner) {
                nonNlsTargets.add((PsiModifierListOwner)((PsiModifierListOwner)variableJavaPsi));
            }
            return false;
        }
        return false;
    }

    private static boolean isNonNlsCall(UReferenceExpression qualifier, Set<? super PsiModifierListOwner> nonNlsTargets) {
        UExpression receiver;
        PsiElement resolved = qualifier.resolve();
        if (resolved instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)resolved;
            if (I18nInspection.annotatedAsNonNls(modifierListOwner)) {
                return true;
            }
            nonNlsTargets.add((PsiModifierListOwner)modifierListOwner);
        }
        if (qualifier instanceof UQualifiedReferenceExpression && (receiver = UastUtils.skipParenthesizedExprDown((UExpression)((UQualifiedReferenceExpression)qualifier).getReceiver())) instanceof UReferenceExpression) {
            return I18nInspection.isNonNlsCall((UReferenceExpression)receiver, nonNlsTargets);
        }
        return false;
    }

    private static boolean isToString(UExpression expression) {
        UMethod method = (UMethod)UastUtils.getParentOfType((UElement)expression, UMethod.class);
        if (method == null) {
            return false;
        }
        PsiType returnType = method.getReturnType();
        return TO_STRING.equals(method.getName()) && method.getUastParameters().isEmpty() && returnType != null && "java.lang.String".equals(returnType.getCanonicalText());
    }

    private static boolean isArgOfJUnitAssertion(UExpression expression) {
        UElement parent = UastUtils.skipParenthesizedExprUp((UElement)expression.getUastParent());
        if (parent == null || !UastExpressionUtils.isMethodCall((UElement)parent)) {
            return false;
        }
        String methodName = ((UCallExpression)parent).getMethodName();
        if (methodName == null) {
            return false;
        }
        if (!methodName.startsWith("assert") && !methodName.equals("fail")) {
            return false;
        }
        PsiMethod method = ((UCallExpression)parent).resolve();
        if (method == null) {
            return false;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.junit.Assert") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"org.junit.jupiter.api.Assertions") || InheritanceUtil.isInheritor((PsiClass)containingClass, (String)"junit.framework.Assert");
    }

    private static boolean isArgOfSpecifiedExceptionConstructor(UExpression expression, String[] specifiedExceptions) {
        PsiClass aClass;
        if (specifiedExceptions.length == 0) {
            return false;
        }
        UCallExpression parent = (UCallExpression)UastUtils.getParentOfType((UElement)expression, UCallExpression.class, (boolean)true, (Class[])new Class[]{UClass.class});
        if (parent == null || !UastExpressionUtils.isConstructorCall((UElement)parent)) {
            return false;
        }
        PsiMethod resolved = parent.resolve();
        PsiClass psiClass = aClass = resolved != null ? resolved.getContainingClass() : null;
        if (aClass == null) {
            return false;
        }
        return ArrayUtil.contains((String)aClass.getQualifiedName(), (String[])specifiedExceptions);
    }

    private static boolean isArgOfAssertStatement(UExpression expression) {
        UCallExpression parent = (UCallExpression)UastUtils.getParentOfType((UElement)expression, UCallExpression.class);
        return parent != null && "assert".equals(parent.getMethodName());
    }

    public static boolean isExceptionArgument(@NotNull UExpression expression) {
        UCallExpression newExpression;
        if (expression == null) {
            I18nInspection.$$$reportNull$$$0(31);
        }
        if ((newExpression = (UCallExpression)UastUtils.getParentOfType((UElement)expression, UCallExpression.class, (boolean)true, (Class[])new Class[]{UBlockExpression.class, UClass.class})) != null && UastExpressionUtils.isConstructorCall((UElement)newExpression)) {
            PsiMethod ctor = newExpression.resolve();
            return ctor != null && InheritanceUtil.isInheritor((PsiClass)ctor.getContainingClass(), (String)"java.lang.Throwable");
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/I18nInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 19: 
            case 23: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonNlsTargets";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/I18nInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodBody";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotations";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkField";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkElement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStringValueOfKnownPart";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedNlsInfo";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedByComment";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shouldIgnoreUsage";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isClassNonNls";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isPassedToNonNlsVariable";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isInNonNlsCall";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isExceptionArgument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class StringI18nVisitor
    extends PsiElementVisitor {
        private final List<ProblemDescriptor> myProblems;
        private final InspectionManager myManager;
        private final boolean myOnTheFly;

        private StringI18nVisitor(InspectionManager manager, boolean onTheFly) {
            if (manager == null) {
                StringI18nVisitor.$$$reportNull$$$0(0);
            }
            this.myProblems = new ArrayList<ProblemDescriptor>();
            this.myManager = manager;
            this.myOnTheFly = onTheFly;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                StringI18nVisitor.$$$reportNull$$$0(1);
            }
            super.visitElement(element);
            if (element instanceof PsiMember && ((PsiMember)element).getName() != null || element instanceof PsiClassInitializer) {
                return;
            }
            UElement uElement = UastContextKt.toUElementOfExpectedTypes((PsiElement)element, (Class[])new Class[]{UInjectionHost.class, UAnnotation.class});
            if (uElement instanceof UInjectionHost) {
                this.visitLiteralExpression(element, (UInjectionHost)uElement);
                return;
            }
            if (uElement instanceof UAnnotation && "java.lang.SuppressWarnings".equals(((UAnnotation)uElement).getQualifiedName())) {
                return;
            }
            element.acceptChildren((PsiElementVisitor)this);
        }

        private void visitLiteralExpression(@NotNull PsiElement sourcePsi, @NotNull UInjectionHost expression) {
            String stringValue;
            if (sourcePsi == null) {
                StringI18nVisitor.$$$reportNull$$$0(2);
            }
            if (expression == null) {
                StringI18nVisitor.$$$reportNull$$$0(3);
            }
            if (StringUtil.isEmptyOrSpaces((String)(stringValue = I18nInspection.getStringValueOfKnownPart(expression)))) {
                return;
            }
            THashSet nonNlsTargets = new THashSet();
            NlsInfo info = I18nInspection.this.getExpectedNlsInfo(this.myManager.getProject(), expression, stringValue, (Set)nonNlsTargets);
            if (info instanceof NlsInfo.Localized) {
                UField parentField = (UField)UastUtils.getParentOfType((UElement)expression, UField.class);
                if (parentField != null) {
                    nonNlsTargets.add((PsiModifierListOwner)parentField.getJavaPsi());
                }
                String description = JavaI18nBundle.message("inspection.i18n.message.general.with.value", "#ref");
                ArrayList<Object> fixes = new ArrayList<Object>();
                if (this.myOnTheFly) {
                    if (sourcePsi instanceof PsiLiteralExpression) {
                        if (I18nizeConcatenationQuickFix.getEnclosingLiteralConcatenation(sourcePsi) != null) {
                            fixes.add(new I18nizeConcatenationQuickFix((NlsInfo.Localized)info));
                        }
                        fixes.add(new I18nizeQuickFix((NlsInfo.Localized)info));
                        if (!this.isNotConstantFieldInitializer((PsiExpression)sourcePsi)) {
                            fixes.add(I18nInspection.createIntroduceConstantFix());
                        }
                        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)sourcePsi)) {
                            JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.myManager.getProject());
                            for (PsiModifierListOwner element : nonNlsTargets) {
                                if (NlsInfo.forModifierListOwner(element).getNlsStatus() != ThreeState.UNSURE || element.getManager().isInProject((PsiElement)element) && facade.findClass("org.jetbrains.annotations.NonNls", element.getResolveScope()) == null) continue;
                                fixes.add(new NonNlsAnnotationProvider().createFix(element));
                            }
                        }
                    }
                } else if (Registry.is((String)"i18n.for.idea.project")) {
                    fixes.add(new I18nizeBatchQuickFix());
                }
                LocalQuickFix[] farr = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
                ProblemDescriptor problem = this.myManager.createProblemDescriptor(sourcePsi, description, this.myOnTheFly, farr, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                this.myProblems.add(problem);
            }
        }

        private boolean isNotConstantFieldInitializer(PsiExpression expression) {
            PsiField parentField = expression.getParent() instanceof PsiField ? (PsiField)expression.getParent() : null;
            return parentField != null && expression == parentField.getInitializer() && parentField.hasModifierProperty("final") && parentField.hasModifierProperty("static");
        }

        private List<ProblemDescriptor> getProblems() {
            return this.myProblems;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourcePsi";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/i18n/I18nInspection$StringI18nVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLiteralExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

