/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.i18n.I18nizeQuickFix;
import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.codeInspection.i18n.batch.I18nizeMultipleStringsDialog;
import com.intellij.codeInspection.i18n.batch.I18nizedPropertyData;
import com.intellij.lang.Language;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.references.I18nizeQuickFixDialog;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.psi.util.PsiConcatenationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.NameUtilCore;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;
import org.jetbrains.uast.generate.UastCodeGenerationPlugin;
import org.jetbrains.uast.generate.UastElementFactory;

public class I18nizeBatchQuickFix
extends I18nizeQuickFix
implements BatchQuickFix<CommonProblemDescriptor> {
    private static final Logger LOG = Logger.getInstance(I18nizeBatchQuickFix.class);

    public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        if (project == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(0);
        }
        if (psiElementsToIgnore == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptors == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(2);
        }
        HashSet<PsiElement> distinct = new HashSet<PsiElement>();
        LinkedHashMap<String, I18nizedPropertyData<HardcodedStringContextData>> keyValuePairs = new LinkedHashMap<String, I18nizedPropertyData<HardcodedStringContextData>>();
        UniqueNameGenerator uniqueNameGenerator = new UniqueNameGenerator();
        LinkedHashSet<PsiFile> contextFiles = new LinkedHashSet<PsiFile>();
        for (CommonProblemDescriptor descriptor : descriptors) {
            String key;
            PsiElement psiElement = ((ProblemDescriptor)descriptor).getPsiElement();
            UStringConcatenationsFacade concatenation = UStringConcatenationsFacade.createFromTopConcatenation((UExpression)((UExpression)UastContextKt.toUElement((PsiElement)psiElement, UInjectionHost.class)));
            if (concatenation == null) continue;
            PartiallyKnownString pks = concatenation.asPartiallyKnownString();
            if (pks.getSegments().size() == 1) {
                String value = pks.getValueIfKnown();
                if (!distinct.add(psiElement) || value == null) continue;
                I18nizedPropertyData data2 = (I18nizedPropertyData)keyValuePairs.get(value);
                if (data2 != null) {
                    ((HardcodedStringContextData)data2.getContextData()).getPsiElements().add(psiElement);
                    ((HardcodedStringContextData)data2.getContextData()).getExpressions().add(concatenation.getRootUExpression());
                } else {
                    key = (String)ObjectUtils.notNull((Object)I18nizeBatchQuickFix.suggestKeyByPlace(concatenation.getRootUExpression()), (Object)I18nizeQuickFixDialog.suggestUniquePropertyKey((String)value, null, null));
                    ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                    elements.add(psiElement);
                    ArrayList<UExpression> uExpressions = new ArrayList<UExpression>();
                    uExpressions.add(concatenation.getRootUExpression());
                    HardcodedStringContextData contextData = new HardcodedStringContextData(uExpressions, elements, Collections.emptyList());
                    keyValuePairs.put(value, new I18nizedPropertyData<HardcodedStringContextData>(uniqueNameGenerator.generateUniqueName(key), value, contextData));
                }
                ContainerUtil.addIfNotNull(contextFiles, (Object)psiElement.getContainingFile());
                continue;
            }
            if (!distinct.add(concatenation.getRootUExpression().getSourcePsi())) continue;
            ArrayList args = new ArrayList();
            String value = I18nizeBatchQuickFix.buildUnescapedFormatString(concatenation, args);
            key = (String)ObjectUtils.notNull((Object)I18nizeBatchQuickFix.suggestKeyByPlace(concatenation.getRootUExpression()), (Object)I18nizeQuickFixDialog.suggestUniquePropertyKey((String)value, null, null));
            HardcodedStringContextData contextData = new HardcodedStringContextData(Collections.singletonList(concatenation.getRootUExpression()), Collections.singletonList(concatenation.getRootUExpression().getSourcePsi()), args);
            keyValuePairs.put(value + concatenation.hashCode(), new I18nizedPropertyData<HardcodedStringContextData>(uniqueNameGenerator.generateUniqueName(key), value, contextData));
            ContainerUtil.addIfNotNull(contextFiles, (Object)psiElement.getContainingFile());
        }
        if (keyValuePairs.isEmpty()) {
            return;
        }
        ArrayList replacements = new ArrayList(keyValuePairs.values());
        I18nizeMultipleStringsDialog<HardcodedStringContextData> dialog = new I18nizeMultipleStringsDialog<HardcodedStringContextData>(project, replacements, contextFiles, data -> {
            List elements = ((HardcodedStringContextData)data).getPsiElements();
            return ContainerUtil.map((Collection)elements, element -> new UsageInfo(element.getParent()));
        }, null);
        if (dialog.showAndGet()) {
            PropertiesFile propertiesFile = dialog.getPropertiesFile();
            HashSet<PsiFile> files = new HashSet<PsiFile>();
            for (I18nizedPropertyData pair : replacements) {
                for (PsiElement element : ((HardcodedStringContextData)pair.getContextData()).getPsiElements()) {
                    ContainerUtil.addIfNotNull(files, (Object)element.getContainingFile());
                }
            }
            if (files.isEmpty()) {
                return;
            }
            files.add(propertiesFile.getContainingFile());
            WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getFamilyName(), null, () -> {
                String bundleName = propertiesFile.getVirtualFile().getNameWithoutExtension();
                PsiClass[] classesByName = PsiShortNamesCache.getInstance((Project)project).getClassesByName(bundleName, GlobalSearchScope.projectScope((Project)project));
                if (classesByName.length == 1) {
                    bundleName = classesByName[0].getQualifiedName();
                    LOG.assertTrue(bundleName != null, (Object)propertiesFile.getName());
                }
                for (I18nizedPropertyData data : replacements) {
                    JavaI18nUtil.DEFAULT_PROPERTY_CREATION_HANDLER.createProperty(project, Collections.singletonList(propertiesFile), data.getKey(), data.getValue(), PsiExpression.EMPTY_ARRAY);
                    List uExpressions = ((HardcodedStringContextData)data.getContextData()).getExpressions();
                    List psiElements = ((HardcodedStringContextData)data.getContextData()).getPsiElements();
                    for (int i = 0; i < psiElements.size(); ++i) {
                        PsiElement psiElement = (PsiElement)psiElements.get(i);
                        UExpression uExpression = (UExpression)uExpressions.get(i);
                        Language language = psiElement.getLanguage();
                        UastCodeGenerationPlugin generationPlugin = UastCodeGenerationPlugin.byLanguage((Language)language);
                        if (generationPlugin == null) {
                            LOG.debug("No UAST generation plugin exist for " + language.getDisplayName());
                            continue;
                        }
                        UastElementFactory pluginElementFactory = generationPlugin.getElementFactory(project);
                        ArrayList<ULiteralExpression> arguments = new ArrayList<ULiteralExpression>();
                        arguments.add(pluginElementFactory.createStringLiteralExpression(data.getKey(), psiElement));
                        arguments.addAll(((HardcodedStringContextData)data.getContextData()).getArgs());
                        UCallExpression callExpression = pluginElementFactory.createCallExpression((UExpression)pluginElementFactory.createQualifiedReference(bundleName, (UElement)uExpression), "message", arguments, null, UastCallKind.METHOD_CALL, psiElement);
                        if (callExpression != null) {
                            generationPlugin.replace((UElement)uExpression, (UElement)callExpression, UCallExpression.class);
                            continue;
                        }
                        LOG.debug("Null generated UAST call expression");
                    }
                }
            }, (PsiFile[])files.toArray(PsiFile.EMPTY_ARRAY));
        }
    }

    private static String buildUnescapedFormatString(UStringConcatenationsFacade cf, List<? super UExpression> formatParameters) {
        StringBuilder result = new StringBuilder();
        int elIndex = 0;
        for (UExpression expression : SequencesKt.asIterable((Sequence)cf.getUastOperands())) {
            if (expression instanceof ULiteralExpression) {
                Object value = ((ULiteralExpression)expression).getValue();
                if (value == null) continue;
                result.append(PsiConcatenationUtil.formatString((String)value.toString(), (boolean)false));
                continue;
            }
            result.append("{").append(elIndex++).append("}");
            formatParameters.add((UExpression)expression);
        }
        return result.toString();
    }

    @Nullable
    private static String suggestKeyByPlace(@NotNull UExpression expression) {
        String name;
        UElement uClass;
        UMethod uMethod;
        UElement parent;
        if (expression == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(3);
        }
        if ((parent = UastUtils.skipParenthesizedExprUp((UElement)expression.getUastParent())) instanceof UPolyadicExpression) {
            parent = UastUtils.skipParenthesizedExprUp((UElement)parent.getUastParent());
        }
        if (parent == null) {
            return null;
        }
        UCallExpression callExpression = UastUtils.getUCallExpression((UElement)parent);
        if (callExpression != null) {
            PsiMethod method = callExpression.resolve();
            if (method != null && "registerProblem".equals(method.getName()) && InheritanceUtil.isInheritor((PsiClass)method.getContainingClass(), (String)ProblemsHolder.class.getName())) {
                PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)callExpression.getSourcePsi(), PsiClass.class);
                while (containingClass != null) {
                    if (InheritanceUtil.isInheritor((PsiClass)containingClass, (String)InspectionProfileEntry.class.getName())) {
                        String containingClassName = containingClass.getName();
                        return containingClassName == null ? null : "inspection." + I18nizeBatchQuickFix.toPropertyName(InspectionProfileEntry.getShortName((String)containingClassName)) + ".description";
                    }
                    containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)containingClass, PsiClass.class, (boolean)true);
                }
            }
            return null;
        }
        UElement returnStmt = UastUtils.getParentOfType((UElement)parent, UReturnExpression.class, (boolean)false, (Class[])new Class[]{UCallExpression.class, ULambdaExpression.class});
        if (returnStmt instanceof UReturnExpression && (uMethod = (UMethod)UastUtils.getParentOfType((UElement)expression, UMethod.class)) != null && (uClass = uMethod.getUastParent()) instanceof UClass && InheritanceUtil.isInheritor((PsiClass)((UClass)uClass), (String)LocalQuickFix.class.getName()) && (name = ((UClass)uClass).getName()) != null) {
            if ("getName".equals(uMethod.getName())) {
                return I18nizeBatchQuickFix.toPropertyName(name) + ".text";
            }
            if ("getFamilyName".equals(uMethod.getName())) {
                return I18nizeBatchQuickFix.toPropertyName(name) + ".family.name";
            }
        }
        return null;
    }

    @NotNull
    private static String toPropertyName(String name) {
        String string = StringUtil.join((Object[])NameUtilCore.splitNameIntoWords((String)name), s -> StringUtil.decapitalize((String)s), (String)".");
        if (string == null) {
            I18nizeBatchQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementsToIgnore";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/I18nizeBatchQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/I18nizeBatchQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toPropertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "suggestKeyByPlace";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class HardcodedStringContextData {
        private final List<UExpression> myExpressions;
        private final List<PsiElement> myPsiElements;
        private final List<UExpression> myArgs;

        private HardcodedStringContextData(@NotNull List<UExpression> expressions, @NotNull List<PsiElement> psiElements, @NotNull List<UExpression> args) {
            if (expressions == null) {
                HardcodedStringContextData.$$$reportNull$$$0(0);
            }
            if (psiElements == null) {
                HardcodedStringContextData.$$$reportNull$$$0(1);
            }
            if (args == null) {
                HardcodedStringContextData.$$$reportNull$$$0(2);
            }
            this.myExpressions = expressions;
            this.myPsiElements = psiElements;
            this.myArgs = args;
        }

        private List<UExpression> getExpressions() {
            return this.myExpressions;
        }

        private List<PsiElement> getPsiElements() {
            return this.myPsiElements;
        }

        private List<UExpression> getArgs() {
            return this.myArgs;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expressions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "psiElements";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "args";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInspection/i18n/I18nizeBatchQuickFix$HardcodedStringContextData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

