/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.IntStream;
import kotlin.Pair;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UNamedExpression;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;

public abstract class NlsInfo {
    @NotNull
    private static final Set<String> ANNOTATION_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"org.jetbrains.annotations.Nls", "org.jetbrains.annotations.NonNls"});
    @NotNull
    private static final String NLS_CONTEXT = "com.intellij.openapi.util.NlsContext";
    @NotNull
    private final ThreeState myNls;

    private NlsInfo(@NotNull ThreeState nls) {
        if (nls == null) {
            NlsInfo.$$$reportNull$$$0(0);
        }
        this.myNls = nls;
    }

    @NotNull
    public ThreeState getNlsStatus() {
        ThreeState threeState = this.myNls;
        if (threeState == null) {
            NlsInfo.$$$reportNull$$$0(1);
        }
        return threeState;
    }

    @NotNull
    public static Localized localized() {
        Localized localized = Localized.NLS;
        if (localized == null) {
            NlsInfo.$$$reportNull$$$0(2);
        }
        return localized;
    }

    @NotNull
    public static NonLocalized nonLocalized() {
        NonLocalized nonLocalized = NonLocalized.INSTANCE;
        if (nonLocalized == null) {
            NlsInfo.$$$reportNull$$$0(3);
        }
        return nonLocalized;
    }

    @NotNull
    public static NlsInfo forExpression(@NotNull UExpression expression) {
        NlsInfo info;
        if (expression == null) {
            NlsInfo.$$$reportNull$$$0(4);
        }
        if ((info = NlsInfo.fromMethodReturn(expression)) != Unspecified.UNKNOWN) {
            NlsInfo nlsInfo = info;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(5);
            }
            return nlsInfo;
        }
        info = NlsInfo.fromInitializer(expression);
        if (info != Unspecified.UNKNOWN) {
            NlsInfo nlsInfo = info;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(6);
            }
            return nlsInfo;
        }
        return NlsInfo.fromArgument(expression);
    }

    @NotNull
    public static NlsInfo forModifierListOwner(@NotNull PsiModifierListOwner owner) {
        PsiElement scope;
        if (owner == null) {
            NlsInfo.$$$reportNull$$$0(7);
        }
        if (owner instanceof PsiParameter && (scope = ((PsiParameter)owner).getDeclarationScope()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)scope;
            PsiParameterList list = method.getParameterList();
            int index = list.getParameterIndex((PsiParameter)owner);
            if (index < 0) {
                Unspecified unspecified = Unspecified.UNKNOWN;
                if (unspecified == null) {
                    NlsInfo.$$$reportNull$$$0(8);
                }
                return unspecified;
            }
            return NlsInfo.fromMethodParameter(method, index, null);
        }
        if (owner instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)owner;
            return NlsInfo.fromMethodReturn(method, method.getReturnType(), null);
        }
        return NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)owner.getModifierList());
    }

    @NotNull
    public static Nls.Capitalization getCapitalization(@NotNull PsiModifierListOwner owner) {
        NlsInfo info;
        if (owner == null) {
            NlsInfo.$$$reportNull$$$0(9);
        }
        if ((info = NlsInfo.forModifierListOwner(owner)) instanceof Localized) {
            Nls.Capitalization capitalization = ((Localized)info).getCapitalization();
            if (capitalization == null) {
                NlsInfo.$$$reportNull$$$0(10);
            }
            return capitalization;
        }
        Nls.Capitalization capitalization = Nls.Capitalization.NotSpecified;
        if (capitalization == null) {
            NlsInfo.$$$reportNull$$$0(11);
        }
        return capitalization;
    }

    private static NlsInfo fromInitializer(UExpression expression) {
        UElement parent;
        PsiElement var = null;
        while ((parent = expression.getUastParent()) instanceof UParenthesizedExpression || parent instanceof UIfExpression || parent instanceof UPolyadicExpression && ((UPolyadicExpression)parent).getOperator() == UastBinaryOperator.PLUS) {
            expression = (UExpression)parent;
        }
        if (parent instanceof UBinaryExpression) {
            UReferenceExpression lValue;
            UBinaryExpression binOp = (UBinaryExpression)parent;
            UastBinaryOperator operator = binOp.getOperator();
            if ((operator == UastBinaryOperator.ASSIGN || operator == UastBinaryOperator.PLUS_ASSIGN) && expression.equals(binOp.getRightOperand()) && (lValue = (UReferenceExpression)ObjectUtils.tryCast((Object)UastUtils.skipParenthesizedExprDown((UExpression)binOp.getLeftOperand()), UReferenceExpression.class)) != null) {
                var = lValue.resolve();
            }
        } else if (parent instanceof UVariable) {
            var = parent.getJavaPsi();
        }
        if (var instanceof PsiVariable) {
            NlsInfo info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)((PsiVariable)var).getModifierList());
            if (info != Unspecified.UNKNOWN) {
                return info;
            }
            return NlsInfo.fromType(((PsiVariable)var).getType());
        }
        return Unspecified.UNKNOWN;
    }

    @NotNull
    private static NlsInfo fromArgument(@NotNull UExpression expression) {
        UCallExpression callExpression;
        UElement parent;
        if (expression == null) {
            NlsInfo.$$$reportNull$$$0(12);
        }
        if ((parent = UastUtils.skipParenthesizedExprUp((UElement)expression.getUastParent())) instanceof UPolyadicExpression) {
            parent = UastUtils.skipParenthesizedExprUp((UElement)parent.getUastParent());
        }
        if ((callExpression = UastUtils.getUCallExpression((UElement)parent)) == null) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(13);
            }
            return unspecified;
        }
        List arguments = callExpression.getValueArguments();
        OptionalInt idx = IntStream.range(0, arguments.size()).filter(i -> UastUtils.isUastChildOf((UElement)expression, (UElement)UastLiteralUtils.wrapULiteral((UExpression)((UExpression)arguments.get(i))), (boolean)false)).findFirst();
        if (!idx.isPresent()) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(14);
            }
            return unspecified;
        }
        PsiMethod method = callExpression.resolve();
        if (method == null) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(15);
            }
            return unspecified;
        }
        NlsInfo fromParameter = NlsInfo.fromMethodParameter(method, idx.getAsInt(), null);
        if (fromParameter != Unspecified.UNKNOWN) {
            NlsInfo nlsInfo = fromParameter;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(16);
            }
            return nlsInfo;
        }
        PsiParameter parameter = method.getParameterList().getParameter(idx.getAsInt());
        if (parameter != null) {
            NlsInfo info;
            PsiType parameterType = parameter.getType();
            PsiElement psi = callExpression.getSourcePsi();
            if (psi instanceof PsiMethodCallExpression) {
                PsiSubstitutor substitutor = ((PsiMethodCallExpression)psi).getMethodExpression().advancedResolve(false).getSubstitutor();
                parameterType = substitutor.substitute(parameterType);
            }
            if ((info = NlsInfo.fromType(parameterType)) != Unspecified.UNKNOWN) {
                NlsInfo nlsInfo = info;
                if (nlsInfo == null) {
                    NlsInfo.$$$reportNull$$$0(17);
                }
                return nlsInfo;
            }
        }
        return new Unspecified((PsiModifierListOwner)parameter);
    }

    @NotNull
    private static NlsInfo fromType(PsiType type) {
        if (type == null) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(18);
            }
            return unspecified;
        }
        Ref result = Ref.create((Object)Unspecified.UNKNOWN);
        InheritanceUtil.processSuperTypes((PsiType)type, (boolean)true, eachType -> {
            NlsInfo info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)eachType);
            if (info != Unspecified.UNKNOWN) {
                result.set((Object)info);
                return false;
            }
            return !(eachType instanceof PsiClassType) || PsiUtil.resolveClassInClassTypeOnly((PsiType)eachType) instanceof PsiTypeParameter;
        });
        NlsInfo nlsInfo = (NlsInfo)result.get();
        if (nlsInfo == null) {
            NlsInfo.$$$reportNull$$$0(19);
        }
        return nlsInfo;
    }

    @NotNull
    private static NlsInfo fromMethodReturn(@NotNull UExpression expression) {
        PsiMethod method;
        if (expression == null) {
            NlsInfo.$$$reportNull$$$0(20);
        }
        PsiType returnType = null;
        UNamedExpression nameValuePair = (UNamedExpression)UastUtils.getParentOfType((UElement)expression, UNamedExpression.class);
        if (nameValuePair != null) {
            method = UastUtils.getAnnotationMethod((UNamedExpression)nameValuePair);
        } else {
            UElement parent = UastUtils.skipParenthesizedExprUp((UElement)expression.getUastParent());
            while (parent instanceof UCallExpression && (UastExpressionUtils.isArrayInitializer((UElement)parent) || UastExpressionUtils.isNewArrayWithInitializer((UElement)parent))) {
                parent = UastUtils.skipParenthesizedExprUp((UElement)parent.getUastParent());
            }
            if (parent == null) {
                Unspecified unspecified = Unspecified.UNKNOWN;
                if (unspecified == null) {
                    NlsInfo.$$$reportNull$$$0(21);
                }
                return unspecified;
            }
            UReturnExpression returnStmt = (UReturnExpression)UastUtils.getParentOfType((UElement)parent, UReturnExpression.class, (boolean)false, (Class[])new Class[]{UCallExpression.class, ULambdaExpression.class});
            if (returnStmt == null) {
                Unspecified unspecified = Unspecified.UNKNOWN;
                if (unspecified == null) {
                    NlsInfo.$$$reportNull$$$0(22);
                }
                return unspecified;
            }
            UElement jumpTarget = returnStmt.getJumpTarget();
            if (jumpTarget instanceof UMethod) {
                method = ((UMethod)jumpTarget).getJavaPsi();
            } else if (jumpTarget instanceof ULambdaExpression) {
                PsiType type = ((ULambdaExpression)jumpTarget).getFunctionalInterfaceType();
                returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)type);
                if (type == null) {
                    Unspecified unspecified = Unspecified.UNKNOWN;
                    if (unspecified == null) {
                        NlsInfo.$$$reportNull$$$0(23);
                    }
                    return unspecified;
                }
                method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)type);
            } else {
                Unspecified unspecified = Unspecified.UNKNOWN;
                if (unspecified == null) {
                    NlsInfo.$$$reportNull$$$0(24);
                }
                return unspecified;
            }
        }
        if (method == null) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(25);
            }
            return unspecified;
        }
        return NlsInfo.fromMethodReturn(method, returnType, null);
    }

    @NotNull
    private static NlsInfo fromMethodReturn(@NotNull PsiMethod method, @Nullable PsiType returnType, @Nullable Collection<? super PsiMethod> processed) {
        NlsInfo info;
        if (method == null) {
            NlsInfo.$$$reportNull$$$0(26);
        }
        if (processed != null && processed.contains(method)) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(27);
            }
            return unspecified;
        }
        NlsInfo methodInfo = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)method.getModifierList());
        if (methodInfo != Unspecified.UNKNOWN) {
            NlsInfo nlsInfo = methodInfo;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(28);
            }
            return nlsInfo;
        }
        if (returnType != null && (info = NlsInfo.fromType(returnType)) != Unspecified.UNKNOWN) {
            NlsInfo nlsInfo = info;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(29);
            }
            return nlsInfo;
        }
        PsiMethod[] superMethods = method.findSuperMethods();
        if (superMethods.length > 0) {
            if (processed == null) {
                processed = new THashSet();
            }
            processed.add((PsiMethod)method);
            for (PsiMethod superMethod : superMethods) {
                NlsInfo superInfo = NlsInfo.fromMethodReturn(superMethod, null, (Collection<? super PsiMethod>)processed);
                if (superInfo == Unspecified.UNKNOWN) continue;
                NlsInfo nlsInfo = superInfo;
                if (nlsInfo == null) {
                    NlsInfo.$$$reportNull$$$0(30);
                }
                return nlsInfo;
            }
        }
        return new Unspecified((PsiModifierListOwner)method);
    }

    @NotNull
    private static NlsInfo fromAnnotationOwner(@Nullable PsiAnnotationOwner owner) {
        if (owner == null) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(31);
            }
            return unspecified;
        }
        if (owner instanceof PsiModifierList) {
            NlsInfo nlsInfo = (NlsInfo)CachedValuesManager.getCachedValue((PsiElement)((PsiModifierList)owner), () -> CachedValueProvider.Result.create((Object)NlsInfo.computeFromAnnotationOwner(owner), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(32);
            }
            return nlsInfo;
        }
        return NlsInfo.computeFromAnnotationOwner(owner);
    }

    @NotNull
    private static NlsInfo computeFromAnnotationOwner(@NotNull PsiAnnotationOwner owner) {
        PsiAnnotation annotation;
        PsiElement parent;
        if (owner == null) {
            NlsInfo.$$$reportNull$$$0(33);
        }
        for (PsiAnnotation annotation2 : owner.getAnnotations()) {
            NlsInfo info = NlsInfo.fromAnnotation(annotation2);
            if (info != Unspecified.UNKNOWN) {
                NlsInfo nlsInfo = info;
                if (nlsInfo == null) {
                    NlsInfo.$$$reportNull$$$0(34);
                }
                return nlsInfo;
            }
            info = NlsInfo.fromMetaAnnotation(annotation2);
            if (info == Unspecified.UNKNOWN) continue;
            NlsInfo nlsInfo = info;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(35);
            }
            return nlsInfo;
        }
        if (owner instanceof PsiModifierList && (parent = ((PsiModifierList)owner).getParent()) instanceof PsiModifierListOwner && (annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)((PsiModifierListOwner)parent), ANNOTATION_NAMES, (boolean)false)) != null) {
            return NlsInfo.fromAnnotation(annotation);
        }
        Unspecified unspecified = Unspecified.UNKNOWN;
        if (unspecified == null) {
            NlsInfo.$$$reportNull$$$0(36);
        }
        return unspecified;
    }

    @NotNull
    private static NlsInfo fromMetaAnnotation(@NotNull PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement element;
        if (annotation == null) {
            NlsInfo.$$$reportNull$$$0(37);
        }
        if ((element = annotation.getNameReferenceElement()) == null) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(38);
            }
            return unspecified;
        }
        PsiClass annotationClass = (PsiClass)ObjectUtils.tryCast((Object)element.resolve(), PsiClass.class);
        if (annotationClass == null) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(39);
            }
            return unspecified;
        }
        NlsInfo baseInfo = Unspecified.UNKNOWN;
        String prefix = "";
        String suffix = "";
        for (PsiAnnotation metaAnno : annotationClass.getAnnotations()) {
            if (metaAnno.hasQualifiedName(NLS_CONTEXT)) {
                prefix = StringUtil.notNullize((String)AnnotationUtil.getStringAttributeValue((PsiAnnotation)metaAnno, (String)"prefix"));
                suffix = StringUtil.notNullize((String)AnnotationUtil.getStringAttributeValue((PsiAnnotation)metaAnno, (String)"suffix"));
                continue;
            }
            NlsInfo info = NlsInfo.fromAnnotation(metaAnno);
            if (info == Unspecified.UNKNOWN) continue;
            baseInfo = info;
        }
        if (baseInfo instanceof Localized) {
            NlsInfo nlsInfo = ((Localized)baseInfo).withPrefixAndSuffix(prefix, suffix);
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(40);
            }
            return nlsInfo;
        }
        Unspecified unspecified = baseInfo;
        if (unspecified == null) {
            NlsInfo.$$$reportNull$$$0(41);
        }
        return unspecified;
    }

    @NotNull
    private static NlsInfo fromAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            NlsInfo.$$$reportNull$$$0(42);
        }
        if (annotation.hasQualifiedName("org.jetbrains.annotations.NonNls") || annotation.hasQualifiedName("org.jetbrains.annotations.PropertyKey")) {
            NonLocalized nonLocalized = NonLocalized.INSTANCE;
            if (nonLocalized == null) {
                NlsInfo.$$$reportNull$$$0(43);
            }
            return nonLocalized;
        }
        if (annotation.hasQualifiedName("org.jetbrains.annotations.Nls")) {
            Pair pair;
            PsiAnnotationMemberValue value = annotation.findAttributeValue("capitalization");
            String name = null;
            if (value instanceof PsiReferenceExpression) {
                name = ((PsiReferenceExpression)value).getReferenceName();
            } else if (value instanceof PsiLiteralExpression && (pair = (Pair)ObjectUtils.tryCast((Object)((PsiLiteralExpression)value).getValue(), Pair.class)) != null && pair.getSecond() != null) {
                name = pair.getSecond().toString();
            }
            if (name != null) {
                if (Nls.Capitalization.Title.name().equals(name)) {
                    Localized localized = Localized.NLS_TITLE;
                    if (localized == null) {
                        NlsInfo.$$$reportNull$$$0(44);
                    }
                    return localized;
                }
                if (Nls.Capitalization.Sentence.name().equals(name)) {
                    Localized localized = Localized.NLS_SENTENCE;
                    if (localized == null) {
                        NlsInfo.$$$reportNull$$$0(45);
                    }
                    return localized;
                }
            }
            Localized localized = Localized.NLS;
            if (localized == null) {
                NlsInfo.$$$reportNull$$$0(46);
            }
            return localized;
        }
        Unspecified unspecified = Unspecified.UNKNOWN;
        if (unspecified == null) {
            NlsInfo.$$$reportNull$$$0(47);
        }
        return unspecified;
    }

    @NotNull
    private static NlsInfo fromMethodParameter(@NotNull PsiMethod method, int idx, @Nullable Collection<? super PsiMethod> processed) {
        Object param;
        if (method == null) {
            NlsInfo.$$$reportNull$$$0(48);
        }
        if (processed != null && processed.contains(method)) {
            Unspecified unspecified = Unspecified.UNKNOWN;
            if (unspecified == null) {
                NlsInfo.$$$reportNull$$$0(49);
            }
            return unspecified;
        }
        Object[] params = method.getParameterList().getParameters();
        if (idx >= params.length) {
            PsiParameter lastParam = (PsiParameter)ArrayUtil.getLastElement((Object[])params);
            if (lastParam == null || !lastParam.isVarArgs()) {
                Unspecified unspecified = Unspecified.UNKNOWN;
                if (unspecified == null) {
                    NlsInfo.$$$reportNull$$$0(50);
                }
                return unspecified;
            }
            param = lastParam;
        } else {
            param = params[idx];
        }
        NlsInfo explicit = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)param.getModifierList());
        if (explicit != Unspecified.UNKNOWN) {
            NlsInfo nlsInfo = explicit;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(51);
            }
            return nlsInfo;
        }
        PsiMethod[] superMethods = method.findSuperMethods();
        if (superMethods.length > 0) {
            if (processed == null) {
                processed = new THashSet();
            }
            processed.add((PsiMethod)method);
            for (PsiMethod superMethod : superMethods) {
                NlsInfo superInfo = NlsInfo.fromMethodParameter(superMethod, idx, (Collection<? super PsiMethod>)processed);
                if (superInfo == Unspecified.UNKNOWN) continue;
                NlsInfo nlsInfo = superInfo;
                if (nlsInfo == null) {
                    NlsInfo.$$$reportNull$$$0(52);
                }
                return nlsInfo;
            }
        }
        return NlsInfo.fromContainer(method);
    }

    @NotNull
    private static NlsInfo fromContainer(@NotNull PsiMethod method) {
        if (method == null) {
            NlsInfo.$$$reportNull$$$0(53);
        }
        for (PsiClass containingClass = method.getContainingClass(); containingClass != null; containingClass = containingClass.getContainingClass()) {
            NlsInfo classInfo = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)containingClass.getModifierList());
            if (classInfo == Unspecified.UNKNOWN) continue;
            NlsInfo nlsInfo = classInfo;
            if (nlsInfo == null) {
                NlsInfo.$$$reportNull$$$0(54);
            }
            return nlsInfo;
        }
        PsiFile containingFile = method.getContainingFile();
        if (containingFile instanceof PsiClassOwner) {
            String packageName = ((PsiClassOwner)containingFile).getPackageName();
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)method.getProject()).findPackage(packageName);
            if (aPackage != null) {
                NlsInfo info = NlsInfo.fromAnnotationOwner((PsiAnnotationOwner)aPackage.getAnnotationList());
                if (info != Unspecified.UNKNOWN) {
                    NlsInfo nlsInfo = info;
                    if (nlsInfo == null) {
                        NlsInfo.$$$reportNull$$$0(55);
                    }
                    return nlsInfo;
                }
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aPackage, ANNOTATION_NAMES, (boolean)false);
                if (annotation != null) {
                    return NlsInfo.fromAnnotation(annotation);
                }
            }
        }
        Unspecified unspecified = Unspecified.UNKNOWN;
        if (unspecified == null) {
            NlsInfo.$$$reportNull$$$0(56);
        }
        return unspecified;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nls";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/NlsInfo";
                break;
            }
            case 4: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: 
            case 9: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 26: 
            case 48: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/NlsInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNlsStatus";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "localized";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "nonLocalized";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "forExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "forModifierListOwner";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCapitalization";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "fromArgument";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "fromType";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMethodReturn";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAnnotationOwner";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "computeFromAnnotationOwner";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMetaAnnotation";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "fromAnnotation";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMethodParameter";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "fromContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "forExpression";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forModifierListOwner";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCapitalization";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fromArgument";
                break;
            }
            case 20: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fromMethodReturn";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "computeFromAnnotationOwner";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "fromMetaAnnotation";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "fromAnnotation";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "fromMethodParameter";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "fromContainer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Unspecified
    extends NlsInfo {
        private static final Unspecified UNKNOWN = new Unspecified(null);
        @Nullable
        private final PsiModifierListOwner myCandidate;

        private Unspecified(@Nullable PsiModifierListOwner candidate) {
            super(ThreeState.UNSURE);
            this.myCandidate = candidate;
        }

        @Nullable
        public PsiModifierListOwner getAnnotationCandidate() {
            return this.myCandidate;
        }
    }

    public static class NonLocalized
    extends NlsInfo {
        private static final NonLocalized INSTANCE = new NonLocalized();

        private NonLocalized() {
            super(ThreeState.NO);
        }
    }

    public static class Localized
    extends NlsInfo {
        private static final Localized NLS = new Localized(Nls.Capitalization.NotSpecified, "", "");
        private static final Localized NLS_TITLE = new Localized(Nls.Capitalization.Title, "", "");
        private static final Localized NLS_SENTENCE = new Localized(Nls.Capitalization.Sentence, "", "");
        @NotNull
        private final Nls.Capitalization myCapitalization;
        @NotNull
        @NonNls
        private final String myPrefix;
        @NotNull
        @NonNls
        private final String mySuffix;

        private Localized(@NotNull Nls.Capitalization capitalization, @NotNull @NonNls String prefix, @NotNull @NonNls String suffix) {
            if (capitalization == null) {
                Localized.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                Localized.$$$reportNull$$$0(1);
            }
            if (suffix == null) {
                Localized.$$$reportNull$$$0(2);
            }
            super(ThreeState.YES);
            this.myCapitalization = capitalization;
            this.myPrefix = prefix;
            this.mySuffix = suffix;
        }

        @NotNull
        public Nls.Capitalization getCapitalization() {
            Nls.Capitalization capitalization = this.myCapitalization;
            if (capitalization == null) {
                Localized.$$$reportNull$$$0(3);
            }
            return capitalization;
        }

        @NotNull
        @NonNls
        public String getPrefix() {
            String string = this.myPrefix;
            if (string == null) {
                Localized.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        @NonNls
        public String getSuffix() {
            String string = this.mySuffix;
            if (string == null) {
                Localized.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        private NlsInfo withPrefixAndSuffix(@NotNull String prefix, @NotNull String suffix) {
            if (prefix == null) {
                Localized.$$$reportNull$$$0(6);
            }
            if (suffix == null) {
                Localized.$$$reportNull$$$0(7);
            }
            if (prefix.equals(this.myPrefix) && suffix.equals(this.mySuffix)) {
                Localized localized = this;
                if (localized == null) {
                    Localized.$$$reportNull$$$0(8);
                }
                return localized;
            }
            return new Localized(this.myCapitalization, prefix, suffix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "capitalization";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffix";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/i18n/NlsInfo$Localized";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/i18n/NlsInfo$Localized";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCapitalization";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuffix";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withPrefixAndSuffix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "withPrefixAndSuffix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

