/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.java.i18n.JavaI18nBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class SuppressByCommentOutAction
extends SuppressIntentionAction {
    private final String nonNlsCommentPattern;

    SuppressByCommentOutAction(String nonNlsCommentPattern) {
        this.nonNlsCommentPattern = nonNlsCommentPattern;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        IElementType tokenType;
        if (project == null) {
            SuppressByCommentOutAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            SuppressByCommentOutAction.$$$reportNull$$$0(1);
        }
        element = SuppressByCommentOutAction.findJavaCodeUpThere(element);
        PsiFile file = element.getContainingFile();
        editor = InjectedLanguageUtil.openEditorFor((PsiFile)file, (Project)project);
        int endOffset = element.getTextRange().getEndOffset();
        int line = editor.getDocument().getLineNumber(endOffset);
        int lineEndOffset = editor.getDocument().getLineEndOffset(line);
        PsiComment comment = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(lineEndOffset - 1), PsiComment.class, (boolean)false);
        String prefix = "";
        boolean prefixFound = false;
        if (comment != null && (tokenType = comment.getTokenType()) == JavaTokenType.END_OF_LINE_COMMENT) {
            prefix = StringUtil.trimStart((String)comment.getText(), (String)"//") + " ";
            prefixFound = true;
        }
        String commentText = "//" + prefix + this.nonNlsCommentPattern;
        if (prefixFound) {
            PsiComment newcom = JavaPsiFacade.getElementFactory((Project)project).createCommentFromText(commentText, element);
            comment.replace((PsiElement)newcom);
        } else {
            editor.getDocument().insertString(lineEndOffset, (CharSequence)(" " + commentText));
        }
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            SuppressByCommentOutAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            SuppressByCommentOutAction.$$$reportNull$$$0(3);
        }
        if (!element.isValid()) {
            return false;
        }
        return SuppressByCommentOutAction.findJavaCodeUpThere(element) != null;
    }

    private static PsiElement findJavaCodeUpThere(PsiElement element) {
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)element.getProject());
        while (element != null) {
            if (element.getLanguage() == JavaLanguage.INSTANCE && !injectedManager.isInjectedFragment(element.getContainingFile())) {
                return element;
            }
            element = element.getContext();
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = AnalysisBundle.message((String)"suppress.inspection.family", (Object[])new Object[0]);
        if (string == null) {
            SuppressByCommentOutAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = JavaI18nBundle.message("intention.text.suppress.with.0.comment", this.nonNlsCommentPattern);
        if (string == null) {
            SuppressByCommentOutAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/i18n/SuppressByCommentOutAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/i18n/SuppressByCommentOutAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

