/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInspection.i18n.JavaI18nUtil;
import com.intellij.lang.properties.references.PropertyReference;
import com.intellij.lang.properties.references.PropertyReferenceBase;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.UastInjectionHostReferenceProvider;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UNamedExpression;

class UastPropertiesReferenceProvider
extends UastInjectionHostReferenceProvider {
    private final boolean myDefaultSoft;

    UastPropertiesReferenceProvider(boolean defaultSoft) {
        this.myDefaultSoft = defaultSoft;
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        if (target == null) {
            UastPropertiesReferenceProvider.$$$reportNull$$$0(0);
        }
        return PropertyReferenceBase.isPropertyPsi((PsiElement)target);
    }

    public PsiReference @NotNull [] getReferencesForInjectionHost(@NotNull UExpression element, @NotNull PsiLanguageInjectionHost host, @NotNull ProcessingContext context) {
        String bundleName;
        boolean soft;
        if (element == null) {
            UastPropertiesReferenceProvider.$$$reportNull$$$0(1);
        }
        if (host == null) {
            UastPropertiesReferenceProvider.$$$reportNull$$$0(2);
        }
        if (context == null) {
            UastPropertiesReferenceProvider.$$$reportNull$$$0(3);
        }
        if (!UastPropertiesReferenceProvider.canBePropertyKeyRef(element)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                UastPropertiesReferenceProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Object value = element.evaluate();
        if (!(value instanceof String)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                UastPropertiesReferenceProvider.$$$reportNull$$$0(5);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String text = (String)value;
        if (text.indexOf(10) != -1) {
            if (PsiReference.EMPTY_ARRAY == null) {
                UastPropertiesReferenceProvider.$$$reportNull$$$0(6);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Ref resourceBundleValue = Ref.create();
        if (JavaI18nUtil.mustBePropertyKey(element, (Ref<? super UExpression>)resourceBundleValue)) {
            Object bundleValue;
            soft = false;
            UExpression resourceBundleName = (UExpression)resourceBundleValue.get();
            bundleName = resourceBundleName != null ? ((bundleValue = resourceBundleName.evaluate()) == null ? null : bundleValue.toString()) : null;
        } else {
            soft = this.myDefaultSoft;
            bundleName = null;
        }
        PropertyReference reference = new PropertyReference(text, (PsiElement)host, bundleName, soft);
        PsiReference[] psiReferenceArray = new PsiReference[]{reference};
        if (psiReferenceArray == null) {
            UastPropertiesReferenceProvider.$$$reportNull$$$0(7);
        }
        return psiReferenceArray;
    }

    private static boolean canBePropertyKeyRef(@NotNull UExpression element) {
        UElement parent;
        if (element == null) {
            UastPropertiesReferenceProvider.$$$reportNull$$$0(8);
        }
        if ((parent = element.getUastParent()) instanceof UExpression) {
            if (parent instanceof UIfExpression && ((UIfExpression)parent).isTernary()) {
                UExpression elseExpr = ((UIfExpression)parent).getElseExpression();
                UExpression thenExpr = ((UIfExpression)parent).getThenExpression();
                PsiElement elseExprSrc = elseExpr == null ? null : elseExpr.getSourcePsi();
                PsiElement thenExprSrc = thenExpr == null ? null : thenExpr.getSourcePsi();
                PsiElement psi = element.getSourcePsi();
                return (psi == thenExprSrc || psi == elseExprSrc) && UastPropertiesReferenceProvider.canBePropertyKeyRef((UExpression)parent);
            }
            return parent instanceof UCallExpression || parent instanceof UNamedExpression;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/UastPropertiesReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/UastPropertiesReferenceProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesForInjectionHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsTarget";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesForInjectionHost";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canBePropertyKeyRef";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

