/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.internal.statistic.eventLog.LogEvent;
import com.intellij.internal.statistic.eventLog.LogEventRecord;
import com.intellij.internal.statistic.eventLog.LogEventRecordRequest;
import com.intellij.internal.statistic.eventLog.LogEventSerializerKt;
import java.io.OutputStreamWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventSerializer;", "", "()V", "toJson", "Lcom/google/gson/JsonObject;", "event", "Lcom/intellij/internal/statistic/eventLog/LogEvent;", "toString", "", "request", "Lcom/intellij/internal/statistic/eventLog/LogEventRecordRequest;", "", "session", "writer", "Ljava/io/OutputStreamWriter;", "intellij.platform.statistics.uploader"})
public final class LogEventSerializer {
    public static final LogEventSerializer INSTANCE;

    public final void toString(@NotNull LogEventRecordRequest session, @NotNull OutputStreamWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        writer.write(this.toString(session));
    }

    @NotNull
    public final String toString(@NotNull LogEventRecordRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        JsonObject obj = new JsonObject();
        obj.addProperty("recorder", request.getRecorder());
        obj.addProperty("product", request.getProduct());
        obj.addProperty("device", request.getDevice());
        if (request.getInternal()) {
            obj.addProperty("internal", Boolean.valueOf(request.getInternal()));
        }
        JsonArray records = new JsonArray();
        for (LogEventRecord record : request.getRecords()) {
            JsonArray events = new JsonArray();
            for (LogEvent event : record.getEvents()) {
                events.add((JsonElement)this.toJson(event));
            }
            JsonObject recordObj = new JsonObject();
            recordObj.add("events", (JsonElement)events);
            records.add((JsonElement)recordObj);
        }
        obj.add("records", (JsonElement)records);
        String string = obj.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"obj.toString()");
        return string;
    }

    @NotNull
    public final JsonObject toJson(@NotNull LogEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        JsonObject obj = new JsonObject();
        obj.addProperty("recorder_version", event.getRecorderVersion());
        obj.addProperty("session", event.getSession());
        obj.addProperty("build", event.getBuild());
        obj.addProperty("bucket", event.getBucket());
        obj.addProperty("time", (Number)event.getTime());
        JsonObject group = new JsonObject();
        group.addProperty("id", event.getGroup().getId());
        group.addProperty("version", event.getGroup().getVersion());
        JsonObject action = new JsonObject();
        if (event.getEvent().getState()) {
            action.addProperty("state", Boolean.valueOf(event.getEvent().getState()));
        } else {
            action.addProperty("count", (Number)event.getEvent().getCount());
        }
        action.add("data", LogEventSerializerKt.access$getGson$p().toJsonTree(event.getEvent().getData()));
        action.addProperty("id", event.getEvent().getId());
        obj.add("group", (JsonElement)group);
        obj.add("event", (JsonElement)action);
        return obj;
    }

    @NotNull
    public final String toString(@NotNull LogEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String string = this.toJson(event).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"toJson(event).toString()");
        return string;
    }

    private LogEventSerializer() {
    }

    static {
        LogEventSerializer logEventSerializer;
        INSTANCE = logEventSerializer = new LogEventSerializer();
    }
}

