/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.NamedEnumUtil;
import com.intellij.util.xml.NonExhaustiveEnum;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumConverter<T extends Enum>
extends ResolvingConverter<T> {
    private static final ConcurrentMap<Class, EnumConverter> ourCache = ConcurrentFactoryMap.createMap(key -> new EnumConverter(key));
    private final Class<T> myType;

    private EnumConverter(Class<T> aClass) {
        this.myType = aClass;
    }

    public static <T extends Enum> EnumConverter<T> createEnumConverter(Class<T> aClass) {
        return (EnumConverter)((Object)ourCache.get(aClass));
    }

    private String getStringValue(T anEnum) {
        return NamedEnumUtil.getEnumValueByElement(anEnum);
    }

    public final T fromString(String s, ConvertContext context) {
        return (T)(s == null ? null : NamedEnumUtil.getEnumElementByValue(this.myType, (String)s));
    }

    public final String toString(T t, ConvertContext context) {
        return t == null ? null : this.getStringValue(t);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return XmlDomBundle.message((String)"error.unknown.enum.value.message", (Object[])new Object[]{s});
    }

    @NotNull
    public Collection<? extends T> getVariants(ConvertContext context) {
        XmlTag simpleContent;
        XmlElement element = context.getXmlElement();
        if (element instanceof XmlTag && (simpleContent = XmlUtil.getSchemaSimpleContent((XmlTag)((XmlTag)element))) != null && XmlUtil.collectEnumerationValues((XmlTag)simpleContent, new HashSet())) {
            List list = Collections.emptyList();
            if (list == null) {
                EnumConverter.$$$reportNull$$$0(0);
            }
            return list;
        }
        List<Enum> list = Arrays.asList((Enum[])this.myType.getEnumConstants());
        if (list == null) {
            EnumConverter.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean isExhaustive() {
        return !ReflectionUtil.isAssignable(NonExhaustiveEnum.class, this.myType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/EnumConverter", "getVariants"));
    }
}

