/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.icons.AllIcons;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBoxTableRenderer;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.cellvalidators.CellComponentProvider;
import com.intellij.openapi.ui.cellvalidators.CellTooltipManager;
import com.intellij.openapi.ui.cellvalidators.ValidatingTableCellRendererWrapper;
import com.intellij.openapi.ui.cellvalidators.ValidationUtils;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ExcludeTable
extends ListTableWithButtons<Item> {
    private static final Pattern ourPackagePattern = Pattern.compile("([\\w*]+\\.)*[\\w*]+");
    private static final BiFunction<Object, JComponent, ValidationInfo> validationInfoProducer = (value2, component) -> value2 == null || StringUtil.isEmpty((String)value2.toString()) || ourPackagePattern.matcher(value2.toString()).matches() ? null : new ValidationInfo(JavaBundle.message((String)"illegal.name.validation.info", (Object[])new Object[]{value2.toString()}), component);
    private static final Disposable validatorsDisposable = Disposer.newDisposable();
    private static final ColumnInfo<Item, String> NAME_COLUMN = new ColumnInfo<Item, String>(JavaBundle.message((String)"exclude.table.mask", (Object[])new Object[0])){

        @Nullable
        public String valueOf(Item pair2) {
            return pair2.exclude;
        }

        public TableCellEditor getEditor(Item pair2) {
            ExtendableTextField cellEditor = new ExtendableTextField();
            cellEditor.putClientProperty((Object)"JComponent.compactHeight", (Object)Boolean.TRUE);
            new ComponentValidator(validatorsDisposable).withValidator(() -> {
                String text2 = cellEditor.getText();
                boolean hasError = !StringUtil.isEmpty((String)text2) && !ourPackagePattern.matcher(text2).matches();
                ValidationUtils.setExtension((ExtendableTextComponent)cellEditor, (ExtendableTextComponent.Extension)ValidationUtils.ERROR_EXTENSION, (boolean)hasError);
                return (ValidationInfo)validationInfoProducer.apply(text2, cellEditor);
            }).andRegisterOnDocumentListener((JTextComponent)cellEditor).installOn((JComponent)cellEditor);
            return new DefaultCellEditor((JTextField)cellEditor);
        }

        public TableCellRenderer getRenderer(Item pair2) {
            JTextField cellEditor = new JTextField();
            cellEditor.putClientProperty("JComponent.compactHeight", Boolean.TRUE);
            return new ValidatingTableCellRendererWrapper((TableCellRenderer)new DefaultTableCellRenderer()).withCellValidator((value2, row, column) -> (ValidationInfo)validationInfoProducer.apply(value2, null)).bindToEditorSize(cellEditor::getPreferredSize);
        }

        public boolean isCellEditable(Item pair2) {
            return true;
        }

        public void setValue(Item item, String value2) {
            item.exclude = value2;
        }
    };
    private static final ColumnInfo<Item, ExclusionScope> SCOPE_COLUMN = new ColumnInfo<Item, ExclusionScope>(JavaBundle.message((String)"exclude.table.scope.column", (Object[])new Object[0])){

        @Nullable
        public ExclusionScope valueOf(Item pair2) {
            return pair2.scope;
        }

        public TableCellRenderer getRenderer(Item pair2) {
            return new ComboBoxTableRenderer((Object[])ExclusionScope.values());
        }

        public TableCellEditor getEditor(Item pair2) {
            return new ComboBoxTableRenderer((Object[])ExclusionScope.values());
        }

        public boolean isCellEditable(Item pair2) {
            return true;
        }

        public void setValue(Item pair2, ExclusionScope value2) {
            pair2.scope = value2;
        }

        public String getMaxStringValue() {
            return "Project";
        }

        public int getAdditionalWidth() {
            return JBUIScale.scale((int)12) + AllIcons.General.ArrowDown.getIconWidth();
        }
    };
    private final Project myProject;

    ExcludeTable(@NotNull Project project) {
        if (project == null) {
            ExcludeTable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        TableView table = this.getTableView();
        table.getEmptyText().clear();
        table.getEmptyText().appendLine(JavaBundle.message((String)"exclude.from.imports.no.exclusions", (Object[])new Object[0]));
        table.getEmptyText().appendLine(JavaBundle.message((String)"exclude.from.imports.no.exclusions.2", (Object[])new Object[0]));
        table.setStriped(false);
        new CellTooltipManager((Disposable)this.myProject).withCellComponentProvider(CellComponentProvider.forTable((JTable)table)).installOn((JComponent)table);
        Disposer.register((Disposable)project, (Disposable)validatorsDisposable);
    }

    protected ListTableModel createListModel() {
        return new ListTableModel(new ColumnInfo[]{NAME_COLUMN, SCOPE_COLUMN});
    }

    protected Item createElement() {
        return new Item("", ExclusionScope.IDE);
    }

    protected boolean isEmpty(Item element) {
        return element.exclude.isEmpty();
    }

    protected Item cloneElement(Item variable) {
        return new Item(variable.exclude, variable.scope);
    }

    protected boolean canDeleteElement(Item selection) {
        return true;
    }

    void addExcludePackage(@NotNull String packageName) {
        int index;
        if (packageName == null) {
            ExcludeTable.$$$reportNull$$$0(1);
        }
        for (index = 0; index < this.getTableView().getListTableModel().getRowCount() && ((Item)this.getTableView().getListTableModel().getItem((int)index)).exclude.compareTo(packageName) <= 0; ++index) {
        }
        this.getTableView().getListTableModel().insertRow(index, (Object)new Item(packageName, ExclusionScope.IDE));
        this.getTableView().clearSelection();
        this.getTableView().addRowSelectionInterval(index, index);
        ScrollingUtil.ensureIndexIsVisible((JTable)this.getTableView(), (int)index, (int)0);
        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.getTableView(), false);
    }

    void reset() {
        ArrayList<Item> rows = new ArrayList<Item>();
        for (String s : CodeInsightSettings.getInstance().EXCLUDED_PACKAGES) {
            rows.add(new Item(s, ExclusionScope.IDE));
        }
        for (String s : JavaProjectCodeInsightSettings.getSettings((Project)this.myProject).excludedNames) {
            rows.add(new Item(s, ExclusionScope.Project));
        }
        rows.sort(Comparator.comparing(o -> o.exclude));
        this.setValues(rows);
    }

    void apply() {
        CodeInsightSettings.getInstance().EXCLUDED_PACKAGES = ArrayUtilRt.toStringArray(this.getExcludedPackages(ExclusionScope.IDE));
        JavaProjectCodeInsightSettings.getSettings((Project)this.myProject).excludedNames = this.getExcludedPackages(ExclusionScope.Project);
    }

    private List<String> getExcludedPackages(ExclusionScope scope) {
        ArrayList<String> result = new ArrayList<String>();
        for (Item pair2 : this.getTableView().getListTableModel().getItems()) {
            if (scope != pair2.scope) continue;
            result.add(pair2.exclude);
        }
        Collections.sort(result);
        return result;
    }

    boolean isModified() {
        return !this.getExcludedPackages(ExclusionScope.IDE).equals(Arrays.asList(CodeInsightSettings.getInstance().EXCLUDED_PACKAGES)) || !this.getExcludedPackages(ExclusionScope.Project).equals(JavaProjectCodeInsightSettings.getSettings((Project)this.myProject).excludedNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/application/options/editor/ExcludeTable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addExcludePackage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Item {
        String exclude;
        ExclusionScope scope;

        Item(@NotNull String exclude, ExclusionScope scope) {
            if (exclude == null) {
                Item.$$$reportNull$$$0(0);
            }
            this.exclude = exclude;
            this.scope = scope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exclude", "com/intellij/application/options/editor/ExcludeTable$Item", "<init>"));
        }
    }

    private static enum ExclusionScope {
        Project,
        IDE;

    }
}

