/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.DefaultInferredAnnotationProvider;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.InferredAnnotationsManager;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.inferNullity.InferNullityAnnotationsAction;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MakeInferredAnnotationExplicit
extends BaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaBundle.message((String)"intention.family.make.inferred.annotations.explicit", (Object[])new Object[0]);
        if (string == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiElement leaf;
        if (project == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(1);
        }
        if ((leaf = file.findElementAt(editor.getCaretModel().getOffset())) == null) {
            return false;
        }
        PsiModifierListOwner owner2 = (PsiModifierListOwner)ObjectUtils.tryCast((Object)leaf.getParent(), PsiModifierListOwner.class);
        return this.isAvailable(project, file, owner2);
    }

    public boolean isAvailable(@NotNull Project project, PsiFile file, PsiModifierListOwner owner2) {
        String annotations;
        if (project == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(2);
        }
        if (owner2 != null && owner2.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE) && MakeInferredAnnotationExplicit.isWritable(owner2) && ModuleUtilCore.findModuleForPsiElement((PsiElement)file) != null && PsiUtil.getLanguageLevel((PsiElement)file).isAtLeast(LanguageLevel.JDK_1_5) && !(annotations = ((StreamEx)StreamEx.of((Object[])InferredAnnotationsManager.getInstance((Project)project).findInferredAnnotations(owner2)).remove(DefaultInferredAnnotationProvider::isExperimentalInferredAnnotation)).map(MakeInferredAnnotationExplicit::getAnnotationPresentation).joining((CharSequence)" ")).isEmpty()) {
            this.setText(JavaBundle.message((String)"intention.text.insert.0.annotation", (Object[])new Object[]{annotations}));
            return true;
        }
        return false;
    }

    @NotNull
    private static String getAnnotationPresentation(PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement nameRef = MakeInferredAnnotationExplicit.correctAnnotation(annotation).getNameReferenceElement();
        String name2 = nameRef != null ? nameRef.getReferenceName() : annotation.getQualifiedName();
        String string = "@" + name2 + annotation.getParameterList().getText();
        if (string == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static boolean isWritable(PsiModifierListOwner owner2) {
        if (owner2 instanceof PsiCompiledElement) {
            return false;
        }
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)owner2);
        return vFile != null && vFile.isInLocalFileSystem();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(4);
        }
        PsiElement leaf = file.findElementAt(editor.getCaretModel().getOffset());
        assert (leaf != null);
        PsiModifierListOwner owner2 = (PsiModifierListOwner)ObjectUtils.tryCast((Object)leaf.getParent(), PsiModifierListOwner.class);
        assert (owner2 != null);
        this.makeAnnotationsExplicit(project, file, owner2);
    }

    public void makeAnnotationsExplicit(@NotNull Project project, PsiFile file, PsiModifierListOwner owner2) {
        if (project == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(5);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        assert (module != null);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)owner2)) {
            return;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        for (PsiAnnotation inferred : InferredAnnotationsManager.getInstance((Project)project).findInferredAnnotations(owner2)) {
            if (DefaultInferredAnnotationProvider.isExperimentalInferredAnnotation(inferred)) continue;
            PsiAnnotation toInsert = MakeInferredAnnotationExplicit.correctAnnotation(inferred);
            String qname = toInsert.getQualifiedName();
            assert (qname != null);
            if (facade.findClass(qname, file.getResolveScope()) == null && !InferNullityAnnotationsAction.addAnnotationsDependency(project, Collections.singleton(module), qname, this.getFamilyName())) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getFamilyName(), null, () -> DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
                PsiAnnotationOwner target = AnnotationTargetUtil.getTarget((PsiModifierListOwner)owner2, (String)qname);
                assert (target != null);
                PsiElement element = target.addAnnotation(qname).replace((PsiElement)toInsert);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(element);
            }), (PsiFile[])new PsiFile[]{file});
        }
    }

    @NotNull
    private static PsiAnnotation correctAnnotation(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(6);
        }
        Project project = annotation.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project);
        NullableNotNullManager nnnm = NullableNotNullManager.getInstance((Project)project);
        if ("org.jetbrains.annotations.Nullable".equals(annotation.getQualifiedName()) && facade.findClass(nnnm.getDefaultNullable(), allScope) != null) {
            PsiAnnotation psiAnnotation = facade.getElementFactory().createAnnotationFromText("@" + nnnm.getDefaultNullable(), null);
            if (psiAnnotation == null) {
                MakeInferredAnnotationExplicit.$$$reportNull$$$0(7);
            }
            return psiAnnotation;
        }
        if ("org.jetbrains.annotations.NotNull".equals(annotation.getQualifiedName()) && facade.findClass(nnnm.getDefaultNotNull(), allScope) != null) {
            PsiAnnotation psiAnnotation = facade.getElementFactory().createAnnotationFromText("@" + nnnm.getDefaultNotNull(), null);
            if (psiAnnotation == null) {
                MakeInferredAnnotationExplicit.$$$reportNull$$$0(8);
            }
            return psiAnnotation;
        }
        PsiAnnotation psiAnnotation = annotation;
        if (psiAnnotation == null) {
            MakeInferredAnnotationExplicit.$$$reportNull$$$0(9);
        }
        return psiAnnotation;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/MakeInferredAnnotationExplicit";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/MakeInferredAnnotationExplicit";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationPresentation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "correctAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makeAnnotationsExplicit";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "correctAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

