/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.annoPackages;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.annoPackages.AnnotationPackageSupport;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Jsr305Support
implements AnnotationPackageSupport {
    public static final String JAVAX_ANNOTATION_NULLABLE = "javax.annotation.Nullable";
    public static final String JAVAX_ANNOTATION_NONNULL = "javax.annotation.Nonnull";
    public static final String TYPE_QUALIFIER_NICKNAME = "javax.annotation.meta.TypeQualifierNickname";
    private final NullableNotNullManager myManager;

    Jsr305Support(NullableNotNullManager manager) {
        this.myManager = manager;
    }

    @Override
    @Nullable
    public NullabilityAnnotationInfo getNullabilityByContainerAnnotation(@NotNull PsiAnnotation annotation, // Could not load outer class - annotation placement on inner may be incorrect
    PsiAnnotation.TargetType @NotNull [] placeTargetTypes, boolean superPackage) {
        PsiModifierList modList;
        if (annotation == null) {
            Jsr305Support.$$$reportNull$$$0(0);
        }
        if (placeTargetTypes == null) {
            Jsr305Support.$$$reportNull$$$0(1);
        }
        if (superPackage) {
            return null;
        }
        PsiClass declaration2 = annotation.resolveAnnotationType();
        PsiModifierList psiModifierList = modList = declaration2 == null ? null : declaration2.getModifierList();
        if (modList == null) {
            return null;
        }
        PsiAnnotation tqDefault = AnnotationUtil.findAnnotation((PsiModifierListOwner)declaration2, (boolean)true, (String[])new String[]{"javax.annotation.meta.TypeQualifierDefault"});
        if (tqDefault == null) {
            return null;
        }
        Set required = AnnotationTargetUtil.extractRequiredAnnotationTargets((PsiAnnotationMemberValue)tqDefault.findAttributeValue(null));
        if (required == null || !required.isEmpty() && !ContainerUtil.intersects((Collection)required, Arrays.asList(placeTargetTypes))) {
            return null;
        }
        for (PsiAnnotation qualifier : modList.getAnnotations()) {
            Nullability nullability = this.getJsr305QualifierNullability(qualifier);
            if (nullability == null) continue;
            return new NullabilityAnnotationInfo(annotation, nullability, true);
        }
        return null;
    }

    @Nullable
    private Nullability getJsr305QualifierNullability(@NotNull PsiAnnotation qualifier) {
        String qName;
        if (qualifier == null) {
            Jsr305Support.$$$reportNull$$$0(2);
        }
        if ((qName = qualifier.getQualifiedName()) == null || !qName.startsWith("javax.annotation.")) {
            return null;
        }
        if (qName.equals(JAVAX_ANNOTATION_NULLABLE) && this.myManager.getNullables().contains(qName)) {
            return Nullability.NULLABLE;
        }
        if (qName.equals(JAVAX_ANNOTATION_NONNULL)) {
            return Jsr305Support.extractNullityFromWhenValue(qualifier);
        }
        return null;
    }

    public static boolean isNullabilityNickName(@NotNull PsiClass candidate) {
        String qname;
        if (candidate == null) {
            Jsr305Support.$$$reportNull$$$0(3);
        }
        if ((qname = candidate.getQualifiedName()) == null || qname.startsWith("javax.annotation.")) {
            return false;
        }
        return Jsr305Support.getNickNamedNullability(candidate) != Nullability.UNKNOWN;
    }

    @NotNull
    public static Nullability getNickNamedNullability(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            Jsr305Support.$$$reportNull$$$0(4);
        }
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{TYPE_QUALIFIER_NICKNAME}) == null) {
            Nullability nullability = Nullability.UNKNOWN;
            if (nullability == null) {
                Jsr305Support.$$$reportNull$$$0(5);
            }
            return nullability;
        }
        PsiAnnotation nonNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, (String[])new String[]{JAVAX_ANNOTATION_NONNULL});
        Nullability nullability = nonNull != null ? Jsr305Support.extractNullityFromWhenValue(nonNull) : Nullability.UNKNOWN;
        if (nullability == null) {
            Jsr305Support.$$$reportNull$$$0(6);
        }
        return nullability;
    }

    @NotNull
    private static Nullability extractNullityFromWhenValue(@NotNull PsiAnnotation nonNull) {
        PsiAnnotationMemberValue when;
        if (nonNull == null) {
            Jsr305Support.$$$reportNull$$$0(7);
        }
        if ((when = nonNull.findAttributeValue("when")) instanceof PsiReferenceExpression) {
            String refName = ((PsiReferenceExpression)when).getReferenceName();
            if ("ALWAYS".equals(refName)) {
                Nullability nullability = Nullability.NOT_NULL;
                if (nullability == null) {
                    Jsr305Support.$$$reportNull$$$0(8);
                }
                return nullability;
            }
            if ("MAYBE".equals(refName) || "NEVER".equals(refName)) {
                Nullability nullability = Nullability.NULLABLE;
                if (nullability == null) {
                    Jsr305Support.$$$reportNull$$$0(9);
                }
                return nullability;
            }
        }
        if (when == null && JAVAX_ANNOTATION_NONNULL.equals(nonNull.getQualifiedName())) {
            Nullability nullability = Nullability.NOT_NULL;
            if (nullability == null) {
                Jsr305Support.$$$reportNull$$$0(10);
            }
            return nullability;
        }
        Nullability nullability = Nullability.UNKNOWN;
        if (nullability == null) {
            Jsr305Support.$$$reportNull$$$0(11);
        }
        return nullability;
    }

    @Override
    @NotNull
    public List<String> getNullabilityAnnotations(@NotNull Nullability nullability) {
        if (nullability == null) {
            Jsr305Support.$$$reportNull$$$0(12);
        }
        switch (nullability) {
            case NOT_NULL: {
                List<String> list = Collections.singletonList(JAVAX_ANNOTATION_NONNULL);
                if (list == null) {
                    Jsr305Support.$$$reportNull$$$0(13);
                }
                return list;
            }
            case NULLABLE: {
                List<String> list = Arrays.asList(JAVAX_ANNOTATION_NULLABLE, "javax.annotation.CheckForNull");
                if (list == null) {
                    Jsr305Support.$$$reportNull$$$0(14);
                }
                return list;
            }
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            Jsr305Support.$$$reportNull$$$0(15);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeTargetTypes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/annoPackages/Jsr305Support";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonNull";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullability";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/annoPackages/Jsr305Support";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNickNamedNullability";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNullityFromWhenValue";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullabilityAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNullabilityByContainerAnnotation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJsr305QualifierNullability";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isNullabilityNickName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNickNamedNullability";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractNullityFromWhenValue";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNullabilityAnnotations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

