/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class CollectionsUtilityMethodsProvider {
    private final PsiElement myElement;
    private final PsiType myExpectedType;
    private final PsiType myDefaultType;
    @NotNull
    private final Consumer<? super LookupElement> myResult;

    CollectionsUtilityMethodsProvider(PsiElement position, PsiType expectedType, PsiType defaultType, @NotNull Consumer<? super LookupElement> result) {
        if (result == null) {
            CollectionsUtilityMethodsProvider.$$$reportNull$$$0(0);
        }
        this.myResult = result;
        this.myElement = position;
        this.myExpectedType = expectedType;
        this.myDefaultType = defaultType;
    }

    public void addCompletions(boolean showAll) {
        PsiElement parent = this.myElement.getParent();
        if (parent instanceof PsiReferenceExpression && ((PsiReferenceExpression)parent).getQualifierExpression() != null) {
            return;
        }
        PsiClass collectionsClass = JavaPsiFacade.getInstance((Project)this.myElement.getProject()).findClass("java.util.Collections", this.myElement.getResolveScope());
        if (collectionsClass == null) {
            return;
        }
        PsiElement pparent = parent.getParent();
        if (showAll || pparent instanceof PsiReturnStatement || pparent instanceof PsiConditionalExpression && pparent.getParent() instanceof PsiReturnStatement) {
            this.addCollectionMethod("java.util.List", "emptyList", collectionsClass);
            this.addCollectionMethod("java.util.Set", "emptySet", collectionsClass);
            this.addCollectionMethod("java.util.Map", "emptyMap", collectionsClass);
        }
        if (showAll) {
            this.addCollectionMethod("java.util.List", "singletonList", collectionsClass);
            this.addCollectionMethod("java.util.Set", "singleton", collectionsClass);
            this.addCollectionMethod("java.util.Map", "singletonMap", collectionsClass);
            this.addCollectionMethod("java.util.Collection", "unmodifiableCollection", collectionsClass);
            this.addCollectionMethod("java.util.List", "unmodifiableList", collectionsClass);
            this.addCollectionMethod("java.util.Set", "unmodifiableSet", collectionsClass);
            this.addCollectionMethod("java.util.Map", "unmodifiableMap", collectionsClass);
            this.addCollectionMethod("java.util.SortedSet", "unmodifiableSortedSet", collectionsClass);
            this.addCollectionMethod("java.util.SortedMap", "unmodifiableSortedMap", collectionsClass);
        }
    }

    private void addCollectionMethod(String baseClassName, @NonNls String method, @NotNull PsiClass collectionsClass) {
        if (collectionsClass == null) {
            CollectionsUtilityMethodsProvider.$$$reportNull$$$0(1);
        }
        if (CollectionsUtilityMethodsProvider.isClassType(this.myExpectedType, baseClassName) || CollectionsUtilityMethodsProvider.isClassType(this.myExpectedType, "java.util.Collection")) {
            this.addMethodItem(this.myExpectedType, method, collectionsClass);
        } else if (CollectionsUtilityMethodsProvider.isClassType(this.myDefaultType, baseClassName) || CollectionsUtilityMethodsProvider.isClassType(this.myDefaultType, "java.util.Collection")) {
            this.addMethodItem(this.myDefaultType, method, collectionsClass);
        }
    }

    private void addMethodItem(PsiType expectedType, String methodName, PsiClass containingClass) {
        PsiMethod[] methods = containingClass.findMethodsByName(methodName, false);
        if (methods.length == 0) {
            return;
        }
        PsiMethod method = methods[0];
        JavaMethodCallElement item = new JavaMethodCallElement(method, false, false);
        item.setAutoCompletionPolicy(AutoCompletionPolicy.NEVER_AUTOCOMPLETE);
        item.setInferenceSubstitutorFromExpectedType(this.myElement, expectedType);
        this.myResult.consume((Object)item);
    }

    private static boolean isClassType(PsiType type2, String className2) {
        if (type2 instanceof PsiClassType) {
            PsiClass psiClass = ((PsiClassType)type2).resolve();
            return psiClass != null && className2.equals(psiClass.getQualifiedName());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionsClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/CollectionsUtilityMethodsProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addCollectionMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

