/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.completion.CompletionMemory;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameInsertHandler;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.completion.JavaConstructorCallElement;
import com.intellij.codeInsight.completion.JavaMethodCallElement;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.SmartCompletionDecorator;
import com.intellij.codeInsight.completion.util.MethodParenthesesHandler;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorInsertHandler
implements InsertHandler<LookupElementDecorator<LookupElement>> {
    private static final Logger LOG = Logger.getInstance(ConstructorInsertHandler.class);
    public static final ConstructorInsertHandler SMART_INSTANCE = new ConstructorInsertHandler(true);
    public static final ConstructorInsertHandler BASIC_INSTANCE = new ConstructorInsertHandler(false);
    private final boolean mySmart;

    private ConstructorInsertHandler(boolean smart) {
        this.mySmart = smart;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElementDecorator<LookupElement> item) {
        boolean inAnonymous;
        if (context == null) {
            ConstructorInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            ConstructorInsertHandler.$$$reportNull$$$0(1);
        }
        LookupElement delegate = item.getDelegate();
        PsiClass psiClass = (PsiClass)item.getObject();
        SmartPsiElementPointer classPointer = SmartPointerManager.createPointer((PsiElement)psiClass);
        boolean isAbstract = psiClass.hasModifierProperty("abstract");
        if ('\t' == context.getCompletionChar()) {
            JavaClassNameInsertHandler.overwriteTopmostReference(context);
        }
        context.commitDocument();
        OffsetKey insideRef = context.trackOffset(context.getTailOffset(), false);
        PsiElement position = SmartCompletionDecorator.getPosition(context, delegate);
        if (position == null) {
            return;
        }
        PsiExpression enclosing = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)position, PsiExpression.class, (boolean)true);
        PsiAnonymousClass anonymousClass = (PsiAnonymousClass)PsiTreeUtil.getParentOfType((PsiElement)position, PsiAnonymousClass.class);
        boolean bl = inAnonymous = anonymousClass != null && anonymousClass.getParent() == enclosing;
        if (delegate instanceof PsiTypeLookupItem) {
            PsiReferenceParameterList parameterList;
            PsiJavaCodeReferenceElement ref;
            if (context.getDocument().getTextLength() > context.getTailOffset() && context.getDocument().getCharsSequence().charAt(context.getTailOffset()) == '<' && (ref = JavaClassNameInsertHandler.findJavaReference(context.getFile(), context.getTailOffset() - 1)) != null && (parameterList = ref.getParameterList()) != null && context.getTailOffset() == parameterList.getTextRange().getStartOffset()) {
                context.getDocument().deleteString(parameterList.getTextRange().getStartOffset(), parameterList.getTextRange().getEndOffset());
                context.commitDocument();
            }
            delegate.handleInsert(context);
            PostprocessReformattingAspect.getInstance((Project)context.getProject()).doPostponedFormatting(context.getFile().getViewProvider());
        }
        if (item.getDelegate() instanceof JavaPsiClassReferenceElement && classPointer.getElement() != null) {
            PsiTypeLookupItem.addImportForItem(context, (PsiClass)classPointer.getElement());
        }
        if (classPointer.getElement() != null) {
            ConstructorInsertHandler.insertParentheses(context, delegate, (PsiClass)classPointer.getElement(), !inAnonymous && isAbstract);
        }
        if (inAnonymous) {
            return;
        }
        if (this.mySmart) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.afternew");
        }
        if (isAbstract) {
            PostprocessReformattingAspect.getInstance((Project)context.getProject()).doPostponedFormatting(context.getFile().getViewProvider());
            Editor editor = context.getEditor();
            Document document = editor.getDocument();
            int offset = context.getTailOffset();
            document.insertString(offset, (CharSequence)" {}");
            OffsetKey insideBraces = context.trackOffset(offset + 2, true);
            PsiFile file = context.getFile();
            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
            ConstructorInsertHandler.reformatEnclosingExpressionListAtOffset(file, offset);
            if (ConstructorInsertHandler.promptTypeOrConstructorArgs(context, delegate, insideRef, insideBraces)) {
                return;
            }
            editor.getCaretModel().moveToOffset(context.getOffset(insideBraces));
            context.setLaterRunnable(ConstructorInsertHandler.generateAnonymousBody(editor, file));
        } else {
            PsiJavaCodeReferenceElement classReference2;
            PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
            PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiNewExpression.class, (boolean)false);
            if (newExpression != null && (classReference2 = newExpression.getClassOrAnonymousClassReference()) != null) {
                CodeStyleManager.getInstance((Project)context.getProject()).reformat((PsiElement)classReference2);
            }
            if (this.mySmart) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.smarttype.afternew");
            }
            ConstructorInsertHandler.promptTypeOrConstructorArgs(context, delegate, insideRef, null);
        }
    }

    private static boolean promptTypeOrConstructorArgs(InsertionContext context, LookupElement delegate, OffsetKey refOffset, @Nullable OffsetKey insideBraces) {
        if (ConstructorInsertHandler.shouldFillTypeArgs(context, delegate) && JavaCompletionUtil.promptTypeArgs(context, context.getOffset(refOffset))) {
            return true;
        }
        PsiMethod constructor = JavaConstructorCallElement.extractCalledConstructor(delegate);
        if (constructor != null && JavaMethodCallElement.startArgumentLiveTemplate(context, constructor)) {
            ConstructorInsertHandler.implementMethodsWhenTemplateIsFinished(context, insideBraces);
            return true;
        }
        return false;
    }

    private static void implementMethodsWhenTemplateIsFinished(final InsertionContext context, final @Nullable OffsetKey insideBraces) {
        TemplateState state = TemplateManagerImpl.getTemplateState((Editor)context.getEditor());
        if (state != null && insideBraces != null) {
            state.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!brokenOff) {
                        context.getEditor().getCaretModel().moveToOffset(context.getOffset(insideBraces));
                        ConstructorInsertHandler.createOverrideRunnable(context.getEditor(), context.getFile(), context.getProject()).run();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/completion/ConstructorInsertHandler$1", "templateFinished"));
                }
            });
        }
    }

    private static boolean shouldFillTypeArgs(InsertionContext context, LookupElement delegate) {
        if (!(delegate instanceof PsiTypeLookupItem) || ConstructorInsertHandler.isRawTypeExpected(context, (PsiTypeLookupItem)delegate) || !((PsiClass)delegate.getObject()).hasTypeParameters()) {
            return false;
        }
        PsiElement position = SmartCompletionDecorator.getPosition(context, delegate);
        return position != null && ((PsiTypeLookupItem)delegate).calcGenerics(position, context).isEmpty() && context.getCompletionChar() != '(';
    }

    private static void reformatEnclosingExpressionListAtOffset(@NotNull PsiFile file, int offset) {
        PsiElement elementAtOffset;
        PsiExpressionList listToReformat;
        if (file == null) {
            ConstructorInsertHandler.$$$reportNull$$$0(2);
        }
        if ((listToReformat = ConstructorInsertHandler.getEnclosingExpressionList((elementAtOffset = PsiUtilCore.getElementAtOffset((PsiFile)file, (int)offset)).getParent())) != null) {
            CodeStyleManager.getInstance((Project)file.getProject()).reformat((PsiElement)listToReformat);
            PostprocessReformattingAspect.getInstance((Project)file.getProject()).doPostponedFormatting();
        }
    }

    @Nullable
    private static PsiExpressionList getEnclosingExpressionList(@NotNull PsiElement element) {
        if (element == null) {
            ConstructorInsertHandler.$$$reportNull$$$0(3);
        }
        if (!(element instanceof PsiAnonymousClass)) {
            return null;
        }
        PsiElement e = element.getParent();
        if (e instanceof PsiNewExpression && e.getParent() instanceof PsiExpressionList) {
            return (PsiExpressionList)e.getParent();
        }
        return null;
    }

    static boolean isRawTypeExpected(InsertionContext context, PsiTypeLookupItem delegate) {
        PsiNewExpression newExpr = (PsiNewExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiNewExpression.class, (boolean)false);
        if (newExpr != null) {
            for (ExpectedTypeInfo info : ExpectedTypesProvider.getExpectedTypes((PsiExpression)newExpr, true)) {
                PsiType expected = info.getDefaultType();
                if (!expected.isAssignableFrom(delegate.getType()) || !(expected instanceof PsiClassType) || !((PsiClassType)expected).isRaw()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean insertParentheses(@NotNull InsertionContext context, @NotNull LookupElement delegate, @NotNull PsiClass psiClass, boolean forAnonymous) {
        PsiCallExpression call;
        if (context == null) {
            ConstructorInsertHandler.$$$reportNull$$$0(4);
        }
        if (delegate == null) {
            ConstructorInsertHandler.$$$reportNull$$$0(5);
        }
        if (psiClass == null) {
            ConstructorInsertHandler.$$$reportNull$$$0(6);
        }
        if (context.getCompletionChar() == '[') {
            return false;
        }
        PsiMethod constructor = JavaConstructorCallElement.extractCalledConstructor(delegate);
        PsiElement place = context.getFile().findElementAt(context.getStartOffset());
        assert (place != null);
        ThreeState hasParams = constructor != null ? ThreeState.fromBoolean((!constructor.getParameterList().isEmpty() ? 1 : 0) != 0) : ConstructorInsertHandler.hasConstructorParameters(psiClass, place);
        RangeMarker refEnd = context.getDocument().createRangeMarker(context.getTailOffset(), context.getTailOffset());
        JavaCompletionUtil.insertParentheses(context, delegate, false, hasParams, forAnonymous);
        if (constructor != null && (call = JavaMethodCallElement.findCallAtOffset(context, refEnd.getStartOffset())) != null) {
            CompletionMemory.registerChosenMethod(constructor, (PsiCall)call);
        }
        return true;
    }

    static ThreeState hasConstructorParameters(PsiClass psiClass, @NotNull PsiElement place) {
        if (place == null) {
            ConstructorInsertHandler.$$$reportNull$$$0(7);
        }
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)place.getProject()).getResolveHelper();
        return MethodParenthesesHandler.hasParameters((List)ContainerUtil.filter((Object[])psiClass.getConstructors(), c -> resolveHelper.isAccessible((PsiMember)c, place, null)));
    }

    @Nullable
    private static Runnable generateAnonymousBody(Editor editor, PsiFile file) {
        Project project = file.getProject();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiAnonymousClass)) {
            return null;
        }
        return ConstructorInsertHandler.genAnonymousBodyFor((PsiAnonymousClass)parent, editor, file, project);
    }

    public static Runnable genAnonymousBodyFor(PsiAnonymousClass parent, Editor editor, PsiFile file, Project project) {
        try {
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)parent);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        int offset = parent.getTextRange().getEndOffset() - 1;
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
        PsiReferenceParameterList parameterList = parent.getBaseClassReference().getParameterList();
        PsiTypeElement[] parameters2 = parameterList != null ? parameterList.getTypeParameterElements() : null;
        PsiElement newExpr = parent.getParent();
        if (newExpr != null && PsiTypesUtil.getExpectedTypeByParent((PsiElement)newExpr) == null && ConstructorInsertHandler.shouldStartTypeTemplate(parameters2)) {
            ConstructorInsertHandler.startTemplate(parent, editor, ConstructorInsertHandler.createOverrideRunnable(editor, file, project), parameters2);
            return null;
        }
        return ConstructorInsertHandler.createOverrideRunnable(editor, file, project);
    }

    private static Runnable createOverrideRunnable(Editor editor, PsiFile file, Project project) {
        return () -> {
            TemplateManager.getInstance((Project)project).finishTemplate(editor);
            if (DumbService.getInstance((Project)project).isDumb()) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiAnonymousClass aClass = (PsiAnonymousClass)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)editor.getCaretModel().getOffset(), PsiAnonymousClass.class, (boolean)false);
            if (aClass == null) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(project, () -> {
                Collection<CandidateInfo> candidatesToImplement = OverrideImplementExploreUtil.getMethodsToOverrideImplement((PsiClass)aClass, true);
                Iterator<CandidateInfo> iterator = candidatesToImplement.iterator();
                while (iterator.hasNext()) {
                    CandidateInfo candidate = iterator.next();
                    PsiElement element = candidate.getElement();
                    if (!(element instanceof PsiMethod) || !((PsiMethod)element).hasModifierProperty("default")) continue;
                    iterator.remove();
                }
                boolean invokeOverride = candidatesToImplement.isEmpty();
                if (invokeOverride) {
                    OverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, (PsiClass)aClass, false);
                } else {
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        try {
                            List<PsiMethod> methods = OverrideImplementUtil.overrideOrImplementMethodCandidates((PsiClass)aClass, candidatesToImplement, false);
                            List<PsiGenerationInfo<PsiMethod>> prototypes = OverrideImplementUtil.convert2GenerationInfos(methods);
                            List<PsiGenerationInfo<PsiMethod>> resultMembers = GenerateMembersUtil.insertMembersBeforeAnchor((PsiClass)aClass, null, prototypes);
                            resultMembers.get(0).positionCaret(editor, true);
                        }
                        catch (IncorrectOperationException ioe) {
                            LOG.error((Throwable)ioe);
                        }
                    });
                }
            }, ConstructorInsertHandler.getCommandName(), (Object)ConstructorInsertHandler.getCommandName(), UndoConfirmationPolicy.DEFAULT, editor.getDocument());
        };
    }

    @Contract(value="null -> false")
    private static boolean shouldStartTypeTemplate(PsiTypeElement[] parameters2) {
        if (parameters2 != null && parameters2.length > 0) {
            for (PsiTypeElement parameter2 : parameters2) {
                if (!parameter2.getType().equalsToText("java.lang.Object")) continue;
                return true;
            }
        }
        return false;
    }

    private static void startTemplate(PsiAnonymousClass aClass, Editor editor, final Runnable runnable, PsiTypeElement @NotNull [] parameters2) {
        if (parameters2 == null) {
            ConstructorInsertHandler.$$$reportNull$$$0(8);
        }
        Project project = aClass.getProject();
        WriteCommandAction.writeCommandAction((Project)project).withName(ConstructorInsertHandler.getCommandName()).withGroupId(ConstructorInsertHandler.getCommandName()).run(() -> {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            editor.getCaretModel().moveToOffset(aClass.getTextOffset());
            TemplateBuilderImpl templateBuilder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)aClass);
            for (int i = 0; i < parameters2.length; ++i) {
                PsiTypeElement parameter2 = parameters2[i];
                templateBuilder.replaceElement((PsiElement)parameter2, "param" + i, (Expression)new TypeExpression(project, new PsiType[]{parameter2.getType()}), true);
            }
            Template template = templateBuilder.buildInlineTemplate();
            TemplateManager.getInstance((Project)project).startTemplate(editor, template, false, null, (TemplateEditingListener)new TemplateEditingAdapter(){

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (!brokenOff) {
                        runnable.run();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInsight/completion/ConstructorInsertHandler$2", "templateFinished"));
                }
            });
        });
    }

    private static String getCommandName() {
        return JavaBundle.message((String)"completion.smart.type.generate.anonymous.body", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/ConstructorInsertHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatEnclosingExpressionListAtOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnclosingExpressionList";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "insertParentheses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "hasConstructorParameters";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "startTemplate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

