/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.lookup.ExpressionLookupItem;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FromArrayConversion {
    FromArrayConversion() {
    }

    static void addConversions(final PsiElement element, final String prefix, PsiType itemType, Consumer<? super LookupElement> result, @Nullable PsiElement qualifier, @NotNull PsiType expectedType) throws IncorrectOperationException {
        String methodName;
        if (expectedType == null) {
            FromArrayConversion.$$$reportNull$$$0(0);
        }
        if ((methodName = FromArrayConversion.getArraysConversionMethod(itemType, expectedType)) == null) {
            return;
        }
        final String qualifierText = ReferenceExpressionCompletionContributor.getQualifierText(qualifier);
        PsiExpression conversion = ReferenceExpressionCompletionContributor.createExpression("java.util.Arrays." + methodName + "(" + qualifierText + prefix + ")", element);
        PsiType type2 = conversion.getType();
        if (type2 == null || !expectedType.isAssignableFrom(type2)) {
            return;
        }
        String presentable = "Arrays." + methodName + "(" + qualifierText + prefix + ")";
        String[] lookupStrings = new String[]{StringUtil.isEmpty((String)qualifierText) ? presentable : prefix, prefix, presentable, methodName + "(" + prefix + ")"};
        result.consume((Object)new ExpressionLookupItem(conversion, PlatformIcons.METHOD_ICON, presentable, lookupStrings){

            @Override
            public void handleInsert(@NotNull InsertionContext context) {
                if (context == null) {
                    1.$$$reportNull$$$0(0);
                }
                FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.second.smarttype.aslist");
                int startOffset = context.getStartOffset() - qualifierText.length();
                Project project = element.getProject();
                String callSpace = ReferenceExpressionCompletionContributor.getSpace(CodeStyle.getLanguageSettings((PsiFile)context.getFile()).SPACE_WITHIN_METHOD_CALL_PARENTHESES);
                String newText = "java.util.Arrays." + methodName + "(" + callSpace + qualifierText + prefix + callSpace + ")";
                context.getDocument().replaceString(startOffset, context.getTailOffset(), (CharSequence)newText);
                context.commitDocument();
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)context.getFile(), startOffset, startOffset + "java.util.Arrays".length());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/completion/FromArrayConversion$1", "handleInsert"));
            }
        });
    }

    @Nullable
    private static String getArraysConversionMethod(PsiType itemType, PsiType expectedType) {
        String methodName = "asList";
        PsiType componentType = PsiUtil.extractIterableTypeParameter((PsiType)expectedType, (boolean)true);
        if (componentType == null) {
            methodName = "stream";
            componentType = FromArrayConversion.getStreamComponentType(expectedType);
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)componentType);
            if (unboxedType != null) {
                componentType = unboxedType;
            }
        }
        if (componentType == null || !(itemType instanceof PsiArrayType) || !componentType.isAssignableFrom(((PsiArrayType)itemType).getComponentType())) {
            return null;
        }
        return methodName;
    }

    private static PsiType getStreamComponentType(PsiType expectedType) {
        return PsiUtil.substituteTypeParameter((PsiType)expectedType, (String)"java.util.stream.BaseStream", (int)0, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedType", "com/intellij/codeInsight/completion/FromArrayConversion", "addConversions"));
    }
}

