/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.TailTypes;
import com.intellij.codeInsight.completion.BasicExpressionCompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionContributor;
import com.intellij.codeInsight.completion.JavaCompletionSession;
import com.intellij.codeInsight.completion.JavaMemberNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.ModifierChooser;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.ReferenceExpressionCompletionContributor;
import com.intellij.codeInsight.completion.StartOnlyMatcher;
import com.intellij.codeInsight.completion.util.CompletionStyleUtil;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassLevelDeclarationStatement;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceCodeFragment;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.filters.FilterPositionUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaKeywordCompletion {
    public static final ElementPattern<PsiElement> AFTER_DOT = PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."});
    static final ElementPattern<PsiElement> VARIABLE_AFTER_FINAL = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"final"})).inside(PsiDeclarationStatement.class);
    private static final ElementPattern<PsiElement> INSIDE_PARAMETER_LIST = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).insideStarting((ElementPattern)PsiJavaPatterns.psiElement().withTreeParent((ElementPattern)PsiJavaPatterns.psiElement(PsiParameterList.class).andNot((ElementPattern)PsiJavaPatterns.psiElement(PsiAnnotationParameterList.class)))));
    private static final ElementPattern<PsiElement> INSIDE_RECORD_HEADER = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiJavaCodeReferenceElement.class).insideStarting(PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement().withTreeParent((ElementPattern)PsiJavaPatterns.psiElement(PsiRecordComponent.class)), PsiJavaPatterns.psiElement().withTreeParent((ElementPattern)PsiJavaPatterns.psiElement(PsiRecordHeader.class))})));
    private static final InsertHandler<LookupElementDecorator<?>> ADJUST_LINE_OFFSET = (context, item) -> {
        item.getDelegate().handleInsert(context);
        context.commitDocument();
        CodeStyleManager.getInstance((Project)context.getProject()).adjustLineIndent(context.getFile(), context.getStartOffset());
    };
    static final ElementPattern<PsiElement> START_SWITCH = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("{")).withParents(new Class[]{PsiCodeBlock.class, PsiSwitchStatement.class}));
    private static final ElementPattern<PsiElement> SUPER_OR_THIS_PATTERN = PsiJavaPatterns.and((ElementPattern[])new ElementPattern[]{JavaSmartCompletionContributor.INSIDE_EXPRESSION, PsiJavaPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"case"})), PsiJavaPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(".")).afterLeaf(new String[]{"this", "super"}))), PsiJavaPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().inside(PsiAnnotation.class)), PsiJavaPatterns.not(START_SWITCH), PsiJavaPatterns.not(JavaMemberNameCompletionContributor.INSIDE_TYPE_PARAMS_PATTERN)});
    static final Set<String> PRIMITIVE_TYPES = ContainerUtil.newLinkedHashSet((Object[])new String[]{"short", "boolean", "double", "long", "int", "float", "char", "byte"});
    static final PsiElementPattern<PsiElement, ?> START_FOR = PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("(")).afterLeaf(new String[]{"for"}));
    private static final ElementPattern<PsiElement> CLASS_REFERENCE = PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().referencing((ElementPattern)PsiJavaPatterns.psiClass().andNot((ElementPattern)PsiJavaPatterns.psiElement(PsiTypeParameter.class))));
    private final CompletionParameters myParameters;
    private final JavaCompletionSession mySession;
    private final PsiElement myPosition;
    private final PrefixMatcher myKeywordMatcher;
    private final List<LookupElement> myResults = new ArrayList<LookupElement>();
    private final PsiElement myPrevLeaf;

    private static boolean isStatementCodeFragment(PsiFile file) {
        return file instanceof JavaCodeFragment && !(file instanceof PsiExpressionCodeFragment) && !(file instanceof PsiJavaCodeReferenceCodeFragment) && !(file instanceof PsiTypeCodeFragment);
    }

    static boolean isEndOfBlock(@NotNull PsiElement element) {
        PsiElement prev;
        if (element == null) {
            JavaKeywordCompletion.$$$reportNull$$$0(0);
        }
        if ((prev = JavaKeywordCompletion.prevSignificantLeaf(element)) == null) {
            PsiFile file = element.getContainingFile();
            return !(file instanceof PsiCodeFragment) || JavaKeywordCompletion.isStatementCodeFragment(file);
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiAnnotation())).accepts((Object)prev)) {
            return false;
        }
        if (prev instanceof OuterLanguageElement) {
            return true;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText((ElementPattern)PsiJavaPatterns.string().oneOf(new String[]{"{", "}", ";", ":", "else"}))).accepts((Object)prev)) {
            return true;
        }
        if (prev.textMatches((CharSequence)")")) {
            PsiElement parent = prev.getParent();
            if (parent instanceof PsiParameterList) {
                return PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.prevVisibleLeaf((PsiElement)element), PsiDocComment.class) != null;
            }
            return !(parent instanceof PsiExpressionList) && !(parent instanceof PsiTypeCastExpression) && !(parent instanceof PsiRecordHeader);
        }
        return false;
    }

    JavaKeywordCompletion(CompletionParameters parameters2, JavaCompletionSession session) {
        this.myParameters = parameters2;
        this.mySession = session;
        this.myKeywordMatcher = new StartOnlyMatcher(session.getMatcher());
        this.myPosition = parameters2.getPosition();
        this.myPrevLeaf = JavaKeywordCompletion.prevSignificantLeaf(this.myPosition);
        this.addKeywords();
        this.addEnumCases();
    }

    private static PsiElement prevSignificantLeaf(PsiElement position) {
        return FilterPositionUtil.searchNonSpaceNonCommentBack((PsiElement)position);
    }

    private void addKeyword(LookupElement element) {
        if (this.myKeywordMatcher.isStartMatch(element.getLookupString())) {
            this.myResults.add(element);
        }
    }

    List<LookupElement> getResults() {
        return this.myResults;
    }

    public static boolean isInsideParameterList(PsiElement position) {
        PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        PsiModifierList modifierList = (PsiModifierList)PsiTreeUtil.getParentOfType((PsiElement)prev, PsiModifierList.class);
        if (modifierList != null) {
            if (PsiTreeUtil.isAncestor((PsiElement)modifierList, (PsiElement)position, (boolean)false)) {
                return false;
            }
            PsiElement parent = modifierList.getParent();
            return parent instanceof PsiParameterList || parent instanceof PsiParameter && parent.getParent() instanceof PsiParameterList;
        }
        return INSIDE_PARAMETER_LIST.accepts((Object)position);
    }

    private static TailType getReturnTail(PsiElement position) {
        PsiElement scope = position;
        while (!(scope instanceof PsiFile) && !(scope instanceof PsiClassInitializer)) {
            if (scope instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                if (method.isConstructor() || PsiType.VOID.equals((Object)method.getReturnType())) {
                    return TailType.SEMICOLON;
                }
                return TailType.HUMBLE_SPACE_BEFORE_WORD;
            }
            if (scope instanceof PsiLambdaExpression) {
                PsiType returnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiLambdaExpression)scope));
                if (PsiType.VOID.equals((Object)returnType)) {
                    return TailType.SEMICOLON;
                }
                return TailType.HUMBLE_SPACE_BEFORE_WORD;
            }
            scope = scope.getParent();
        }
        return TailType.NONE;
    }

    private void addStatementKeywords() {
        this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("switch"), TailTypes.SWITCH_LPARENTH));
        this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("while"), TailTypes.WHILE_LPARENTH));
        this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("do"), TailTypes.DO_LBRACE));
        this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("for"), TailTypes.FOR_LPARENTH));
        this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("if"), TailTypes.IF_LPARENTH));
        this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("try"), TailTypes.TRY_LBRACE));
        this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("throw"), TailType.INSERT_SPACE));
        this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("new"), TailType.INSERT_SPACE));
        this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("synchronized"), TailTypes.SYNCHRONIZED_LPARENTH));
        if (PsiUtil.getLanguageLevel((PsiElement)this.myPosition).isAtLeast(LanguageLevel.JDK_1_4)) {
            this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("assert"), TailType.INSERT_SPACE));
        }
        TailType returnTail = JavaKeywordCompletion.getReturnTail(this.myPosition);
        Object ret = this.createKeyword("return");
        if (returnTail != TailType.NONE) {
            ret = new OverridableSpace((LookupElement)ret, returnTail);
        }
        this.addKeyword((LookupElement)ret);
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(";")).withSuperParent(2, PsiIfStatement.class)).accepts((Object)this.myPrevLeaf) || ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("}")).withSuperParent(3, PsiIfStatement.class)).accepts((Object)this.myPrevLeaf)) {
            this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("else"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("}")).withParent((ElementPattern)PsiJavaPatterns.psiElement(PsiCodeBlock.class).withParent(PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiTryStatement.class), PsiJavaPatterns.psiElement(PsiCatchSection.class)})))).accepts((Object)this.myPrevLeaf)) {
            this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("catch"), TailTypes.CATCH_LPARENTH));
            this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("finally"), TailTypes.FINALLY_LBRACE));
        }
    }

    void addKeywords() {
        if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myPosition, (Class[])new Class[]{PsiLiteralExpression.class, PsiComment.class}) != null) {
            return;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"::"})).accepts((Object)this.myPosition)) {
            return;
        }
        PsiFile file = this.myPosition.getContainingFile();
        if ("module-info.java".equals(file.getName()) && PsiUtil.isLanguageLevel9OrHigher((PsiElement)file)) {
            this.addModuleKeywords();
            return;
        }
        this.addFinal();
        boolean statementPosition = JavaKeywordCompletion.isStatementPosition(this.myPosition);
        if (statementPosition) {
            this.addCaseDefault();
            if (START_SWITCH.accepts((Object)this.myPosition)) {
                return;
            }
            this.addBreakContinue();
            this.addStatementKeywords();
        }
        this.addThisSuper();
        this.addExpressionKeywords(statementPosition);
        this.addFileHeaderKeywords();
        this.addInstanceof();
        this.addClassKeywords();
        this.addMethodHeaderKeywords();
        JavaKeywordCompletion.addPrimitiveTypes((Consumer<? super LookupElement>)((Consumer)this::addKeyword), this.myPosition, this.mySession);
        this.addVar();
        this.addClassLiteral();
        this.addExtendsImplements();
    }

    private void addVar() {
        if (this.isVarAllowed()) {
            this.addKeyword(this.createKeyword("var"));
        }
    }

    private boolean isVarAllowed() {
        if (PsiUtil.isLanguageLevel11OrHigher((PsiElement)this.myPosition) && this.isLambdaParameterType()) {
            return true;
        }
        if (!PsiUtil.isLanguageLevel10OrHigher((PsiElement)this.myPosition)) {
            return false;
        }
        if (JavaKeywordCompletion.isAtCatchOrResourceVariableStart(this.myPosition) && PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiCatchSection.class) == null) {
            return true;
        }
        return JavaKeywordCompletion.isVariableTypePosition(this.myPosition) && PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class}) != null;
    }

    private boolean isLambdaParameterType() {
        PsiElement position = this.myParameters.getOriginalPosition();
        PsiParameterList paramList = (PsiParameterList)PsiTreeUtil.getParentOfType((PsiElement)position, PsiParameterList.class);
        if (paramList != null && paramList.getParent() instanceof PsiLambdaExpression) {
            PsiParameter param = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)position, PsiParameter.class);
            PsiTypeElement type2 = param == null ? null : param.getTypeElement();
            return type2 == null || PsiTreeUtil.isAncestor((PsiElement)type2, (PsiElement)position, (boolean)false);
        }
        return false;
    }

    boolean addWildcardExtendsSuper(CompletionResultSet result, PsiElement position) {
        if (JavaMemberNameCompletionContributor.INSIDE_TYPE_PARAMS_PATTERN.accepts((Object)position)) {
            for (String keyword : (String[])ContainerUtil.ar((Object[])new String[]{"extends", "super"})) {
                if (!this.myKeywordMatcher.isStartMatch(keyword)) continue;
                LookupElement item = BasicExpressionCompletionContributor.createKeywordLookupItem(position, keyword);
                result.addElement((LookupElement)new OverridableSpace(item, TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
            return true;
        }
        return false;
    }

    private void addMethodHeaderKeywords() {
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(")")).withParents(new Class[]{PsiParameterList.class, PsiMethod.class})).accepts((Object)this.myPrevLeaf)) {
            assert (this.myPrevLeaf != null);
            if (this.myPrevLeaf.getParent().getParent() instanceof PsiAnnotationMethod) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("default"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            } else {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("throws"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
        }
    }

    private void addCaseDefault() {
        PsiSwitchBlock switchBlock = JavaKeywordCompletion.getSwitchFromLabelPosition(this.myPosition);
        if (switchBlock != null) {
            this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("case"), TailType.INSERT_SPACE));
            this.addKeyword((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)new OverridableSpace(this.createKeyword("default"), TailTypes.forSwitchLabel(switchBlock)), ADJUST_LINE_OFFSET));
        }
    }

    private static PsiSwitchBlock getSwitchFromLabelPosition(PsiElement position) {
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiStatement.class, (boolean)false, (Class[])new Class[]{PsiMember.class});
        if (statement == null || statement.getTextRange().getStartOffset() != position.getTextRange().getStartOffset()) {
            return null;
        }
        if (!(statement instanceof PsiSwitchLabelStatementBase) && statement.getParent() instanceof PsiCodeBlock) {
            return (PsiSwitchBlock)ObjectUtils.tryCast((Object)statement.getParent().getParent(), PsiSwitchBlock.class);
        }
        return null;
    }

    void addEnumCases() {
        PsiClass switchType;
        PsiSwitchBlock switchBlock = JavaKeywordCompletion.getSwitchFromLabelPosition(this.myPosition);
        PsiExpression expression2 = switchBlock == null ? null : switchBlock.getExpression();
        PsiClass psiClass = switchType = expression2 == null ? null : PsiUtil.resolveClassInClassTypeOnly((PsiType)expression2.getType());
        if (switchType == null || !switchType.isEnum()) {
            return;
        }
        Set<PsiField> used = ReferenceExpressionCompletionContributor.findConstantsUsedInSwitch(switchBlock);
        TailType tailType = TailTypes.forSwitchLabel(switchBlock);
        for (PsiField field : switchType.getAllFields()) {
            String name2 = field.getName();
            if (!(field instanceof PsiEnumConstant) || used.contains(CompletionUtil.getOriginalOrSelf((PsiElement)field))) continue;
            String prefix = "case ";
            LookupElementBuilder caseConst = LookupElementBuilder.create((Object)field, (String)(prefix + name2)).bold().withPresentableText(prefix).withTailText(name2).withLookupString(name2);
            this.myResults.add((LookupElement)new JavaCompletionContributor.IndentingDecorator((LookupElement)TailTypeDecorator.withTail((LookupElement)caseConst, (TailType)tailType)));
        }
    }

    private void addFinal() {
        PsiTryStatement tryStatement;
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, (Class[])new Class[]{PsiExpressionStatement.class, PsiDeclarationStatement.class});
        if (!(statement == null || statement.getTextRange().getStartOffset() != this.myPosition.getTextRange().getStartOffset() || ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withSuperParent(2, PsiSwitchStatement.class)).afterLeaf(new String[]{"{"})).accepts((Object)statement) || (tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myPrevLeaf, PsiTryStatement.class)) != null && tryStatement.getCatchSections().length <= 0 && tryStatement.getFinallyBlock() == null && tryStatement.getResourceList() == null)) {
            this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("final"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            return;
        }
        if ((JavaKeywordCompletion.isInsideParameterList(this.myPosition) || JavaKeywordCompletion.isAtCatchOrResourceVariableStart(this.myPosition)) && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"final"})).accepts((Object)this.myPosition) && !AFTER_DOT.accepts((Object)this.myPosition)) {
            this.addKeyword((LookupElement)TailTypeDecorator.withTail((LookupElement)this.createKeyword("final"), (TailType)TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
    }

    private void addThisSuper() {
        if (SUPER_OR_THIS_PATTERN.accepts((Object)this.myPosition)) {
            boolean insideInheritorClass;
            boolean afterDot = AFTER_DOT.accepts((Object)this.myPosition);
            boolean insideQualifierClass = this.isInsideQualifierClass();
            boolean bl = insideInheritorClass = PsiUtil.isLanguageLevel8OrHigher((PsiElement)this.myPosition) && this.isInsideInheritorClass();
            if (!afterDot || insideQualifierClass || insideInheritorClass) {
                if (!afterDot || insideQualifierClass) {
                    this.addKeyword(this.createKeyword("this"));
                }
                LookupElement superItem = this.createKeyword("super");
                if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("{")).withSuperParent(2, (ElementPattern)PsiJavaPatterns.psiMethod().constructor(true)))).accepts((Object)this.myPosition)) {
                    PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiMethod.class, (boolean)false, (Class[])new Class[]{PsiClass.class});
                    assert (method != null);
                    final boolean hasParams = JavaKeywordCompletion.superConstructorHasParameters(method);
                    this.addKeyword((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)superItem, (InsertHandler)new ParenthesesInsertHandler<LookupElement>(){

                        protected boolean placeCaretInsideParentheses(InsertionContext context, LookupElement item) {
                            return hasParams;
                        }

                        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                            if (context == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (item == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            super.handleInsert(context, item);
                            TailType.insertChar((Editor)context.getEditor(), (int)context.getTailOffset(), (char)';');
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "context";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "item";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/codeInsight/completion/JavaKeywordCompletion$1";
                            objectArray[2] = "handleInsert";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }));
                    return;
                }
                this.addKeyword(superItem);
            }
        }
    }

    private void addExpressionKeywords(boolean statementPosition) {
        if (JavaKeywordCompletion.isExpressionPosition(this.myPosition)) {
            boolean allowExprKeywords;
            PsiElement parent = this.myPosition.getParent();
            PsiElement grandParent = parent == null ? null : parent.getParent();
            boolean bl = allowExprKeywords = !(grandParent instanceof PsiExpressionStatement) && !(grandParent instanceof PsiUnaryExpression);
            if (PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiAnnotation.class) == null) {
                if (!statementPosition) {
                    this.addKeyword((LookupElement)TailTypeDecorator.withTail((LookupElement)this.createKeyword("new"), (TailType)TailType.INSERT_SPACE));
                    if (HighlightingFeature.ENHANCED_SWITCH.isAvailable(this.myPosition)) {
                        this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("switch"), TailTypes.SWITCH_LPARENTH));
                    }
                }
                if (allowExprKeywords) {
                    this.addKeyword(this.createKeyword("null"));
                }
            }
            if (allowExprKeywords && JavaKeywordCompletion.mayExpectBoolean(this.myParameters)) {
                this.addKeyword(this.createKeyword("true"));
                this.addKeyword(this.createKeyword("false"));
            }
        }
        if (this.isQualifiedNewContext()) {
            this.addKeyword(this.createKeyword("new"));
        }
    }

    private boolean isQualifiedNewContext() {
        PsiExpression qualifier;
        PsiClass qualifierClass;
        return this.myPosition.getParent() instanceof PsiReferenceExpression && (qualifierClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)((qualifier = ((PsiReferenceExpression)this.myPosition.getParent()).getQualifierExpression()) == null ? null : qualifier.getType()))) != null && ContainerUtil.exists((Object[])qualifierClass.getAllInnerClasses(), inner -> this.canBeCreatedInQualifiedNew(qualifierClass, (PsiClass)inner));
    }

    private boolean canBeCreatedInQualifiedNew(PsiClass outer, PsiClass inner) {
        Object[] constructors = inner.getConstructors();
        return !inner.hasModifierProperty("static") && PsiUtil.isAccessible((PsiMember)inner, (PsiElement)this.myPosition, (PsiClass)outer) && (constructors.length == 0 || ContainerUtil.exists((Object[])constructors, c -> PsiUtil.isAccessible((PsiMember)c, (PsiElement)this.myPosition, (PsiClass)outer)));
    }

    private void addFileHeaderKeywords() {
        PsiFile file = this.myPosition.getContainingFile();
        assert (file != null);
        if (!(file instanceof PsiExpressionCodeFragment || file instanceof PsiJavaCodeReferenceCodeFragment || file instanceof PsiTypeCodeFragment)) {
            if (this.myPrevLeaf == null) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("package"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("import"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            } else if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiAnnotation().withParents(new Class[]{PsiModifierList.class, PsiFile.class}))).accepts((Object)this.myPrevLeaf) && "package-info.java".equals(file.getName())) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("package"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            } else if (JavaKeywordCompletion.isEndOfBlock(this.myPosition) && PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiMember.class) == null) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("import"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
        }
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && this.myPrevLeaf != null && this.myPrevLeaf.textMatches((CharSequence)"import")) {
            this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("static"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
    }

    private void addInstanceof() {
        if (JavaKeywordCompletion.isInstanceofPlace(this.myPosition)) {
            this.addKeyword((LookupElement)LookupElementDecorator.withInsertHandler((LookupElement)this.createKeyword("instanceof"), (context, item) -> {
                TailType tailType = TailType.HUMBLE_SPACE_BEFORE_WORD;
                if (tailType.isApplicable(context)) {
                    tailType.processTail(context.getEditor(), context.getTailOffset());
                }
                if ('!' == context.getCompletionChar()) {
                    context.setAddCompletionChar(false);
                }
                context.commitDocument();
                PsiInstanceOfExpression expr2 = (PsiInstanceOfExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset(), PsiInstanceOfExpression.class, (boolean)false);
                if (expr2 != null) {
                    PsiExpression operand2 = expr2.getOperand();
                    if (operand2 instanceof PsiPrefixExpression && ((PsiPrefixExpression)operand2).getOperationTokenType().equals(JavaTokenType.EXCL)) {
                        PsiExpression negated = ((PsiPrefixExpression)operand2).getOperand();
                        if (negated != null) {
                            String space = CompletionStyleUtil.getCodeStyleSettings((InsertionContext)context).SPACE_WITHIN_PARENTHESES ? " " : "";
                            context.getDocument().insertString(negated.getTextRange().getStartOffset(), (CharSequence)("(" + space));
                            context.getDocument().insertString(context.getTailOffset(), (CharSequence)(space + ")"));
                        }
                    } else if ('!' == context.getCompletionChar()) {
                        String space = CompletionStyleUtil.getCodeStyleSettings((InsertionContext)context).SPACE_WITHIN_PARENTHESES ? " " : "";
                        context.getDocument().insertString(expr2.getTextRange().getStartOffset(), (CharSequence)("!(" + space));
                        context.getDocument().insertString(context.getTailOffset(), (CharSequence)(space + ")"));
                    }
                }
            }));
        }
    }

    private void addClassKeywords() {
        if (JavaKeywordCompletion.isSuitableForClass(this.myPosition)) {
            for (String s : ModifierChooser.getKeywords(this.myPosition)) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword(s), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
            if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiLocalVariable.class, PsiExpressionStatement.class}))).accepts((Object)this.myPosition)) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("class"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                if (HighlightingFeature.RECORDS.isAvailable(this.myPosition)) {
                    this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("record"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                }
                if (HighlightingFeature.LOCAL_ENUMS.isAvailable(this.myPosition)) {
                    this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("enum"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                }
                if (HighlightingFeature.LOCAL_INTERFACES.isAvailable(this.myPosition)) {
                    this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("interface"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                }
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiExpression.class, (boolean)true, (Class[])new Class[]{PsiMember.class}) == null && PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiMember.class}) == null) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("class"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("interface"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                if (HighlightingFeature.RECORDS.isAvailable(this.myPosition)) {
                    this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("record"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                }
                if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)this.myPosition)) {
                    this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("enum"), TailType.INSERT_SPACE));
                }
            }
        }
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("@")).andNot((ElementPattern)PsiJavaPatterns.psiElement().inside(PsiParameterList.class))).andNot((ElementPattern)PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiNameValuePair()))).accepts((Object)this.myPrevLeaf)) {
            this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("interface"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
    }

    private void addClassLiteral() {
        if (JavaKeywordCompletion.isAfterTypeDot(this.myPosition)) {
            this.addKeyword(this.createKeyword("class"));
        }
    }

    private void addExtendsImplements() {
        if (this.myPrevLeaf == null || !(this.myPrevLeaf instanceof PsiIdentifier) && !this.myPrevLeaf.textMatches((CharSequence)">") && !this.myPrevLeaf.textMatches((CharSequence)")")) {
            return;
        }
        PsiClass psiClass = null;
        PsiElement prevParent = this.myPrevLeaf.getParent();
        if (this.myPrevLeaf instanceof PsiIdentifier && prevParent instanceof PsiClass) {
            psiClass = (PsiClass)prevParent;
        } else {
            PsiReferenceList referenceList = (PsiReferenceList)PsiTreeUtil.getParentOfType((PsiElement)this.myPrevLeaf, PsiReferenceList.class);
            if (referenceList != null && referenceList.getParent() instanceof PsiClass) {
                psiClass = (PsiClass)referenceList.getParent();
            } else if ((prevParent instanceof PsiTypeParameterList || prevParent instanceof PsiRecordHeader) && prevParent.getParent() instanceof PsiClass) {
                psiClass = (PsiClass)prevParent.getParent();
            }
        }
        if (psiClass != null) {
            if (!psiClass.isEnum() && !psiClass.isRecord()) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("extends"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
            if (!psiClass.isInterface()) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("implements"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
            if (psiClass.hasModifierProperty("sealed")) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("permits"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
        }
    }

    private static boolean mayExpectBoolean(CompletionParameters parameters2) {
        for (ExpectedTypeInfo info : JavaSmartCompletionContributor.getExpectedTypes(parameters2)) {
            PsiType type2 = info.getType();
            if (!(type2 instanceof PsiClassType) && !PsiType.BOOLEAN.equals((Object)type2)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExpressionPosition(PsiElement position) {
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiElement(PsiClassObjectAccessExpression.class))).accepts((Object)position)) {
            return true;
        }
        PsiElement parent = position.getParent();
        if (!(parent instanceof PsiReferenceExpression) || ((PsiReferenceExpression)parent).isQualified() || JavaCompletionContributor.IN_SWITCH_LABEL.accepts((Object)position)) {
            return false;
        }
        if (parent.getParent() instanceof PsiExpressionStatement) {
            PsiElement previous = PsiTreeUtil.skipWhitespacesBackward((PsiElement)parent.getParent());
            return previous == null || !(previous.getLastChild() instanceof PsiErrorElement);
        }
        return true;
    }

    public static boolean isInstanceofPlace(PsiElement position) {
        PsiElement grandParent;
        PsiType type2;
        PsiElement prev = PsiTreeUtil.prevVisibleLeaf((PsiElement)position);
        if (prev == null) {
            return false;
        }
        PsiElement expr2 = PsiTreeUtil.getParentOfType((PsiElement)prev, PsiExpression.class);
        if (expr2 != null && expr2.getTextRange().getEndOffset() == prev.getTextRange().getEndOffset() && PsiTreeUtil.getParentOfType((PsiElement)expr2, PsiAnnotation.class) == null) {
            return true;
        }
        return position instanceof PsiIdentifier && position.getParent() instanceof PsiLocalVariable && (type2 = ((PsiLocalVariable)position.getParent()).getType()) instanceof PsiClassType && ((PsiClassType)type2).resolve() == null && (!((grandParent = position.getParent().getParent()) instanceof PsiDeclarationStatement) || !(grandParent.getParent() instanceof PsiForStatement) || ((PsiForStatement)grandParent.getParent()).getInitialization() != grandParent);
    }

    public static boolean isSuitableForClass(PsiElement position) {
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"@"})).accepts((Object)position) || PsiTreeUtil.getNonStrictParentOfType((PsiElement)position, (Class[])new Class[]{PsiLiteralExpression.class, PsiComment.class, PsiExpressionCodeFragment.class}) != null) {
            return false;
        }
        PsiElement prev = JavaKeywordCompletion.prevSignificantLeaf(position);
        if (prev == null) {
            return true;
        }
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withoutText(".")).inside((ElementPattern)PsiJavaPatterns.psiElement(PsiModifierList.class).withParent((ElementPattern)PsiJavaPatterns.not((ElementPattern)PsiJavaPatterns.psiElement(PsiParameter.class)).andNot((ElementPattern)PsiJavaPatterns.psiElement(PsiParameterList.class))))).accepts((Object)prev) && (!((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiAnnotationParameterList.class)).accepts((Object)prev) || prev.textMatches((CharSequence)")"))) {
            return true;
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiErrorElement.class, PsiFile.class})).accepts((Object)position)) {
            return true;
        }
        return JavaKeywordCompletion.isEndOfBlock(position);
    }

    static boolean isAfterPrimitiveOrArrayType(PsiElement element) {
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParent((ElementPattern)PsiJavaPatterns.psiReferenceExpression().withFirstChild((ElementPattern)PsiJavaPatterns.psiElement(PsiClassObjectAccessExpression.class).withLastChild((ElementPattern)PsiJavaPatterns.not((ElementPattern)PsiJavaPatterns.psiElement().withText("class")))))).accepts((Object)element);
    }

    static boolean isAfterTypeDot(PsiElement position) {
        if (JavaKeywordCompletion.isInsideParameterList(position) || position.getContainingFile() instanceof PsiJavaCodeReferenceCodeFragment) {
            return false;
        }
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText(".")).afterLeaf(CLASS_REFERENCE))).accepts((Object)position) || JavaKeywordCompletion.isAfterPrimitiveOrArrayType(position);
    }

    static void addPrimitiveTypes(Consumer<? super LookupElement> result, PsiElement position, JavaCompletionSession session) {
        boolean inGenerics;
        boolean afterNew;
        if (AFTER_DOT.accepts((Object)position) || ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside((ElementPattern)PsiJavaPatterns.psiAnnotation())).accepts((Object)position) && !JavaKeywordCompletion.expectsClassLiteral(position)) {
            return;
        }
        boolean bl = afterNew = JavaSmartCompletionContributor.AFTER_NEW.accepts((Object)position) && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."}))).accepts((Object)position);
        if (afterNew) {
            Set expected = ContainerUtil.map2Set((Object[])JavaSmartCompletionContributor.getExpectedTypes(position, false), ExpectedTypeInfo::getDefaultType);
            boolean addAll = expected.isEmpty() || ContainerUtil.exists((Iterable)expected, t -> t.equalsToText("java.lang.Object") || t.equalsToText("java.io.Serializable"));
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)position.getProject());
            for (String primitiveType : PRIMITIVE_TYPES) {
                PsiType array = factory.createTypeFromText(primitiveType + "[]", null);
                if (!addAll && !expected.contains(array)) continue;
                result.consume((Object)PsiTypeLookupItem.createLookupItem(array, null));
            }
            return;
        }
        boolean inCast = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf((ElementPattern)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withText("(")).withParent((ElementPattern)PsiJavaPatterns.psiElement((Class[])new Class[]{PsiParenthesizedExpression.class, PsiTypeCastExpression.class})))).accepts((Object)position);
        boolean typeFragment = position.getContainingFile() instanceof PsiTypeCodeFragment && PsiTreeUtil.prevVisibleLeaf((PsiElement)position) == null;
        boolean declaration2 = JavaKeywordCompletion.isDeclarationStart(position);
        boolean expressionPosition = JavaKeywordCompletion.isExpressionPosition(position);
        boolean bl2 = inGenerics = PsiTreeUtil.getParentOfType((PsiElement)position, PsiReferenceParameterList.class) != null;
        if (JavaKeywordCompletion.isVariableTypePosition(position) || inGenerics || inCast || declaration2 || typeFragment || expressionPosition) {
            for (String primitiveType : PRIMITIVE_TYPES) {
                if (session.isKeywordAlreadyProcessed(primitiveType)) continue;
                result.consume((Object)BasicExpressionCompletionContributor.createKeywordLookupItem(position, primitiveType));
            }
            if (expressionPosition && !session.isKeywordAlreadyProcessed("void")) {
                result.consume((Object)BasicExpressionCompletionContributor.createKeywordLookupItem(position, "void"));
            }
        }
        if (declaration2) {
            LookupElement item = BasicExpressionCompletionContributor.createKeywordLookupItem(position, "void");
            result.consume((Object)new OverridableSpace(item, TailType.HUMBLE_SPACE_BEFORE_WORD));
        } else if (typeFragment && ((PsiTypeCodeFragment)position.getContainingFile()).isVoidValid()) {
            result.consume((Object)BasicExpressionCompletionContributor.createKeywordLookupItem(position, "void"));
        }
    }

    private static boolean isVariableTypePosition(PsiElement position) {
        return START_FOR.accepts((Object)position) || JavaKeywordCompletion.isInsideParameterList(position) || INSIDE_RECORD_HEADER.accepts((Object)position) || VARIABLE_AFTER_FINAL.accepts((Object)position) || JavaKeywordCompletion.isStatementPosition(position);
    }

    static boolean isDeclarationStart(@NotNull PsiElement position) {
        if (position == null) {
            JavaKeywordCompletion.$$$reportNull$$$0(1);
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"@", "."})).accepts((Object)position)) {
            return false;
        }
        PsiElement parent = position.getParent();
        if (parent instanceof PsiJavaCodeReferenceElement && parent.getParent() instanceof PsiTypeElement) {
            PsiElement typeHolder = (PsiElement)SyntaxTraverser.psiApi().parents((Object)parent.getParent()).skipWhile(Conditions.instanceOf(PsiTypeElement.class)).first();
            return typeHolder instanceof PsiMember || typeHolder instanceof PsiClassLevelDeclarationStatement;
        }
        return false;
    }

    private static boolean expectsClassLiteral(PsiElement position) {
        return ContainerUtil.find((Object[])JavaSmartCompletionContributor.getExpectedTypes(position, false), info -> InheritanceUtil.isInheritor((PsiType)info.getType(), (String)"java.lang.Class")) != null;
    }

    private static boolean isAtCatchOrResourceVariableStart(PsiElement position) {
        PsiElement type2 = PsiTreeUtil.getParentOfType((PsiElement)position, PsiTypeElement.class);
        if (type2 != null && type2.getTextRange().getStartOffset() == position.getTextRange().getStartOffset()) {
            PsiElement parent = type2.getParent();
            if (parent instanceof PsiVariable) {
                parent = parent.getParent();
            }
            return parent instanceof PsiCatchSection || parent instanceof PsiResourceList;
        }
        return ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiElement(PsiResourceExpression.class))).accepts((Object)position);
    }

    private void addBreakContinue() {
        PsiLoopStatement loop = (PsiLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)this.myPosition, PsiLoopStatement.class, (boolean)true, (Class[])new Class[]{PsiLambdaExpression.class, PsiMember.class});
        LookupElement br = this.createKeyword("break");
        LookupElement cont = this.createKeyword("continue");
        TailType tailType = ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideSequence(true, new ElementPattern[]{PsiJavaPatterns.psiElement(PsiLabeledStatement.class), PsiJavaPatterns.or((ElementPattern[])new ElementPattern[]{PsiJavaPatterns.psiElement(PsiFile.class), PsiJavaPatterns.psiElement(PsiMethod.class), PsiJavaPatterns.psiElement(PsiClassInitializer.class)})})).accepts((Object)this.myPosition) ? TailType.HUMBLE_SPACE_BEFORE_WORD : TailType.SEMICOLON;
        br = TailTypeDecorator.withTail((LookupElement)br, (TailType)tailType);
        cont = TailTypeDecorator.withTail((LookupElement)cont, (TailType)tailType);
        if (loop != null && PsiTreeUtil.isAncestor((PsiElement)loop.getBody(), (PsiElement)this.myPosition, (boolean)false)) {
            this.addKeyword(br);
            this.addKeyword(cont);
        }
        if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiSwitchStatement.class)).accepts((Object)this.myPosition)) {
            this.addKeyword(br);
        } else if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().inside(PsiSwitchExpression.class)).accepts((Object)this.myPosition) && PsiUtil.getLanguageLevel((PsiElement)this.myPosition).isAtLeast(LanguageLevel.JDK_14)) {
            this.addKeyword((LookupElement)TailTypeDecorator.withTail((LookupElement)this.createKeyword("yield"), (TailType)TailType.INSERT_SPACE));
        }
        for (PsiLabeledStatement labeled : SyntaxTraverser.psiApi().parents((Object)this.myPosition).takeWhile(Conditions.notInstanceOf(PsiMember.class)).filter(PsiLabeledStatement.class)) {
            this.addKeyword((LookupElement)TailTypeDecorator.withTail((LookupElement)LookupElementBuilder.create((String)("break " + labeled.getName())).bold(), (TailType)TailType.SEMICOLON));
        }
    }

    private static boolean isStatementPosition(PsiElement position) {
        PsiElement stmt;
        PsiIfStatement ifStatement;
        if (((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withSuperParent(2, PsiConditionalExpression.class)).andNot((ElementPattern)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiElement(PsiConditionalExpression.class)))).accepts((Object)position)) {
            return false;
        }
        if (JavaKeywordCompletion.isEndOfBlock(position) && PsiTreeUtil.getParentOfType((PsiElement)position, PsiCodeBlock.class, (boolean)true, (Class[])new Class[]{PsiMember.class}) != null) {
            return !JavaKeywordCompletion.isForLoopMachinery(position);
        }
        return ((PsiJavaElementPattern.Capture)((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().withParents(new Class[]{PsiReferenceExpression.class, PsiExpressionStatement.class, PsiIfStatement.class})).andNot((ElementPattern)PsiJavaPatterns.psiElement().afterLeaf(new String[]{"."}))).accepts((Object)position) && ((ifStatement = (PsiIfStatement)(stmt = position.getParent().getParent()).getParent()).getElseBranch() == stmt || ifStatement.getThenBranch() == stmt);
    }

    private static boolean isForLoopMachinery(PsiElement position) {
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)position, PsiStatement.class);
        if (statement == null) {
            return false;
        }
        return statement instanceof PsiForStatement || statement.getParent() instanceof PsiForStatement && statement != ((PsiForStatement)statement.getParent()).getBody();
    }

    private LookupElement createKeyword(String keyword) {
        return BasicExpressionCompletionContributor.createKeywordLookupItem(this.myPosition, keyword);
    }

    private boolean isInsideQualifierClass() {
        PsiElement qualifierClass;
        PsiElement qualifier;
        if (this.myPosition.getParent() instanceof PsiJavaCodeReferenceElement && (qualifier = ((PsiJavaCodeReferenceElement)this.myPosition.getParent()).getQualifier()) instanceof PsiJavaCodeReferenceElement && (qualifierClass = ((PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiClass) {
            PsiElement parent = this.myPosition;
            PsiManager psiManager = this.myPosition.getManager();
            while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)true)) != null) {
                if (!psiManager.areElementsEquivalent(parent, qualifierClass)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isInsideInheritorClass() {
        PsiElement qualifierClass;
        PsiElement qualifier;
        if (this.myPosition.getParent() instanceof PsiJavaCodeReferenceElement && (qualifier = ((PsiJavaCodeReferenceElement)this.myPosition.getParent()).getQualifier()) instanceof PsiJavaCodeReferenceElement && (qualifierClass = ((PsiJavaCodeReferenceElement)qualifier).resolve()) instanceof PsiClass && ((PsiClass)qualifierClass).isInterface()) {
            PsiElement parent = this.myPosition;
            while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class, (boolean)true)) != null) {
                if (PsiUtil.getEnclosingStaticElement((PsiElement)this.myPosition, (PsiClass)((PsiClass)parent)) != null || !((PsiClass)parent).isInheritor((PsiClass)qualifierClass, true)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean superConstructorHasParameters(PsiMethod method) {
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return false;
        }
        PsiClass superClass = psiClass.getSuperClass();
        if (superClass != null) {
            for (PsiMethod psiMethod : superClass.getConstructors()) {
                PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)method.getProject()).getResolveHelper();
                if (!resolveHelper.isAccessible((PsiMember)psiMethod, (PsiElement)method, null) || psiMethod.getParameterList().isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private void addModuleKeywords() {
        PsiElement context = PsiTreeUtil.skipParentsOfType((PsiElement)this.myPosition.getParent(), (Class[])new Class[]{PsiErrorElement.class});
        PsiElement prevElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)this.myPosition.getParent());
        if (context instanceof PsiJavaFile && !(prevElement instanceof PsiJavaModule) || context instanceof PsiImportList) {
            this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("module"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            if (this.myPrevLeaf == null || !this.myPrevLeaf.textMatches((CharSequence)"open")) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("open"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
        } else if (context instanceof PsiJavaModule) {
            if (prevElement instanceof PsiPackageAccessibilityStatement && !this.myPrevLeaf.textMatches((CharSequence)";")) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("to"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            } else if (!PsiUtil.isJavaToken((PsiElement)prevElement, (IElementType)JavaTokenType.MODULE_KEYWORD)) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("requires"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("exports"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("opens"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("uses"), TailType.HUMBLE_SPACE_BEFORE_WORD));
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("provides"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
        } else if (context instanceof PsiRequiresStatement) {
            if (!this.myPrevLeaf.textMatches((CharSequence)"transitive")) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("transitive"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
            if (!this.myPrevLeaf.textMatches((CharSequence)"static")) {
                this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("static"), TailType.HUMBLE_SPACE_BEFORE_WORD));
            }
        } else if (context instanceof PsiProvidesStatement && prevElement instanceof PsiJavaCodeReferenceElement) {
            this.addKeyword((LookupElement)new OverridableSpace(this.createKeyword("with"), TailType.HUMBLE_SPACE_BEFORE_WORD));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/completion/JavaKeywordCompletion";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEndOfBlock";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDeclarationStart";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class OverridableSpace
    extends TailTypeDecorator<LookupElement> {
        private final TailType myTail;

        public OverridableSpace(LookupElement keyword, TailType tail) {
            super(keyword);
            this.myTail = tail;
        }

        protected TailType computeTailType(InsertionContext context) {
            return context.shouldAddCompletionChar() ? TailType.NONE : this.myTail;
        }
    }
}

