/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaMethodReferenceElement
extends LookupElement
implements TypedLookupItem {
    private final PsiMethod myMethod;
    private final PsiElement myRefPlace;
    private final PsiType myType;

    JavaMethodReferenceElement(PsiMethod method, PsiElement refPlace, @Nullable PsiType type2) {
        this.myMethod = method;
        this.myRefPlace = refPlace;
        this.myType = type2;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return this.myType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaMethodReferenceElement)) {
            return false;
        }
        JavaMethodReferenceElement element = (JavaMethodReferenceElement)o;
        return this.getLookupString().equals(element.getLookupString()) && this.myRefPlace.equals(element.myRefPlace);
    }

    public int hashCode() {
        return Objects.hash(this.getLookupString(), this.myRefPlace);
    }

    @NotNull
    public Object getObject() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            JavaMethodReferenceElement.$$$reportNull$$$0(0);
        }
        return psiMethod;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myMethod.isConstructor() ? "new" : this.myMethod.getName();
        if (string == null) {
            JavaMethodReferenceElement.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setIcon(this.myMethod.getIcon(1));
        super.renderElement(presentation);
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            JavaMethodReferenceElement.$$$reportNull$$$0(2);
        }
        if (!(this.myRefPlace instanceof PsiMethodReferenceExpression)) {
            PsiClass containingClass = Objects.requireNonNull(this.myMethod.getContainingClass());
            String qualifiedName = Objects.requireNonNull(containingClass.getQualifiedName());
            Editor editor = context.getEditor();
            Document document = editor.getDocument();
            int startOffset = context.getStartOffset();
            document.insertString(startOffset, (CharSequence)(qualifiedName + "::"));
            JavaCompletionUtil.shortenReference(context.getFile(), startOffset + qualifiedName.length() - 1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/JavaMethodReferenceElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/JavaMethodReferenceElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

