/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionMemory;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.codeInsight.lookup.VariableLookupItem;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.java.PsiEmptyExpressionImpl;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.Consumer;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SameSignatureCallParametersProvider {
    static final PsiElementPattern.Capture<PsiElement> IN_CALL_ARGUMENT = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{"("})).withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class).withParent((ElementPattern)PlatformPatterns.psiElement(PsiExpressionList.class).withParent(PsiCall.class)))).with((PatternCondition)new PatternCondition<PsiElement>("Method call completed with parameter hints"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            PsiElement e = element.getParent();
            while ((e = e.getNextSibling()) != null) {
                if (!(e instanceof PsiExpression) || e instanceof PsiEmptyExpressionImpl) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/SameSignatureCallParametersProvider$1", "accepts"));
        }
    });

    SameSignatureCallParametersProvider() {
    }

    void addSignatureItems(@NotNull PsiElement position, @NotNull Consumer<? super LookupElement> result) {
        if (position == null) {
            SameSignatureCallParametersProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SameSignatureCallParametersProvider.$$$reportNull$$$0(1);
        }
        PsiCall methodCall = (PsiCall)PsiTreeUtil.getParentOfType((PsiElement)position, PsiCall.class);
        assert (methodCall != null);
        Set<Pair<PsiMethod, PsiSubstitutor>> candidates = SameSignatureCallParametersProvider.getCallCandidates(methodCall);
        PsiMethod container = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)methodCall, PsiMethod.class);
        while (container != null) {
            for (Pair<PsiMethod, PsiSubstitutor> candidate : candidates) {
                PsiMethod from;
                if (container.getParameterList().getParametersCount() <= 1 || ((PsiMethod)candidate.first).getParameterList().getParametersCount() <= 1 || (from = SameSignatureCallParametersProvider.getMethodToTakeParametersFrom(container, (PsiMethod)candidate.first, (PsiSubstitutor)candidate.second)) == null) continue;
                result.consume((Object)SameSignatureCallParametersProvider.createParametersLookupElement(from, (PsiElement)methodCall, (PsiMethod)candidate.first));
            }
            container = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)container, PsiMethod.class);
        }
    }

    private static LookupElement createParametersLookupElement(final PsiMethod takeParametersFrom, PsiElement call, PsiMethod invoked) {
        Object[] parameters2 = takeParametersFrom.getParameterList().getParameters();
        String lookupString = StringUtil.join((Object[])parameters2, PsiNamedElement::getName, (String)", ");
        int w = PlatformIcons.PARAMETER_ICON.getIconWidth();
        LayeredIcon icon = new LayeredIcon(2);
        icon.setIcon(PlatformIcons.PARAMETER_ICON, 0, 2 * w / 5, 0);
        icon.setIcon(PlatformIcons.PARAMETER_ICON, 1);
        LookupElementBuilder element = LookupElementBuilder.create((String)lookupString).withIcon((Icon)icon);
        final boolean makeFinalIfNeeded = PsiTreeUtil.isAncestor((PsiElement)takeParametersFrom, (PsiElement)call, (boolean)true);
        element = element.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                PsiElement rParen;
                if (context == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (item == null) {
                    2.$$$reportNull$$$0(1);
                }
                context.commitDocument();
                int startOffset = context.getTailOffset();
                PsiExpressionList exprList = (PsiExpressionList)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context.getFile(), (int)(startOffset - 1), PsiExpressionList.class, (boolean)false);
                PsiElement psiElement = rParen = exprList == null ? null : exprList.getLastChild();
                if (rParen != null && rParen.textMatches((CharSequence)")")) {
                    context.getDocument().deleteString(startOffset, rParen.getTextRange().getStartOffset());
                }
                if (makeFinalIfNeeded) {
                    context.commitDocument();
                    for (PsiParameter parameter2 : ((PsiMethod)CompletionUtil.getOriginalOrSelf((PsiElement)takeParametersFrom)).getParameterList().getParameters()) {
                        VariableLookupItem.makeFinalIfNeeded(context, (PsiVariable)parameter2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "item";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/completion/SameSignatureCallParametersProvider$2";
                objectArray[2] = "handleInsert";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        element.putUserData(JavaCompletionUtil.SUPER_METHOD_PARAMETERS, (Object)Boolean.TRUE);
        return TailTypeDecorator.withTail((LookupElement)element, (TailType)ExpectedTypesProvider.getFinalCallParameterTailType(call, invoked.getReturnType(), invoked));
    }

    private static Set<Pair<PsiMethod, PsiSubstitutor>> getCallCandidates(PsiCall expression2) {
        PsiMethod chosenMethod = CompletionMemory.getChosenMethod(expression2);
        LinkedHashSet<Pair<PsiMethod, PsiSubstitutor>> candidates = new LinkedHashSet<Pair<PsiMethod, PsiSubstitutor>>();
        JavaResolveResult[] results = expression2 instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expression2).getMethodExpression().multiResolve(false) : new JavaResolveResult[]{expression2.resolveMethodGenerics()};
        PsiMethod toExclude = JavaPsiConstructorUtil.isConstructorCall((PsiElement)expression2) ? (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiMethod.class) : null;
        for (JavaResolveResult candidate : results) {
            PsiClass psiClass;
            PsiElement element = candidate.getElement();
            if (!(element instanceof PsiMethod) || (psiClass = ((PsiMethod)element).getContainingClass()) == null) continue;
            for (Pair overload : psiClass.findMethodsAndTheirSubstitutorsByName(((PsiMethod)element).getName(), true)) {
                if (overload.first == toExclude || chosenMethod != null && !chosenMethod.equals(overload.first)) continue;
                candidates.add((Pair<PsiMethod, PsiSubstitutor>)Pair.create((Object)((PsiMethod)overload.first), (Object)candidate.getSubstitutor().putAll((PsiSubstitutor)overload.second)));
            }
            break;
        }
        return candidates;
    }

    @Nullable
    private static PsiMethod getMethodToTakeParametersFrom(PsiMethod place, PsiMethod invoked, PsiSubstitutor substitutor) {
        if (PsiSuperMethodUtil.isSuperMethod((PsiMethod)place, (PsiMethod)invoked)) {
            return place;
        }
        HashMap<String, PsiType> requiredNames = new HashMap<String, PsiType>();
        PsiParameter[] parameters2 = place.getParameterList().getParameters();
        PsiParameter[] callParams = invoked.getParameterList().getParameters();
        if (callParams.length > parameters2.length) {
            return null;
        }
        boolean checkNames = invoked.isConstructor();
        boolean sameTypes = true;
        for (int i = 0; i < callParams.length; ++i) {
            PsiParameter callParam = callParams[i];
            PsiParameter parameter2 = parameters2[i];
            requiredNames.put(callParam.getName(), substitutor.substitute(callParam.getType()));
            if ((!checkNames || Objects.equals(parameter2.getName(), callParam.getName())) && Comparing.equal((Object)parameter2.getType(), (Object)substitutor.substitute(callParam.getType()))) continue;
            sameTypes = false;
        }
        if (sameTypes && callParams.length == parameters2.length) {
            return place;
        }
        for (PsiParameter parameter3 : parameters2) {
            PsiType type2 = (PsiType)requiredNames.remove(parameter3.getName());
            if (type2 == null || parameter3.getType().equals(type2)) continue;
            return null;
        }
        return requiredNames.isEmpty() ? invoked : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "position";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/completion/SameSignatureCallParametersProvider";
        objectArray[2] = "addSignatureItems";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

