/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.impl.JavaLensConfigurable;
import com.intellij.codeInsight.daemon.impl.MarkerType;
import com.intellij.codeInsight.daemon.impl.analysis.JavaLensSettings;
import com.intellij.codeInsight.daemon.impl.analysis.JavaTelescope;
import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.SequencePresentation;
import com.intellij.codeInsight.hints.settings.InlayHintsConfigurable;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.java.JavaBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.SmartList;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import kotlin.Unit;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLensProvider
implements InlayHintsProvider<JavaLensSettings> {
    private static final String CODE_LENS_ID = "JavaLens";
    public static final String FUS_GROUP_ID = "java.lens";
    private static final String USAGES_CLICKED_EVENT_ID = "usages.clicked";
    private static final String IMPLEMENTATIONS_CLICKED_EVENT_ID = "implementations.clicked";
    private static final String SETTING_CLICKED_EVENT_ID = "setting.clicked";
    private static final SettingsKey<JavaLensSettings> KEY = new SettingsKey("JavaLens");

    @Nullable
    public InlayHintsCollector getCollectorFor(final @NotNull PsiFile file, @NotNull Editor editor, final @NotNull JavaLensSettings settings, @NotNull InlayHintsSink __) {
        if (file == null) {
            JavaLensProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaLensProvider.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            JavaLensProvider.$$$reportNull$$$0(2);
        }
        if (__ == null) {
            JavaLensProvider.$$$reportNull$$$0(3);
        }
        return new FactoryInlayHintsCollector(editor){

            public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
                String usagesHint;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (editor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (sink == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!(element instanceof PsiMember) || element instanceof PsiTypeParameter) {
                    return true;
                }
                PsiElement prevSibling = element.getPrevSibling();
                if (!(prevSibling instanceof PsiWhiteSpace) || !prevSibling.textContains('\n')) {
                    return true;
                }
                PsiMember member = (PsiMember)element;
                if (member.getName() == null) {
                    return true;
                }
                SmartList hints = new SmartList();
                if (settings.isShowUsages() && (usagesHint = JavaTelescope.usagesHint(member, file)) != null) {
                    hints.add(new InlResult(){

                        @Override
                        public void onClick(@NotNull Editor editor, @NotNull PsiElement element, MouseEvent event) {
                            if (editor == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (element == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            FUCounterUsageLogger.getInstance().logEvent(file.getProject(), JavaLensProvider.FUS_GROUP_ID, JavaLensProvider.USAGES_CLICKED_EVENT_ID);
                            GotoDeclarationAction.startFindUsages((Editor)editor, (Project)file.getProject(), (PsiElement)element, (RelativePoint)new RelativePoint(event));
                        }

                        @Override
                        @NotNull
                        public String getRegularText() {
                            String string = usagesHint;
                            if (string == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 2: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 2: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "editor";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "element";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$1$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$1$1";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getRegularText";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "onClick";
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 2: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    });
                }
                if (settings.isShowImplementations()) {
                    int overridings;
                    int inheritors;
                    if (element instanceof PsiClass && (inheritors = JavaTelescope.collectInheritingClasses((PsiClass)element)) != 0) {
                        hints.add(new InlResult(){

                            @Override
                            public void onClick(@NotNull Editor editor, @NotNull PsiElement element, MouseEvent event) {
                                if (editor == null) {
                                    2.$$$reportNull$$$0(0);
                                }
                                if (element == null) {
                                    2.$$$reportNull$$$0(1);
                                }
                                FeatureUsageData data = new FeatureUsageData().addData("location", "class");
                                FUCounterUsageLogger.getInstance().logEvent(file.getProject(), JavaLensProvider.FUS_GROUP_ID, JavaLensProvider.IMPLEMENTATIONS_CLICKED_EVENT_ID, data);
                                GutterIconNavigationHandler<PsiElement> navigationHandler = MarkerType.SUBCLASSED_CLASS.getNavigationHandler();
                                navigationHandler.navigate(event, (PsiElement)((PsiClass)element).getNameIdentifier());
                            }

                            @Override
                            @NotNull
                            public String getRegularText() {
                                String prop = "{0, choice, 1#1 implementation|2#{0,number} implementations}";
                                String string = MessageFormat.format(prop, inheritors);
                                if (string == null) {
                                    2.$$$reportNull$$$0(2);
                                }
                                return string;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                RuntimeException runtimeException;
                                Object[] objectArray;
                                Object[] objectArray2;
                                int n2;
                                String string;
                                switch (n) {
                                    default: {
                                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                        break;
                                    }
                                    case 2: {
                                        string = "@NotNull method %s.%s must not return null";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        n2 = 3;
                                        break;
                                    }
                                    case 2: {
                                        n2 = 2;
                                        break;
                                    }
                                }
                                Object[] objectArray3 = new Object[n2];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "editor";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "element";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$1$2";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$1$2";
                                        break;
                                    }
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "getRegularText";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray;
                                        objectArray[2] = "onClick";
                                        break;
                                    }
                                    case 2: {
                                        break;
                                    }
                                }
                                String string2 = String.format(string, objectArray);
                                switch (n) {
                                    default: {
                                        runtimeException = new IllegalArgumentException(string2);
                                        break;
                                    }
                                    case 2: {
                                        runtimeException = new IllegalStateException(string2);
                                        break;
                                    }
                                }
                                throw runtimeException;
                            }
                        });
                    }
                    if (element instanceof PsiMethod && (overridings = JavaTelescope.collectOverridingMethods((PsiMethod)element)) != 0) {
                        hints.add(new InlResult(){

                            @Override
                            public void onClick(@NotNull Editor editor, @NotNull PsiElement element, MouseEvent event) {
                                if (editor == null) {
                                    3.$$$reportNull$$$0(0);
                                }
                                if (element == null) {
                                    3.$$$reportNull$$$0(1);
                                }
                                FeatureUsageData data = new FeatureUsageData().addData("location", "method");
                                FUCounterUsageLogger.getInstance().logEvent(file.getProject(), JavaLensProvider.FUS_GROUP_ID, JavaLensProvider.IMPLEMENTATIONS_CLICKED_EVENT_ID, data);
                                GutterIconNavigationHandler<PsiElement> navigationHandler = MarkerType.OVERRIDDEN_METHOD.getNavigationHandler();
                                navigationHandler.navigate(event, (PsiElement)((PsiMethod)element).getNameIdentifier());
                            }

                            @Override
                            @NotNull
                            public String getRegularText() {
                                String prop = "{0, choice, 1#1 implementation|2#{0,number} implementations}";
                                String string = MessageFormat.format(prop, overridings);
                                if (string == null) {
                                    3.$$$reportNull$$$0(2);
                                }
                                return string;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                RuntimeException runtimeException;
                                Object[] objectArray;
                                Object[] objectArray2;
                                int n2;
                                String string;
                                switch (n) {
                                    default: {
                                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                        break;
                                    }
                                    case 2: {
                                        string = "@NotNull method %s.%s must not return null";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        n2 = 3;
                                        break;
                                    }
                                    case 2: {
                                        n2 = 2;
                                        break;
                                    }
                                }
                                Object[] objectArray3 = new Object[n2];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "editor";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "element";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$1$3";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$1$3";
                                        break;
                                    }
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "getRegularText";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray;
                                        objectArray[2] = "onClick";
                                        break;
                                    }
                                    case 2: {
                                        break;
                                    }
                                }
                                String string2 = String.format(string, objectArray);
                                switch (n) {
                                    default: {
                                        runtimeException = new IllegalArgumentException(string2);
                                        break;
                                    }
                                    case 2: {
                                        runtimeException = new IllegalStateException(string2);
                                        break;
                                    }
                                }
                                throw runtimeException;
                            }
                        });
                    }
                }
                if (!hints.isEmpty()) {
                    PresentationFactory factory = this.getFactory();
                    Document document = editor.getDocument();
                    int offset = JavaLensProvider.getAnchorOffset(element);
                    int line = document.getLineNumber(offset);
                    int startOffset = document.getLineStartOffset(line);
                    int column = offset - startOffset;
                    SmartList presentations2 = new SmartList();
                    presentations2.add(factory.textSpacePlaceholder(column, true));
                    for (InlResult inlResult : hints) {
                        presentations2.add(JavaLensProvider.createPresentation(factory, element, editor, inlResult));
                        presentations2.add(factory.textSpacePlaceholder(1, true));
                    }
                    SequencePresentation shiftedPresentation = new SequencePresentation((List)presentations2);
                    InlayPresentation withSettings = JavaLensProvider.addSettings(element.getProject(), factory, (InlayPresentation)shiftedPresentation);
                    sink.addBlockElement(startOffset, true, true, 0, withSettings);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "editor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "sink";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider$1";
                objectArray[2] = "collect";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static int getAnchorOffset(PsiElement element) {
        for (PsiElement child : element.getChildren()) {
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            return child.getTextRange().getStartOffset();
        }
        return element.getTextRange().getStartOffset();
    }

    @NotNull
    private static InlayPresentation createPresentation(@NotNull PresentationFactory factory, @NotNull PsiElement element, @NotNull Editor editor, @NotNull InlResult result) {
        if (factory == null) {
            JavaLensProvider.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JavaLensProvider.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            JavaLensProvider.$$$reportNull$$$0(6);
        }
        if (result == null) {
            JavaLensProvider.$$$reportNull$$$0(7);
        }
        InlayPresentation text2 = factory.smallText(result.getRegularText());
        InlayPresentation inlayPresentation = factory.referenceOnHover(text2, (event, translated) -> result.onClick(editor, element, event));
        if (inlayPresentation == null) {
            JavaLensProvider.$$$reportNull$$$0(8);
        }
        return inlayPresentation;
    }

    private static InlayPresentation addSettings(@NotNull Project project, @NotNull PresentationFactory factory, @NotNull InlayPresentation presentation) {
        if (project == null) {
            JavaLensProvider.$$$reportNull$$$0(9);
        }
        if (factory == null) {
            JavaLensProvider.$$$reportNull$$$0(10);
        }
        if (presentation == null) {
            JavaLensProvider.$$$reportNull$$$0(11);
        }
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem item = new JMenuItem(JavaBundle.message((String)"button.text.settings", (Object[])new Object[0]));
        item.addActionListener(e -> {
            FUCounterUsageLogger.getInstance().logEvent(project, FUS_GROUP_ID, SETTING_CLICKED_EVENT_ID);
            JavaLensProvider.openSettings((Language)JavaLanguage.INSTANCE, project);
        });
        popupMenu.add(item);
        return factory.onClick(presentation, MouseButton.Right, (e, __) -> {
            popupMenu.show(e.getComponent(), e.getX(), e.getY());
            return Unit.INSTANCE;
        });
    }

    public static void openSettings(@NotNull Language language, @NotNull Project project) {
        if (language == null) {
            JavaLensProvider.$$$reportNull$$$0(12);
        }
        if (project == null) {
            JavaLensProvider.$$$reportNull$$$0(13);
        }
        InlayHintsConfigurable.showSettingsDialogForLanguage((Project)project, (Language)language, model -> model.getId().equals(CODE_LENS_ID));
    }

    public static JavaLensSettings getSettings() {
        return (JavaLensSettings)InlayHintsSettings.instance().findSettings(KEY, (Language)JavaLanguage.INSTANCE, JavaLensSettings::new);
    }

    @NotNull
    public JavaLensSettings createSettings() {
        return new JavaLensSettings();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = JavaBundle.message((String)"title.lenses", (Object[])new Object[0]);
        if (string == null) {
            JavaLensProvider.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public SettingsKey<JavaLensSettings> getKey() {
        SettingsKey<JavaLensSettings> settingsKey = KEY;
        if (settingsKey == null) {
            JavaLensProvider.$$$reportNull$$$0(15);
        }
        return settingsKey;
    }

    @Nullable
    public String getPreviewText() {
        return null;
    }

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull JavaLensSettings settings) {
        if (settings == null) {
            JavaLensProvider.$$$reportNull$$$0(16);
        }
        return new JavaLensConfigurable(settings);
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        if (language == null) {
            JavaLensProvider.$$$reportNull$$$0(17);
        }
        return true;
    }

    public boolean isVisibleInSettings() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "__";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaLensProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCollectorFor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 8: 
            case 14: 
            case 15: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addSettings";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "openSettings";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isLanguageSupported";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface InlResult {
        public void onClick(@NotNull Editor var1, @NotNull PsiElement var2, MouseEvent var3);

        @NotNull
        public String getRegularText();
    }
}

