/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.analysis.JavaModuleGraphUtil;
import com.intellij.icons.AllIcons;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUsesStatement;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaServiceUtil {
    static final CallMatcher SERVICE_LOADER_LOAD = CallMatcher.staticCall("java.util.ServiceLoader", "load", "loadInstalled");

    JavaServiceUtil() {
    }

    static boolean isServiceProviderMethod(@NotNull PsiMethod method) {
        if (method == null) {
            JavaServiceUtil.$$$reportNull$$$0(0);
        }
        return "provider".equals(method.getName()) && method.getParameterList().isEmpty() && method.hasModifierProperty("public") && method.hasModifierProperty("static");
    }

    @NotNull
    static List<LineMarkerInfo<PsiElement>> collectServiceProviderMethod(@NotNull PsiMethod method) {
        if (method == null) {
            JavaServiceUtil.$$$reportNull$$$0(1);
        }
        PsiClass containingClass = method.getContainingClass();
        PsiClass resultClass = PsiUtil.resolveClassInType((PsiType)method.getReturnType());
        return JavaServiceUtil.createJavaServiceLineMarkerInfo(method.getNameIdentifier(), containingClass, resultClass);
    }

    @NotNull
    static List<LineMarkerInfo<PsiElement>> collectServiceImplementationClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            JavaServiceUtil.$$$reportNull$$$0(2);
        }
        return JavaServiceUtil.createJavaServiceLineMarkerInfo(psiClass.getNameIdentifier(), psiClass, psiClass);
    }

    @NotNull
    private static List<LineMarkerInfo<PsiElement>> createJavaServiceLineMarkerInfo(@Nullable PsiIdentifier identifier, @Nullable PsiClass implementerClass, @Nullable PsiClass resultClass) {
        PsiJavaModule javaModule;
        String implementerClassName;
        if (identifier != null && implementerClass != null && resultClass != null && (implementerClassName = implementerClass.getQualifiedName()) != null && PsiUtil.isLanguageLevel9OrHigher((PsiElement)identifier) && (javaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)identifier)) != null) {
            for (PsiProvidesStatement providesStatement : javaModule.getProvides()) {
                PsiClassType[] implementationTypes;
                PsiClassType interfaceType = providesStatement.getInterfaceType();
                PsiReferenceList implementationList = providesStatement.getImplementationList();
                if (interfaceType == null || implementationList == null) continue;
                for (PsiClassType implementationType : implementationTypes = implementationList.getReferencedTypes()) {
                    String interfaceClassName;
                    PsiClass interfaceClass;
                    if (!implementerClass.equals(implementationType.resolve()) || !InheritanceUtil.isInheritorOrSelf((PsiClass)resultClass, (PsiClass)(interfaceClass = interfaceType.resolve()), (boolean)true) || (interfaceClassName = interfaceClass.getQualifiedName()) == null) continue;
                    LineMarkerInfo info = new LineMarkerInfo((PsiElement)identifier, identifier.getTextRange(), AllIcons.Gutter.Java9Service, e -> JavaAnalysisBundle.message((String)"service.provides", (Object[])new Object[]{interfaceClassName}), (GutterIconNavigationHandler)new ServiceProvidesNavigationHandler(interfaceClassName, implementerClassName), GutterIconRenderer.Alignment.LEFT);
                    List<LineMarkerInfo<PsiElement>> list = Collections.singletonList(info);
                    if (list == null) {
                        JavaServiceUtil.$$$reportNull$$$0(3);
                    }
                    return list;
                }
            }
        }
        List<LineMarkerInfo<PsiElement>> list = Collections.emptyList();
        if (list == null) {
            JavaServiceUtil.$$$reportNull$$$0(4);
        }
        return list;
    }

    static List<LineMarkerInfo<PsiElement>> collectServiceLoaderLoadCall(@NotNull PsiIdentifier identifier, @NotNull PsiMethodCallExpression methodCall) {
        if (identifier == null) {
            JavaServiceUtil.$$$reportNull$$$0(5);
        }
        if (methodCall == null) {
            JavaServiceUtil.$$$reportNull$$$0(6);
        }
        if (PsiUtil.isLanguageLevel9OrHigher((PsiElement)methodCall)) {
            PsiJavaModule javaModule;
            String qualifiedName;
            PsiClass psiClass;
            PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
            JavaReflectionReferenceUtil.ReflectiveType serviceType = null;
            for (int i = 0; i < arguments.length && serviceType == null; ++i) {
                serviceType = JavaReflectionReferenceUtil.getReflectiveType(arguments[i]);
            }
            if (serviceType != null && serviceType.isExact() && (psiClass = serviceType.getPsiClass()) != null && (qualifiedName = psiClass.getQualifiedName()) != null && (javaModule = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)methodCall)) != null) {
                for (PsiUsesStatement statement : javaModule.getUses()) {
                    PsiClassType usedClass = statement.getClassType();
                    if (usedClass == null || !psiClass.equals(usedClass.resolve())) continue;
                    LineMarkerInfo info = new LineMarkerInfo((PsiElement)identifier, identifier.getTextRange(), AllIcons.Gutter.Java9Service, e -> JavaAnalysisBundle.message((String)"service.uses", (Object[])new Object[]{qualifiedName}), (GutterIconNavigationHandler)new ServiceUsesNavigationHandler(qualifiedName), GutterIconRenderer.Alignment.LEFT);
                    return Collections.singletonList(info);
                }
            }
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaServiceUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaServiceUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createJavaServiceLineMarkerInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isServiceProviderMethod";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "collectServiceProviderMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectServiceImplementationClass";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectServiceLoaderLoadCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ServiceProvidesNavigationHandler
    extends ServiceNavigationHandler {
        private final String myImplementerClassName;

        ServiceProvidesNavigationHandler(@NotNull String interfaceClassName, @NotNull String implementerClassName) {
            if (interfaceClassName == null) {
                ServiceProvidesNavigationHandler.$$$reportNull$$$0(0);
            }
            if (implementerClassName == null) {
                ServiceProvidesNavigationHandler.$$$reportNull$$$0(1);
            }
            super(interfaceClassName);
            this.myImplementerClassName = implementerClassName;
        }

        @Override
        public PsiJavaCodeReferenceElement findTargetReference(@NotNull PsiJavaModule module) {
            PsiReferenceList list;
            PsiProvidesStatement statement;
            if (module == null) {
                ServiceProvidesNavigationHandler.$$$reportNull$$$0(2);
            }
            if ((statement = (PsiProvidesStatement)ContainerUtil.find((Iterable)module.getProvides(), this::isTargetStatement)) != null && (list = statement.getImplementationList()) != null) {
                return (PsiJavaCodeReferenceElement)ContainerUtil.find((Object[])list.getReferenceElements(), this::isTargetReference);
            }
            return null;
        }

        @Override
        @NotNull
        protected String getTargetFQN() {
            String string = this.myImplementerClassName;
            if (string == null) {
                ServiceProvidesNavigationHandler.$$$reportNull$$$0(3);
            }
            return string;
        }

        private boolean isTargetStatement(@NotNull PsiProvidesStatement statement) {
            PsiJavaCodeReferenceElement reference;
            if (statement == null) {
                ServiceProvidesNavigationHandler.$$$reportNull$$$0(4);
            }
            return (reference = statement.getInterfaceReference()) != null && this.myInterfaceClassName.equals(reference.getQualifiedName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interfaceClassName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "implementerClassName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaServiceUtil$ServiceProvidesNavigationHandler";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaServiceUtil$ServiceProvidesNavigationHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetFQN";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findTargetReference";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isTargetStatement";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ServiceUsesNavigationHandler
    extends ServiceNavigationHandler {
        ServiceUsesNavigationHandler(String interfaceClassName) {
            super(interfaceClassName);
        }

        @Override
        public PsiJavaCodeReferenceElement findTargetReference(@NotNull PsiJavaModule module) {
            if (module == null) {
                ServiceUsesNavigationHandler.$$$reportNull$$$0(0);
            }
            return StreamEx.of(module.getUses().iterator()).map(PsiUsesStatement::getClassReference).findAny(this::isTargetReference).orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/codeInsight/daemon/impl/JavaServiceUtil$ServiceUsesNavigationHandler", "findTargetReference"));
        }
    }

    static abstract class ServiceNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        final String myInterfaceClassName;

        ServiceNavigationHandler(@NotNull String interfaceClassName) {
            if (interfaceClassName == null) {
                ServiceNavigationHandler.$$$reportNull$$$0(0);
            }
            this.myInterfaceClassName = interfaceClassName;
        }

        public void navigate(MouseEvent e, PsiElement element) {
            Optional.ofNullable(JavaModuleGraphUtil.findDescriptorByElement(element)).map(this::findTargetReference).filter(NavigationItem.class::isInstance).map(NavigationItem.class::cast).ifPresent(item -> item.navigate(true));
        }

        public abstract PsiJavaCodeReferenceElement findTargetReference(@NotNull PsiJavaModule var1);

        @NotNull
        protected String getTargetFQN() {
            String string = this.myInterfaceClassName;
            if (string == null) {
                ServiceNavigationHandler.$$$reportNull$$$0(1);
            }
            return string;
        }

        boolean isTargetReference(PsiJavaCodeReferenceElement reference) {
            return reference != null && this.getTargetFQN().equals(reference.getQualifiedName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interfaceClassName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/JavaServiceUtil$ServiceNavigationHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaServiceUtil$ServiceNavigationHandler";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetFQN";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

