/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public enum HighlightingFeature {
    GENERICS(LanguageLevel.JDK_1_5, "feature.generics"),
    ANNOTATIONS(LanguageLevel.JDK_1_5, "feature.annotations"),
    STATIC_IMPORTS(LanguageLevel.JDK_1_5, "feature.static.imports"),
    FOR_EACH(LanguageLevel.JDK_1_5, "feature.for.each"),
    VARARGS(LanguageLevel.JDK_1_5, "feature.varargs"),
    HEX_FP_LITERALS(LanguageLevel.JDK_1_5, "feature.hex.fp.literals"),
    DIAMOND_TYPES(LanguageLevel.JDK_1_7, "feature.diamond.types"),
    MULTI_CATCH(LanguageLevel.JDK_1_7, "feature.multi.catch"),
    TRY_WITH_RESOURCES(LanguageLevel.JDK_1_7, "feature.try.with.resources"),
    BIN_LITERALS(LanguageLevel.JDK_1_7, "feature.binary.literals"),
    UNDERSCORES(LanguageLevel.JDK_1_7, "feature.underscores.in.literals"),
    EXTENSION_METHODS(LanguageLevel.JDK_1_8, "feature.extension.methods"),
    METHOD_REFERENCES(LanguageLevel.JDK_1_8, "feature.method.references"),
    LAMBDA_EXPRESSIONS(LanguageLevel.JDK_1_8, "feature.lambda.expressions"),
    TYPE_ANNOTATIONS(LanguageLevel.JDK_1_8, "feature.type.annotations"),
    RECEIVERS(LanguageLevel.JDK_1_8, "feature.type.receivers"),
    INTERSECTION_CASTS(LanguageLevel.JDK_1_8, "feature.intersections.in.casts"),
    STATIC_INTERFACE_CALLS(LanguageLevel.JDK_1_8, "feature.static.interface.calls"),
    REFS_AS_RESOURCE(LanguageLevel.JDK_1_9, "feature.try.with.resources.refs"),
    MODULES(LanguageLevel.JDK_1_9, "feature.modules"),
    LVTI(LanguageLevel.JDK_10, "feature.lvti"),
    VAR_LAMBDA_PARAMETER(LanguageLevel.JDK_11, "feature.var.lambda.parameter"),
    ENHANCED_SWITCH(LanguageLevel.JDK_14, "feature.enhanced.switch"),
    SWITCH_EXPRESSION(LanguageLevel.JDK_14, "feature.switch.expressions"),
    RECORDS(LanguageLevel.JDK_14_PREVIEW, "feature.records"),
    PATTERNS(LanguageLevel.JDK_14_PREVIEW, "feature.patterns.instanceof"),
    TEXT_BLOCK_ESCAPES(LanguageLevel.JDK_14_PREVIEW, "feature.text.block.escape.sequences"){

        @Override
        boolean isSufficient(@NotNull LanguageLevel useSiteLevel) {
            if (useSiteLevel == null) {
                1.$$$reportNull$$$0(0);
            }
            return useSiteLevel.isAtLeast(LanguageLevel.JDK_14_PREVIEW);
        }

        @Override
        LanguageLevel getStandardLevel() {
            return LanguageLevel.JDK_15;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useSiteLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightingFeature$1", "isSufficient"));
        }
    }
    ,
    TEXT_BLOCKS(LanguageLevel.JDK_14_PREVIEW, "feature.text.blocks"){

        @Override
        boolean isSufficient(@NotNull LanguageLevel useSiteLevel) {
            if (useSiteLevel == null) {
                2.$$$reportNull$$$0(0);
            }
            return useSiteLevel.isAtLeast(LanguageLevel.JDK_14_PREVIEW);
        }

        @Override
        LanguageLevel getStandardLevel() {
            return LanguageLevel.JDK_15;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "useSiteLevel", "com/intellij/codeInsight/daemon/impl/analysis/HighlightingFeature$2", "isSufficient"));
        }
    }
    ,
    SEALED_CLASSES(LanguageLevel.JDK_15_PREVIEW, "feature.sealed.classes"),
    LOCAL_INTERFACES(LanguageLevel.JDK_15_PREVIEW, "feature.local.interfaces"),
    LOCAL_ENUMS(LanguageLevel.JDK_15_PREVIEW, "feature.local.enums");

    final LanguageLevel level;
    @PropertyKey(resourceBundle="messages.JavaErrorBundle")
    final String key;

    private HighlightingFeature(LanguageLevel level, String key2) {
        if (level == null) {
            HighlightingFeature.$$$reportNull$$$0(0);
        }
        if (key2 == null) {
            HighlightingFeature.$$$reportNull$$$0(1);
        }
        this.level = level;
        this.key = key2;
    }

    public boolean isAvailable(@NotNull PsiElement element) {
        if (element == null) {
            HighlightingFeature.$$$reportNull$$$0(2);
        }
        return this.isSufficient(PsiUtil.getLanguageLevel((PsiElement)element));
    }

    boolean isSufficient(@NotNull LanguageLevel useSiteLevel) {
        if (useSiteLevel == null) {
            HighlightingFeature.$$$reportNull$$$0(3);
        }
        return useSiteLevel.isAtLeast(this.level) && (!this.level.isPreview() || useSiteLevel.isPreview());
    }

    LanguageLevel getStandardLevel() {
        return this.level.isPreview() ? null : this.level;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useSiteLevel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightingFeature";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSufficient";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

