/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingFeature;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiTypeElement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class JavaFutureKeywordUseFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiJavaCodeReferenceElement> {
    public void registerFixes(@NotNull PsiJavaCodeReferenceElement ref, @NotNull QuickFixActionRegistrar registrar) {
        PsiTypeElement typeElement;
        if (ref == null) {
            JavaFutureKeywordUseFixProvider.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            JavaFutureKeywordUseFixProvider.$$$reportNull$$$0(1);
        }
        if ((typeElement = (PsiTypeElement)ObjectUtils.tryCast((Object)ref.getParent(), PsiTypeElement.class)) == null || typeElement.getFirstChild() != typeElement.getLastChild()) {
            return;
        }
        PsiElement parent = typeElement.getParent();
        if ("var".equals(ref.getReferenceName())) {
            JavaFutureKeywordUseFixProvider.registerVarLanguageLevelFix(ref, parent, registrar);
        }
        if ("record".equals(ref.getReferenceName())) {
            JavaFutureKeywordUseFixProvider.registerRecordLanguageLevelFix(ref, parent, registrar);
        }
    }

    private static void registerRecordLanguageLevelFix(@NotNull PsiJavaCodeReferenceElement ref, PsiElement parent, @NotNull QuickFixActionRegistrar registrar) {
        if (ref == null) {
            JavaFutureKeywordUseFixProvider.$$$reportNull$$$0(2);
        }
        if (registrar == null) {
            JavaFutureKeywordUseFixProvider.$$$reportNull$$$0(3);
        }
        if ((parent instanceof PsiMethod || parent instanceof PsiField) && parent.getParent() instanceof PsiClass) {
            HighlightUtil.registerIncreaseLanguageLevelFixes(registrar, (PsiElement)ref, HighlightingFeature.RECORDS);
        }
        if (parent instanceof PsiLocalVariable && parent.getParent() instanceof PsiDeclarationStatement && ((PsiDeclarationStatement)parent.getParent()).getDeclaredElements().length == 1) {
            HighlightUtil.registerIncreaseLanguageLevelFixes(registrar, (PsiElement)ref, HighlightingFeature.RECORDS);
        }
    }

    private static void registerVarLanguageLevelFix(@NotNull PsiJavaCodeReferenceElement ref, PsiElement parent, @NotNull QuickFixActionRegistrar registrar) {
        if (ref == null) {
            JavaFutureKeywordUseFixProvider.$$$reportNull$$$0(4);
        }
        if (registrar == null) {
            JavaFutureKeywordUseFixProvider.$$$reportNull$$$0(5);
        }
        HighlightingFeature feature = parent instanceof PsiParameter && ((PsiParameter)parent).getDeclarationScope() instanceof PsiLambdaExpression ? HighlightingFeature.VAR_LAMBDA_PARAMETER : HighlightingFeature.LVTI;
        HighlightUtil.registerIncreaseLanguageLevelFixes(registrar, (PsiElement)ref, feature);
    }

    @NotNull
    public Class<PsiJavaCodeReferenceElement> getReferenceClass() {
        return PsiJavaCodeReferenceElement.class;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaFutureKeywordUseFixProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerFixes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "registerRecordLanguageLevelFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "registerVarLanguageLevelFix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

