/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.java.stubs.index.JavaModuleNameIndex;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JavaModuleGraphUtil {
    private JavaModuleGraphUtil() {
    }

    @Nullable
    public static PsiJavaModule findDescriptorByElement(@Nullable PsiElement element) {
        if (element != null) {
            PsiFileSystemItem fsItem;
            Object object = fsItem = element instanceof PsiFileSystemItem ? (PsiFileSystemItem)element : element.getContainingFile();
            if (fsItem != null) {
                return JavaModuleGraphUtil.findDescriptorByFile(fsItem.getVirtualFile(), fsItem.getProject());
            }
        }
        return null;
    }

    @Nullable
    public static PsiJavaModule findDescriptorByFile(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            return null;
        }
        ProjectFileIndex index = ProjectFileIndex.SERVICE.getInstance((Project)project);
        if (index.isInLibrary(file)) {
            VirtualFile root = index.getClassRootForFile(file);
            if (root != null) {
                VirtualFile descriptorFile = JavaModuleNameIndex.descriptorFile(root);
                if (descriptorFile != null) {
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(descriptorFile);
                    if (psiFile instanceof PsiJavaFile) {
                        return ((PsiJavaFile)psiFile).getModuleDeclaration();
                    }
                } else if (root.getFileSystem() instanceof JarFileSystem && "jar".equalsIgnoreCase(root.getExtension())) {
                    return LightJavaModule.findModule(PsiManager.getInstance((Project)project), root);
                }
            }
        } else {
            return JavaModuleGraphUtil.findDescriptorByModule(index.getModuleForFile(file), index.isInTestSourceContent(file));
        }
        return null;
    }

    @Nullable
    public static PsiJavaModule findDescriptorByModule(@Nullable Module module, boolean inTests) {
        if (module != null) {
            VirtualFile manifest;
            String name2;
            JavaSourceRootType rootType = inTests ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE;
            List files = ContainerUtil.mapNotNull((Collection)ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)rootType), root -> root.findChild("module-info.java"));
            if (files.size() == 1) {
                PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile((VirtualFile)files.get(0));
                if (psiFile instanceof PsiJavaFile) {
                    return ((PsiJavaFile)psiFile).getModuleDeclaration();
                }
            } else if (files.isEmpty() && (files = ContainerUtil.mapNotNull((Collection)ModuleRootManager.getInstance((Module)module).getSourceRoots((JpsModuleSourceRootType)rootType), root -> root.findFileByRelativePath("META-INF/MANIFEST.MF"))).size() == 1 && (name2 = LightJavaModule.claimedModuleName(manifest = (VirtualFile)files.get(0))) != null) {
                return LightJavaModule.findModule(PsiManager.getInstance((Project)module.getProject()), manifest.getParent().getParent());
            }
        }
        return null;
    }

    @NotNull
    public static Collection<PsiJavaModule> findCycle(@NotNull PsiJavaModule module) {
        if (module == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(1);
        }
        Project project = module.getProject();
        List cycles = (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create(JavaModuleGraphUtil.findCycles(project), (Object[])new Object[]{JavaModuleGraphUtil.cacheDependency()}));
        Collection collection = (Collection)ObjectUtils.notNull((Object)((Collection)ContainerUtil.find((Iterable)cycles, set -> set.contains(module))), Collections.emptyList());
        if (collection == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(2);
        }
        return collection;
    }

    public static boolean exports(@NotNull PsiJavaModule source, @NotNull String packageName, @Nullable PsiJavaModule target) {
        Map exports;
        Set targets;
        if (source == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(3);
        }
        if (packageName == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(4);
        }
        return (targets = (Set)(exports = (Map)CachedValuesManager.getCachedValue((PsiElement)source, () -> CachedValueProvider.Result.create(JavaModuleGraphUtil.exportsMap(source), (Object[])new Object[]{source.getContainingFile()}))).get(packageName)) != null && (targets.isEmpty() || target != null && targets.contains(target.getName()));
    }

    public static boolean reads(@NotNull PsiJavaModule source, @NotNull PsiJavaModule destination) {
        if (source == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(5);
        }
        if (destination == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(6);
        }
        return JavaModuleGraphUtil.getRequiresGraph(source).reads(source, destination);
    }

    @NotNull
    public static Set<PsiJavaModule> getAllDependencies(PsiJavaModule source) {
        Set<PsiJavaModule> set = JavaModuleGraphUtil.getRequiresGraph(source).getAllDependencies(source);
        if (set == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(7);
        }
        return set;
    }

    @Nullable
    public static Trinity<String, PsiJavaModule, PsiJavaModule> findConflict(@NotNull PsiJavaModule module) {
        if (module == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(8);
        }
        return JavaModuleGraphUtil.getRequiresGraph(module).findConflict(module);
    }

    @Nullable
    public static PsiJavaModule findOrigin(@NotNull PsiJavaModule module, @NotNull String packageName) {
        if (module == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(9);
        }
        if (packageName == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(10);
        }
        return JavaModuleGraphUtil.getRequiresGraph(module).findOrigin(module, packageName);
    }

    private static Object cacheDependency() {
        return PsiModificationTracker.MODIFICATION_COUNT;
    }

    @NotNull
    private static List<Set<PsiJavaModule>> findCycles(Project project) {
        HashSet<PsiJavaModule> projectModules = new HashSet<PsiJavaModule>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            List descriptors = ContainerUtil.mapNotNull((Object[])ModuleRootManager.getInstance((Module)module).getSourceRoots(true), root -> JavaModuleGraphUtil.findDescriptorByFile(root, project));
            if (descriptors.size() > 1) {
                List<Set<PsiJavaModule>> list = Collections.emptyList();
                if (list == null) {
                    JavaModuleGraphUtil.$$$reportNull$$$0(11);
                }
                return list;
            }
            if (descriptors.size() != 1) continue;
            projectModules.add((PsiJavaModule)descriptors.get(0));
        }
        if (!projectModules.isEmpty()) {
            ChameleonGraph graph;
            DFSTBuilder builder;
            Collection components;
            MultiMap relations = MultiMap.create();
            for (PsiJavaModule module : projectModules) {
                for (PsiRequiresStatement statement : module.getRequires()) {
                    PsiJavaModule dependency;
                    ResolveResult[] results;
                    PsiJavaModuleReference ref = statement.getModuleReference();
                    if (ref == null || (results = ref.multiResolve(true)).length != 1 || (dependency = (PsiJavaModule)results[0].getElement()) == null || !projectModules.contains(dependency)) continue;
                    relations.putValue((Object)module, (Object)dependency);
                }
            }
            if (!relations.isEmpty() && !(components = (builder = new DFSTBuilder(graph = new ChameleonGraph(relations, false))).getComponents()).isEmpty()) {
                List list = ContainerUtil.map((Collection)components, elements -> new LinkedHashSet(elements));
                if (list == null) {
                    JavaModuleGraphUtil.$$$reportNull$$$0(12);
                }
                return list;
            }
        }
        List<Set<PsiJavaModule>> list = Collections.emptyList();
        if (list == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static Map<String, Set<String>> exportsMap(@NotNull PsiJavaModule source) {
        if (source == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(14);
        }
        HashMap<String, Set<String>> map2 = new HashMap<String, Set<String>>();
        for (PsiPackageAccessibilityStatement statement : source.getExports()) {
            String pkg = statement.getPackageName();
            List targets = statement.getModuleNames();
            map2.put(pkg, (Set<String>)(targets.isEmpty() ? Collections.emptySet() : new THashSet((Collection)targets)));
        }
        return map2;
    }

    private static RequiresGraph getRequiresGraph(PsiJavaModule module) {
        Project project = module.getProject();
        return (RequiresGraph)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create((Object)JavaModuleGraphUtil.buildRequiresGraph(project), (Object[])new Object[]{JavaModuleGraphUtil.cacheDependency()}));
    }

    private static RequiresGraph buildRequiresGraph(Project project) {
        MultiMap relations = MultiMap.create();
        THashSet transitiveEdges = new THashSet();
        JavaModuleNameIndex index = JavaModuleNameIndex.getInstance();
        GlobalSearchScope scope = ProjectScope.getAllScope((Project)project);
        for (String key2 : index.getAllKeys(project)) {
            for (PsiJavaModule module : index.get(key2, project, scope)) {
                JavaModuleGraphUtil.visit(module, (MultiMap<PsiJavaModule, PsiJavaModule>)relations, (Set<String>)transitiveEdges);
            }
        }
        Graph graph = GraphGenerator.generate(new ChameleonGraph(relations, true));
        return new RequiresGraph(graph, (Set)transitiveEdges);
    }

    private static void visit(PsiJavaModule module, MultiMap<PsiJavaModule, PsiJavaModule> relations, Set<String> transitiveEdges) {
        if (!(module instanceof LightJavaModule) && !relations.containsKey((Object)module)) {
            PsiJavaModule javaBase;
            relations.putValues((Object)module, Collections.emptyList());
            boolean explicitJavaBase = false;
            for (PsiRequiresStatement statement : module.getRequires()) {
                PsiJavaModuleReference ref = statement.getModuleReference();
                if (ref == null) continue;
                if ("java.base".equals(ref.getCanonicalText())) {
                    explicitJavaBase = true;
                }
                for (ResolveResult result : ref.multiResolve(false)) {
                    PsiJavaModule dependency = (PsiJavaModule)result.getElement();
                    assert (dependency != null) : result;
                    relations.putValue((Object)module, (Object)dependency);
                    if (statement.hasModifierProperty("transitive")) {
                        transitiveEdges.add(RequiresGraph.key(dependency, module));
                    }
                    JavaModuleGraphUtil.visit(dependency, relations, transitiveEdges);
                }
            }
            if (!explicitJavaBase && (javaBase = JavaPsiFacade.getInstance((Project)module.getProject()).findModule("java.base", module.getResolveScope())) != null) {
                relations.putValue((Object)module, (Object)javaBase);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil";
                break;
            }
            case 3: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destination";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findCycle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependencies";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findCycles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptorByFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findCycle";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exports";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reads";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findConflict";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findOrigin";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "exportsMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChameleonGraph<N>
    implements Graph<N> {
        private final Set<N> myNodes = new THashSet();
        private final MultiMap<N, N> myEdges;
        private final boolean myInbound;

        private ChameleonGraph(MultiMap<N, N> edges, boolean inbound) {
            edges.entrySet().forEach(e -> {
                this.myNodes.add(e.getKey());
                this.myNodes.addAll((Collection)e.getValue());
            });
            this.myEdges = edges;
            this.myInbound = inbound;
        }

        @NotNull
        public Collection<N> getNodes() {
            Set<N> set = this.myNodes;
            if (set == null) {
                ChameleonGraph.$$$reportNull$$$0(0);
            }
            return set;
        }

        @NotNull
        public Iterator<N> getIn(N n) {
            Iterator<Object> iterator = this.myInbound ? this.myEdges.get(n).iterator() : Collections.emptyIterator();
            if (iterator == null) {
                ChameleonGraph.$$$reportNull$$$0(1);
            }
            return iterator;
        }

        @NotNull
        public Iterator<N> getOut(N n) {
            Iterator<Object> iterator = this.myInbound ? Collections.emptyIterator() : this.myEdges.get(n).iterator();
            if (iterator == null) {
                ChameleonGraph.$$$reportNull$$$0(2);
            }
            return iterator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil$ChameleonGraph";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNodes";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIn";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOut";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private static class RequiresGraph {
        private final Graph<PsiJavaModule> myGraph;
        private final Set<String> myTransitiveEdges;

        private RequiresGraph(Graph<PsiJavaModule> graph, Set<String> transitiveEdges) {
            this.myGraph = graph;
            this.myTransitiveEdges = transitiveEdges;
        }

        public boolean reads(PsiJavaModule source, PsiJavaModule destination) {
            Collection nodes = this.myGraph.getNodes();
            if (nodes.contains(destination) && nodes.contains(source)) {
                Iterator directReaders = this.myGraph.getOut((Object)destination);
                while (directReaders.hasNext()) {
                    PsiJavaModule next = (PsiJavaModule)directReaders.next();
                    if (!source.equals(next) && (!this.myTransitiveEdges.contains(RequiresGraph.key(destination, next)) || !this.reads(source, next))) continue;
                    return true;
                }
            }
            return false;
        }

        public Trinity<String, PsiJavaModule, PsiJavaModule> findConflict(PsiJavaModule source) {
            HashMap exports = new HashMap();
            return this.processExports(source, (pkg, m) -> {
                PsiJavaModule existing = exports.put(pkg, m);
                return existing != null ? new Trinity(pkg, (Object)existing, m) : null;
            });
        }

        public PsiJavaModule findOrigin(PsiJavaModule module, String packageName) {
            return this.processExports(module, (pkg, m) -> packageName.equals(pkg) ? m : null);
        }

        private <T> T processExports(PsiJavaModule start, BiFunction<String, PsiJavaModule, T> processor2) {
            return this.myGraph.getNodes().contains(start) ? (T)this.processExports(start.getName(), start, 0, new HashSet<PsiJavaModule>(), processor2) : null;
        }

        private <T> T processExports(String name2, PsiJavaModule module, int layer, Set<PsiJavaModule> visited, BiFunction<String, PsiJavaModule, T> processor2) {
            if (visited.add(module)) {
                if (layer == 1) {
                    for (PsiPackageAccessibilityStatement statement : module.getExports()) {
                        T result;
                        List exportTargets = statement.getModuleNames();
                        if (!exportTargets.isEmpty() && !exportTargets.contains(name2) || (result = processor2.apply(statement.getPackageName(), module)) == null) continue;
                        return result;
                    }
                }
                if (layer < 2) {
                    Iterator iterator = this.myGraph.getIn((Object)module);
                    while (iterator.hasNext()) {
                        T result;
                        PsiJavaModule dependency = (PsiJavaModule)iterator.next();
                        if (layer != 0 && !this.myTransitiveEdges.contains(RequiresGraph.key(dependency, module)) || (result = this.processExports(name2, dependency, 1, visited, processor2)) == null) continue;
                        return result;
                    }
                }
            }
            return null;
        }

        public static String key(PsiJavaModule module, PsiJavaModule exporter) {
            return module.getName() + '/' + exporter.getName();
        }

        @NotNull
        public Set<PsiJavaModule> getAllDependencies(PsiJavaModule module) {
            HashSet<PsiJavaModule> requires = new HashSet<PsiJavaModule>();
            this.collectDependencies(module, requires);
            HashSet<PsiJavaModule> hashSet = requires;
            if (hashSet == null) {
                RequiresGraph.$$$reportNull$$$0(0);
            }
            return hashSet;
        }

        private void collectDependencies(PsiJavaModule module, Set<PsiJavaModule> dependencies) {
            Iterator iterator = this.myGraph.getIn((Object)module);
            while (iterator.hasNext()) {
                PsiJavaModule dependency = (PsiJavaModule)iterator.next();
                if (dependencies.contains(dependency)) continue;
                dependencies.add(dependency);
                this.collectDependencies(dependency, dependencies);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil$RequiresGraph", "getAllDependencies"));
        }
    }
}

