/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddExceptionToCatchFix
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(AddExceptionToCatchFix.class);
    private final boolean myUncaughtOnly;

    public AddExceptionToCatchFix(boolean uncaughtOnly) {
        this.myUncaughtOnly = uncaughtOnly;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        int offset;
        PsiElement element;
        if (project == null) {
            AddExceptionToCatchFix.$$$reportNull$$$0(0);
        }
        if ((element = this.findElement(file, offset = editor.getCaretModel().getOffset())) == null) {
            return;
        }
        PsiTryStatement tryStatement = (PsiTryStatement)element.getParent();
        ArrayList<PsiClassType> unhandledExceptions = new ArrayList<PsiClassType>(this.getExceptions(element, null));
        if (unhandledExceptions.isEmpty()) {
            return;
        }
        ExceptionUtil.sortExceptionsByHierarchy(unhandledExceptions);
        IdeDocumentHistory.getInstance((Project)project).includeCurrentPlaceAsChangePlace();
        PsiCodeBlock catchBlockToSelect = null;
        try {
            if (tryStatement.getFinallyBlock() == null && tryStatement.getCatchBlocks().length == 0) {
                for (PsiClassType unhandledException : unhandledExceptions) {
                    AddExceptionToCatchFix.addCatchStatement(tryStatement, unhandledException, file);
                }
                catchBlockToSelect = tryStatement.getCatchBlocks()[0];
            } else {
                for (PsiClassType unhandledException : unhandledExceptions) {
                    PsiCodeBlock codeBlock = AddExceptionToCatchFix.addCatchStatement(tryStatement, unhandledException, file);
                    if (catchBlockToSelect != null) continue;
                    catchBlockToSelect = codeBlock;
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        if (catchBlockToSelect != null) {
            TextRange range = SurroundWithUtil.getRangeToSelect(catchBlockToSelect);
            editor.getCaretModel().moveToOffset(range.getStartOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
        }
    }

    @NotNull
    protected Collection<PsiClassType> getExceptions(PsiElement element, PsiElement topElement) {
        Collection<PsiClassType> exceptions = ExceptionUtil.collectUnhandledExceptions(element, topElement);
        if (!this.myUncaughtOnly && exceptions.isEmpty() && (exceptions = ExceptionUtil.getThrownExceptions(element)).isEmpty()) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
            PsiClassType exceptionType = factory.createTypeByFQClassName("java.lang.Exception", element.getResolveScope());
            exceptions = Collections.singleton(exceptionType);
        }
        Collection<PsiClassType> collection = exceptions;
        if (collection == null) {
            AddExceptionToCatchFix.$$$reportNull$$$0(1);
        }
        return collection;
    }

    private static PsiCodeBlock addCatchStatement(PsiTryStatement tryStatement, PsiClassType exceptionType, PsiFile file) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)tryStatement.getProject());
        if (tryStatement.getTryBlock() == null) {
            AddExceptionToCatchFix.addTryBlock(tryStatement, factory);
        }
        String name2 = new VariableNameGenerator((PsiElement)tryStatement, VariableKind.PARAMETER).byType((PsiType)exceptionType).byName("e", "ex", "exception").generate(false);
        PsiCatchSection catchSection = factory.createCatchSection((PsiType)exceptionType, name2, (PsiElement)tryStatement);
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock == null) {
            tryStatement.add((PsiElement)catchSection);
        } else {
            tryStatement.addBefore((PsiElement)catchSection, AddExceptionToCatchFix.getFinallySectionStart(finallyBlock));
        }
        PsiParameter[] parameters2 = tryStatement.getCatchBlockParameters();
        PsiTypeElement typeElement = parameters2[parameters2.length - 1].getTypeElement();
        if (typeElement != null) {
            JavaCodeStyleManager.getInstance((Project)file.getProject()).shortenClassReferences((PsiElement)typeElement);
        }
        PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
        return catchBlocks[catchBlocks.length - 1];
    }

    private static void addTryBlock(PsiTryStatement tryStatement, PsiElementFactory factory) {
        PsiCatchSection anchor;
        PsiCodeBlock tryBlock = factory.createCodeBlock();
        PsiCatchSection[] catchSections = tryStatement.getCatchSections();
        if (catchSections.length > 0) {
            anchor = catchSections[0];
        } else {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            PsiElement psiElement = anchor = finallyBlock != null ? AddExceptionToCatchFix.getFinallySectionStart(finallyBlock) : null;
        }
        if (anchor != null) {
            tryStatement.addBefore((PsiElement)tryBlock, (PsiElement)anchor);
        } else {
            tryStatement.add((PsiElement)tryBlock);
        }
    }

    private static PsiElement getFinallySectionStart(@NotNull PsiCodeBlock finallyBlock) {
        PsiCodeBlock finallyElement;
        if (finallyBlock == null) {
            AddExceptionToCatchFix.$$$reportNull$$$0(2);
        }
        for (finallyElement = finallyBlock; !PsiUtil.isJavaToken((PsiElement)finallyElement, (IElementType)JavaTokenType.FINALLY_KEYWORD) && finallyElement != null; finallyElement = finallyElement.getPrevSibling()) {
        }
        assert (finallyElement != null) : finallyBlock.getParent().getText();
        return finallyElement;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddExceptionToCatchFix.$$$reportNull$$$0(3);
        }
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = this.findElement(file, offset);
        if (element == null) {
            return false;
        }
        this.setText(QuickFixBundle.message("add.catch.clause.text", new Object[0]));
        return true;
    }

    @Nullable
    private PsiElement findElement(PsiFile file, int offset) {
        TextRange range;
        PsiElement[] declaredElements;
        PsiElement element = file.findElementAt(offset);
        if (element instanceof PsiWhiteSpace) {
            element = file.findElementAt(offset - 1);
        }
        if (element == null) {
            return null;
        }
        PsiElement parentStatement = RefactoringUtil.getParentStatement(element, false);
        if (parentStatement instanceof PsiDeclarationStatement && (declaredElements = ((PsiDeclarationStatement)parentStatement).getDeclaredElements()).length > 0 && declaredElements[0] instanceof PsiClass) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiTryStatement.class, PsiMethod.class, PsiFunctionalExpression.class});
        if (parent == null || parent instanceof PsiMethod || parent instanceof PsiFunctionalExpression) {
            return null;
        }
        PsiTryStatement statement = (PsiTryStatement)parent;
        PsiCodeBlock tryBlock = statement.getTryBlock();
        if (tryBlock != null && ((range = tryBlock.getTextRange()).contains(offset) || range.getEndOffset() == offset) && !this.getExceptions((PsiElement)tryBlock, statement.getParent()).isEmpty()) {
            return tryBlock;
        }
        PsiResourceList resourceList = statement.getResourceList();
        if (resourceList != null && resourceList.getTextRange().contains(offset) && !this.getExceptions((PsiElement)resourceList, statement.getParent()).isEmpty()) {
            return resourceList;
        }
        return null;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("add.catch.clause.family", new Object[0]);
        if (string == null) {
            AddExceptionToCatchFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToCatchFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finallyBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/AddExceptionToCatchFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFinallySectionStart";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

