/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeArgumentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CastMethodArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapObjectWithOptionalOfNullableFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapWithAdapterMethodCallFix;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.infos.CandidateInfo;
import org.jetbrains.annotations.NotNull;

public class ConstructorParametersFixer {
    public static void registerFixActions(@NotNull PsiJavaCodeReferenceElement ctrRef, @NotNull PsiConstructorCall constructorCall, @NotNull HighlightInfo highlightInfo, @NotNull TextRange fixRange) {
        JavaResolveResult resolved;
        PsiClass aClass;
        if (ctrRef == null) {
            ConstructorParametersFixer.$$$reportNull$$$0(0);
        }
        if (constructorCall == null) {
            ConstructorParametersFixer.$$$reportNull$$$0(1);
        }
        if (highlightInfo == null) {
            ConstructorParametersFixer.$$$reportNull$$$0(2);
        }
        if (fixRange == null) {
            ConstructorParametersFixer.$$$reportNull$$$0(3);
        }
        if ((aClass = (PsiClass)(resolved = ctrRef.advancedResolve(false)).getElement()) == null) {
            return;
        }
        PsiMethod[] methods = aClass.getConstructors();
        CandidateInfo[] candidates = new CandidateInfo[methods.length];
        for (int i = 0; i < candidates.length; ++i) {
            candidates[i] = new CandidateInfo((PsiElement)methods[i], resolved.getSubstitutor());
        }
        CastMethodArgumentFix.REGISTRAR.registerCastActions(candidates, (PsiCall)constructorCall, highlightInfo, fixRange);
        AddTypeArgumentsFix.REGISTRAR.registerCastActions(candidates, (PsiCall)constructorCall, highlightInfo, fixRange);
        WrapObjectWithOptionalOfNullableFix.REGISTAR.registerCastActions(candidates, (PsiCall)constructorCall, highlightInfo, fixRange);
        WrapWithAdapterMethodCallFix.registerCastActions(candidates, (PsiCall)constructorCall, highlightInfo, fixRange);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "ctrRef";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "constructorCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "highlightInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "fixRange";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ConstructorParametersFixer";
        objectArray[2] = "registerFixActions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

