/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.AnnotationsHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateAnnotationMethodFromUsageFix
extends CreateFromUsageBaseFix {
    private static final Logger LOG = Logger.getInstance(CreateAnnotationMethodFromUsageFix.class);
    private final SmartPsiElementPointer<PsiNameValuePair> myNameValuePair;

    public CreateAnnotationMethodFromUsageFix(@NotNull PsiNameValuePair valuePair) {
        if (valuePair == null) {
            CreateAnnotationMethodFromUsageFix.$$$reportNull$$$0(0);
        }
        this.myNameValuePair = SmartPointerManager.getInstance((Project)valuePair.getProject()).createSmartPsiElementPointer((PsiElement)valuePair);
    }

    @Override
    protected boolean isAvailableImpl(int offset) {
        PsiNameValuePair call = this.getNameValuePair();
        if (call == null || !call.isValid()) {
            return false;
        }
        String name2 = call.getName();
        if (name2 == null || !PsiNameHelper.getInstance((Project)call.getProject()).isIdentifier(name2)) {
            return false;
        }
        if (CreateAnnotationMethodFromUsageFix.getAnnotationValueType(call.getValue()) == null) {
            return false;
        }
        this.setText(QuickFixBundle.message("create.method.from.usage.text", name2));
        return true;
    }

    @Override
    protected PsiElement getElement() {
        PsiNameValuePair call = this.getNameValuePair();
        if (call == null || !call.getManager().isInProject((PsiElement)call)) {
            return null;
        }
        return call;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            CreateAnnotationMethodFromUsageFix.$$$reportNull$$$0(1);
        }
        this.chooseTargetClass(project, editor, this::invokeImpl);
    }

    private void invokeImpl(@NotNull PsiClass targetClass) {
        PsiNameValuePair nameValuePair;
        if (targetClass == null) {
            CreateAnnotationMethodFromUsageFix.$$$reportNull$$$0(2);
        }
        if ((nameValuePair = this.getNameValuePair()) == null || this.isValidElement((PsiElement)nameValuePair)) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)nameValuePair.getProject());
        String methodName = nameValuePair.getName();
        LOG.assertTrue(methodName != null);
        PsiMethod method = factory.createMethod(methodName, (PsiType)PsiType.VOID);
        method = (PsiMethod)targetClass.add((PsiElement)method);
        PsiCodeBlock body2 = method.getBody();
        assert (body2 != null);
        body2.delete();
        PsiElement context = PsiTreeUtil.getParentOfType((PsiElement)nameValuePair, (Class[])new Class[]{PsiClass.class, PsiMethod.class});
        PsiType type2 = CreateAnnotationMethodFromUsageFix.getAnnotationValueType(nameValuePair.getValue());
        LOG.assertTrue(type2 != null);
        ExpectedTypeInfo[] expectedTypes = new ExpectedTypeInfo[]{ExpectedTypesProvider.createInfo(type2, 1, type2, TailType.NONE)};
        CreateMethodFromUsageFix.doCreate(targetClass, method, true, ContainerUtil.map2List((Object[])PsiExpression.EMPTY_ARRAY, (Function)Pair.createFunction(null)), CreateAnnotationMethodFromUsageFix.getTargetSubstitutor((PsiElement)nameValuePair), expectedTypes, context);
    }

    @Nullable
    public static PsiType getAnnotationValueType(PsiAnnotationMemberValue value2) {
        PsiType type2 = null;
        if (value2 instanceof PsiExpression) {
            type2 = ((PsiExpression)value2).getType();
        } else if (value2 instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)value2).getInitializers();
            PsiType currentType = null;
            for (PsiAnnotationMemberValue initializer : initializers) {
                if (initializer instanceof PsiArrayInitializerMemberValue) {
                    return null;
                }
                if (!(initializer instanceof PsiExpression)) {
                    return null;
                }
                PsiType psiType = ((PsiExpression)initializer).getType();
                if (psiType == null) continue;
                if (currentType == null) {
                    currentType = psiType;
                    continue;
                }
                if (TypeConversionUtil.isAssignable((PsiType)currentType, (PsiType)psiType)) continue;
                if (TypeConversionUtil.isAssignable((PsiType)psiType, (PsiType)currentType)) {
                    currentType = psiType;
                    continue;
                }
                return null;
            }
            if (currentType != null) {
                type2 = currentType.createArrayType();
            }
        }
        if (type2 != null && ((Boolean)type2.accept((PsiTypeVisitor)AnnotationsHighlightUtil.AnnotationReturnTypeVisitor.INSTANCE)).booleanValue()) {
            return type2;
        }
        return null;
    }

    @Override
    protected boolean isValidElement(PsiElement element) {
        PsiReference reference = element.getReference();
        return reference != null && reference.resolve() != null;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
        if (string == null) {
            CreateAnnotationMethodFromUsageFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    protected PsiNameValuePair getNameValuePair() {
        return (PsiNameValuePair)this.myNameValuePair.getElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuePair";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateAnnotationMethodFromUsageFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateAnnotationMethodFromUsageFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invokeImpl";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

