/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodFromUsageFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CreateStaticMethodQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<PsiClass> myTargetClass;
    private final String myMethodName;
    private final List<String> myTypes;

    public CreateStaticMethodQuickFix(@NotNull PsiClass aClass, @NotNull String name2, @NotNull List<String> types) {
        if (aClass == null) {
            CreateStaticMethodQuickFix.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            CreateStaticMethodQuickFix.$$$reportNull$$$0(1);
        }
        if (types == null) {
            CreateStaticMethodQuickFix.$$$reportNull$$$0(2);
        }
        this.myTargetClass = SmartPointerManager.createPointer((PsiElement)aClass);
        this.myMethodName = name2;
        this.myTypes = types;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("create.method.from.usage.family", new Object[0]);
        if (string == null) {
            CreateStaticMethodQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiMethod method;
        PsiClass targetClass;
        if (project == null) {
            CreateStaticMethodQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            CreateStaticMethodQuickFix.$$$reportNull$$$0(5);
        }
        if ((targetClass = (PsiClass)this.myTargetClass.getElement()) == null) {
            return;
        }
        boolean java8Interface = false;
        if (targetClass.isInterface()) {
            if (PsiUtil.isLanguageLevel8OrHigher((PsiElement)targetClass)) {
                java8Interface = true;
            } else {
                return;
            }
        }
        if ((method = CreateMethodFromUsageFix.createMethod(targetClass, null, null, this.myMethodName)) == null) {
            return;
        }
        if (!java8Interface) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"public", (boolean)true);
        }
        PsiUtil.setModifierProperty((PsiModifierListOwner)method, (String)"static", (boolean)true);
        List args = ContainerUtil.map(this.myTypes, s -> new Pair(null, (Object)PsiType.getTypeByName((String)s, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project))));
        CreateMethodFromUsageFix.doCreate(targetClass, method, false, args, PsiSubstitutor.UNKNOWN, ExpectedTypeInfo.EMPTY_ARRAY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateStaticMethodQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/CreateStaticMethodQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

