/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.problems;

import com.intellij.codeInsight.daemon.problems.FileState;
import com.intellij.codeInsight.daemon.problems.FileStateCache;
import com.intellij.codeInsight.daemon.problems.FileStateUpdater;
import com.intellij.codeInsight.daemon.problems.Member;
import com.intellij.codeInsight.daemon.problems.MemberCollector;
import com.intellij.codeInsight.daemon.problems.ScopedMember;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB'\u0012 \u0010\u0002\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003j\u0004\u0018\u0001`\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001c\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0002\u001a\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0003j\u0004\u0018\u0001`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/codeInsight/daemon/problems/FileStateUpdater;", "Lcom/intellij/psi/JavaElementVisitor;", "prevSnapshot", "", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiMember;", "Lcom/intellij/codeInsight/daemon/problems/ScopedMember;", "Lcom/intellij/codeInsight/daemon/problems/Snapshot;", "(Ljava/util/Map;)V", "changes", "", "snapshot", "visitClass", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "visitEnumConstant", "psiEnumConstant", "Lcom/intellij/psi/PsiEnumConstant;", "visitField", "psiField", "Lcom/intellij/psi/PsiField;", "visitMember", "psiMember", "visitMethod", "psiMethod", "Lcom/intellij/psi/PsiMethod;", "Companion", "intellij.java.impl"})
public final class FileStateUpdater
extends JavaElementVisitor {
    private final Map<SmartPsiElementPointer<PsiMember>, ScopedMember> snapshot;
    private final Map<PsiMember, ScopedMember> changes;
    private final Map<SmartPsiElementPointer<PsiMember>, ScopedMember> prevSnapshot;
    public static final Companion Companion = new Companion(null);

    public void visitEnumConstant(@NotNull PsiEnumConstant psiEnumConstant) {
        Intrinsics.checkParameterIsNotNull((Object)psiEnumConstant, (String)"psiEnumConstant");
        this.visitMember((PsiMember)psiEnumConstant);
    }

    public void visitClass(@NotNull PsiClass psiClass) {
        Intrinsics.checkParameterIsNotNull((Object)psiClass, (String)"psiClass");
        this.visitMember((PsiMember)psiClass);
    }

    public void visitField(@NotNull PsiField psiField) {
        Intrinsics.checkParameterIsNotNull((Object)psiField, (String)"psiField");
        this.visitMember((PsiMember)psiField);
    }

    public void visitMethod(@NotNull PsiMethod psiMethod) {
        Intrinsics.checkParameterIsNotNull((Object)psiMethod, (String)"psiMethod");
        this.visitMember((PsiMember)psiMethod);
    }

    private final void visitMember(PsiMember psiMember) {
        ScopedMember scopedMember = ScopedMember.Companion.create$intellij_java_impl$default(ScopedMember.Companion, psiMember, null, 2, null);
        if (scopedMember == null) {
            return;
        }
        ScopedMember member = scopedMember;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)((PsiElement)psiMember));
        Intrinsics.checkExpressionValueIsNotNull((Object)smartPsiElementPointer, (String)"SmartPointerManager.createPointer(psiMember)");
        SmartPsiElementPointer pointer = smartPsiElementPointer;
        this.snapshot.put((SmartPsiElementPointer<PsiMember>)pointer, member);
        if (this.prevSnapshot == null) {
            return;
        }
        ScopedMember prevMember = this.prevSnapshot.get(pointer);
        if (prevMember != null && !member.hasChanged$intellij_java_impl(prevMember)) {
            return;
        }
        this.changes.put(psiMember, prevMember);
        FileStateUpdater.Companion.collectRelatedChanges(psiMember, member, prevMember, this.changes);
    }

    public FileStateUpdater(@Nullable Map<SmartPsiElementPointer<PsiMember>, ScopedMember> prevSnapshot) {
        Map map2;
        this.prevSnapshot = prevSnapshot;
        FileStateUpdater fileStateUpdater = this;
        boolean bl = false;
        fileStateUpdater.snapshot = map2 = (Map)new LinkedHashMap();
        fileStateUpdater = this;
        bl = false;
        fileStateUpdater.changes = map2 = (Map)new LinkedHashMap();
    }

    @JvmStatic
    @JvmName(name="getState")
    @Nullable
    public static final FileState getState(@NotNull PsiFile psiFile) {
        return Companion.getState(psiFile);
    }

    @JvmStatic
    @JvmName(name="findState")
    @NotNull
    public static final FileState findState(@NotNull PsiFile psiFile, @NotNull Map<SmartPsiElementPointer<PsiMember>, ScopedMember> prevSnapshot) {
        return Companion.findState(psiFile, prevSnapshot);
    }

    @JvmStatic
    @JvmName(name="setPreviousState")
    public static final void setPreviousState(@NotNull PsiFile psiFile) {
        Companion.setPreviousState(psiFile);
    }

    @JvmStatic
    @JvmName(name="updateState")
    public static final void updateState(@NotNull PsiFile psiFile, @NotNull FileState fileState) {
        Companion.updateState(psiFile, fileState);
    }

    @JvmStatic
    @JvmName(name="removeState")
    public static final void removeState(@NotNull PsiFile psiFile) {
        Companion.removeState(psiFile);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\b0\u000bH\u0002J.\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u001c\u0010\u0010\u001a\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0012\u0012\u0004\u0012\u00020\b0\u0011j\u0002`\u0013H\u0001J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0001J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0001J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0001J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\rH\u0001J\u0014\u0010\u001d\u001a\u00020\u001e*\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0002J\f\u0010!\u001a\u00020\u001e*\u00020\"H\u0002\u00a8\u0006#"}, d2={"Lcom/intellij/codeInsight/daemon/problems/FileStateUpdater$Companion;", "", "()V", "collectRelatedChanges", "", "psiMember", "Lcom/intellij/psi/PsiMember;", "member", "Lcom/intellij/codeInsight/daemon/problems/ScopedMember;", "prevMember", "changes", "", "findState", "Lcom/intellij/codeInsight/daemon/problems/FileState;", "psiFile", "Lcom/intellij/psi/PsiFile;", "prevSnapshot", "", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/codeInsight/daemon/problems/Snapshot;", "getState", "publicApi", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "removeState", "setPreviousState", "updateState", "fileState", "hasModifier", "", "modifier", "", "isOverride", "Lcom/intellij/psi/PsiMethod;", "intellij.java.impl"})
    public static final class Companion {
        @JvmStatic
        @JvmName(name="getState")
        @Nullable
        public final FileState getState(@NotNull PsiFile psiFile) {
            Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
            if (DumbService.isDumb((Project)psiFile.getProject())) {
                return null;
            }
            Project project = psiFile.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"psiFile.project");
            FileState storedState = FileStateCache.SERVICE.INSTANCE.getInstance(project).getState$intellij_java_impl(psiFile);
            if (storedState != null) {
                return storedState;
            }
            FileStateUpdater updater = new FileStateUpdater(null);
            Iterable $this$forEach$iv = this.publicApi((PsiElement)psiFile);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PsiMember it = (PsiMember)element$iv;
                boolean bl = false;
                it.accept((PsiElementVisitor)updater);
            }
            Map snapshot = updater.snapshot;
            return new FileState(snapshot, MapsKt.emptyMap());
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmName(name="findState")
        @NotNull
        public final FileState findState(@NotNull PsiFile psiFile, @NotNull Map<SmartPsiElementPointer<PsiMember>, ScopedMember> prevSnapshot) {
            boolean bl;
            Object it;
            Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
            Intrinsics.checkParameterIsNotNull(prevSnapshot, (String)"prevSnapshot");
            FileStateUpdater updater = new FileStateUpdater(prevSnapshot);
            Iterable $this$forEach$iv = this.publicApi((PsiElement)psiFile);
            boolean $i$f$forEach = false;
            Object object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                it = (PsiMember)element$iv;
                bl = false;
                it.accept((PsiElementVisitor)updater);
            }
            Map snapshot = updater.snapshot;
            Map changes2 = updater.changes;
            it = prevSnapshot;
            bl = false;
            Iterator iterator = it.entrySet().iterator();
            while (iterator.hasNext()) {
                ScopedMember member;
                PsiMember psiMember;
                void memberPointer;
                Object object2 = object = iterator.next();
                boolean bl2 = false;
                it = (SmartPsiElementPointer)object2.getKey();
                object2 = object;
                bl2 = false;
                ScopedMember prevMember = (ScopedMember)object2.getValue();
                object2 = snapshot;
                bl2 = false;
                Object object3 = object2;
                boolean bl3 = false;
                if (object3.containsKey(memberPointer)) continue;
                if ((PsiMember)memberPointer.getElement() == null) {
                    continue;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiMember, (String)"memberPointer.element ?: continue");
                if (ScopedMember.Companion.create$intellij_java_impl$default(ScopedMember.Companion, psiMember, null, 2, null) == null) {
                    continue;
                }
                changes2.put(psiMember, prevMember);
                this.collectRelatedChanges(psiMember, member, prevMember, changes2);
            }
            return new FileState(snapshot, changes2);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @JvmName(name="setPreviousState")
        public final void setPreviousState(@NotNull PsiFile psiFile) {
            void snapshot;
            Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
            Project project = psiFile.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"psiFile.project");
            Project project2 = project;
            FileStateCache fileStateCache = FileStateCache.SERVICE.INSTANCE.getInstance(project2);
            FileState fileState = fileStateCache.getState$intellij_java_impl(psiFile);
            if (fileState == null) {
                return;
            }
            FileState fileState2 = fileState;
            Map<SmartPsiElementPointer<PsiMember>, ScopedMember> map2 = fileState2.component1();
            Map<PsiMember, ScopedMember> changes2 = fileState2.component2();
            if (changes2.isEmpty()) {
                return;
            }
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)project2);
            Map oldSnapshot = MapsKt.toMutableMap((Map)snapshot);
            Map<PsiMember, ScopedMember> $this$forEach$iv = changes2;
            boolean $i$f$forEach = false;
            Map<PsiMember, ScopedMember> map3 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<PsiMember, ScopedMember>> iterator = map3.entrySet().iterator();
            while (iterator.hasNext()) {
                SmartPsiElementPointer memberPointer;
                void psiMember;
                Map.Entry<PsiMember, ScopedMember> element$iv;
                Map.Entry<PsiMember, ScopedMember> $dstr$psiMember$prevMember = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry<PsiMember, ScopedMember> entry = $dstr$psiMember$prevMember;
                boolean bl3 = false;
                PsiMember psiMember2 = entry.getKey();
                entry = $dstr$psiMember$prevMember;
                bl3 = false;
                ScopedMember prevMember = entry.getValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)manager.createSmartPsiElementPointer((PsiElement)psiMember), (String)"manager.createSmartPsiElementPointer(psiMember)");
                if (prevMember == null) {
                    oldSnapshot.remove(memberPointer);
                    continue;
                }
                oldSnapshot.put(memberPointer, prevMember);
            }
            fileStateCache.setState$intellij_java_impl(psiFile, oldSnapshot, MapsKt.emptyMap());
        }

        @JvmStatic
        @JvmName(name="updateState")
        public final void updateState(@NotNull PsiFile psiFile, @NotNull FileState fileState) {
            Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
            Intrinsics.checkParameterIsNotNull((Object)fileState, (String)"fileState");
            Project project = psiFile.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"psiFile.project");
            FileStateCache.SERVICE.INSTANCE.getInstance(project).setState$intellij_java_impl(psiFile, fileState.getSnapshot(), fileState.getChanges());
        }

        @JvmStatic
        @JvmName(name="removeState")
        public final void removeState(@NotNull PsiFile psiFile) {
            Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
            Project project = psiFile.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"psiFile.project");
            FileStateCache.SERVICE.INSTANCE.getInstance(project).removeState$intellij_java_impl(psiFile);
        }

        /*
         * WARNING - void declaration
         */
        private final void collectRelatedChanges(PsiMember psiMember, ScopedMember member, ScopedMember prevMember, Map<PsiMember, ScopedMember> changes2) {
            block9: {
                void $this$filterTo$iv$iv;
                Member.Class curClass;
                Member.Class prevClass;
                block10: {
                    PsiMember psiMember2;
                    block8: {
                        psiMember2 = psiMember;
                        if (!(psiMember2 instanceof PsiMethod)) break block8;
                        PsiClass psiClass = ((PsiMethod)psiMember).getContainingClass();
                        if (psiClass == null) {
                            return;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiClass, (String)"psiMember.containingClass ?: return");
                        PsiClass containingClass = psiClass;
                        changes2.putIfAbsent((PsiMember)containingClass, null);
                        break block9;
                    }
                    if (!(psiMember2 instanceof PsiClass)) break block9;
                    ScopedMember scopedMember = prevMember;
                    Member member2 = scopedMember != null ? scopedMember.getMember() : null;
                    if (!(member2 instanceof Member.Class)) {
                        member2 = null;
                    }
                    Member.Class clazz = (Member.Class)member2;
                    if (clazz == null) {
                        return;
                    }
                    prevClass = clazz;
                    Member member3 = member.getMember();
                    if (!(member3 instanceof Member.Class)) {
                        member3 = null;
                    }
                    Member.Class clazz2 = (Member.Class)member3;
                    if (clazz2 == null) {
                        return;
                    }
                    curClass = clazz2;
                    if (prevClass.isInterface() == ((PsiClass)psiMember).isInterface()) break block10;
                    Iterable $this$forEach$iv = this.publicApi((PsiElement)psiMember);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        PsiMember it = (PsiMember)element$iv;
                        boolean bl = false;
                        changes2.putIfAbsent(it, null);
                    }
                    break block9;
                }
                if (!(Intrinsics.areEqual(prevClass.getExtendsList(), curClass.getExtendsList()) ^ true) && !(Intrinsics.areEqual(prevClass.getImplementsList(), curClass.getImplementsList()) ^ true)) break block9;
                Iterable $this$filter$iv = this.publicApi((PsiElement)psiMember);
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PsiMember it = (PsiMember)element$iv$iv;
                    boolean bl = false;
                    if (!(it instanceof PsiMethod && Companion.isOverride((PsiMethod)it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PsiMember it = (PsiMember)element$iv;
                    boolean bl = false;
                    changes2.putIfAbsent(it, null);
                }
            }
        }

        private final List<PsiMember> publicApi(PsiElement psiElement) {
            return MemberCollector.Companion.collectMembers(psiElement, (Function1<? super PsiMember, Boolean>)((Function1)publicApi.1.INSTANCE));
        }

        private final boolean isOverride(@NotNull PsiMethod $this$isOverride) {
            return $this$isOverride.hasAnnotation("java.lang.Override");
        }

        private final boolean hasModifier(@NotNull PsiMember $this$hasModifier, String modifier) {
            PsiModifierList psiModifierList = $this$hasModifier.getModifierList();
            return psiModifierList != null ? psiModifierList.hasModifierProperty(modifier) : false;
        }

        private Companion() {
        }

        public static final /* synthetic */ boolean access$hasModifier(Companion $this, PsiMember $this$access_u24hasModifier, String modifier) {
            return $this.hasModifier($this$access_u24hasModifier, modifier);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

