/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.problems.pass;

import com.intellij.codeInsight.daemon.problems.FileStateUpdater;
import com.intellij.codeInsight.daemon.problems.pass.ProjectProblemPassUtils;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class ProjectProblemFileSelectionListener
implements FileEditorManagerListener,
InlayHintsSettings.SettingsListener,
BulkFileListener {
    private final Project myProject;

    private ProjectProblemFileSelectionListener(Project project) {
        this.myProject = project;
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            ProjectProblemFileSelectionListener.$$$reportNull$$$0(0);
        }
        if (!ProjectProblemPassUtils.hintsEnabled()) {
            return;
        }
        VirtualFile oldFile = event.getOldFile();
        VirtualFile newFile = event.getNewFile();
        TextEditor oldEditor = (TextEditor)ObjectUtils.tryCast((Object)event.getOldEditor(), TextEditor.class);
        if (oldFile == null || oldEditor == null || oldFile.equals(newFile)) {
            return;
        }
        this.setPreviousState(oldFile, oldEditor);
    }

    private void setPreviousState(@NotNull VirtualFile file, @NotNull TextEditor textEditor) {
        if (file == null) {
            ProjectProblemFileSelectionListener.$$$reportNull$$$0(1);
        }
        if (textEditor == null) {
            ProjectProblemFileSelectionListener.$$$reportNull$$$0(2);
        }
        if (file instanceof VirtualFileWindow || !file.isValid()) {
            return;
        }
        PsiJavaFile psiJavaFile = (PsiJavaFile)ObjectUtils.tryCast((Object)PsiManager.getInstance((Project)this.myProject).findFile(file), PsiJavaFile.class);
        if (psiJavaFile == null) {
            return;
        }
        ProjectProblemPassUtils.removeInfos(textEditor.getEditor());
        FileStateUpdater.setPreviousState((PsiFile)psiJavaFile);
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            ProjectProblemFileSelectionListener.$$$reportNull$$$0(3);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        for (VFileEvent vFileEvent : events) {
            VirtualFile selectedFile;
            TextEditor editor;
            VirtualFile changedFile = vFileEvent.getFile();
            if (changedFile == null) continue;
            if (vFileEvent instanceof VFileDeleteEvent) {
                PsiFile psiFile;
                if (!fileIndex.isInContent(changedFile) || (psiFile = psiManager.findFile(changedFile)) == null) continue;
                FileStateUpdater.removeState(psiFile);
            }
            if (!(vFileEvent instanceof VFileContentChangeEvent) && !(vFileEvent instanceof VFileDeleteEvent) || (editor = (TextEditor)ObjectUtils.tryCast((Object)FileEditorManager.getInstance((Project)this.myProject).getSelectedEditor(), TextEditor.class)) == null || (selectedFile = editor.getFile()) == null || changedFile.equals(selectedFile)) continue;
            this.setPreviousState(selectedFile, editor);
        }
    }

    public void settingsChanged() {
        if (!ProjectProblemPassUtils.hintsEnabled()) {
            this.onHintsDisabled();
        }
    }

    public void languageStatusChanged() {
        if (!ProjectProblemPassUtils.hintsEnabled()) {
            this.onHintsDisabled();
        }
    }

    public void globalEnabledStatusChanged(boolean newEnabled) {
        if (!ProjectProblemPassUtils.hintsEnabled()) {
            this.onHintsDisabled();
        }
    }

    private void onHintsDisabled() {
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.myProject);
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        for (FileEditor selectedEditor : editorManager.getSelectedEditors()) {
            PsiJavaFile psiJavaFile;
            VirtualFile virtualFile;
            TextEditor textEditor = (TextEditor)ObjectUtils.tryCast((Object)selectedEditor, TextEditor.class);
            if (textEditor == null || (virtualFile = selectedEditor.getFile()) == null || (psiJavaFile = (PsiJavaFile)ObjectUtils.tryCast((Object)psiManager.findFile(virtualFile), PsiJavaFile.class)) == null) continue;
            ProjectProblemPassUtils.removeInfos(textEditor.getEditor());
            FileStateUpdater.setPreviousState((PsiFile)psiJavaFile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/problems/pass/ProjectProblemFileSelectionListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "selectionChanged";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setPreviousState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "before";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MyStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            ProjectProblemFileSelectionListener listener = new ProjectProblemFileSelectionListener(project);
            MessageBusConnection connection = project.getMessageBus().connect();
            connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)listener);
            connection.subscribe(InlayHintsSettings.getINLAY_SETTINGS_CHANGED(), (Object)listener);
            connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)listener);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/problems/pass/ProjectProblemFileSelectionListener$MyStartupActivity", "runActivity"));
        }
    }
}

