/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.JavaClassReferenceCompletionContributor;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.editorActions.TypedHandlerUtil;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTypedHandler
extends TypedHandlerDelegate {
    static final TokenSet INVALID_INSIDE_REFERENCE = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.SEMICOLON, JavaTokenType.LBRACE, JavaTokenType.RBRACE});
    private boolean myJavaLTTyped;

    private static void autoPopupMemberLookup(Project project, Editor editor) {
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, file -> {
            int offset = editor.getCaretModel().getOffset();
            PsiElement lastElement = file.findElementAt(offset - 1);
            if (lastElement == null) {
                return false;
            }
            PsiElement prevSibling = PsiTreeUtil.prevVisibleLeaf((PsiElement)lastElement);
            if (prevSibling == null || ".".equals(prevSibling.getText())) {
                return false;
            }
            PsiElement parent = prevSibling;
            while ((parent = parent.getParent()) instanceof PsiJavaCodeReferenceElement || parent instanceof PsiTypeElement) {
            }
            if (parent instanceof PsiParameterList || parent instanceof PsiParameter) {
                return false;
            }
            if (!".".equals(lastElement.getText()) && !"#".equals(lastElement.getText())) {
                return JavaClassReferenceCompletionContributor.findJavaClassReference(file, offset - 1) != null;
            }
            PsiElement element = file.findElementAt(offset);
            return element == null || !"#".equals(lastElement.getText()) || PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocComment.class) != null;
        });
    }

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            JavaTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            JavaTypedHandler.$$$reportNull$$$0(2);
        }
        int offset = editor.getCaretModel().getOffset();
        if (charTyped == ' ' && StringUtil.endsWith((CharSequence)editor.getDocument().getImmutableCharSequence(), (int)0, (int)offset, (CharSequence)"new")) {
            AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor, CompletionType.BASIC, f -> {
                PsiElement leaf = f.findElementAt(offset - "new".length());
                return leaf instanceof PsiKeyword && leaf.textMatches((CharSequence)"new") && !((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().insideStarting((ElementPattern)PsiJavaPatterns.psiExpressionStatement())).accepts((Object)leaf);
            });
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                JavaTypedHandler.$$$reportNull$$$0(3);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = super.checkAutoPopup(charTyped, project, editor, file);
        if (result == null) {
            JavaTypedHandler.$$$reportNull$$$0(4);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            JavaTypedHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            JavaTypedHandler.$$$reportNull$$$0(6);
        }
        if (file == null) {
            JavaTypedHandler.$$$reportNull$$$0(7);
        }
        if (fileType == null) {
            JavaTypedHandler.$$$reportNull$$$0(8);
        }
        if (!(file instanceof PsiJavaFile)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                JavaTypedHandler.$$$reportNull$$$0(9);
            }
            return result;
        }
        if (c == '@') {
            JavaTypedHandler.autoPopupJavadocLookup(project, editor);
        } else if (c == '#' || c == '.') {
            JavaTypedHandler.autoPopupMemberLookup(project, editor);
        }
        int offsetBefore = editor.getCaretModel().getOffset();
        boolean bl = this.myJavaLTTyped = '<' == c && !(file instanceof JspFile) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && TypedHandlerUtil.isAfterClassLikeIdentifierOrDot((int)offsetBefore, (Editor)editor, (IElementType)JavaTokenType.DOT, (IElementType)JavaTokenType.IDENTIFIER, (boolean)true);
        if ('>' == c && !(file instanceof JspFile) && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && PsiUtil.isLanguageLevel5OrHigher((PsiElement)file) && TypedHandlerUtil.handleGenericGT((Editor)editor, (IElementType)JavaTokenType.LT, (IElementType)JavaTokenType.GT, (TokenSet)INVALID_INSIDE_REFERENCE)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                JavaTypedHandler.$$$reportNull$$$0(10);
            }
            return result;
        }
        if (c == ';' && JavaTypedHandler.handleSemicolon(project, editor, file, fileType)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                JavaTypedHandler.$$$reportNull$$$0(11);
            }
            return result;
        }
        if (fileType == JavaFileType.INSTANCE && c == '{') {
            PsiElement prev;
            int offset = editor.getCaretModel().getOffset();
            if (offset == 0) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    JavaTypedHandler.$$$reportNull$$$0(12);
                }
                return result;
            }
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset - 1);
            while (!iterator.atEnd() && iterator.getTokenType() == TokenType.WHITE_SPACE) {
                iterator.retreat();
            }
            if (iterator.atEnd() || iterator.getTokenType() == JavaTokenType.RBRACKET || iterator.getTokenType() == JavaTokenType.EQ) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    JavaTypedHandler.$$$reportNull$$$0(13);
                }
                return result;
            }
            Document doc = editor.getDocument();
            PsiDocumentManager.getInstance((Project)project).commitDocument(doc);
            PsiElement leaf = file.findElementAt(offset);
            if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiArrayInitializerExpression.class, (boolean)false, (Class[])new Class[]{PsiCodeBlock.class, PsiMember.class}) != null) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    JavaTypedHandler.$$$reportNull$$$0(14);
                }
                return result;
            }
            PsiElement st = leaf != null ? leaf.getParent() : null;
            PsiElement psiElement = prev = offset > 1 ? file.findElementAt(offset - 1) : null;
            if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && JavaTypedHandler.isRparenth(leaf) && (st instanceof PsiWhileStatement || st instanceof PsiIfStatement) && JavaTypedHandler.shouldInsertStatementBody(st, doc, prev)) {
                CommandProcessor.getInstance().executeCommand(project, () -> new JavaSmartEnterProcessor().process(project, editor, file), JavaBundle.message((String)"command.name.insert.block.statement", (Object[])new Object[0]), null);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaTypedHandler.$$$reportNull$$$0(15);
                }
                return result;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)leaf, PsiCodeBlock.class, (boolean)false, (Class[])new Class[]{PsiMember.class}) != null && !JavaTypedHandler.shouldInsertPairedBrace(leaf)) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{");
                TypedHandler.indentOpenedBrace((Project)project, (Editor)editor);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaTypedHandler.$$$reportNull$$$0(16);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            JavaTypedHandler.$$$reportNull$$$0(17);
        }
        return result;
    }

    private static boolean shouldInsertPairedBrace(@NotNull PsiElement leaf) {
        PsiElement prevLeaf;
        if (leaf == null) {
            JavaTypedHandler.$$$reportNull$$$0(18);
        }
        if (PsiUtil.isJavaToken((PsiElement)(prevLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)leaf)), (IElementType)JavaTokenType.ARROW)) {
            return true;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)prevLeaf, PsiNewExpression.class, (boolean)true, (Class[])new Class[]{PsiCodeBlock.class, PsiMember.class}) != null) {
            return true;
        }
        if (prevLeaf instanceof PsiIdentifier && prevLeaf.getParent() instanceof PsiClass) {
            return true;
        }
        return PsiUtil.isJavaToken((PsiElement)prevLeaf, (IElementType)JavaTokenType.RPARENTH) && prevLeaf.getParent() instanceof PsiRecordHeader;
    }

    private static boolean shouldInsertStatementBody(@NotNull PsiElement statement, @NotNull Document doc, @Nullable PsiElement prev) {
        if (statement == null) {
            JavaTypedHandler.$$$reportNull$$$0(19);
        }
        if (doc == null) {
            JavaTypedHandler.$$$reportNull$$$0(20);
        }
        PsiStatement block = statement instanceof PsiWhileStatement ? ((PsiWhileStatement)statement).getBody() : ((PsiIfStatement)statement).getThenBranch();
        PsiExpression condition2 = (PsiExpression)PsiTreeUtil.getChildOfType((PsiElement)statement, PsiExpression.class);
        PsiExpression latestExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)prev, PsiExpression.class);
        if (latestExpression instanceof PsiNewExpression && ((PsiNewExpression)latestExpression).getAnonymousClass() == null) {
            return false;
        }
        return !(block instanceof PsiBlockStatement) && (block == null || JavaTypedHandler.startLine(doc, (PsiElement)block) != JavaTypedHandler.startLine(doc, statement) || condition2 == null);
    }

    private static boolean isRparenth(@Nullable PsiElement leaf) {
        if (leaf == null) {
            return false;
        }
        if (leaf.getNode().getElementType() == JavaTokenType.RPARENTH) {
            return true;
        }
        PsiElement next = PsiTreeUtil.nextVisibleLeaf((PsiElement)leaf);
        if (next == null) {
            return false;
        }
        return next.getNode().getElementType() == JavaTokenType.RPARENTH;
    }

    private static int startLine(@NotNull Document doc, @NotNull PsiElement psiElement) {
        if (doc == null) {
            JavaTypedHandler.$$$reportNull$$$0(21);
        }
        if (psiElement == null) {
            JavaTypedHandler.$$$reportNull$$$0(22);
        }
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            JavaTypedHandler.$$$reportNull$$$0(23);
        }
        if (editor == null) {
            JavaTypedHandler.$$$reportNull$$$0(24);
        }
        if (file == null) {
            JavaTypedHandler.$$$reportNull$$$0(25);
        }
        if (!(file instanceof PsiJavaFile)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                JavaTypedHandler.$$$reportNull$$$0(26);
            }
            return result;
        }
        if (this.myJavaLTTyped) {
            this.myJavaLTTyped = false;
            TypedHandlerUtil.handleAfterGenericLT((Editor)editor, (IElementType)JavaTokenType.LT, (IElementType)JavaTokenType.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                JavaTypedHandler.$$$reportNull$$$0(27);
            }
            return result;
        }
        if (c == ':') {
            if (JavaTypedHandler.autoIndentCase(editor, project, file)) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    JavaTypedHandler.$$$reportNull$$$0(28);
                }
                return result;
            }
        } else if (c == ',' && JavaTypedHandler.handleAnnotationParameter(project, editor, file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                JavaTypedHandler.$$$reportNull$$$0(29);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            JavaTypedHandler.$$$reportNull$$$0(30);
        }
        return result;
    }

    private static boolean handleAnnotationParameter(Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        int caret;
        if (editor == null) {
            JavaTypedHandler.$$$reportNull$$$0(31);
        }
        if (file == null) {
            JavaTypedHandler.$$$reportNull$$$0(32);
        }
        if (JavaTypedHandler.mightBeInsideDefaultAnnotationAttribute(editor, (caret = editor.getCaretModel().getOffset()) - 2)) {
            PsiNameValuePair attr;
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PsiAnnotation anno = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(caret), PsiAnnotation.class, (boolean)false, (Class[])new Class[]{PsiExpression.class, PsiComment.class});
            PsiNameValuePair psiNameValuePair = attr = anno == null ? null : JavaTypedHandler.getTheOnlyDefaultAttribute(anno);
            if (attr != null && JavaTypedHandler.hasDefaultArrayMethod(anno) && !(attr.getValue() instanceof PsiArrayInitializerMemberValue)) {
                editor.getDocument().insertString(caret, (CharSequence)"}");
                editor.getDocument().insertString(attr.getTextRange().getStartOffset(), (CharSequence)"{");
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static PsiNameValuePair getTheOnlyDefaultAttribute(@NotNull PsiAnnotation anno) {
        List attributes;
        if (anno == null) {
            JavaTypedHandler.$$$reportNull$$$0(33);
        }
        return (attributes = ContainerUtil.findAll((Object[])anno.getParameterList().getAttributes(), a -> !a.getTextRange().isEmpty())).size() == 1 && ((PsiNameValuePair)attributes.get(0)).getNameIdentifier() == null ? (PsiNameValuePair)attributes.get(0) : null;
    }

    private static boolean hasDefaultArrayMethod(@NotNull PsiAnnotation anno) {
        PsiJavaCodeReferenceElement nameRef;
        PsiElement annoClass;
        if (anno == null) {
            JavaTypedHandler.$$$reportNull$$$0(34);
        }
        PsiElement psiElement = annoClass = (nameRef = anno.getNameReferenceElement()) == null ? null : nameRef.resolve();
        if (annoClass instanceof PsiClass) {
            PsiMethod[] methods = ((PsiClass)annoClass).getMethods();
            return methods.length == 1 && PsiUtil.isAnnotationMethod((PsiElement)methods[0]) && "value".equals(methods[0].getName()) && methods[0].getReturnType() instanceof PsiArrayType;
        }
        return false;
    }

    private static boolean mightBeInsideDefaultAnnotationAttribute(@NotNull Editor editor, int offset) {
        if (editor == null) {
            JavaTypedHandler.$$$reportNull$$$0(35);
        }
        if (offset < 0) {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        int parenCount = 0;
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == JavaTokenType.AT) {
                return true;
            }
            if (tokenType == JavaTokenType.RPARENTH || tokenType == JavaTokenType.LBRACE || tokenType == JavaTokenType.EQ || tokenType == JavaTokenType.SEMICOLON || tokenType == JavaTokenType.COMMA) {
                return false;
            }
            if (tokenType == JavaTokenType.LPARENTH && ++parenCount > 1) {
                return false;
            }
            iterator.retreat();
        }
        return false;
    }

    private static boolean handleSemicolon(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project == null) {
            JavaTypedHandler.$$$reportNull$$$0(36);
        }
        if (editor == null) {
            JavaTypedHandler.$$$reportNull$$$0(37);
        }
        if (file == null) {
            JavaTypedHandler.$$$reportNull$$$0(38);
        }
        if (fileType == null) {
            JavaTypedHandler.$$$reportNull$$$0(39);
        }
        if (fileType != JavaFileType.INSTANCE) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        if (JavaTypedHandler.moveSemicolonAtRParen(project, editor, file, offset)) {
            return true;
        }
        char charAt = editor.getDocument().getCharsSequence().charAt(offset);
        if (charAt != ';') {
            return false;
        }
        HighlighterIterator hi = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (hi.atEnd() || hi.getTokenType() != JavaTokenType.SEMICOLON) {
            return false;
        }
        EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
        return true;
    }

    private static boolean moveSemicolonAtRParen(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int caretOffset) {
        if (project == null) {
            JavaTypedHandler.$$$reportNull$$$0(40);
        }
        if (editor == null) {
            JavaTypedHandler.$$$reportNull$$$0(41);
        }
        if (file == null) {
            JavaTypedHandler.$$$reportNull$$$0(42);
        }
        if (!Registry.is((String)"editor.move.semicolon.after.paren")) {
            return false;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        HighlighterIterator it = ((EditorEx)editor).getHighlighter().createIterator(caretOffset);
        int afterLastParenOffset = -1;
        while (!it.atEnd() && !JavaTypedHandler.isAtLineEnd(it) && it.getTokenType() != JavaTokenType.RBRACE) {
            if (it.getTokenType() == JavaTokenType.RPARENTH) {
                afterLastParenOffset = it.getEnd();
            } else if (it.getTokenType() != TokenType.WHITE_SPACE) {
                return false;
            }
            it.advance();
        }
        if (!it.atEnd() && afterLastParenOffset >= 0 && afterLastParenOffset >= caretOffset) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement curElement = file.findElementAt(caretOffset);
            PsiStatement curStmt = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)curElement, PsiStatement.class);
            if (curStmt != null) {
                int stmtEndOffset;
                if (curStmt instanceof PsiTryStatement) {
                    return false;
                }
                if (curStmt instanceof PsiForStatement) {
                    return false;
                }
                if (PsiTreeUtil.getDeepestLast((PsiElement)curStmt) instanceof PsiErrorElement && ((stmtEndOffset = curStmt.getTextRange().getEndOffset()) == afterLastParenOffset || stmtEndOffset == it.getStart())) {
                    editor.getDocument().insertString(stmtEndOffset, (CharSequence)";");
                    editor.getCaretModel().moveToOffset(stmtEndOffset + 1);
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isAtLineEnd(HighlighterIterator it) {
        if (it.getTokenType() == TokenType.WHITE_SPACE) {
            CharSequence tokenText = it.getDocument().getImmutableCharSequence().subSequence(it.getStart(), it.getEnd());
            return CharArrayUtil.containLineBreaks((CharSequence)tokenText);
        }
        return false;
    }

    private static void autoPopupJavadocLookup(Project project, Editor editor) {
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, file -> {
            int offset = editor.getCaretModel().getOffset();
            PsiElement lastElement = file.findElementAt(offset - 1);
            return lastElement != null && StringUtil.endsWithChar((CharSequence)lastElement.getText(), (char)'@');
        });
    }

    private static boolean autoIndentCase(Editor editor, Project project, PsiFile file) {
        PsiElement parent;
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement currElement = file.findElementAt(offset - 1);
        if (currElement != null && (parent = currElement.getParent()) instanceof PsiSwitchLabelStatement) {
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, parent.getTextOffset());
            return true;
        }
        return false;
    }

    @Deprecated
    public static boolean handleJavaGT(@NotNull Editor editor, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference) {
        if (editor == null) {
            JavaTypedHandler.$$$reportNull$$$0(43);
        }
        if (lt == null) {
            JavaTypedHandler.$$$reportNull$$$0(44);
        }
        if (gt == null) {
            JavaTypedHandler.$$$reportNull$$$0(45);
        }
        if (invalidInsideReference == null) {
            JavaTypedHandler.$$$reportNull$$$0(46);
        }
        return TypedHandlerUtil.handleGenericGT((Editor)editor, (IElementType)lt, (IElementType)gt, (TokenSet)invalidInsideReference);
    }

    @Deprecated
    public static void handleAfterJavaLT(@NotNull Editor editor, @NotNull IElementType lt, @NotNull IElementType gt, @NotNull TokenSet invalidInsideReference) {
        if (editor == null) {
            JavaTypedHandler.$$$reportNull$$$0(47);
        }
        if (lt == null) {
            JavaTypedHandler.$$$reportNull$$$0(48);
        }
        if (gt == null) {
            JavaTypedHandler.$$$reportNull$$$0(49);
        }
        if (invalidInsideReference == null) {
            JavaTypedHandler.$$$reportNull$$$0(50);
        }
        TypedHandlerUtil.handleAfterGenericLT((Editor)editor, (IElementType)lt, (IElementType)gt, (TokenSet)invalidInsideReference);
    }

    @Deprecated
    public static boolean isClassLikeIdentifier(int offset, @NotNull Editor editor, @NotNull HighlighterIterator iterator, @NotNull IElementType idType) {
        if (editor == null) {
            JavaTypedHandler.$$$reportNull$$$0(51);
        }
        if (iterator == null) {
            JavaTypedHandler.$$$reportNull$$$0(52);
        }
        if (idType == null) {
            JavaTypedHandler.$$$reportNull$$$0(53);
        }
        return TypedHandlerUtil.isClassLikeIdentifier((int)offset, (Editor)editor, (HighlighterIterator)iterator, (IElementType)idType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 24: 
            case 31: 
            case 35: 
            case 37: 
            case 41: 
            case 43: 
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 7: 
            case 25: 
            case 32: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/JavaTypedHandler";
                break;
            }
            case 8: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leaf";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lt";
                break;
            }
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gt";
                break;
            }
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidInsideReference";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/JavaTypedHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsertPairedBrace";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsertStatementBody";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "startLine";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "handleAnnotationParameter";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTheOnlyDefaultAttribute";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "hasDefaultArrayMethod";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "mightBeInsideDefaultAnnotationAttribute";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "handleSemicolon";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "moveSemicolonAtRParen";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "handleJavaGT";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "handleAfterJavaLT";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isClassLikeIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

