/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class NestedIfJoinLinesHandler
implements JoinLinesHandlerDelegate {
    public int tryJoinLines(@NotNull Document document, @NotNull PsiFile psiFile, int start, int end) {
        PsiBlockStatement blockStatement;
        PsiCodeBlock block;
        if (document == null) {
            NestedIfJoinLinesHandler.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            NestedIfJoinLinesHandler.$$$reportNull$$$0(1);
        }
        PsiJavaToken elementAtStartLineEnd = (PsiJavaToken)ObjectUtils.tryCast((Object)psiFile.findElementAt(start), PsiJavaToken.class);
        PsiElement nextLineElement = psiFile.findElementAt(end);
        if (elementAtStartLineEnd == null || nextLineElement == null) {
            return -1;
        }
        PsiIfStatement outerIf = null;
        if (elementAtStartLineEnd.getTokenType().equals(JavaTokenType.RPARENTH)) {
            outerIf = (PsiIfStatement)ObjectUtils.tryCast((Object)elementAtStartLineEnd.getParent(), PsiIfStatement.class);
        } else if (elementAtStartLineEnd.getTokenType().equals(JavaTokenType.LBRACE) && (block = (PsiCodeBlock)ObjectUtils.tryCast((Object)elementAtStartLineEnd.getParent(), PsiCodeBlock.class)) != null && (blockStatement = (PsiBlockStatement)ObjectUtils.tryCast((Object)block.getParent(), PsiBlockStatement.class)) != null && ((outerIf = (PsiIfStatement)ObjectUtils.tryCast((Object)blockStatement.getParent(), PsiIfStatement.class)) == null || outerIf.getThenBranch() != blockStatement)) {
            return -1;
        }
        if (outerIf == null || outerIf.getElseBranch() != null) {
            return -1;
        }
        PsiIfStatement innerIf = (PsiIfStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(outerIf.getThenBranch()), PsiIfStatement.class);
        if (!PsiTreeUtil.isAncestor((PsiElement)innerIf, (PsiElement)nextLineElement, (boolean)false)) {
            return -1;
        }
        if (innerIf.getThenBranch() == null || innerIf.getElseBranch() != null) {
            return -1;
        }
        PsiExpression outerCondition = outerIf.getCondition();
        if (outerCondition == null) {
            return -1;
        }
        PsiExpression innerCondition = innerIf.getCondition();
        if (innerCondition == null) {
            return -1;
        }
        PsiJavaToken lParenth = outerIf.getLParenth();
        PsiJavaToken rParenth = innerIf.getRParenth();
        if (lParenth == null || rParenth == null) {
            return -1;
        }
        String childConditionText = ParenthesesUtils.getText(innerCondition, 14);
        String parentConditionText = ParenthesesUtils.getText(outerCondition, 14);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)psiFile.getProject());
        String condition2 = parentConditionText + " && " + childConditionText;
        String resultText = outerIf.getText().substring(0, lParenth.getTextRangeInParent().getEndOffset()) + condition2 + innerIf.getText().substring(rParenth.getTextRangeInParent().getStartOffset());
        PsiStatement statement = factory.createStatementFromText(resultText, (PsiElement)outerIf);
        PsiIfStatement result = (PsiIfStatement)outerIf.replace((PsiElement)statement);
        return Objects.requireNonNull(result.getCondition()).getTextRange().getStartOffset() + parentConditionText.length() + 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/editorActions/NestedIfJoinLinesHandler";
        objectArray[2] = "tryJoinLines";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

