/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.google.common.base.Strings;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.resolve.reference.impl.manipulators.StringLiteralManipulator;
import com.intellij.psi.util.PsiLiteralUtil;
import java.awt.datatransfer.DataFlavor;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text2) {
        StringBuilder buffer = new StringBuilder();
        int givenTextOffset = 0;
        boolean textWasChanged = false;
        int deducedBlockSelectionWidth = StringLiteralCopyPasteProcessor.deduceBlockSelectionWidth(startOffsets, endOffsets, text2);
        for (int i = 0; i < startOffsets.length && givenTextOffset < text2.length(); ++i, ++givenTextOffset) {
            TextRange escapedRange;
            if (i > 0) {
                buffer.append('\n');
            }
            int fileStartOffset = startOffsets[i];
            int fileEndOffset = endOffsets[i];
            int givenTextStartOffset = givenTextOffset;
            int givenTextEndOffset = givenTextOffset + (fileEndOffset - fileStartOffset);
            if ((givenTextOffset = givenTextEndOffset) > text2.length()) {
                return null;
            }
            String fragment = text2.substring(givenTextStartOffset, givenTextEndOffset);
            PsiElement element = file.findElementAt(fileStartOffset);
            TextRange textRange = escapedRange = element == null ? null : this.getEscapedRange(element);
            if (escapedRange == null || escapedRange.getStartOffset() > fileStartOffset || escapedRange.getEndOffset() < fileEndOffset) {
                buffer.append(fragment);
            } else {
                String unescaped = this.unescape(fragment, element);
                if (unescaped != null) {
                    textWasChanged = true;
                    buffer.append(unescaped);
                } else {
                    buffer.append(fragment);
                }
            }
            int blockSelectionPadding = deducedBlockSelectionWidth - (fileEndOffset - fileStartOffset);
            for (int j = 0; j < blockSelectionPadding; ++j) {
                buffer.append(' ');
                ++givenTextOffset;
            }
        }
        return textWasChanged ? buffer.toString() : null;
    }

    private static int deduceBlockSelectionWidth(int[] startOffsets, int[] endOffsets, String text2) {
        int fragmentCount = startOffsets.length;
        assert (fragmentCount > 0);
        int totalLength = fragmentCount - 1;
        for (int i = 0; i < fragmentCount; ++i) {
            totalLength += endOffsets[i] - startOffsets[i];
        }
        if (totalLength < text2.length() && (text2.length() + 1) % fragmentCount == 0) {
            return (text2.length() + 1) / fragmentCount - 1;
        }
        return -1;
    }

    @Nullable
    protected String unescape(String text2, PsiElement token) {
        return StringUtil.unescapeStringCharacters((String)text2);
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text2, RawText rawText) {
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        PsiElement token = this.findLiteralTokenType(file, selectionStart, selectionEnd);
        if (token == null) {
            String string = text2;
            if (string == null) {
                StringLiteralCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (rawText != null && StringLiteralCopyPasteProcessor.wasUnescaped(text2, rawText.rawText) && this.isSuitableForContext(rawText.rawText, token)) {
            String string = rawText.rawText;
            if (string == null) {
                StringLiteralCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (this.isStringLiteral(token)) {
            text2 = this.escapeAndSplit(text2, token);
        } else {
            if (this.isCharLiteral(token)) {
                String string = this.escapeCharCharacters(text2, token);
                if (string == null) {
                    StringLiteralCopyPasteProcessor.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (this.isTextBlock(token)) {
                String before = document.getText(new TextRange(selectionStart - 1, selectionStart));
                String after = document.getText(new TextRange(selectionEnd, selectionEnd + 1));
                int caretOffset = editor.getCaretModel().getOffset();
                int offset = caretOffset - document.getLineStartOffset(document.getLineNumber(caretOffset));
                String string = this.escapeTextBlock(text2, offset, "\"".equals(before), "\"".equals(after));
                if (string == null) {
                    StringLiteralCopyPasteProcessor.$$$reportNull$$$0(3);
                }
                return string;
            }
        }
        String string = text2;
        if (string == null) {
            StringLiteralCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    private boolean isSuitableForContext(String text2, PsiElement context) {
        if (this.isStringLiteral(context)) {
            return !StringLiteralCopyPasteProcessor.containsUnescapedChars(text2, '\"', '\n');
        }
        if (this.isCharLiteral(context)) {
            return !StringLiteralCopyPasteProcessor.containsUnescapedChars(text2, '\'', '\n');
        }
        if (this.isTextBlock(context)) {
            return !text2.contains("\"\"\"");
        }
        return true;
    }

    private static boolean containsUnescapedChars(String text2, char ... cs) {
        boolean slash = false;
        for (int i = 0; i < text2.length(); ++i) {
            char ch = text2.charAt(i);
            if (ch == '\\') {
                slash = !slash;
                continue;
            }
            if (!slash) {
                for (char c : cs) {
                    if (ch != c) continue;
                    return true;
                }
            }
            slash = false;
        }
        return false;
    }

    public String escapeAndSplit(String text2, PsiElement token) {
        StringBuilder buffer = new StringBuilder(text2.length());
        String breaker = this.getLineBreaker(token);
        String[] lines = LineTokenizer.tokenize((char[])text2.toCharArray(), (boolean)false, (boolean)true);
        for (int i = 0; i < lines.length; ++i) {
            buffer.append(this.escapeCharCharacters(lines[i], token));
            if (i != lines.length - 1) {
                buffer.append(breaker);
                continue;
            }
            if (!text2.endsWith("\n")) continue;
            buffer.append("\\n");
        }
        text2 = buffer.toString();
        return text2;
    }

    private static boolean wasUnescaped(String text2, String originalText) {
        try {
            return new TextBlockTransferable(StringUtil.unescapeStringCharacters((String)originalText), Collections.emptyList(), null).getTransferData(DataFlavor.stringFlavor).equals(text2);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getLineBreaker(@NotNull PsiElement token) {
        if (token == null) {
            StringLiteralCopyPasteProcessor.$$$reportNull$$$0(5);
        }
        CommonCodeStyleSettings codeStyleSettings = CodeStyle.getLanguageSettings((PsiFile)token.getContainingFile());
        return codeStyleSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE ? "\\n\"\n+ \"" : "\\n\" +\n\"";
    }

    @Nullable
    protected PsiElement findLiteralTokenType(PsiFile file, int selectionStart, int selectionEnd) {
        PsiElement elementAtSelectionStart = file.findElementAt(selectionStart);
        PsiElement elementAtSelectionEnd = file.findElementAt(selectionEnd);
        if (elementAtSelectionStart == null || elementAtSelectionEnd == null || elementAtSelectionEnd.getNode().getElementType() != elementAtSelectionStart.getNode().getElementType()) {
            return null;
        }
        if (!(this.isStringLiteral(elementAtSelectionStart) || this.isCharLiteral(elementAtSelectionStart) || this.isTextBlock(elementAtSelectionStart))) {
            return null;
        }
        TextRange startTextRange = this.getEscapedRange(elementAtSelectionStart);
        TextRange endTextRange = this.getEscapedRange(elementAtSelectionEnd);
        if (startTextRange == null || endTextRange == null || !startTextRange.containsOffset(selectionStart) || !endTextRange.containsOffset(selectionEnd)) {
            return null;
        }
        return elementAtSelectionStart;
    }

    protected boolean isCharLiteral(@NotNull PsiElement token) {
        ASTNode node;
        if (token == null) {
            StringLiteralCopyPasteProcessor.$$$reportNull$$$0(6);
        }
        return (node = token.getNode()) != null && node.getElementType() == JavaTokenType.CHARACTER_LITERAL;
    }

    protected boolean isStringLiteral(@NotNull PsiElement token) {
        ASTNode node;
        if (token == null) {
            StringLiteralCopyPasteProcessor.$$$reportNull$$$0(7);
        }
        return (node = token.getNode()) != null && node.getElementType() == JavaTokenType.STRING_LITERAL;
    }

    protected boolean isTextBlock(@NotNull PsiElement token) {
        ASTNode node;
        if (token == null) {
            StringLiteralCopyPasteProcessor.$$$reportNull$$$0(8);
        }
        return (node = token.getNode()) != null && node.getElementType() == JavaTokenType.TEXT_BLOCK_LITERAL;
    }

    @Nullable
    protected TextRange getEscapedRange(@NotNull PsiElement token) {
        PsiElement parent;
        if (token == null) {
            StringLiteralCopyPasteProcessor.$$$reportNull$$$0(9);
        }
        if (!((parent = token.getParent()) instanceof PsiLiteralExpression)) {
            return null;
        }
        TextRange valueTextRange = StringLiteralManipulator.getValueRange((PsiLiteralExpression)token.getParent());
        return valueTextRange.shiftRight(token.getTextRange().getStartOffset());
    }

    @NotNull
    protected String escapeCharCharacters(@NotNull String s, @NotNull PsiElement token) {
        if (s == null) {
            StringLiteralCopyPasteProcessor.$$$reportNull$$$0(10);
        }
        if (token == null) {
            StringLiteralCopyPasteProcessor.$$$reportNull$$$0(11);
        }
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)(this.isStringLiteral(token) ? "\"" : "'"), (StringBuilder)buffer);
        String string = buffer.toString();
        if (string == null) {
            StringLiteralCopyPasteProcessor.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    protected String escapeTextBlock(@NotNull String text2, int offset, boolean escapeStartQuote, boolean escapeEndQuote) {
        if (text2 == null) {
            StringLiteralCopyPasteProcessor.$$$reportNull$$$0(13);
        }
        StringBuilder buffer = new StringBuilder(text2.length());
        String[] lines = LineTokenizer.tokenize((char[])text2.toCharArray(), (boolean)false, (boolean)false);
        String indent = Strings.repeat((String)" ", (int)offset);
        for (int i = 0; i < lines.length; ++i) {
            String content = PsiLiteralUtil.escapeBackSlashesInTextBlock((String)lines[i]);
            content = PsiLiteralUtil.escapeTextBlockCharacters((String)content, (i == 0 && escapeStartQuote ? 1 : 0) != 0, (i == lines.length - 1 && escapeEndQuote ? 1 : 0) != 0, (boolean)true);
            buffer.append(content);
            if (i >= lines.length - 1) continue;
            buffer.append('\n').append(indent);
        }
        String string = buffer.toString();
        if (string == null) {
            StringLiteralCopyPasteProcessor.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/editorActions/StringLiteralCopyPasteProcessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/editorActions/StringLiteralCopyPasteProcessor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharCharacters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeTextBlock";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreaker";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCharLiteral";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isStringLiteral";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isTextBlock";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEscapedRange";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "escapeTextBlock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

