/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.source.tree.JavaJspElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ForStatementFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (!(psiElement instanceof PsiForStatement)) {
            return;
        }
        PsiForStatement forStatement = (PsiForStatement)psiElement;
        PsiJavaToken lParenth = forStatement.getLParenth();
        PsiJavaToken rParenth = forStatement.getRParenth();
        if (lParenth == null || rParenth == null) {
            TextRange textRange = forStatement.getTextRange();
            editor.getDocument().replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)"for () {\n}");
            processor2.registerUnresolvedError(textRange.getStartOffset() + "for (".length());
            return;
        }
        PsiStatement initialization = forStatement.getInitialization();
        if (initialization == null) {
            processor2.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
            return;
        }
        PsiExpression condition2 = forStatement.getCondition();
        if (condition2 == null) {
            ForStatementFixer.registerErrorOffset(editor, processor2, (PsiElement)initialization, forStatement);
            return;
        }
        if (forStatement.getUpdate() == null) {
            ForStatementFixer.registerErrorOffset(editor, processor2, (PsiElement)condition2, forStatement);
        }
    }

    private static void registerErrorOffset(@NotNull Editor editor, @NotNull JavaSmartEnterProcessor processor2, @NotNull PsiElement lastValidForPart, @NotNull PsiForStatement forStatement) {
        if (editor == null) {
            ForStatementFixer.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            ForStatementFixer.$$$reportNull$$$0(1);
        }
        if (lastValidForPart == null) {
            ForStatementFixer.$$$reportNull$$$0(2);
        }
        if (forStatement == null) {
            ForStatementFixer.$$$reportNull$$$0(3);
        }
        Project project = editor.getProject();
        int offset = lastValidForPart.getTextRange().getEndOffset();
        if (project != null && CodeStyle.getSettings((Editor)editor).getCommonSettings((Language)JavaLanguage.INSTANCE).SPACE_AFTER_COMMA) {
            if (editor.getDocument().getCharsSequence().charAt(lastValidForPart.getTextRange().getEndOffset() - 1) != ';') {
                ++offset;
            }
            for (PsiElement element = lastValidForPart.getNextSibling(); element != null && element != forStatement.getRParenth() && element.getParent() == forStatement; element = element.getNextSibling()) {
                ASTNode node = element.getNode();
                if (node == null || !JavaJspElementType.WHITE_SPACE_BIT_SET.contains(node.getElementType()) || element.getTextLength() <= 0) continue;
                ++offset;
                break;
            }
        }
        processor2.registerUnresolvedError(offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "lastValidForPart";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "forStatement";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/editorActions/smartEnter/ForStatementFixer";
        objectArray[2] = "registerErrorOffset";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

