/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.util.IncorrectOperationException;

public class WhileConditionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        if (psiElement instanceof PsiWhileStatement) {
            Document doc = editor.getDocument();
            PsiWhileStatement whileStatement = (PsiWhileStatement)psiElement;
            PsiJavaToken rParenth = whileStatement.getRParenth();
            PsiJavaToken lParenth = whileStatement.getLParenth();
            PsiExpression condition2 = whileStatement.getCondition();
            if (condition2 == null) {
                if (lParenth == null || rParenth == null) {
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(whileStatement.getTextRange().getStartOffset()));
                    PsiStatement block = whileStatement.getBody();
                    if (block != null) {
                        stopOffset = Math.min(stopOffset, block.getTextRange().getStartOffset());
                    }
                    stopOffset = Math.min(stopOffset, whileStatement.getTextRange().getEndOffset());
                    doc.replaceString(whileStatement.getTextRange().getStartOffset(), stopOffset, (CharSequence)"while ()");
                    processor2.registerUnresolvedError(whileStatement.getTextRange().getStartOffset() + "while (".length());
                } else {
                    processor2.registerUnresolvedError(lParenth.getTextRange().getEndOffset());
                }
            } else if (rParenth == null) {
                doc.insertString(condition2.getTextRange().getEndOffset(), (CharSequence)")");
            }
        }
    }
}

